/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseStaffBoService;
import com.jxdinfo.hussar.authorization.organ.vo.StaffBo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffInfoVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseStaffBoServiceImpl")
public class HussarBaseStaffBoServiceImpl
implements IHussarBaseStaffBoService {
    @Autowired
    private QueryStaffManager queryStaffManager;
    @Autowired
    private ISysUsersService usersService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Autowired
    private ISysDicRefService dicRefService;

    public StaffBo findStaffByStaffId(Long id) {
        AssertUtil.isNotNull((Object)id, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        StaffInfoVo staffInfoVo = this.queryStaffManager.loadStaff(id);
        StaffBo bo = new StaffBo();
        bo.setId(id);
        bo.setParentId(staffInfoVo.getParentId());
        bo.setParentOrganName(staffInfoVo.getParentName());
        bo.setParentOrganType(staffInfoVo.getParentStruType());
        bo.setParentOrganTypeName(staffInfoVo.getParentStruTypeName());
        bo.setStaffCode(staffInfoVo.getStaffCode());
        bo.setStaffName(staffInfoVo.getStaffName());
        bo.setStaffPosition(staffInfoVo.getStaffPosition());
        bo.setStaffPositionName(staffInfoVo.getStaffPositionName());
        bo.setSex(staffInfoVo.getSex());
        bo.setSexName(staffInfoVo.getSexName());
        bo.setBirthday(staffInfoVo.getBirthday());
        bo.setIdcard(staffInfoVo.getIdcard());
        bo.setAddress(staffInfoVo.getAddress());
        bo.setWorkId(staffInfoVo.getWorkId());
        bo.setWorkDate(staffInfoVo.getWorkDate());
        bo.setGraduateDate(staffInfoVo.getGraduateDate());
        bo.setGraduateSchool(staffInfoVo.getGraduateSchool());
        return bo;
    }

    public StaffBo findStaffByUserId(Long id) {
        SysUsers user = this.usersService.getUser(id);
        AssertUtil.isNotNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        return this.findStaffByStaffId(user.getEmployeeId());
    }

    public List<StaffBo> findStaffsByStaffIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        ArrayList<StaffBo> list = new ArrayList<StaffBo>();
        AssertUtil.isTrue((ids.size() <= 50 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u67e5\u8be2\u6700\u591a50\u4e2a\u4eba\u5458");
        for (Long id : ids) {
            list.add(this.findStaffByStaffId(id));
        }
        return list;
    }

    public List<StaffBo> findStaffsByUserIds(List<Long> ids) {
        AssertUtil.isNotEmpty(ids, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isTrue((ids.size() <= 50 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u67e5\u8be2\u6700\u591a50\u4e2a\u4eba\u5458");
        List<Long> collect = this.usersService.listByIds(ids).stream().map(SysUsers::getEmployeeId).collect(Collectors.toList());
        return this.findStaffsByStaffIds(collect);
    }

    public StaffBo findStaffByUserAccount(String account) {
        AssertUtil.isNotEmpty((String)account, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysUsers::getUserAccount, (Object)account);
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)wrapper);
        Long userId = sysUsers.getId();
        return this.findStaffByUserId(userId);
    }

    public List<StaffBo> findStaffsByUserAccounts(List<String> accounts) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        for (String account : accounts) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysUsers::getUserAccount, (Object)account);
            SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)wrapper);
            Long userId = sysUsers.getId();
            userIds.add(userId);
        }
        return this.findStaffsByUserIds(userIds);
    }

    public StaffBo findStaffByStaffCode(String code) {
        AssertUtil.isNotEmpty((String)code, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        StaffBo bo = this.sysStaffMapper.selectStaffBoByStaffCode(code);
        String sex = bo.getSex();
        String sexName = this.dicRefService.getDictLabel("sex", sex);
        bo.setSexName(sexName);
        String staffPosition = bo.getStaffPosition();
        String staffPositionName = this.dicRefService.getDictLabel("staff_position", staffPosition);
        bo.setStaffPositionName(staffPositionName);
        return bo;
    }

    public List<StaffBo> findStaffsByStaffCodes(List<String> codes) {
        AssertUtil.isNotEmpty(codes, (String)"\u672a\u4f20\u9012\u67e5\u8be2\u53c2\u6570");
        AssertUtil.isTrue((codes.size() <= 50 ? 1 : 0) != 0, (String)"\u4e00\u6b21\u67e5\u8be2\u6700\u591a50\u4e2a\u4eba\u5458");
        List<StaffBo> bos = this.sysStaffMapper.selectStaffBosByStaffCodes(codes);
        for (StaffBo bo : bos) {
            String sex = bo.getSex();
            String sexName = this.dicRefService.getDictLabel("sex", sex);
            bo.setSexName(sexName);
            String staffPosition = bo.getStaffPosition();
            String staffPositionName = this.dicRefService.getDictLabel("staff_position", staffPosition);
            bo.setStaffPositionName(staffPositionName);
        }
        return bos;
    }
}

