/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonOutsideOrganizationManager {
    @Autowired
    protected ISysOrganService organService;
    @Autowired
    protected ISysOrganTypeService organTypeService;
    @Autowired
    protected ISysOfficeService sysOfficeService;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Resource
    protected SysUserRoleMapper sysUserRoleMapper;
    @Resource
    protected SysStaffMapper sysStaffMapper;
    @Autowired
    protected ISysStruService struService;
    @Autowired
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Autowired
    protected AddOrganizationManager addOrganizationManager;

    protected Long getOrganId(String organCode) {
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            return Constants.ROOT_NODE_ID;
        }
        SysOrgan sysOrganTemp = (SysOrgan)this.organService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode))).ne(SysOrgan::getOrganType, (Object)"9"));
        AssertUtil.isNotNull((Object)sysOrganTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
        SysStru sysStruTemp = (SysStru)this.struService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrganTemp.getId()));
        AssertUtil.isNotNull((Object)sysStruTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
        return sysStruTemp.getId();
    }

    protected Long getUserId(String userAccount) {
        if (HussarUtils.isBlank((CharSequence)userAccount)) {
            return null;
        }
        String userAccountTemp = userAccount;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            userAccountTemp = userAccountTemp.toUpperCase();
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccountTemp)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()));
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        return sysUsers.getId();
    }

    protected String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.sysStruMapper.getMaxStruSeq(pFid, level);
        if (HussarUtils.isBlank((CharSequence)maxStruSeq)) {
            return pSeq + "/0001";
        }
        return this.getStruSeqByMaxStruSeq(maxStruSeq, pSeq, level);
    }

    protected String getStruSeqByMaxStruSeq(String maxStruSeq, String pSeq, int level) {
        String struSeq = "";
        String[] arr = maxStruSeq.split("/");
        if (StringUtils.isNotBlank((CharSequence)pSeq)) {
            int len = arr.length - 1;
            if (len < level) {
                StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                for (int i = 0; i < level - len; ++i) {
                    stringBuilder.append("/0001");
                }
                struSeq = stringBuilder.toString();
            } else {
                struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf("/")) + "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        } else {
            struSeq = "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
        }
        return struSeq;
    }
}

