/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAssistOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class CommonOrganizationManager {
    @Autowired
    protected ISysOrgEventService sysOrgEventService;
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    protected ISysOrganService sysOrganService;
    @Autowired
    protected ISysStruService sysStruService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Resource
    protected SysStruMapper sysStruMapper;
    @Resource
    protected SysOrganMapper sysOrganMapper;
    @Resource
    protected SysStruRuleMapper sysStruRuleMapper;
    @Resource
    protected SysOfficeMapper sysOfficeMapper;
    @Resource
    protected SysUsersMapper sysUsersMapper;
    @Resource
    protected SysRolesMapper sysRolesMapper;
    @Resource
    protected SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    protected SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    protected SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Autowired
    protected ISysStaffService sysStaffService;
    @Autowired
    protected ISysOfficeService sysOfficeService;
    @Autowired
    protected ISysStruAssistOrganService sysStruAssistOrganService;
    @Autowired
    protected ISysOrganAuditService sysOrganAuditService;
    @Autowired
    protected ISysStaffAuditService sysStaffAuditService;
    @Autowired
    protected ISysOfficeAuditService sysOfficeAuditService;
    @Autowired
    protected ISysStruAuditService sysStruAuditService;
    @Autowired
    protected ISysUsersAuditService sysUsersAuditService;
    @Autowired
    protected ISysStruAssistOrganAuditService sysStruAssistOrganAuditService;
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Autowired
    protected ISysStruRuleService sysStruRuleService;
    @Autowired
    protected ISysUsersService sysUsersService;
    @Autowired
    protected SysOrgManageService sysOrgManageService;

    protected void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, SysOffice sysOffice, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if ("2".equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setId(null);
        }
        this.sysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getId());
        if ("2".equals(flag)) {
            sysStruAudit.setOrganId(sysOrganAudit.getId());
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.sysStruAuditService.save((Object)sysStruAudit);
        if (HussarUtils.isNotEmpty((Object)sysStaff)) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag)) {
                sysStaffAudit.setStruId(sysStruAudit.getId());
                sysStaffAudit.setRealStaffId(sysStaff.getId());
                sysStaffAudit.setId(null);
            }
            this.sysStaffAuditService.save((Object)sysStaffAudit);
        }
        if (HussarUtils.isNotEmpty((Object)sysOffice)) {
            SysOfficeAudit sysOfficeAudit = new SysOfficeAudit();
            CopyPropertieUtils.copyProperties((Object)sysOfficeAudit, (Object)sysOffice);
            sysOfficeAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag)) {
                sysOfficeAudit.setStruId(sysStruAudit.getId());
                sysOfficeAudit.setRealOfficeId(sysOffice.getId());
                sysOfficeAudit.setId(null);
            }
            this.sysOfficeAuditService.save((Object)sysOfficeAudit);
        }
    }

    protected String getCode(SysOrgan sysOrgan) {
        String fieldName = "ORGAN_CODE_4";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        String code = StringUtils.trimToEmpty((String)sysOrgan.getOrganCode());
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode(fieldName, "SYS_ORGAN");
                ((LambdaQueryWrapper)lambdaQueryWrapper.ne(SysOrgan::getOrganType, (Object)"9")).eq(SysOrgan::getOrganCode, (Object)code);
                currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            ((LambdaQueryWrapper)lambdaQueryWrapper.ne(SysOrgan::getOrganType, (Object)"9")).eq(SysOrgan::getOrganCode, (Object)code);
            currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d\uff01");
            }
        }
        return code;
    }

    protected String getStruSeq(String pFid, String pSeq, int level) {
        String maxStruSeq = this.sysStruMapper.getMaxStruSeq(pFid, level);
        String struSeq = "";
        if (HussarUtils.isBlank((CharSequence)maxStruSeq)) {
            struSeq = pSeq + "/0001";
        } else {
            String[] arr = maxStruSeq.split("/");
            if (StringUtils.isNotBlank((CharSequence)pSeq)) {
                int len = arr.length - 1;
                if (len < level) {
                    StringBuilder stringBuilder = new StringBuilder(maxStruSeq);
                    for (int i = 0; i < level - len; ++i) {
                        stringBuilder.append("/0001");
                    }
                    struSeq = stringBuilder.toString();
                } else {
                    struSeq = maxStruSeq.substring(0, maxStruSeq.lastIndexOf("/")) + "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
                }
            } else {
                struSeq = "/" + String.format("%04d", Integer.parseInt(arr[arr.length - 1]) + 1);
            }
        }
        return struSeq;
    }

    protected boolean delOrganByStruId(long struId) {
        boolean flag;
        SysStru sysStruById = (SysStru)this.sysStruMapper.selectById(Long.valueOf(struId));
        int struLevel = sysStruById.getStruLevel();
        Long parentId = sysStruById.getParentId();
        LambdaQueryWrapper delOrgan = new LambdaQueryWrapper();
        delOrgan.eq(SysOrgan::getId, (Object)sysStruById.getOrganId());
        this.sysOrganMapper.delete((Wrapper)delOrgan);
        LambdaQueryWrapper delOffice = new LambdaQueryWrapper();
        delOffice.eq(SysOffice::getStruId, (Object)struId);
        this.sysOfficeMapper.delete((Wrapper)delOffice);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysStruRoleAudit::getStruId, (Object)struId);
        this.sysStruRoleAuditMapper.delete((Wrapper)queryWrapper);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysStruAssistOrgan::getStruId, (Object)struId);
        this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
        boolean bl = flag = this.sysStruMapper.deleteById(Long.valueOf(struId)) > 0;
        if (struLevel > 1) {
            SysStru stru = (SysStru)this.sysStruMapper.selectById(parentId);
            LambdaQueryWrapper wrapperC = new LambdaQueryWrapper();
            wrapperC.eq(SysStru::getParentId, (Object)parentId);
            wrapperC.ne(SysStru::getId, (Object)struId);
            wrapperC.ne(SysStru::getStruType, (Object)"9");
            Long count = this.sysStruMapper.selectCount((Wrapper)wrapperC);
            stru.setIsLeaf(count > 0L ? "N" : "Y");
            this.sysStruMapper.updateById(stru);
        }
        return flag;
    }
}

