/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationListDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryTransferOrganizationTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.TransferOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.SortOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.TransferOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganTreeInitVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationPartialVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.ReadOnlyOrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganizationVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStruRuleVo;
import com.jxdinfo.hussar.authorization.permit.vo.SelectCustomOrgTreeVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseOrganizationServiceImpl")
public class HussarBaseOrganizationServiceImpl
implements IHussarBaseOrganizationService {
    @Autowired
    private AddOrganizationManager addOrganizationManager;
    @Autowired
    private EditOrganizationManager editOrganizationManager;
    @Autowired
    private DeleteOrganizationManager deleteOrganizationManager;
    @Autowired
    private SortOrganizationManager sortOrganizationManager;
    @Autowired
    private TransferOrganizationManager transferOrganizationManager;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    protected SysStruMapper sysStruMapper;

    @HussarTransactional
    public ApiResponse<Long> addOrganization(AddOrganizationDto addOrganizationDto) {
        return this.addOrganizationManager.addOrganization(addOrganizationDto);
    }

    @HussarTransactional
    public ApiResponse<String> editOrganization(EditOrganizationDto editOrganizationDto) {
        return ApiResponse.success((String)this.editOrganizationManager.editOrganization(editOrganizationDto));
    }

    @HussarTransactional
    public ApiResponse<String> deleteOrganization(Long struId) {
        return ApiResponse.success((String)this.deleteOrganizationManager.deleteOrganization(struId));
    }

    @HussarTransactional
    public ApiResponse<String> sortOrganization(List<Long> idList) {
        return ApiResponse.success((String)this.sortOrganizationManager.sortOrganization(idList));
    }

    @HussarTransactional
    public ApiResponse<String> transferOrganization(TransferOrganizationDto transferOrganizationDto) {
        return ApiResponse.success((String)this.transferOrganizationManager.transferOrganization(transferOrganizationDto));
    }

    public ApiResponse<List<OrganizationTreeVo>> getTransferOrganizationTree(QueryTransferOrganizationTreeDto queryTransferOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.getTransferOrganizationTree(queryTransferOrganizationDto));
    }

    public ApiResponse<List<OrganizationTreeVo>> lazyLoadOrganizationTree(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganizationTree(parentId));
    }

    public ApiResponse<OrganizationPartialVo> viewOrganization(Long id) {
        return ApiResponse.success((Object)this.queryOrganizationManager.viewOrganization(id));
    }

    public ApiResponse<OrganizationInfoVo> loadOrganization(Long struId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.loadOrganizationById(struId));
    }

    public ApiResponse<Page<SearchOrganizationVo>> searchOrganization(PageInfo pageInfo, String name) {
        return ApiResponse.success(this.queryOrganizationManager.searchOrganization(pageInfo, name));
    }

    public ApiResponse<List<OrganizationTreeVo>> backOrganizationTree(Long organId) {
        return ApiResponse.success(this.queryOrganizationManager.backOrganizationTree(organId));
    }

    public ApiResponse<Page<OrganizationVo>> queryOrganization(PageInfo pageInfo, QueryOrganizationDto queryOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.queryOrganization(pageInfo, queryOrganizationDto));
    }

    @HussarTransactional
    public void organizationChange(Long orgId, Long parentId, String orgType, Integer struOrder) {
        this.transferOrganizationManager.organizationChange(orgId, parentId, orgType, struOrder);
    }

    @HussarTransactional
    public synchronized void refreshOrgan() {
        this.editOrganizationManager.refreshOrgan();
    }

    public ApiResponse<List<SysStruRuleVo>> getOrganizationTypeByParentId(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.getOrganizationTypeByParentId(parentId));
    }

    public ApiResponse<List<OrganizationTreeVo>> getOrderOrganizationTree(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.getOrderOrganizationTree(parentId));
    }

    public ApiResponse<OrganizationTreeVo> lazyOrganizationById(Long id) {
        return ApiResponse.success((Object)this.queryOrganizationManager.lazyOrganizationById(id));
    }

    public ApiResponse<List<ReadOnlyOrganizationTreeVo>> lazyLoadingOrganizationTreeNoPermissions(Long parentId) {
        return ApiResponse.success(this.queryOrganizationManager.lazyLoadOrganizationTreeNoPermissions(parentId));
    }

    public ApiResponse<Page<OrganizationVo>> transferOrganizationList(PageInfo pageInfo, QueryTransferOrganizationListDto queryOrganizationDto) {
        return ApiResponse.success(this.queryOrganizationManager.transferOrganizationList(pageInfo, queryOrganizationDto));
    }

    public ApiResponse<String> getOrganFname(Long struId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.getOrganFname(struId), (String)"\u64cd\u4f5c\u6210\u529f");
    }

    public ApiResponse<SelectCustomOrgTreeVo> getCustomOrgTree(Long dataRightId) {
        return ApiResponse.success((Object)this.queryOrganizationManager.getCustomOrgTree(dataRightId));
    }

    public List<OrganTreeInitVo> getOrganTreeInitVos(Long parentId, int ifLazy, Integer defaultLevel, boolean withStaff) {
        if (ifLazy != 0 && ifLazy != 1) {
            throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u662f\u5426\u61d2\u52a0\u8f7d\u53c2\u6570");
        }
        int defaultLevelNum = 1;
        if (defaultLevel != null && defaultLevel > 0) {
            defaultLevelNum = defaultLevel;
        }
        if (ifLazy == 0) {
            defaultLevelNum = 0;
        }
        List<OrganTreeInitVo> organs = this.queryOrganizationManager.getOrgansByParentIdAndLevel(parentId, defaultLevelNum, withStaff, false);
        if (parentId.toString().equals("11")) {
            OrganTreeInitVo firstOrgan = new OrganTreeInitVo();
            firstOrgan.setId("11");
            if (!withStaff) {
                firstOrgan.setLabel("\u7ec4\u7ec7\u673a\u6784");
            } else {
                firstOrgan.setLabel("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
            }
            firstOrgan.setParentId("0");
            firstOrgan.setStruLevel(0);
            firstOrgan.setChangedLevel(1);
            List<OrganTreeInitVo> organTreeInitVos = this.sysStruMapper.queryChildrenOrgan(Long.parseLong("11"), withStaff, false);
            if (organTreeInitVos.size() != 0) {
                firstOrgan.setHasChildren(Boolean.valueOf(true));
            }
            organs.add(firstOrgan);
        }
        List<OrganTreeInitVo> organTree = this.queryOrganizationManager.getOrganTree(organs);
        return organTree;
    }

    public List<OrganTreeInitVo> getChildrenOrgan(Long parentId, boolean withStaff) {
        return this.queryOrganizationManager.getChildrenOrgan(parentId, withStaff, false);
    }

    public List<OrganTreeInitVo> getOrgansLikeName(String searchValue, boolean isStaff) {
        return this.queryOrganizationManager.getOrgansLikeName(searchValue, isStaff);
    }

    public List<OrganTreeInitVo> getUpOrganTreeByOrganId(Long id, boolean withStaff) {
        int defaultLevel = 0;
        if (!id.toString().equals("11")) {
            Integer level = this.sysStruMapper.getStruLevelByStruId(id);
            if (level != null) {
                defaultLevel = level;
            } else {
                throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u53c2\u6570");
            }
        }
        List<Object> parentLevelOrganList = new ArrayList();
        parentLevelOrganList = !withStaff ? this.sysStruMapper.queryUpOrgansByFidAndLevel("", defaultLevel, withStaff, false) : this.sysStruMapper.queryUpOrgansAndStaffsByFidAndLevel("", defaultLevel, withStaff, false);
        for (OrganTreeInitVo organTreeInitVo : parentLevelOrganList) {
            organTreeInitVo.setChangedLevel(organTreeInitVo.getStruLevel() + 1);
        }
        OrganTreeInitVo firstOrgan = new OrganTreeInitVo();
        firstOrgan.setId("11");
        if (!withStaff) {
            firstOrgan.setLabel("\u7ec4\u7ec7\u673a\u6784");
        } else {
            firstOrgan.setLabel("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        }
        firstOrgan.setParentId("0");
        firstOrgan.setStruLevel(0);
        firstOrgan.setChangedLevel(1);
        firstOrgan.setHasChildren(Boolean.valueOf(true));
        parentLevelOrganList.add(firstOrgan);
        Long l = this.queryOrganizationManager.getParentOrganId(id);
        List<Object> organList = new ArrayList();
        organList = !withStaff ? this.sysStruMapper.queryBrotherOrgans(l, withStaff, false) : this.sysStruMapper.queryBrotherOrgansAndStaffs(l, withStaff, false);
        organList.addAll(parentLevelOrganList);
        return this.queryOrganizationManager.getOrganTree(organList);
    }

    public OrganTreeInitVo getOrganInfoById(Long struId, boolean isStaff) {
        return this.queryOrganizationManager.getOrganInfoById(struId, isStaff);
    }
}

