/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.iamdatasync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.util.HttpUtil;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMTokenToHussarTokenService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IAMTokenToHussarTokenServiceImpl
implements IAMTokenToHussarTokenService {
    @Value(value="${IAM.auth.address:default}")
    private String ipAddress;
    @Value(value="${IAM.auth.clientId:default}")
    private String clientId;
    @Value(value="${IAM.auth.clientSecret:default}")
    private String clientSecret;
    @Value(value="${IAM.request-way:default}")
    private String requestWay;

    public JSONObject getUserInfo(Map<String, String> param) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", param.get("clientId")));
        params.add(new BasicNameValuePair("access_token", param.get("accessToken")));
        String res = HttpUtil.get((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/getUserInfo", params);
        return JSONObject.parseObject((String)res);
    }

    public JSONObject checkTokenValid(Map<String, String> param) throws IOException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("access_token", param.get("accessToken")));
        String res = HttpUtil.get((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/checkTokenValid", params);
        return JSONObject.parseObject((String)res);
    }

    public JSONObject refreshToken(Map<String, String> param) throws IOException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", param.get("clientId")));
        params.add(new BasicNameValuePair("client_secret", param.get("clientSecret")));
        params.add(new BasicNameValuePair("refresh_token", param.get("refreshToken")));
        params.add(new BasicNameValuePair("grant_type", "refresh_token"));
        String res = HttpUtil.post((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/refreshToken", params);
        return JSONObject.parseObject((String)res);
    }

    public JSONObject getTokenInfo(Map<String, String> param) throws IOException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("access_token", param.get("accessToken")));
        String res = HttpUtil.get((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/getTokenInfo", params);
        return JSONObject.parseObject((String)res);
    }

    public JSONObject revokeToken(Map<String, String> param) throws IOException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("access_token", param.get("accessToken")));
        String res = HttpUtil.post((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/revokeToken", params);
        return JSONObject.parseObject((String)res);
    }
}

