/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.iamdatasync.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.banboocloud.Codec.BamboocloudFacade;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.iamdatasync.constants.AppConstants;
import com.jxdinfo.hussar.authorization.iamdatasync.model.SchemaAttr;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMAuthcService;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMDataSyncService;
import com.jxdinfo.hussar.authorization.iamdatasync.service.ISchemaAttrService;
import com.jxdinfo.hussar.authorization.iamdatasync.util.BamboocloudUtils;
import com.jxdinfo.hussar.authorization.iamdatasync.util.SHA256Util;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IAMDataSyncServiceImpl
implements IAMDataSyncService {
    private static Logger logger = LoggerFactory.getLogger(IAMDataSyncServiceImpl.class);
    @Autowired
    private ISchemaAttrService schemaAttrService;
    @Autowired
    private ISysOrganService sysOrganService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private ISysOfficeService sysOfficeService;
    @Autowired
    private ISysStaffService sysStaffService;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysRoleGroupService sysRoleGroupService;
    @Autowired
    private ISysFunctionsService sysFunctionsService;
    @Autowired
    private ISysFunctionModulesService sysFunctionModulesService;
    @Autowired
    private ISysResourcesService sysResourcesService;
    @Autowired
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Autowired
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Autowired
    private ISysRoleDataRightService sysRoleDataRightService;
    @Autowired
    private ISysRoleResourceService sysRoleResourceService;
    @Autowired
    private IAMAuthcService iamAuthcService;
    @Autowired
    private ISysDicRefService sysDicRefService;
    @Autowired
    private ISysDicTypeService sysDicTypeService;
    @Autowired
    private ISysDicSingleService sysDicSingleService;
    @Autowired
    private ISysStruAssistOrganService sysStruAssistOrganService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    private static final String SIGN_ERR = "\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25";
    @Value(value="${IAM.data-sync.key:default}")
    private String key;
    @Value(value="${IAM.data-sync.type:default}")
    private String type;
    @Value(value="${IAM.data-sync.signType:default}")
    private String signType;
    @Value(value="${IAM.data-sync.bimRemoteUser:default}")
    private String localUserName;
    @Value(value="${IAM.data-sync.bimRemotePwd:default}")
    private String localPwd;
    @Value(value="${IAM.grant.appKey:default}")
    private String appKey;

    public String SchemaService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        logger.info("\u89e3\u5bc6\u540e\u7684\u4fe1\u606f-------" + bodyparam);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                logger.info("\u7528\u6237\u540d-------" + username);
                logger.info("\u5bc6\u7801--------" + password);
                logger.info("\u914d\u7f6e\u7528\u6237\u540d-------" + this.localUserName);
                logger.info("\u914d\u7f6e\u5bc6\u7801--------" + this.localPwd);
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                ArrayList accountList = new ArrayList();
                ArrayList organizationList = new ArrayList();
                ArrayList functionList = new ArrayList();
                ArrayList resourceBtnList = new ArrayList();
                ArrayList resourceRightList = new ArrayList();
                ArrayList jobList = new ArrayList();
                ArrayList postList = new ArrayList();
                ArrayList userpostList = new ArrayList();
                List schemaAttrList = this.schemaAttrService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"create_time"));
                logger.info("for\u5faa\u73af\u4e4b\u524d\uff0c\u6253\u5370schemaAttrList.size():{}", (Object)schemaAttrList.size());
                block22: for (int i = 0; i < schemaAttrList.size(); ++i) {
                    SchemaAttr schemaAttr = (SchemaAttr)schemaAttrList.get(i);
                    logger.info("for\u5faa\u73af\u4e2d\uff0c\u6253\u5370schemaAttr:{},{},{},{},{}", new Object[]{schemaAttr.getMultivalued(), schemaAttr.getAttrName(), schemaAttr.getRequired(), schemaAttr.getAttrType(), schemaAttr.getAttrGroup()});
                    HashMap<String, Object> attr = new HashMap<String, Object>();
                    attr.put("multivalued", !"0".equals(schemaAttr.getMultivalued()));
                    attr.put("name", schemaAttr.getAttrName());
                    attr.put("required", !"0".equals(schemaAttr.getRequired()));
                    attr.put("type", schemaAttr.getAttrType());
                    switch (schemaAttr.getAttrGroup()) {
                        case "account": {
                            accountList.add(attr);
                            continue block22;
                        }
                        case "organization": {
                            organizationList.add(attr);
                            continue block22;
                        }
                        case "function": {
                            functionList.add(attr);
                            continue block22;
                        }
                        case "resourcebtn": {
                            resourceBtnList.add(attr);
                            continue block22;
                        }
                        case "resourceright": {
                            resourceRightList.add(attr);
                            continue block22;
                        }
                        case "post": {
                            postList.add(attr);
                            continue block22;
                        }
                        case "job": {
                            jobList.add(attr);
                            continue block22;
                        }
                        case "userpost": {
                            userpostList.add(attr);
                            continue block22;
                        }
                    }
                }
                HashMap schema = new HashMap();
                schema.put("account", accountList);
                schema.put("organization", organizationList);
                schema.put("function", functionList);
                schema.put("RESOURCEBTN", resourceBtnList);
                schema.put("RESOURCERIGHT", resourceRightList);
                schema.put("post", postList);
                schema.put("job", jobList);
                schema.put("userpost", userpostList);
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                logger.info("====================schema:{}", schema);
                String mapJson = JSON.toJSONString(schema);
                logger.info("====================mapJson:{}", (Object)mapJson);
                logger.info("====================BamboocloudFacade.encrypt:{}", (Object)BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type));
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  SchemaService\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e.getMessage());
            e.printStackTrace();
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    @Transactional
    public String QueryAllResourceIdsService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("\u8fd4\u56de\u6240\u6709\u7684\u529f\u80fdid\u5165\u53c2\uff1a{}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                String resourceType = (String)reqmap.get("resourceType");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                ArrayList<String> uids = new ArrayList<String>();
                if ("function".equals(resourceType)) {
                    int i;
                    List sysFunctionModulesList = this.sysFunctionModulesService.list();
                    List sysFunctionsList = this.sysFunctionsService.list();
                    for (i = 0; i < sysFunctionModulesList.size(); ++i) {
                        uids.add(String.valueOf(((SysFunctionModules)sysFunctionModulesList.get(i)).getId()));
                    }
                    for (i = 0; i < sysFunctionsList.size(); ++i) {
                        uids.add(String.valueOf(((SysFunctions)sysFunctionsList.get(i)).getId()));
                    }
                } else if ("resourceright".equals(resourceType)) {
                    List dataScopeType = this.sysDicRefService.getDictByType("data_scope_type");
                    for (DicSingle item : dataScopeType) {
                        uids.add(String.valueOf(item.getId()));
                    }
                } else if ("resourcebtn".equals(resourceType)) {
                    Wrapper qwBtn = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"RES_TYPE_ID", (Object)"res_btn")).eq((Object)"IS_BUTTON_RESOURCE", (Object)"1");
                    List sysResourcesListBtn = this.sysResourcesService.list(qwBtn);
                    for (int i = 0; i < sysResourcesListBtn.size(); ++i) {
                        uids.add(String.valueOf(((SysResources)sysResourcesListBtn.get(i)).getId()));
                    }
                }
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("resourceIdList", uids);
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  QueryAllResourceIdsService\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e.getMessage());
            e.printStackTrace();
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    @Transactional
    public String QueryResourceByIdService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("\u6839\u636e\u529f\u80fdid\u67e5\u8be2\u529f\u80fd\u5165\u53c2\uff1a{}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                Long id = Long.parseLong((String)reqmap.get("resourceId"));
                String resourceType = (String)reqmap.get("resourceType");
                HashMap<String, Object> resource = new HashMap<String, Object>();
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                if ("function".equals(resourceType)) {
                    SysFunctionModules sysFunctionModules = (SysFunctionModules)this.sysFunctionModulesService.getById((Serializable)id);
                    SysFunctions sysFunctions = (SysFunctions)this.sysFunctionsService.getById((Serializable)id);
                    if (sysFunctionModules != null) {
                        resource.put("functionId", sysFunctionModules.getId());
                        resource.put("functionCode", sysFunctionModules.getId());
                        resource.put("functionName", sysFunctionModules.getFunctionModuleName());
                        resource.put("functionParentCode", sysFunctionModules.getParentModuleId());
                        resource.put("isleaf", "false");
                        resource.put("isFunctionModule", "0");
                    } else if (sysFunctions != null) {
                        resource.put("functionId", sysFunctions.getId());
                        resource.put("functionCode", sysFunctions.getId());
                        resource.put("functionName", sysFunctions.getFunctionName());
                        resource.put("functionParentCode", sysFunctions.getFunctionModuleId());
                        resource.put("isleaf", "true");
                        resource.put("isFunctionModule", "1");
                    }
                } else if ("resourceright".equals(resourceType)) {
                    DicSingle dictSingele = (DicSingle)this.sysDicSingleService.getById((Serializable)id);
                    resource.put("resourceIdRight", dictSingele.getId());
                    resource.put("resourceCodeRight", dictSingele.getValue());
                    resource.put("resourceNameRight", dictSingele.getLabel());
                    resource.put("resourceTypeRight", "res_rights");
                } else if ("resourcebtn".equals(resourceType)) {
                    SysResources resourceBtn = (SysResources)this.sysResourcesService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getId, (Object)id)).eq(SysResources::getResTypeId, (Object)"res_btn")).eq(SysResources::getIsButtonResource, (Object)"1"));
                    resource.put("resourceIdBtn", resourceBtn.getId());
                    resource.put("resourceCodeBtn", resourceBtn.getId());
                    resource.put("resourceNameBtn", resourceBtn.getResourceName());
                    resource.put("resourceTypeBtn", resourceBtn.getResTypeId());
                } else {
                    schema.put("resultCode", "500");
                    schema.put("message", "\u672a\u627e\u5230\u5bf9\u5e94\u529f\u80fd");
                    String mapJson = JSON.toJSONString(schema);
                    return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
                }
                schema.put("resultCode", "0");
                schema.put("resource", resource);
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  QueryResourceByIdService\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e.getMessage());
            e.printStackTrace();
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    @Transactional
    public String UserCreateService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u89e3\u5bc6\u540e\u7684\u4fe1\u606fbodyparam-------{}", (Object)bodyparam);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                String uid = this.createUser(bodyparam);
                HashMap<String, String> schema = new HashMap<String, String>();
                schema.put("uid", uid);
                schema.put("bimRequestId", (String)reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u9a8c\u8bc1\u5931\u8d25=========");
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u5f02\u5e38\u5931\u8d25========={}", (Object)e.getMessage());
            e.printStackTrace();
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private String createUser(String bodyparam) {
        JSONObject jsonObject = JSONObject.parseObject((String)bodyparam);
        logger.info("IAM\u521b\u5efa\u4eba\u5458\u53c2\u6570\uff1ajsonObject========={}", (Object)jsonObject);
        SysUsers sysUsers = (SysUsers)jsonObject.toJavaObject(SysUsers.class);
        SysUsers one = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)sysUsers.getUserAccount()));
        if (one != null) {
            logger.info("\u7528\u6237{}======\u5df2\u5b58\u5728", (Object)sysUsers.getUserAccount());
            new BaseException("\u7528\u6237" + sysUsers.getUserAccount() + "\u5df2\u5b58\u5728");
            return null;
        }
        SysStru sysStru = (SysStru)jsonObject.toJavaObject(SysStru.class);
        SysStaff sysStaff = (SysStaff)jsonObject.toJavaObject(SysStaff.class);
        SysOrgan sysOrgan = (SysOrgan)jsonObject.toJavaObject(SysOrgan.class);
        String orgcode = jsonObject.getString("orgcode");
        SysOrgan parentOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysOrgan::getOrganCode, (Object)orgcode));
        SysStru parentStru = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysStru::getOrganId, (Object)parentOrgan.getId()));
        sysOrgan.setOrganType("9");
        sysOrgan.setOrganFcode(sysOrgan.getOrganFcode() + "/" + sysUsers.getUserAccount() + "/");
        sysOrgan.setOrganFname(sysOrgan.getOrganFname() + "/" + sysUsers.getUserName());
        logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u5b58\u50a8sys_organ========={}", (Object)sysOrgan);
        this.sysOrganService.save((Object)sysOrgan);
        sysStru.setId(Long.valueOf(IdWorker.getId((Object)new SysStru())));
        sysStru.setOrganId(sysOrgan.getId());
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setStruType("9");
        sysStru.setParentId(parentStru.getId());
        sysStru.setStruFid(parentStru.getStruFid() + sysStru.getId() + "/");
        sysStru.setStruLevel(Integer.valueOf(parentStru.getStruLevel() + 1));
        sysStru.setIsLeaf("0");
        sysStru.setIsEmployee("1");
        logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u5b58\u50a8sys_stru========={}", (Object)sysStru);
        this.sysStruService.save((Object)sysStru);
        sysStaff.setStruId(sysStru.getId());
        logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u5b58\u50a8sys_staff========={}", (Object)sysStaff);
        this.sysStaffService.save((Object)sysStaff);
        if (null != sysUsers.getPassword()) {
            sysUsers.setPassword(this.credentialsMatcher.passwordEncode(sysUsers.getPassword().getBytes()));
        } else {
            logger.info("IAM\u540c\u6b65\u7528\u6237\u5bc6\u7801\u4e3a\u7a7a,\u4f7f\u7528\u9ed8\u8ba4\u5bc6\u7801\u52a0\u5bc6\u8fdb\u884c\u5b58\u50a8\uff1a===========");
            sysUsers.setPassword(this.credentialsMatcher.passwordEncode("Qddt@1357".getBytes()));
        }
        sysUsers.setCorporationId(parentStru.getId());
        sysUsers.setDepartmentId(parentStru.getId());
        sysUsers.setEmployeeId(sysStru.getId());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(-1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setTypeProperty("1");
        logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u5b58\u50a8sys_users========={}", (Object)sysUsers);
        this.sysUsersService.save((Object)sysUsers);
        if (HussarUtils.isNotEmpty((Object)sysUsers.getChar2())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("userServiceId", IdWorker.getId((Object)new SysStru()));
            param.put("userId", String.valueOf(sysUsers.getId()));
            param.put("messageType", "cp");
            param.put("otherUserId", sysUsers.getChar2());
            param.put("delFlag", "0");
            this.sysUsersService.saveMsgUserService(param);
        }
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(sysUsers.getId());
        sysUserRole.setGrantedRole(Long.valueOf(1450785135866925064L));
        sysUserRole.setAdminOption("1");
        logger.info("IAM\u521b\u5efa\u4eba\u5458\uff1a\u7ed9\u4eba\u5458\u7ed1\u5b9a\u516c\u5171\u89d2\u8272========={}", (Object)sysUserRole);
        this.sysUserRoleService.save((Object)sysUserRole);
        return String.valueOf(sysUsers.getId());
    }

    @Transactional
    public String UserUpdateService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("IAM\u66f4\u65b0\u4eba\u5458\uff1a\u89e3\u5bc6\u540e\u7684\u4fe1\u606freqmap-------{}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                this.updateUser(bodyparam);
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            logger.info("IAM\u66f4\u65b0\u4eba\u5458\uff1a\u9a8c\u8bc1\u5931\u8d25=========");
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("IAM\u66f4\u65b0\u4eba\u5458\uff1a\u5f02\u5e38\u5931\u8d25========={}", (Object)e.getMessage());
            e.printStackTrace();
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private String updateUser(String bodyparam) {
        boolean flag;
        JSONObject jsonObject = JSONObject.parseObject((String)bodyparam);
        logger.info("IAM\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u53c2\u6570\uff1ajsonObject========={}", (Object)jsonObject);
        SysUsers sysUsers = (SysUsers)jsonObject.toJavaObject(SysUsers.class);
        SysStru sysStru = (SysStru)jsonObject.toJavaObject(SysStru.class);
        SysStaff sysStaff = (SysStaff)jsonObject.toJavaObject(SysStaff.class);
        SysOrgan sysOrgan = (SysOrgan)jsonObject.toJavaObject(SysOrgan.class);
        String orgcode = jsonObject.getString("orgcode");
        SysOrgan parentOrgan = null;
        SysStru parentStru = null;
        boolean bl = flag = !HussarUtils.isEmpty((Object)orgcode);
        if (flag) {
            parentOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysOrgan::getOrganCode, (Object)orgcode));
            parentStru = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysStru::getOrganId, (Object)parentOrgan.getId()));
        }
        if (flag) {
            sysUsers.setCorporationId(parentStru.getId());
            sysUsers.setDepartmentId(parentStru.getId());
        }
        String userId = jsonObject.getString("bimUid");
        sysUsers.setId(Long.valueOf(Long.parseLong(userId)));
        logger.info("IAM\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u53c2\u6570\uff1a\u66f4\u65b0\u7528\u6237\u8868sysUsers========={}", (Object)sysUsers);
        if (null != sysUsers.getPassword()) {
            sysUsers.setPassword(this.credentialsMatcher.passwordEncode(sysUsers.getPassword().getBytes()));
        } else {
            logger.info("IAM\u540c\u6b65\u7528\u6237\u5bc6\u7801\u4e3a\u7a7a,\u4f7f\u7528\u9ed8\u8ba4\u5bc6\u7801\u52a0\u5bc6\u8fdb\u884c\u5b58\u50a8\uff1a===========");
            sysUsers.setPassword(this.credentialsMatcher.passwordEncode("Qddt@1357".getBytes()));
        }
        this.sysUsersService.saveOrUpdate((Object)sysUsers);
        sysUsers = (SysUsers)this.sysUsersService.getById((Serializable)sysUsers.getId());
        if (HussarUtils.isNotEmpty((Object)sysUsers.getChar2())) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("userId", String.valueOf(sysUsers.getId()));
            param.put("messageType", "cp");
            param.put("delFlag", "0");
            List msgUserService = this.sysUsersService.getMsgUserService(param);
            if (HussarUtils.isEmpty((Object)msgUserService)) {
                param.put("userServiceId", IdWorker.getId((Object)new SysStru()));
                param.put("otherUserId", sysUsers.getChar2());
                this.sysUsersService.saveMsgUserService(param);
            } else {
                Map map = (Map)msgUserService.get(0);
                map.put("otherUserId", sysUsers.getChar2());
                this.sysUsersService.updateMsgUserService(map);
            }
        } else {
            this.sysUsersService.deleteMsgUserServiceByUserId(sysUsers.getId());
        }
        sysStru.setId(sysUsers.getEmployeeId());
        if (flag) {
            sysStru.setParentId(parentStru.getId());
            sysStru.setStruFid(parentStru.getStruFid() + sysStru.getId() + "/");
            sysStru.setStruLevel(Integer.valueOf(parentStru.getStruLevel() + 1));
        }
        sysStru.setIsEmployee("1");
        logger.info("IAM\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u53c2\u6570\uff1a\u66f4\u65b0stru========={}", (Object)sysStru);
        this.sysStruService.saveOrUpdate((Object)sysStru);
        sysStru = (SysStru)this.sysStruService.getById((Serializable)sysStru.getId());
        SysStaff sysStaff1 = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"stru_id", (Object)sysStru.getId()));
        sysStaff.setId(sysStaff1.getId());
        logger.info("IAM\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u53c2\u6570\uff1a\u66f4\u65b0staff========={}", (Object)sysStaff);
        this.sysStaffService.saveOrUpdate((Object)sysStaff);
        sysOrgan.setId(sysStru.getOrganId());
        if (parentOrgan != null) {
            sysOrgan.setOrganFname(parentOrgan.getOrganFname() + "/" + sysUsers.getUserName());
        }
        logger.info("IAM\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u53c2\u6570\uff1a\u66f4\u65b0organ========={}", (Object)sysOrgan);
        this.sysOrganService.saveOrUpdate((Object)sysOrgan);
        return String.valueOf(sysUsers.getId());
    }

    public String QueryAllUserIdsService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("\u67e5\u8be2\u6240\u6709\u7528\u6237\u7684id\u5165\u53c2\uff1a{}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                List sysUsersList = this.sysUsersService.list();
                ArrayList<String> uids = new ArrayList<String>();
                for (int i = 0; i < sysUsersList.size(); ++i) {
                    uids.add(String.valueOf(((SysUsers)sysUsersList.get(i)).getId()));
                }
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("userIdList", uids);
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  QueryAllUserIdsService\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e);
            e.printStackTrace();
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    public String QueryUserByIdService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("\u901a\u8fc7id\u83b7\u53d6\u7528\u6237\u7684\u6240\u6709\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                Map<String, Object> user = this.queryUserById(Long.parseLong((String)reqmap.get("bimUid")));
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("account", user);
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  QueryUserByIdService\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e.getMessage());
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private Map<String, Object> queryUserById(Long bimUid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getById((Serializable)bimUid);
        map.put("userName", sysUsers.getUserName());
        map.put("password", sysUsers.getPassword());
        map.put("accountStatus", sysUsers.getAccountStatus());
        map.put("eMail", sysUsers.geteMail());
        map.put("telephone", sysUsers.getTelephone());
        map.put("mobile", sysUsers.getMobile());
        map.put("userAccount", sysUsers.getUserAccount());
        map.put("personId", sysUsers.getPersonId());
        if (sysUsers.getEmployeeId() == null) {
            return map;
        }
        SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)sysUsers.getEmployeeId());
        SysStaff sysStaff = (SysStaff)this.sysStaffService.getOne((Wrapper)new QueryWrapper().eq((Object)"stru_id", (Object)sysStru.getId()));
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)sysStru.getOrganId());
        SysStru parentSysStru = (SysStru)this.sysStruService.getById((Serializable)sysStru.getParentId());
        SysOrgan parentSysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)parentSysStru.getOrganId());
        map.put("organCode", sysOrgan.getOrganCode());
        map.put("organName", sysOrgan.getOrganName());
        map.put("organFcode", sysOrgan.getOrganFcode());
        map.put("organFname", sysOrgan.getOrganFname());
        map.put("isEmployee", sysStru.getIsEmployee());
        map.put("staffPosition", sysStru.getStaffPosition());
        map.put("name", sysStaff.getName());
        map.put("birthday", sysStaff.getBirthday());
        map.put("sex", sysStaff.getSex());
        map.put("idcard", sysStaff.getIdcard());
        map.put("address", sysStaff.getAddress());
        map.put("workDate", sysStaff.getWorkDate());
        map.put("orgcode", parentSysOrgan.getOrganCode());
        return map;
    }

    @Transactional
    public String OrgCreateService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1areqmap========={}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                String uid = this.createOrg(bodyparam);
                HashMap<String, String> schema = new HashMap<String, String>();
                schema.put("uid", uid);
                schema.put("bimRequestId", (String)reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u9a8c\u8bc1\u5931\u8d25=========");
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u5f02\u5e38\u5931\u8d25========={}", (Object)e.getMessage());
            e.printStackTrace();
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private String createOrg(String bodyparam) {
        JSONObject jsonObject = JSONObject.parseObject((String)bodyparam);
        logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1ajsonObject========={}", (Object)jsonObject);
        SysStru sysStru = (SysStru)jsonObject.toJavaObject(SysStru.class);
        SysOrgan sysOrgan = (SysOrgan)jsonObject.toJavaObject(SysOrgan.class);
        String parentcode = jsonObject.getString("parentcode");
        SysOrgan parentOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysOrgan::getOrganCode, (Object)parentcode));
        SysStru parentStru = null;
        String parentStruFid = "/";
        Integer level = 0;
        String isLeaf = "Y";
        if (parentOrgan != null) {
            parentStru = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysStru::getOrganId, (Object)parentOrgan.getId()));
            parentStruFid = parentStru.getStruFid();
            level = parentStru.getStruLevel();
            parentStru.setIsLeaf("N");
            logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u66f4\u65b0\u7236\u7ea7\u5b50\u53f6\u8282\u70b9\u6807\u8bc6========={}", (Object)parentStru);
            this.sysStruService.updateById((Object)parentStru);
        }
        logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u4fdd\u5b58sysOrgan========={}", (Object)sysOrgan);
        SysOrgan sysOrganOld = (SysOrgan)this.sysOrganService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysOrgan::getOrganCode, (Object)sysOrgan.getOrganCode()));
        if (sysOrganOld == null) {
            this.sysOrganService.save((Object)sysOrgan);
            sysStru.setId(Long.valueOf(IdWorker.getId((Object)new SysStru())));
            sysStru.setOrganId(sysOrgan.getId());
            sysStru.setOrganAlias(sysOrgan.getOrganName());
            sysStru.setStruType(sysOrgan.getOrganType());
            sysStru.setParentId(Long.valueOf(parentStru == null ? 11L : parentStru.getId()));
            sysStru.setStruFid(parentStruFid + sysStru.getId() + "/");
            sysStru.setStruLevel(Integer.valueOf(level + 1));
            sysStru.setIsLeaf(isLeaf);
            logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u4fdd\u5b58sysStru========={}", (Object)sysStru);
            this.sysStruService.save((Object)sysStru);
            if ("11".equals(sysStru.getParentId())) {
                sysOrgan.setOrganFname("/" + sysOrgan.getOrganName());
                this.sysOrganService.updateById((Object)sysOrgan);
            }
            SysOffice sysOffice = new SysOffice();
            sysOffice.setStruId(sysStru.getId());
            ArrayList<Long> struList = new ArrayList<Long>();
            struList.add(sysStru.getId());
            List officeList = this.sysOfficeService.getSysOfficeByStruId(struList);
            if (officeList.size() == 0) {
                logger.info("IAM\u521b\u5efa\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u4fdd\u5b58sysOffice========={}", (Object)sysOffice);
                this.sysOfficeService.save((Object)sysOffice);
            }
        } else {
            sysOrgan.setId(sysOrganOld.getId());
            this.sysOrganService.saveOrUpdate((Object)sysOrgan);
            SysStru sysStru1 = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().eq((Object)"ORGAN_ID", (Object)sysOrganOld.getId()));
            sysStru.setId(sysStru1.getId());
            sysStru.setOrganAlias(sysOrgan.getOrganName());
            sysStru.setStruType(sysOrgan.getOrganType());
            sysStru.setParentId(Long.valueOf(parentStru == null ? 11L : parentStru.getId()));
            sysStru.setStruFid(parentStruFid + sysStru.getId() + "/");
            sysStru.setStruLevel(Integer.valueOf(level + 1));
            sysStru.setIsLeaf(isLeaf);
            this.sysStruService.saveOrUpdate((Object)sysStru);
        }
        return String.valueOf(sysOrgan.getId());
    }

    @Transactional
    public String OrgUpdateService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("IAM\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1areqmap========={}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                this.updateOrg(bodyparam);
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            logger.info("IAM\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u9a8c\u8bc1\u5931\u8d25=========");
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("IAM\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1a\u5f02\u5e38\u5931\u8d25========={}", (Object)e.getMessage());
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private String updateOrg(String bodyparam) {
        JSONObject jsonObject = JSONObject.parseObject((String)bodyparam);
        logger.info("IAM\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u53c2\u6570\uff1ajsonObject========={}", (Object)jsonObject);
        SysStru sysStru = (SysStru)jsonObject.toJavaObject(SysStru.class);
        SysOrgan sysOrgan = (SysOrgan)jsonObject.toJavaObject(SysOrgan.class);
        String parentcode = jsonObject.getString("parentcode");
        SysOrgan parentOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysOrgan::getOrganCode, (Object)parentcode));
        SysStru parentStru = null;
        String parentStruFid = "/";
        Integer level = 0;
        if (parentOrgan != null) {
            parentStru = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysStru::getOrganId, (Object)parentOrgan.getId()));
            parentStruFid = parentStru.getStruFid();
            level = parentStru.getStruLevel();
            parentStru.setIsLeaf("N");
            this.sysStruService.updateById((Object)parentStru);
        }
        String orgId = jsonObject.getString("bimOrgId");
        sysOrgan.setId(Long.valueOf(Long.parseLong(orgId)));
        this.sysOrganService.saveOrUpdate((Object)sysOrgan);
        SysOrgan sysOrganNew = (SysOrgan)this.sysOrganService.getById((Serializable)((Object)orgId));
        SysStru sysStru1 = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().eq((Object)"ORGAN_ID", (Object)orgId));
        sysStru.setId(sysStru1.getId());
        sysStru.setOrganAlias(sysOrganNew.getOrganName());
        sysStru.setStruType(sysOrganNew.getOrganType());
        if (parentOrgan != null) {
            sysStru.setParentId(Long.valueOf(parentStru == null ? 11L : parentStru.getId()));
            sysStru.setStruFid(parentStruFid + sysStru.getId() + "/");
            sysStru.setStruLevel(Integer.valueOf(level + 1));
        } else if (jsonObject.containsKey((Object)"parentcode") && HussarUtils.isEmpty((Object)jsonObject.get((Object)"parentcode"))) {
            sysStru.setStruLevel(Integer.valueOf(1));
        }
        this.sysStruService.saveOrUpdate((Object)sysStru);
        Long parentId = sysStru1.getParentId();
        if (parentId != 11L) {
            List sysStruList = this.sysStruService.list((Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)parentId));
            if (HussarUtils.isEmpty((Object)sysStruList)) {
                SysStru sysStruOld = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)parentId));
                sysStruOld.setIsLeaf("Y");
                this.sysStruService.updateById((Object)sysStruOld);
            }
        } else {
            Long struId = sysStru1.getId();
            List sysStruList = this.sysStruService.list((Wrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)struId));
            if (HussarUtils.isEmpty((Object)sysStruList)) {
                SysStru sysStruOld = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId));
                sysStruOld.setIsLeaf("Y");
                this.sysStruService.updateById((Object)sysStruOld);
            }
        }
        return orgId;
    }

    public String QueryAllOrgIdsService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("\u83b7\u53d6\u6240\u6709\u7684\u7ec4\u7ec7\u673a\u6784id\u5165\u53c2\uff1a{}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                List sysOrganList = this.sysOrganService.list();
                ArrayList<String> orgs = new ArrayList<String>();
                for (int i = 0; i < sysOrganList.size(); ++i) {
                    orgs.add(String.valueOf(((SysOrgan)sysOrganList.get(i)).getId()));
                }
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("orgIdList", orgs);
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  QueryAllOrgIdsService\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e.getMessage());
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    public String QueryOrgByIdService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("\u6839\u636e\u7ec4\u7ec7\u673a\u6784id\u8fd4\u56de\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)reqmap);
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                Map<String, Object> organization = this.queryOrgById(Long.parseLong((String)reqmap.get("bimOrgId")));
                HashMap schema = new HashMap();
                schema.put("bimRequestId", reqmap.get("bimRequestId"));
                schema.put("resultCode", "0");
                schema.put("organization", organization);
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  QueryOrgByIdService\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e.getMessage());
            HashMap schema = new HashMap();
            schema.put("bimRequestId", reqmap.get("bimRequestId"));
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private Map<String, Object> queryOrgById(Long bimUid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysOrgan sysOrgan = (SysOrgan)this.sysOrganService.getById((Serializable)bimUid);
        SysStru sysStru = (SysStru)this.sysStruService.getOne((Wrapper)new QueryWrapper().eq((Object)"organ_id", (Object)bimUid));
        SysStru parentSysStru = (SysStru)this.sysStruService.getById((Serializable)sysStru.getParentId());
        if (parentSysStru != null) {
            SysOrgan parentOrg = (SysOrgan)this.sysOrganService.getById((Serializable)parentSysStru.getOrganId());
            map.put("parentcode", parentOrg.getOrganCode());
        }
        map.put("organCode", sysOrgan.getOrganCode());
        map.put("organName", sysOrgan.getOrganName());
        map.put("organFcode", sysOrgan.getOrganFcode());
        map.put("organFname", sysOrgan.getOrganFname());
        map.put("delFlag", sysOrgan.getDelFlag());
        return map;
    }

    @Transactional
    public String Grant(String bodyparam) {
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)bodyparam);
            logger.info("GRANT\u63a5\u53e3\uff1a\u53c2\u6570\u4fe1\u606fjsonObject================" + jsonObject);
            String signature = SHA256Util.getSHA256StrJava((String)(jsonObject.getString("entity") + this.appKey + jsonObject.getString("timestamp")));
            logger.info("signature----" + signature);
            if (signature.equals(jsonObject.get((Object)"signature"))) {
                String type = jsonObject.getString("type");
                JSONObject entity = null;
                JSONArray jsonArray = null;
                if ("D_ARG".equals(type) || "D_AR".equals(type) || "D_AM".equals(type)) {
                    entity = jsonObject.getJSONObject("entity");
                } else {
                    jsonArray = jsonObject.getJSONArray("entity");
                }
                String action = jsonObject.getString("action");
                HashMap<String, String> schema = new HashMap<String, String>();
                String resCode = "200";
                String msg = "success";
                switch (type) {
                    case "D_ARG": {
                        this.GrantRG(action, entity);
                        break;
                    }
                    case "D_AR": {
                        this.GrantDAR(action, entity);
                        break;
                    }
                    case "D_AM": {
                        this.GrantDAM(action, entity);
                        break;
                    }
                    case "R_USER_AR": {
                        this.GrantRUSERAR(action, jsonArray);
                        break;
                    }
                    case "R_ARG_AR": {
                        this.GrantDRG(action, jsonArray);
                        break;
                    }
                    case "R_AR_AM": {
                        this.GrantRARAM(action, jsonArray);
                        break;
                    }
                    case "R_AR_ADATA_D": {
                        this.GrantRARADATA(action, jsonArray);
                        break;
                    }
                    default: {
                        resCode = "500";
                        msg = "\u672a\u627e\u5230\u5bf9\u5e94\u6743\u9650\u7c7b\u578b";
                        logger.info(msg);
                    }
                }
                schema.put("resultCode", resCode);
                schema.put("message", msg);
                return JSON.toJSONString(schema);
            }
            HashMap<String, String> schema = new HashMap<String, String>();
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            return JSON.toJSONString(schema);
        }
        catch (Exception e) {
            logger.info("\u5bf9\u63a5IAM  Grant\u63a5\u53e3\u5f02\u5e38\u4fe1\u606f\uff1a=============" + e.getMessage());
            HashMap<String, String> schema = new HashMap<String, String>();
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            return JSON.toJSONString(schema);
        }
    }

    public String getSecretString(JSONObject jsonObject) {
        String res = JSONObject.toJSONString((Object)jsonObject);
        return BamboocloudFacade.encrypt((String)res, (String)this.key, (String)this.type);
    }

    public String getResString(String bodyParam) {
        return BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
    }

    public String ResourceCreateService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        logger.info("IAM\u8d44\u6e90\u540c\u6b65\u65b9\u6cd5ResourceCreateService() \u53c2\u6570:reqmap ============= " + reqmap);
        HashMap schema = new HashMap();
        schema.put("bimRequestId", reqmap.get("bimRequestId"));
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                String resourceType = (String)reqmap.get("resourceType");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                String id = "";
                if ("job".equals(resourceType)) {
                    id = this.createJobResource(reqmap);
                } else if ("post".equals(resourceType)) {
                    id = this.createPostResource(reqmap);
                } else if ("userpost".equals(resourceType)) {
                    id = this.createUserPostResource(reqmap);
                } else {
                    logger.info("IAM:\u672a\u627e\u5230\u540c\u6b65\u8d44\u6e90\u7c7b\u578b\uff1a=============");
                    schema.put("resultCode", "500");
                    schema.put("message", "\u672a\u627e\u5230\u540c\u6b65\u8d44\u6e90\u7c7b\u578b");
                    String mapJson = JSON.toJSONString(schema);
                    return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
                }
                if (HussarUtils.isNotEmpty((Object)id)) {
                    schema.put("uid", id);
                    schema.put("resultCode", "0");
                    schema.put("message", "success");
                }
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            logger.info("\u8d44\u6e90\u540c\u6b65\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private String createUserPostResource(Map<String, Object> reqmap) throws BaseException {
        logger.info("IAM\u517c\u5c97\u4fe1\u606f\u540c\u6b65\u65b9\u6cd5createUserPostResource()\u53c2\u6570reqmap:{}=================", reqmap);
        String empNo = (String)reqmap.get("empNo");
        String postId = (String)reqmap.get("postId");
        String postNo = (String)reqmap.get("postNo");
        String deptId = (String)reqmap.get("deptId");
        String deptNo = (String)reqmap.get("deptNo");
        String isDel = (String)reqmap.get("isDel");
        if (isDel != null && "1".equals(isDel)) {
            logger.info("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u8be5\u517c\u5c97\u4fe1\u606f\u4e3a\u5220\u9664\u72b6\u6001\uff0c\u5c06\u4e0d\u5bf9\u6b64\u4fe1\u606f\u8fdb\u884c\u540c\u6b65");
            return null;
        }
        DicSingle postInfo = (DicSingle)this.sysDicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getBak1, (Object)postId));
        if (null == postInfo) {
            logger.info("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u627e\u5230\u5c97\u4f4d\u4fe1\u606f======={}", (Object)postId);
            new BaseException("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u627e\u5230\u5c97\u4f4d\u4fe1\u606f:==" + postId);
            return null;
        }
        if (!"2".equals(postInfo.getBak2())) {
            logger.info("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u8be5\u5c97\u4f4d\u72b6\u6001\u4e3a\u4e0d\u53ef\u7528\uff1a======={}", (Object)postInfo.getBak1());
            new BaseException("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u8be5\u5c97\u4f4d\u72b6\u6001\u4e3a\u4e0d\u53ef\u7528:==" + postInfo.getBak1());
            return null;
        }
        SysUsers userInfo = this.sysUsersService.getUserByUserAccount(empNo);
        if (null == userInfo) {
            logger.info("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f======={}", (Object)empNo);
            new BaseException("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u67e5\u8be2\u5230\u4eba\u5458\u4fe1\u606f:==" + empNo);
            return null;
        }
        SysOrgan postFOrganInfo = (SysOrgan)this.sysOrganService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)deptNo));
        if (null == postFOrganInfo) {
            logger.info("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u627e\u5230\u5c97\u4f4d\u6240\u5c5e\u90e8\u95e8\u4fe1\u606f======={}", (Object)deptNo);
            new BaseException("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u627e\u5230\u5c97\u4f4d\u6240\u5c5e\u90e8\u95e8\u4fe1\u606f:==" + deptNo);
            return null;
        }
        SysStru postStruFInfo = (SysStru)this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)postFOrganInfo.getId()));
        if (null == postStruFInfo) {
            logger.info("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u627e\u5230\u5c97\u4f4d\u7236\u7ea7\u673a\u6784\u4fe1\u606f=======");
            new BaseException("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u672a\u627e\u5230\u5c97\u4f4d\u7236\u7ea7\u673a\u6784\u4fe1\u606f");
            return null;
        }
        SysOrgan postSysOrgan = (SysOrgan)this.sysOrganService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)postInfo.getValue()));
        SysStru postSysStru = null;
        if (null == postSysOrgan) {
            postSysOrgan = new SysOrgan();
            postSysOrgan.setOrganCode(postInfo.getValue());
            postSysOrgan.setOrganName(postInfo.getLabel());
            postSysOrgan.setOrganFcode(postFOrganInfo.getOrganCode() + postInfo.getValue() + "/");
            postSysOrgan.setOrganFname(postFOrganInfo.getOrganName() + "/" + postInfo.getLabel());
            postSysOrgan.setShortName(postInfo.getLabel());
            postSysOrgan.setOrganType("3");
            postSysOrgan.setDelFlag("0");
            postSysOrgan.setParentTypeCode(postFOrganInfo.getOrganType());
            this.sysOrganService.save((Object)postSysOrgan);
            postSysStru = new SysStru();
            postSysStru.setId(Long.valueOf(IdWorker.getId((Object)new SysStru())));
            postSysStru.setStruType("3");
            postSysStru.setOrganId(postSysOrgan.getId());
            postSysStru.setOrganAlias(postSysOrgan.getOrganName());
            postSysStru.setParentId(postStruFInfo.getId());
            postSysStru.setStruFid(postStruFInfo.getStruFid() + postSysStru.getId() + "/");
            postSysStru.setStruLevel(Integer.valueOf(postStruFInfo.getStruLevel() + 1));
            postSysStru.setIsLeaf("Y");
            postSysStru.setDelFlag("0");
            this.sysStruService.save((Object)postSysStru);
        }
        postSysStru = (SysStru)this.sysStruService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)postSysOrgan.getId()));
        SysStru userStruInfo = (SysStru)this.sysStruService.getById((Serializable)userInfo.getEmployeeId());
        SysStruAssistOrgan assistOrganinfo = (SysStruAssistOrgan)this.sysStruAssistOrganService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruAssistOrgan::getStruId, (Object)userStruInfo.getId())).eq(SysStruAssistOrgan::getAssistParentId, (Object)postSysStru.getId()));
        if (null != assistOrganinfo) {
            logger.info("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u4eba\u5458\u517c\u5c97\u4fe1\u606f\u5df2\u5b58\u5728======={}", (Object)assistOrganinfo.getId());
            new BaseException("\u521b\u5efa\u517c\u5c97\u6570\u636e\uff1a\u4eba\u5458\u517c\u5c97\u4fe1\u606f\u5df2\u5b58\u5728:===" + assistOrganinfo.getId());
            return null;
        }
        assistOrganinfo = new SysStruAssistOrgan();
        assistOrganinfo.setStruId(userStruInfo.getId());
        assistOrganinfo.setAssistParentId(postSysStru.getId());
        this.sysStruAssistOrganService.save((Object)assistOrganinfo);
        return String.valueOf(assistOrganinfo.getId());
    }

    private String createPostResource(Map<String, Object> reqmap) {
        logger.info("IAM\u5c97\u4f4d\u4fe1\u606f\u540c\u6b65\u65b9\u6cd5createPostResource()\u53c2\u6570reqmap:{}================", reqmap);
        String postId = (String)reqmap.get("postId");
        String postNo = (String)reqmap.get("postNo");
        String postName = (String)reqmap.get("postName");
        String postPId = (String)reqmap.get("postPId");
        String postStatus = (String)reqmap.get("postStatus");
        String deptId = (String)reqmap.get("deptId");
        DicType postDicType = (DicType)this.sysDicTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicType::getTypeName, (Object)"iam_post"));
        if (null != postDicType) {
            DicSingle postDicSingle = (DicSingle)this.sysDicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getBak1, (Object)postId));
            if (null != postDicSingle) {
                logger.info("\u65b0\u589e\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38\uff1a\u5c97\u4f4d\u4fe1\u606f\u5df2\u5b58\u5728===={}", (Object)postId);
                new BaseException("\u804c\u52a1\u4fe1\u606f\u5df2\u5b58\u5728\uff1a" + postId);
                return null;
            }
            postDicSingle = new DicSingle();
            postDicSingle.setTypeId(postDicType.getId());
            postDicSingle.setValue(postNo);
            postDicSingle.setLabel(postName);
            postDicSingle.setBak1(postId);
            postDicSingle.setBak2(postStatus);
            postDicSingle.setBak3(deptId);
            this.sysDicSingleService.save((Object)postDicSingle);
        }
        return postId;
    }

    private String createJobResource(Map<String, Object> reqmap) {
        logger.info("IAM\u804c\u52a1\u4fe1\u606f\u540c\u6b65\u65b9\u6cd5createJobResource()\u53c2\u6570reqmap:{}==============", reqmap);
        String jobId = (String)reqmap.get("jobId");
        String jobNo = (String)reqmap.get("jobNo");
        String jobName = (String)reqmap.get("jobName");
        String jobStatus = (String)reqmap.get("jobStatus");
        DicType jobDicType = (DicType)this.sysDicTypeService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicType::getTypeName, (Object)"staff_position"));
        if (null != jobDicType) {
            DicSingle jobDicSingle = (DicSingle)this.sysDicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getBak1, (Object)jobId));
            if (null != jobDicSingle) {
                logger.info("\u65b0\u589e\u804c\u52a1\u4fe1\u606f\u5f02\u5e38\uff1a\u804c\u52a1\u4fe1\u606f\u5df2\u5b58\u5728===={}", (Object)jobId);
                new BaseException("\u804c\u52a1\u4fe1\u606f\u5df2\u5b58\u5728\uff1a" + jobId);
                return null;
            }
            jobDicSingle = new DicSingle();
            jobDicSingle.setTypeId(jobDicType.getId());
            jobDicSingle.setValue(jobNo);
            jobDicSingle.setLabel(jobName);
            jobDicSingle.setBak1(jobId);
            jobDicSingle.setBak2(jobStatus);
            this.sysDicSingleService.save((Object)jobDicSingle);
        }
        return jobId;
    }

    public String ResourceUpdateService(String bodyParam) {
        String bodyparam = BamboocloudUtils.getPlaintext((String)bodyParam, (String)this.key, (String)this.type);
        Map reqmap = (Map)JSON.parse((String)bodyparam);
        HashMap schema = new HashMap();
        schema.put("bimRequestId", reqmap.get("bimRequestId"));
        try {
            if (BamboocloudUtils.verify((Map)reqmap, (String)this.signType).booleanValue()) {
                String username = (String)reqmap.get("bimRemoteUser");
                String password = (String)reqmap.get("bimRemotePwd");
                String resourceType = (String)reqmap.get("resourceType");
                BamboocloudUtils.checkUsernamePassword((String)username, (String)password, (String)this.localUserName, (String)this.localPwd);
                logger.info("IAM\u66f4\u65b0\u8d44\u6e90\u5165\u53c2\uff1areqmap\uff1a==={}", (Object)reqmap);
                if ("job".equals(resourceType)) {
                    this.updateJobResource(reqmap);
                } else if ("post".equals(resourceType)) {
                    this.updatePostResource(reqmap);
                } else if ("userpost".equals(resourceType)) {
                    this.updateUserPostResource(reqmap);
                } else {
                    logger.info("IAM:\u672a\u627e\u5230\u540c\u6b65\u8d44\u6e90\u7c7b\u578b\uff1a=============");
                    schema.put("resultCode", "500");
                    schema.put("message", "\u672a\u627e\u5230\u540c\u6b65\u8d44\u6e90\u7c7b\u578b");
                    String mapJson = JSON.toJSONString(schema);
                    return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
                }
                schema.put("resultCode", "0");
                schema.put("message", "success");
                String mapJson = JSON.toJSONString(schema);
                return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
            }
            schema.put("resultCode", "500");
            schema.put("message", SIGN_ERR);
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
        catch (Exception e) {
            e.printStackTrace();
            schema.put("resultCode", "500");
            schema.put("message", e.getMessage());
            String mapJson = JSON.toJSONString(schema);
            return BamboocloudFacade.encrypt((String)mapJson, (String)this.key, (String)this.type);
        }
    }

    private void updateUserPostResource(Map<String, Object> reqmap) {
        logger.info("\u66f4\u65b0\u517c\u5c97\u4fe1\u606f\u65b9\u6cd5updateUserPostResource()\u53c2\u6570reqmap:{}", reqmap);
        String empId = (String)reqmap.get("empId");
        String empNo = (String)reqmap.get("empNo");
        String postId = (String)reqmap.get("postId");
        String postNo = (String)reqmap.get("postNo");
        String postName = (String)reqmap.get("postName");
        String deptId = (String)reqmap.get("deptId");
        String deptNo = (String)reqmap.get("deptNo");
        String compId = (String)reqmap.get("compId");
        String compNo = (String)reqmap.get("compNo");
        String isDel = (String)reqmap.get("isDel");
        String assistOrganId = (String)reqmap.get("bimResourceId");
        if ("1".equals(isDel)) {
            SysStruAssistOrgan assistOrganInfo = (SysStruAssistOrgan)this.sysStruAssistOrganService.getById((Serializable)Long.valueOf(Long.parseLong(assistOrganId)));
            if (null == assistOrganInfo) {
                logger.info("\u5220\u9664\u517c\u5c97\u5173\u7cfb\uff1a\u672a\u627e\u5230\u517c\u5c97\u6570\u636e=====");
                return;
            }
            this.sysStruAssistOrganService.removeById((Object)assistOrganInfo);
            List list = this.sysStruAssistOrganService.list((Wrapper)new LambdaQueryWrapper().eq(SysStruAssistOrgan::getAssistParentId, (Object)assistOrganInfo.getAssistParentId()));
            if (HussarUtils.isEmpty((Object)list)) {
                Long postStruId = assistOrganInfo.getAssistParentId();
                SysStru postStruInfo = (SysStru)this.sysStruService.getById((Serializable)postStruId);
                if (null == postStruInfo) {
                    logger.info("\u5220\u9664\u517c\u5c97\u5173\u7cfb\uff1a\u672a\u627e\u5230\u5c97\u4f4dstru\u6570\u636e=====");
                    return;
                }
                Long postOrganId = postStruInfo.getOrganId();
                SysOrgan postOrganInfo = (SysOrgan)this.sysOrganService.getById((Serializable)postOrganId);
                if (null == postOrganInfo) {
                    logger.info("\u5220\u9664\u517c\u5c97\u5173\u7cfb\uff1a\u672a\u627e\u5230\u5c97\u4f4dorgan\u6570\u636e=====");
                    return;
                }
                this.sysOrganService.removeById((Object)postOrganInfo);
                this.sysStruService.removeById((Object)postStruInfo);
            }
        }
    }

    private void updatePostResource(Map<String, Object> reqmap) {
        logger.info("\u66f4\u65b0\u5c97\u4f4d\u4fe1\u606f\u65b9\u6cd5updatePostResource()\u53c2\u6570\uff1a{}", reqmap);
        String postId = (String)reqmap.get("bimResourceId");
        String postNo = (String)reqmap.get("postNo");
        String postName = (String)reqmap.get("postName");
        String deptId = (String)reqmap.get("deptId");
        String postPId = (String)reqmap.get("postPId");
        String postStatus = (String)reqmap.get("postStatus");
        DicSingle postDicSingle = (DicSingle)this.sysDicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getBak1, (Object)postId));
        if (null == postDicSingle) {
            logger.info("\u66f4\u65b0\u5c97\u4f4d\u4fe1\u606f\uff1a\u672a\u67e5\u8be2\u5230\u5c97\u4f4d\u4fe1\u606f");
            return;
        }
        postDicSingle.setValue(null == postNo ? postDicSingle.getValue() : postNo);
        postDicSingle.setLabel(null == postName ? postDicSingle.getLabel() : postName);
        postDicSingle.setBak1(null == postId ? postDicSingle.getBak1() : postId);
        postDicSingle.setBak2(null == postStatus ? postDicSingle.getBak2() : postStatus);
        postDicSingle.setBak3(null == deptId ? postDicSingle.getBak3() : deptId);
        this.sysDicSingleService.updateById((Object)postDicSingle);
    }

    private void updateJobResource(Map<String, Object> reqmap) {
        logger.info("\u66f4\u65b0\u804c\u52a1\u4fe1\u606f\u65b9\u6cd5updateJobResource()\u53c2\u6570reqmap:{}============", reqmap);
        String jobId = (String)reqmap.get("bimResourceId");
        String jobNo = (String)reqmap.get("jobNo");
        String jobName = (String)reqmap.get("jobName");
        String jobStatus = (String)reqmap.get("jobStatus");
        DicSingle dicSingle = (DicSingle)this.sysDicSingleService.getOne((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getBak1, (Object)jobId));
        if (null == dicSingle) {
            logger.info("\u672a\u627e\u5230\u804c\u52a1\u4fe1\u606f========");
            new BaseException("\u672a\u627e\u5230\u804c\u52a1\u4fe1\u606f");
            return;
        }
        dicSingle.setValue(jobNo);
        dicSingle.setLabel(jobName);
        dicSingle.setBak2(jobStatus);
        this.sysDicSingleService.updateById((Object)dicSingle);
    }

    private void GrantRG(String action, JSONObject entity) {
        SysRoleGroup sysRoleGroup = new SysRoleGroup();
        sysRoleGroup.setGroupName(entity.getString("code"));
        sysRoleGroup.setGroupAlias(entity.getString("name"));
        sysRoleGroup.setParentId(Long.valueOf(1L));
        sysRoleGroup.setGroupOrder(Integer.valueOf(entity.getString("sort") == null ? 999 : Integer.parseInt(entity.getString("sort"))));
        if ("add".equals(action)) {
            this.sysRoleGroupService.save((Object)sysRoleGroup);
        } else if ("update".equals(action)) {
            SysRoleGroup sysRoleGroup1 = (SysRoleGroup)this.sysRoleGroupService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoleGroup::getGroupName, (Object)sysRoleGroup.getGroupName()));
            if (sysRoleGroup1 == null) {
                throw new BaseException("\u89d2\u8272\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
            sysRoleGroup.setId(sysRoleGroup1.getId());
            this.sysRoleGroupService.saveOrUpdate((Object)sysRoleGroup);
        } else if ("delete".equals(action)) {
            SysRoleGroup sysRoleGroup1 = (SysRoleGroup)this.sysRoleGroupService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoleGroup::getGroupName, (Object)sysRoleGroup.getGroupName()));
            if (sysRoleGroup1 == null) {
                throw new BaseException("\u89d2\u8272\u5206\u7ec4\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            sysRoleGroup.setId(sysRoleGroup1.getId());
            this.sysRoleGroupService.removeById((Object)sysRoleGroup);
        }
    }

    private void GrantDAR(String action, JSONObject entity) {
        SysRoles sysRoles = new SysRoles();
        sysRoles.setRolePermission(entity.getString("code"));
        sysRoles.setRoleName(entity.getString("name"));
        sysRoles.setRoleAlias(entity.getString("name"));
        sysRoles.setIsSys(entity.getString("isSys") == null ? "0" : entity.getString("isSys"));
        sysRoles.setRoleOrder(Integer.valueOf(entity.getString("sort") == null ? 999 : Integer.parseInt(entity.getString("sort"))));
        if ("add".equals(action)) {
            this.sysRolesService.save((Object)sysRoles);
        } else if ("update".equals(action)) {
            SysRoles sysRoles1 = (SysRoles)this.sysRolesService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoles::getRolePermission, (Object)sysRoles.getRolePermission()));
            if (sysRoles1 == null) {
                throw new BaseException("\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fee\u6539");
            }
            sysRoles.setId(sysRoles1.getId());
            sysRoles.setGroupId(sysRoles1.getGroupId());
            this.sysRolesService.updateRole(sysRoles);
        } else if ("delete".equals(action)) {
            SysRoles sysRoles1 = (SysRoles)this.sysRolesService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoles::getRolePermission, (Object)sysRoles.getRolePermission()));
            if (sysRoles1 == null) {
                throw new BaseException("\u89d2\u8272\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664");
            }
            sysRoles.setId(sysRoles1.getId());
            this.sysRolesService.removeById((Object)sysRoles);
        }
    }

    private void GrantDAM(String action, JSONObject entity) {
        SysFunctionModules sysFunctionModules = new SysFunctionModules();
        String code = entity.getString("code");
        sysFunctionModules.setId(Long.valueOf(Long.parseLong(code)));
        sysFunctionModules.setFunctionModuleCode(code);
        sysFunctionModules.setFunctionModuleName(entity.getString("name"));
        String parentCode = entity.getString("parentCode");
        if (parentCode != null) {
            sysFunctionModules.setParentModuleId(Long.valueOf(Long.parseLong(parentCode)));
        } else {
            sysFunctionModules.setParentModuleId(Long.valueOf(1L));
        }
        sysFunctionModules.setSeq(entity.getInteger("sort"));
        if ("add".equals(action)) {
            this.sysFunctionModulesService.save((Object)sysFunctionModules);
        } else if ("update".equals(action)) {
            this.sysFunctionModulesService.saveOrUpdate((Object)sysFunctionModules);
        } else if ("delete".equals(action)) {
            this.sysFunctionModulesService.removeById((Object)sysFunctionModules);
        }
    }

    private void GrantDRG(String action, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject entity = jsonArray.getJSONObject(i);
            SysRoles sysRoles = (SysRoles)this.sysRolesService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoles::getRolePermission, (Object)entity.getString("arCode")));
            if (sysRoles == null) {
                throw new BaseException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            SysRoleGroup sysRoleGroup = (SysRoleGroup)this.sysRoleGroupService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoleGroup::getGroupName, (Object)entity.getString("argCode")));
            if (sysRoleGroup == null) {
                sysRoleGroup = (SysRoleGroup)this.sysRoleGroupService.getById((Serializable)((Object)entity.getString("argCode")));
            }
            if (sysRoleGroup == null) {
                throw new BaseException("\u89d2\u8272\u5206\u7ec4\u4e0d\u5b58\u5728");
            }
            sysRoles.setGroupId(sysRoleGroup.getId());
            if ("add".equals(action)) {
                this.sysRolesService.saveOrUpdate((Object)sysRoles);
                continue;
            }
            if (!"update".equals(action)) continue;
            this.sysRolesService.saveOrUpdate((Object)sysRoles);
        }
    }

    private void GrantRUSERAR(String action, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject entity = jsonArray.getJSONObject(i);
            SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)entity.getString("accountCode")));
            if (sysUsers == null) {
                logger.info("\u7528\u6237\u4e0d\u5b58\u5728==============");
                throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            SysRoles sysRoles = (SysRoles)this.sysRolesService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoles::getRolePermission, (Object)entity.getString("arCode")));
            if (sysRoles == null) {
                logger.info("\u89d2\u8272\u4e0d\u5b58\u5728==============");
                throw new BaseException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            logger.info("\u662f\u5426\u662f\u5e94\u7528\u7ba1\u7406\u5458----" + sysRoles.getId());
            int size = this.sysUserRoleService.getUserRole(sysUsers.getId(), sysRoles.getId());
            if (size == 0) {
                if (!"add".equals(action)) continue;
                logger.info("IAM\u540c\u6b65\u7528\u6237\u89d2\u8272\uff1aadd==============");
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(sysUsers.getId());
                sysUserRole.setGrantedRole(sysRoles.getId());
                sysUserRole.setAdminOption("1");
                this.sysUserRoleService.save((Object)sysUserRole);
                if (!sysRoles.getId().equals(AppConstants.APP_ADMIN_ID)) continue;
                SysUsers superAdmin = this.sysUsersService.getUser(AppConstants.SUPER_ADMIN_ID);
                logger.info("\u662f\u5426\u662f\u5e94\u7528\u7ba1\u7406\u5458----" + superAdmin);
                sysUsers.setChar1(superAdmin.getChar1());
                this.sysUsersService.updateById((Object)sysUsers);
                continue;
            }
            if (!"delete".equals(action)) continue;
            logger.info("IAM\u540c\u6b65\u7528\u6237\u89d2\u8272\uff1adelete==============");
            this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).eq(SysUserRole::getGrantedRole, (Object)sysRoles.getId()));
        }
    }

    private void GrantRARAM(String action, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject entity = jsonArray.getJSONObject(i);
            SysRoles sysRoles = (SysRoles)this.sysRolesService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoles::getRolePermission, (Object)entity.getString("arCode")));
            if (sysRoles == null) {
                throw new BaseException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            SysRoleFunctions sysRoleFunctions = (SysRoleFunctions)this.sysRoleFunctionsService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleFunctions::getRoleId, (Object)sysRoles.getId())).eq(SysRoleFunctions::getFunctionId, (Object)Long.parseLong(entity.getString("amCode"))));
            if (sysRoleFunctions == null) {
                if (!"add".equals(action)) continue;
                sysRoleFunctions = new SysRoleFunctions();
                sysRoleFunctions.setRoleId(sysRoles.getId());
                sysRoleFunctions.setFunctionId(Long.valueOf(Long.parseLong(entity.getString("amCode"))));
                this.sysRoleFunctionsService.save((Object)sysRoleFunctions);
                this.saveRoleResources(sysRoles.getId(), Long.parseLong(entity.getString("amCode")));
                continue;
            }
            if (!"delete".equals(action)) continue;
            this.sysRoleFunctionsService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleFunctions::getRoleId, (Object)sysRoles.getId())).eq(SysRoleFunctions::getFunctionId, (Object)Long.parseLong(entity.getString("amCode"))));
            this.removeRoleResources(sysRoles.getId(), Long.parseLong(entity.getString("amCode")));
        }
    }

    private void GrantRARADATA(String action, JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject entity = jsonArray.getJSONObject(i);
            logger.info("\u529f\u80fd\u6743\u9650\u6570\u636e" + entity);
            SysRoles sysRoles = (SysRoles)this.sysRolesService.getOne((Wrapper)new QueryWrapper().lambda().eq(SysRoles::getRolePermission, (Object)entity.getString("arCode")));
            if (sysRoles == null) {
                throw new BaseException("\u89d2\u8272\u4e0d\u5b58\u5728");
            }
            if ("\u53ef\u89c1\u8303\u56f4".equals(entity.getString("adataType"))) {
                this.grantRoleAndResRight(action, entity, sysRoles);
                continue;
            }
            if ("\u64cd\u4f5c\u6743\u9650".equals(entity.getString("adataType"))) {
                this.grantRoleAndResBtn(action, entity, sysRoles);
                continue;
            }
            this.grantRoleAndFunc(action, entity, sysRoles);
        }
    }

    private void grantRoleAndFunc(String action, JSONObject entity, SysRoles sysRoles) {
        block5: {
            block4: {
                if (!"add".equals(action)) break block4;
                SysRoleFunctions sysRoleFunctions = (SysRoleFunctions)this.sysRoleFunctionsService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleFunctions::getRoleId, (Object)sysRoles.getId())).eq(SysRoleFunctions::getFunctionId, (Object)entity.getString("dataCode")));
                logger.info("sysRoleFunctions----------" + sysRoleFunctions);
                if (sysRoleFunctions == null) {
                    sysRoleFunctions = new SysRoleFunctions();
                    sysRoleFunctions.setRoleId(sysRoles.getId());
                    sysRoleFunctions.setFunctionId(Long.valueOf(Long.parseLong(entity.getString("dataCode"))));
                    this.sysRoleFunctionsService.save((Object)sysRoleFunctions);
                }
                Wrapper queryWrapper = (Wrapper)new QueryWrapper().eq((Object)"FUNCTION_ID", (Object)Long.parseLong(entity.getString("dataCode")));
                List sysFunctionResourcesList = this.sysFunctionResourcesService.list(queryWrapper);
                logger.info("sysFunctionResourcesList----------" + sysFunctionResourcesList);
                if (sysFunctionResourcesList == null) break block5;
                for (SysFunctionResources sysFunctionResources : sysFunctionResourcesList) {
                    SysResources resourceOne = (SysResources)this.sysResourcesService.getById((Serializable)sysFunctionResources.getResourceId());
                    if ("1".equals(resourceOne.getIsButtonResource()) || "res_rights".equals(resourceOne.getResTypeId())) continue;
                    List roleResourceList = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleResource::getId, (Object)sysRoles.getId())).eq(SysRoleResource::getResourceId, (Object)sysFunctionResources.getResourceId()));
                    logger.info("sysRoleResource----------" + roleResourceList);
                    if (!HussarUtils.isNotEmpty((Object)roleResourceList)) continue;
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource = new SysRoleResource();
                    sysRoleResource.setId(sysRoles.getId());
                    sysRoleResource.setResourceId(sysFunctionResources.getResourceId());
                    sysRoleResource.setRelationSource("2");
                    this.sysRoleResourceService.save((Object)sysRoleResource);
                }
                break block5;
            }
            if ("delete".equals(action)) {
                this.sysRoleFunctionsService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleFunctions::getRoleId, (Object)sysRoles.getId())).eq(SysRoleFunctions::getFunctionId, (Object)Long.parseLong(entity.getString("dataCode"))));
                Wrapper queryWrapper = (Wrapper)new QueryWrapper().eq((Object)"FUNCTION_ID", (Object)Long.parseLong(entity.getString("dataCode")));
                List sysFunctionResourcesList = this.sysFunctionResourcesService.list(queryWrapper);
                for (SysFunctionResources sysFunctionResources : sysFunctionResourcesList) {
                    this.sysRoleResourceService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleResource::getId, (Object)sysRoles.getId())).eq(SysRoleResource::getResourceId, (Object)sysFunctionResources.getResourceId()));
                }
            }
        }
    }

    private void grantRoleAndResBtn(String action, JSONObject entity, SysRoles sysRoles) {
        if ("add".equals(action)) {
            List roleResourceList;
            SysFunctions sysFunctions;
            if (HussarUtils.isNotEmpty((Object)entity.getString("adataCode")) && (sysFunctions = (SysFunctions)this.sysFunctionsService.getById((Serializable)((Object)entity.getString("dataCode")))) == null) {
                throw new BaseException("\u529f\u80fd\u4e0d\u5b58\u5728");
            }
            if (HussarUtils.isNotEmpty((Object)entity.getString("adataCode")) && HussarUtils.isNotEmpty((Object)(roleResourceList = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleResource::getId, (Object)sysRoles.getId())).eq(SysRoleResource::getResourceId, (Object)entity.getString("dataCode")))))) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource = new SysRoleResource();
                sysRoleResource.setId(sysRoles.getId());
                sysRoleResource.setResourceId(Long.valueOf(Long.parseLong(entity.getString("adataCode"))));
                sysRoleResource.setRelationSource("2");
                this.sysRoleResourceService.save((Object)sysRoleResource);
            }
            SysRoleFunctions sysRoleFunctions = (SysRoleFunctions)this.sysRoleFunctionsService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleFunctions::getRoleId, (Object)sysRoles.getId())).eq(SysRoleFunctions::getFunctionId, (Object)entity.getString("dataCode")));
            logger.info("sysRoleFunctions----------" + sysRoleFunctions);
            if (sysRoleFunctions == null) {
                sysRoleFunctions = new SysRoleFunctions();
                sysRoleFunctions.setRoleId(sysRoles.getId());
                sysRoleFunctions.setFunctionId(Long.valueOf(Long.parseLong(entity.getString("dataCode"))));
                this.sysRoleFunctionsService.save((Object)sysRoleFunctions);
            }
            Wrapper queryWrapper = (Wrapper)new QueryWrapper().eq((Object)"FUNCTION_ID", (Object)Long.parseLong(entity.getString("dataCode")));
            List sysFunctionResourcesList = this.sysFunctionResourcesService.list(queryWrapper);
            logger.info("sysFunctionResourcesList----------" + sysFunctionResourcesList);
            if (sysFunctionResourcesList != null) {
                for (SysFunctionResources sysFunctionResources : sysFunctionResourcesList) {
                    SysResources resourceOne = (SysResources)this.sysResourcesService.getById((Serializable)sysFunctionResources.getResourceId());
                    if ("1".equals(resourceOne.getIsButtonResource()) || "res_rights".equals(resourceOne.getResTypeId())) continue;
                    List roleResourceList2 = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleResource::getId, (Object)sysRoles.getId())).eq(SysRoleResource::getResourceId, (Object)sysFunctionResources.getResourceId()));
                    logger.info("sysRoleResource----------" + roleResourceList2);
                    if (!HussarUtils.isNotEmpty((Object)roleResourceList2)) continue;
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource = new SysRoleResource();
                    sysRoleResource.setId(sysRoles.getId());
                    sysRoleResource.setResourceId(sysFunctionResources.getResourceId());
                    sysRoleResource.setRelationSource("1");
                    this.sysRoleResourceService.save((Object)sysRoleResource);
                }
            }
        } else if ("delete".equals(action)) {
            this.sysRoleResourceService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleResource::getId, (Object)sysRoles.getId())).eq(SysRoleResource::getResourceId, (Object)Long.parseLong(entity.getString("adataCode"))));
        }
    }

    private void grantRoleAndResRight(String action, JSONObject entity, SysRoles sysRoles) {
        if ("add".equals(action)) {
            if (HussarUtils.isNotEmpty((Object)entity.getString("adataCode"))) {
                SysFunctions sysFunctions = (SysFunctions)this.sysFunctionsService.getById((Serializable)((Object)entity.getString("dataCode")));
                if (sysFunctions == null) {
                    throw new BaseException("\u529f\u80fd\u4e0d\u5b58\u5728");
                }
                SysRoleDataRight sysRoleDataRight = (SysRoleDataRight)this.sysRoleDataRightService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleDataRight::getRoleId, (Object)sysRoles.getId())).eq(SysRoleDataRight::getFunctionId, (Object)Long.parseLong(entity.getString("dataCode"))));
                if (sysRoleDataRight == null) {
                    sysRoleDataRight = new SysRoleDataRight();
                    sysRoleDataRight.setRoleId(sysRoles.getId());
                    sysRoleDataRight.setFunctionId(Long.valueOf(Long.parseLong(entity.getString("dataCode"))));
                    sysRoleDataRight.setDataScope(Integer.valueOf(Integer.parseInt(entity.getString("adataCode"))));
                    this.sysRoleDataRightService.save((Object)sysRoleDataRight);
                }
            }
            SysRoleFunctions sysRoleFunctions = (SysRoleFunctions)this.sysRoleFunctionsService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleFunctions::getRoleId, (Object)sysRoles.getId())).eq(SysRoleFunctions::getFunctionId, (Object)entity.getString("dataCode")));
            logger.info("sysRoleFunctions----------" + sysRoleFunctions);
            if (sysRoleFunctions == null) {
                sysRoleFunctions = new SysRoleFunctions();
                sysRoleFunctions.setRoleId(sysRoles.getId());
                sysRoleFunctions.setFunctionId(Long.valueOf(Long.parseLong(entity.getString("dataCode"))));
                this.sysRoleFunctionsService.save((Object)sysRoleFunctions);
            }
            Wrapper queryWrapper = (Wrapper)new QueryWrapper().eq((Object)"FUNCTION_ID", (Object)Long.parseLong(entity.getString("dataCode")));
            List sysFunctionResourcesList = this.sysFunctionResourcesService.list(queryWrapper);
            logger.info("sysFunctionResourcesList----------" + sysFunctionResourcesList);
            if (sysFunctionResourcesList != null) {
                for (SysFunctionResources sysFunctionResources : sysFunctionResourcesList) {
                    SysResources resourceOne = (SysResources)this.sysResourcesService.getById((Serializable)sysFunctionResources.getResourceId());
                    if ("1".equals(resourceOne.getIsButtonResource()) || "res_rights".equals(resourceOne.getResTypeId())) continue;
                    List roleResourceList = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleResource::getId, (Object)sysRoles.getId())).eq(SysRoleResource::getResourceId, (Object)sysFunctionResources.getResourceId()));
                    logger.info("sysRoleResource----------" + roleResourceList);
                    if (!HussarUtils.isNotEmpty((Object)roleResourceList)) continue;
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource = new SysRoleResource();
                    sysRoleResource.setId(sysRoles.getId());
                    sysRoleResource.setResourceId(sysFunctionResources.getResourceId());
                    sysRoleResource.setRelationSource("1");
                    this.sysRoleResourceService.save((Object)sysRoleResource);
                }
            }
        } else if ("update".equals(action)) {
            if (HussarUtils.isNotEmpty((Object)entity.getString("adataCode"))) {
                SysFunctions sysFunctions = (SysFunctions)this.sysFunctionsService.getById((Serializable)((Object)entity.getString("dataCode")));
                if (sysFunctions == null) {
                    throw new BaseException("\u529f\u80fd\u4e0d\u5b58\u5728");
                }
                SysRoleDataRight sysRoleDataRight = (SysRoleDataRight)this.sysRoleDataRightService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleDataRight::getRoleId, (Object)sysRoles.getId())).eq(SysRoleDataRight::getFunctionId, (Object)Long.parseLong(entity.getString("dataCode"))));
                if (sysRoleDataRight == null) {
                    sysRoleDataRight = new SysRoleDataRight();
                }
                sysRoleDataRight.setRoleId(sysRoles.getId());
                sysRoleDataRight.setFunctionId(Long.valueOf(Long.parseLong(entity.getString("dataCode"))));
                sysRoleDataRight.setDataScope(Integer.valueOf(Integer.parseInt(entity.getString("adataCode"))));
                this.sysRoleDataRightService.saveOrUpdate((Object)sysRoleDataRight);
            }
        } else if ("delete".equals(action) && HussarUtils.isNotEmpty((Object)entity.getString("adataCode"))) {
            this.sysRoleDataRightService.remove((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysRoleDataRight::getRoleId, (Object)sysRoles.getId())).eq(SysRoleDataRight::getFunctionId, (Object)Long.parseLong(entity.getString("dataCode"))));
        }
    }

    private void saveRoleResources(Long roleId, Long functionId) {
        List funcResList = this.sysFunctionResourcesService.getFunctionResourceList(functionId);
        if (HussarUtils.isNotEmpty((Object)funcResList)) {
            ArrayList<SysRoleResource> roleResources = new ArrayList<SysRoleResource>();
            for (FuncResVo funcResVo : funcResList) {
                SysRoleResource roleResource = new SysRoleResource();
                roleResource.setResourceId(funcResVo.getResourceId());
                roleResource.setId(roleId);
                roleResource.setRelationSource("1");
                roleResources.add(roleResource);
            }
            this.sysRoleResourceService.saveBatch(roleResources);
        }
    }

    private void removeRoleResources(Long roleId, Long functionId) {
        List funcResList = this.sysFunctionResourcesService.getFunctionResourceList(functionId);
        if (HussarUtils.isEmpty((Object)funcResList)) {
            return;
        }
        List resIds = funcResList.stream().map(FuncResVo::getResourceId).collect(Collectors.toList());
        this.sysRoleResourceService.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getId, (Object)roleId)).in(SysRoleResource::getResourceId, resIds)).eq(SysRoleResource::getRelationSource, (Object)"1"));
    }
}

