/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.iamdatasync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.util.HttpUtil;
import com.jxdinfo.hussar.authorization.iamdatasync.constants.AppConstants;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMDataRecoverService;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IAMDataRecoverServiceImpl
implements IAMDataRecoverService {
    private static final String TOKEN = "iamToken";
    private static final Logger logger = LoggerFactory.getLogger(IAMDataRecoverServiceImpl.class);
    @Value(value="${IAM.grant.appKey:default}")
    private String appCode;
    @Value(value="${IAM.grant.address:default}")
    private String ipAddress;
    @Value(value="${IAM.grant.username:default}")
    private String username;
    @Value(value="${IAM.request-way:default}")
    private String requestWay;
    @Value(value="${IAM.grant.dataObjectCode:default}")
    private String dataObjectCode;
    @Value(value="${IAM.grant.adataObjectCode:default}")
    private String adataObjectCode;
    @Value(value="${IAM.grant.btnObjectCode:default}")
    private String btnObjectCode;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysDicRefService sysDicRefService;

    private String getToken() {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("username", this.username));
        String res = HttpUtil.get((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/login/token", params);
        JSONObject jsonObject = JSONObject.parseObject((String)res);
        logger.info("-----------\u83b7\u53d6token" + jsonObject.getString("data"));
        return jsonObject.getString("data");
    }

    public boolean roleGroupRec(String accessToken) {
        ArrayList objectList = new ArrayList();
        List roleGroupList = this.sysRoleGroupService.list();
        for (int i = 0; i < roleGroupList.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            SysRoleGroup sysRoleGroup = (SysRoleGroup)roleGroupList.get(i);
            map.put("action", "add");
            map.put("code", sysRoleGroup.getId());
            map.put("name", sysRoleGroup.getGroupName());
            map.put("description", sysRoleGroup.getGroupAlias());
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "APP_ROLE_GROUP");
        paramMap.put("objectList", objectList);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u7ec4\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u7ec4\u6570\u636e\u8fd4\u56de\u6570\u636e=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        return "200".equals(code);
    }

    public boolean rolesGroupRec(String accessToken) {
        ArrayList objectList = new ArrayList();
        Wrapper wrapper = (Wrapper)new QueryWrapper().notIn((Object)"ROLE_ID", new Object[]{AppConstants.DEV_ROLE_ID, AppConstants.PROJECT_LEADER_ROLE_ID, AppConstants.PUBLIC_ROLE_ID, AppConstants.APP_VIEW_ROLE_ID});
        List rolesList = this.sysRolesService.list(wrapper);
        for (int i = 0; i < rolesList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            SysRoles sysRoles = (SysRoles)rolesList.get(i);
            map.put("action", "add");
            map.put("argCode", String.valueOf(sysRoles.getGroupId()));
            map.put("arCode", sysRoles.getRolePermission());
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "R_ARG_AR");
        paramMap.put("objectList", objectList);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u7ec4\u3001\u89d2\u8272\u5173\u7cfb\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u7ec4\u3001\u89d2\u8272\u5173\u7cfb\u6570\u636e\u8fd4\u56de\u6570\u636e=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        return "200".equals(code);
    }

    public boolean roleRec(String accessToken) {
        ArrayList objectList = new ArrayList();
        Wrapper wrapper = (Wrapper)new QueryWrapper().notIn((Object)"ROLE_ID", new Object[]{AppConstants.DEV_ROLE_ID, AppConstants.PROJECT_LEADER_ROLE_ID, AppConstants.PUBLIC_ROLE_ID, AppConstants.APP_VIEW_ROLE_ID});
        List rolesList = this.sysRolesService.list(wrapper);
        logger.info("\u89d2\u8272\u6570\u636e" + rolesList.size());
        logger.info("\u89d2\u8272\u6570\u636e" + rolesList);
        for (int i = 0; i < rolesList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            SysRoles sysRoles = (SysRoles)rolesList.get(i);
            map.put("action", "add");
            map.put("code", sysRoles.getRolePermission());
            map.put("name", sysRoles.getRoleName());
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "APP_ROLE");
        paramMap.put("objectList", objectList);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u6570\u636e\u8fd4\u56de\u6570\u636e=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        return "200".equals(code);
    }

    public boolean functionModuleRec() {
        String accessToken = this.getToken();
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return false;
        }
        ArrayList objectList = new ArrayList();
        List sysFunctionModulesList = this.sysFunctionModulesService.list((Wrapper)new QueryWrapper().eq((Object)"PARENT_MODULE_ID", (Object)"1"));
        if (sysFunctionModulesList.size() == 0) {
            return true;
        }
        for (int i = 0; i < sysFunctionModulesList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            SysFunctionModules sysFunctionModules = (SysFunctionModules)sysFunctionModulesList.get(i);
            map.put("action", "add");
            map.put("code", String.valueOf(sysFunctionModules.getId()));
            map.put("name", sysFunctionModules.getFunctionModuleName());
            map.put("type", "0");
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "APP_MODULE");
        paramMap.put("objectList", objectList);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        String code = JSONObject.parseObject((String)res).getString("code");
        if ("200".equals(code)) {
            for (int i = 0; i < sysFunctionModulesList.size(); ++i) {
                this.functionModuleRec(accessToken, String.valueOf(((SysFunctionModules)sysFunctionModulesList.get(i)).getId()));
            }
            return true;
        }
        return false;
    }

    private boolean functionModuleRec(String accessToken, String parentModuleId) {
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return false;
        }
        ArrayList objectList = new ArrayList();
        List sysFunctionModulesList = this.sysFunctionModulesService.list((Wrapper)new QueryWrapper().eq((Object)"PARENT_MODULE_ID", (Object)parentModuleId));
        if (sysFunctionModulesList.size() == 0) {
            return true;
        }
        for (int i = 0; i < sysFunctionModulesList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            SysFunctionModules sysFunctionModules = (SysFunctionModules)sysFunctionModulesList.get(i);
            map.put("action", "add");
            map.put("code", String.valueOf(sysFunctionModules.getId()));
            map.put("parentCode", String.valueOf(parentModuleId));
            map.put("name", sysFunctionModules.getFunctionModuleName());
            map.put("type", "0");
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "APP_MODULE");
        paramMap.put("objectList", objectList);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        String code = JSONObject.parseObject((String)res).getString("code");
        if ("200".equals(code)) {
            for (int i = 0; i < sysFunctionModulesList.size(); ++i) {
                this.functionModuleRec(accessToken, String.valueOf(((SysFunctionModules)sysFunctionModulesList.get(i)).getId()));
            }
            return true;
        }
        return false;
    }

    public boolean functionRec() {
        String accessToken = this.getToken();
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return false;
        }
        ArrayList objectList = new ArrayList();
        List functionsList = this.sysFunctionsService.list();
        for (int i = 0; i < functionsList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            SysFunctions sysFunctions = (SysFunctions)functionsList.get(i);
            map.put("action", "add");
            map.put("code", String.valueOf(sysFunctions.getId()));
            map.put("parentCode", String.valueOf(sysFunctions.getFunctionModuleId()));
            map.put("name", sysFunctions.getFunctionName());
            map.put("type", "0");
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "APP_MODULE");
        paramMap.put("objectList", objectList);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        String code = JSONObject.parseObject((String)res).getString("code");
        return "200".equals(code);
    }

    public boolean resourceRec() {
        return false;
    }

    public boolean userRoleRec(String accessToken) {
        ArrayList objectList = new ArrayList();
        Wrapper wrapper = (Wrapper)new QueryWrapper().notIn((Object)"GRANTED_ROLE", new Object[]{AppConstants.PUBLIC_ROLE_ID, AppConstants.PROJECT_LEADER_ROLE_ID, AppConstants.DEV_ROLE_ID, AppConstants.APP_VIEW_ROLE_ID});
        List userRoleList = this.sysUserRoleService.list(wrapper);
        for (int i = 0; i < userRoleList.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            SysUserRole sysUserRole = (SysUserRole)userRoleList.get(i);
            SysUsers sysUsers = (SysUsers)this.sysUsersService.getById((Serializable)sysUserRole.getUserId());
            SysRoles sysRoles = (SysRoles)this.sysRolesService.getById((Serializable)sysUserRole.getGrantedRole());
            map.put("action", "add");
            map.put("arCode", sysRoles.getRolePermission());
            map.put("userName", sysUsers.getUserAccount());
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "R_USER_AR");
        paramMap.put("objectList", objectList);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u7528\u6237\u89d2\u8272\u5173\u7cfb\u6570\u636e\u8fd4\u56de\u6570\u636e=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        return "200".equals(code);
    }

    public boolean roleFunctionRec(String accessToken) {
        ArrayList objectList = new ArrayList();
        logger.info("\u63a8\u9001\u89d2\u8272\u529f\u80fd\u5173\u8054\u5173\u7cfb\u5f00\u59cb----------------------------");
        List list = this.sysFunctionResourcesService.getRoleFunctionRes("res_rights");
        for (Map item : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("arCode", String.valueOf(item.get("rolePermission")));
            map.put("dataCode", String.valueOf(item.get("functionId")));
            map.put("dataObjectCode", this.dataObjectCode);
            SysRoleDataRight sysRoleDataRight = (SysRoleDataRight)this.sysRoleDataRightService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleDataRight::getRoleId, item.get("roleId"))).eq(SysRoleDataRight::getFunctionId, item.get("functionId")));
            if (null != sysRoleDataRight) {
                map.put("adataCode", String.valueOf(sysRoleDataRight.getDataScope()));
                map.put("adataObjectCode", this.adataObjectCode);
            }
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("action", "add");
        paramMap.put("objectType", "R_AR_ADATA_D");
        paramMap.put("objectList", objectList);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u529f\u80fd\u53ef\u89c1\u8303\u56f4\u5386\u53f2\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u529f\u80fd\u53ef\u89c1\u8303\u56f4\u5386\u53f2\u6570\u636e\u8fd4\u56de\u53c2\u6570=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        return "200".equals(code);
    }

    public boolean dictRec() {
        String accessToken = this.getToken();
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return false;
        }
        ArrayList objectList = new ArrayList();
        List dicSingleList = this.sysDicSingleService.list();
        for (int i = 0; i < dicSingleList.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            DicSingle dicSingle = (DicSingle)dicSingleList.get(i);
            map.put("action", "add");
            map.put("code", dicSingle.getValue());
            map.put("name", dicSingle.getTypeId());
            map.put("typeCode", dicSingle.getLabel());
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("objectType", "DICTIONARY");
        paramMap.put("objectList", objectList);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        String code = JSONObject.parseObject((String)res).getString("code");
        return "200".equals(code);
    }

    public Boolean pushToIam(String type) {
        logger.info("iam\u521d\u59cb\u5316\u7c7b\u578b\uff1a{}===============", (Object)type);
        String accessToken = this.getToken();
        if (HussarUtils.isEmpty((Object)accessToken)) {
            return false;
        }
        if ("group_roles".equals(type)) {
            this.roleGroupRec(accessToken);
            this.roleRec(accessToken);
        } else if ("group_roles_re".equals(type)) {
            this.rolesGroupRec(accessToken);
        } else if ("user_roles_re".equals(type)) {
            this.userRoleRec(accessToken);
        } else if ("func_rights_re".equals(type)) {
            this.funcRightsResourceRec(accessToken);
        } else if ("func_btn_re".equals(type)) {
            this.funcBtnResourceRec(accessToken);
        } else if ("role_func_rights".equals(type)) {
            this.roleFunctionRec(accessToken);
        } else if ("role_func_btn".equals(type)) {
            this.roleFunctionRecBtn(accessToken);
        } else {
            logger.info("\u65e0\u521d\u59cb\u5316\u7c7b\u578b\u6570\u636e===============");
        }
        return false;
    }

    private Boolean roleFunctionRecBtn(String accessToken) {
        ArrayList objectList = new ArrayList();
        logger.info("\u63a8\u9001\u89d2\u8272\u6309\u94ae\u8d44\u6e90\u5173\u8054\u5173\u7cfb\u5f00\u59cb----------------------------");
        List list = this.sysFunctionResourcesService.getRoleFunctionRes("res_btn");
        for (Map item : list) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("arCode", String.valueOf(item.get("rolePermission")));
            map.put("dataCode", String.valueOf(item.get("functionId")));
            map.put("dataObjectCode", this.dataObjectCode);
            map.put("adataCode", String.valueOf(item.get("resourceId")));
            map.put("adataObjectCode", this.btnObjectCode);
            objectList.add(map);
        }
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("appCode", this.appCode);
        paramMap.put("action", "add");
        paramMap.put("objectType", "R_AR_ADATA_D");
        paramMap.put("objectList", objectList);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u529f\u80fd\u64cd\u4f5c\u6743\u9650\u5386\u53f2\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/sync/data", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u89d2\u8272\u529f\u80fd\u64cd\u4f5c\u6743\u9650\u5386\u53f2\u6570\u636e\u8fd4\u56de\u53c2\u6570=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        if ("200".equals(code)) {
            return true;
        }
        return false;
    }

    private Boolean funcBtnResourceRec(String accessToken) {
        logger.info("\u63a8\u9001\u529f\u80fd\u548c\u6309\u94ae\u8d44\u6e90\u7ea7\u8054\u5173\u7cfb\u5f00\u59cb----------------------------");
        List functionResourcesList = this.sysFunctionResourcesService.getFunctionResource("res_btn");
        List result = functionResourcesList.stream().collect(Collectors.groupingBy(SysFunctionResources::getFunctionId)).entrySet().stream().map(entry -> {
            HashMap<String, Object> groupResult = new HashMap<String, Object>();
            groupResult.put("dataCode", entry.getKey());
            groupResult.put("targetObjectCode", this.dataObjectCode);
            groupResult.put("dataUnionList", ((List)entry.getValue()).stream().map(sysFunctionResources -> {
                HashMap<String, Object> resourceMap = new HashMap<String, Object>();
                resourceMap.put("dataCode", sysFunctionResources.getResourceId());
                resourceMap.put("targetObjectCode", this.btnObjectCode);
                return resourceMap;
            }).collect(Collectors.toList()));
            return groupResult;
        }).collect(Collectors.toList());
        logger.info("\u529f\u80fd\u6309\u94ae\u8d44\u6e90\u5173\u8054\u63a8\u9001\uff1a--------" + result);
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("action", "add");
        paramMap.put("appCode", this.appCode);
        paramMap.put("datas", result);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u529f\u80fd\u548c\u64cd\u4f5c\u6743\u9650\u7ea7\u8054\u5173\u7cfb\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/api/data/union/set", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u529f\u80fd\u548c\u64cd\u4f5c\u6743\u9650\u7ea7\u8054\u5173\u7cfb\u8fd4\u56de\u53c2\u6570=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        if ("200".equals(code)) {
            return true;
        }
        return false;
    }

    private Boolean funcRightsResourceRec(String accessToken) {
        List dataScopeType = this.sysDicRefService.getDictByType("data_scope_type");
        ArrayList dataUnionList = new ArrayList();
        for (DicSingle item : dataScopeType) {
            HashMap<String, String> one = new HashMap<String, String>();
            one.put("dataCode", String.valueOf(item.getValue()));
            one.put("targetObjectCode", this.adataObjectCode);
            dataUnionList.add(one);
        }
        logger.info("\u63a8\u9001\u529f\u80fd\u548c\u53ef\u89c1\u8303\u56f4\u8d44\u6e90\u7ea7\u8054\u5173\u7cfb\u5f00\u59cb----------------------------");
        List functionResourcesList = this.sysFunctionResourcesService.getFunctionResource("res_rights");
        List result = functionResourcesList.stream().collect(Collectors.groupingBy(SysFunctionResources::getFunctionId)).entrySet().stream().map(entry -> {
            HashMap<String, Object> groupResult = new HashMap<String, Object>();
            groupResult.put("dataCode", entry.getKey());
            groupResult.put("targetObjectCode", this.dataObjectCode);
            groupResult.put("dataUnionList", dataUnionList);
            return groupResult;
        }).collect(Collectors.toList());
        ArrayList params = new ArrayList();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("global_id", "API" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + Math.round(Math.random() * 10000.0));
        paramMap.put("action", "add");
        paramMap.put("appCode", this.appCode);
        paramMap.put("datas", result);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u529f\u80fd\u53ef\u9009\u8303\u56f4\u7ea7\u8054\u5173\u7cfb\u6570\u636e\u53c2\u6570==========={}", paramMap);
        String res = HttpUtil.postBody((String)this.requestWay, (String)this.ipAddress, (String)"/bpc/api/data/union/set", (String)accessToken, params, paramMap);
        logger.info("\u4f4e\u4ee3\u7801\u5411IAM\u521d\u59cb\u5316\u529f\u80fd\u53ef\u9009\u8303\u56f4\u7ea7\u8054\u5173\u7cfb\u6570\u636e\u8fd4\u56de\u53c2\u6570=========,{}", (Object)res);
        String code = JSONObject.parseObject((String)res).getString("code");
        if ("200".equals(code)) {
            return true;
        }
        return false;
    }
}

