/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.iamdatasync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginValidateService;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMAuthcService;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HussarIAMLoginValidateServiceImpl
implements HussarLoginValidateService {
    @Resource
    IAMAuthcService iamAuthcService;
    private static String CACHE_NAME = "refreshToken";
    private static String KEY = "key";
    private static Long EXPIRE_TIME = 36000L;
    private static final Logger logger = LoggerFactory.getLogger(HussarIAMLoginValidateServiceImpl.class);

    public String getLoginType() {
        return "iamLogin";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        try {
            logger.info("iam\u5355\u70b9\u767b\u5f55\u8ba4\u8bc1\u65b9\u6cd5\u5f00\u59cb");
            JSONObject jsonObject = this.iamAuthcService.getToken(loginCode);
            logger.info("\u83b7\u53d6jsonObject{}", (Object)jsonObject);
            String accessToken = jsonObject.getString("access_token");
            logger.info("\u6253\u5370access-token{}", (Object)accessToken);
            JSONObject userInfo = this.iamAuthcService.getUserInfo(accessToken);
            logger.info("userInfo{}", (Object)userInfo.toJSONString());
            String userAccount = userInfo.getJSONArray("spRoleList").getString(0);
            logger.info("userAccount{}", (Object)userAccount);
            String refreshToken = jsonObject.getString("refresh_token");
            logger.info("\u6253\u5370refresh-token{}", (Object)refreshToken);
            HussarCacheUtil.put((String)CACHE_NAME, (Object)KEY, (Object)refreshToken, (long)EXPIRE_TIME);
            HussarCacheUtil.put((String)"iamAuthToken", (Object)loginCode, (Object)accessToken, (long)EXPIRE_TIME);
            HussarCacheUtil.put((String)"iamRefreshAuthToken", (Object)loginCode, (Object)refreshToken, (long)EXPIRE_TIME);
            return userAccount;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }
}

