/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.iamdatasync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.util.HttpUtil;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMAuthcService;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMService;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IAMServiceImpl
implements IAMService {
    @Autowired
    private IAMAuthcService iamAuthcService;
    @Value(value="${IAM.auth.address:default}")
    private String ipAddress;
    @Value(value="${IAM.auth.clientId:default}")
    private String clientId;
    @Value(value="${IAM.auth.clientSecret:default}")
    private String clientSecret;
    @Value(value="${IAM.request-way:default}")
    private String requestWay;
    @Value(value="${refreshToken.requestWay:default}")
    private String requestWayLcdp;
    @Value(value="${refreshToken.requestDomain:default}")
    private String requestDomainLcdp;
    private static String CACHE_NAME = "refreshToken";
    private static String KEY = "key";
    private static Long EXPIRE_TIME = 36000L;

    public JSONObject refreshToken(String accessToken, String refreshToken) throws IOException {
        String refreshTokenIam = (String)HussarCacheUtil.get((String)CACHE_NAME, (Object)KEY);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.clientId));
        params.add(new BasicNameValuePair("client_secret", this.clientSecret));
        params.add(new BasicNameValuePair("refresh_token", refreshTokenIam));
        params.add(new BasicNameValuePair("grant_type", "refresh_token"));
        String res = HttpUtil.post((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/refreshToken", params);
        JSONObject jsonObject = JSONObject.parseObject((String)res);
        String refreshTokenIAM = jsonObject.getString("refresh_token");
        HussarCacheUtil.put((String)CACHE_NAME, (Object)KEY, (Object)refreshTokenIAM, (long)EXPIRE_TIME);
        ArrayList<NameValuePair> paramsLcdp = new ArrayList<NameValuePair>();
        HashMap<String, Object> paramMapLcdp = new HashMap<String, Object>();
        paramsLcdp.add((NameValuePair)new BasicNameValuePair("refresh-token", refreshToken));
        paramsLcdp.add((NameValuePair)new BasicNameValuePair("grant_type", "refresh_token"));
        String resLcdp = IAMServiceImpl.postBody(this.requestWayLcdp, this.requestDomainLcdp, "/oauth2/refresh", accessToken, paramsLcdp, paramMapLcdp);
        JSONObject jsonObjectLcdp = JSONObject.parseObject((String)resLcdp);
        return jsonObjectLcdp;
    }

    public Map<String, String> getTokenInfo(String code) throws IOException {
        String accessToken = (String)HussarCacheUtil.get((String)"iamAuthToken", (Object)code, String.class);
        String refreshToken = (String)HussarCacheUtil.get((String)"iamRefreshAuthToken", (Object)code, String.class);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("iamToken", accessToken);
        res.put("iamRefreshToken", refreshToken);
        HussarCacheUtil.evict((String)"iamAuthToken", (Object)code);
        HussarCacheUtil.evict((String)"iamRefreshAuthToken", (Object)code);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postBody(String scheme, String host, String path, String token, List<NameValuePair> params, Map<String, Object> paramMap) {
        CloseableHttpClient aDefault = HttpClients.createDefault();
        URI uri = null;
        try {
            uri = new URIBuilder().setScheme(scheme).setHost(host).setPath(path).setParameters(params).build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString(paramMap), ContentType.create((String)"application/json", (String)"utf-8")));
        httpPost.setHeader("Authorization", token);
        httpPost.setHeader("client-id", "hussar-base");
        CloseableHttpResponse execute = null;
        try {
            execute = aDefault.execute((HttpUriRequest)httpPost);
            HttpEntity entity = execute.getEntity();
            Header[] allHeaders = execute.getAllHeaders();
            if (entity.getContent() != null) {
                String s = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("UTF-8"));
                StatusLine statusLine = execute.getStatusLine();
                String string = s;
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                execute.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

