/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryGradeAdminRoleDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryRoleManager;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncDataRightTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.GradeRoleListVo;
import com.jxdinfo.hussar.authorization.permit.vo.LoadRelatedRoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryRoleManagerImpl")
public class QueryRoleManagerImpl
implements QueryRoleManager {
    @Autowired
    private ISysStruService sysStruService;
    @Autowired
    private SysOrgManageService sysOrgManageService;
    @Autowired
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Autowired
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Autowired
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Autowired
    private ISysFunctionModulesService sysFunctionModulesService;
    @Autowired
    private ISysRoleResourceService sysRoleResourceService;
    @Autowired
    private SysRoleDataRightMapper sysRoleDataRightMapper;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;

    @Override
    public List<JSTreeModel> allRoleTree() {
        Long nodeId = Constants.ROOT_NODE_PARENT;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = securityUser.isGradeadmin();
        if (isGradeAdmin) {
            return TreeModelUtils.merge(this.getOrganRoleTree());
        }
        List<JSTreeModel> jsTreeModels = this.sysRoleGroupMapper.getRoleTree();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setParent(nodeId);
        jsTreeModel.setCode("GROUP");
        jsTreeModel.setText("\u89d2\u8272\u6811");
        jsTreeModel.setId(Constants.ROLE_ROOT_ID);
        jsTreeModel.setType("isRoot");
        jsTreeModels.add(jsTreeModel);
        return TreeModelUtils.merge(jsTreeModels);
    }

    @Override
    public List<JSTreeModel> getOrganRoleTree() {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText("\u7ec4\u7ec7\u89d2\u8272\u6811");
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        jsTreeModel.getState().put("isOrganRoleTree", true);
        jsTreeModel.getState().put("gradeDisabled", true);
        result.add(jsTreeModel);
        List<JSTreeModel> organRoleList = this.getGradeAdminOrganRoleTree();
        for (JSTreeModel treeModel : organRoleList) {
            treeModel.getState().put("isOrganRoleTree", true);
        }
        result.addAll(organRoleList);
        for (JSTreeModel model : result) {
            String type = model.getType();
            if ("ORGANROLE".equals(type)) {
                model.setState(false, false, false);
                continue;
            }
            model.setState(false, false, true);
        }
        return result;
    }

    @Override
    public List<ReadOnlyRoleTreeVo> getUserRoleTree(String id) {
        List sysUserRoles = this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)id));
        ArrayList<Long> roleIds = new ArrayList<Long>();
        HashSet<Long> roleGroupIds = new HashSet<Long>();
        for (SysUserRole userRole : sysUserRoles) {
            roleIds.add(userRole.getGrantedRole());
        }
        List sysRoles = this.sysRolesMapper.selectBatchIds(roleIds);
        List orderSysRoles = sysRoles.stream().sorted(Comparator.comparing(SysRoles::getRoleOrder)).collect(Collectors.toList());
        HashMap<Long, ArrayList<SysRoles>> map = new HashMap<Long, ArrayList<SysRoles>>();
        for (SysRoles role : orderSysRoles) {
            ArrayList<SysRoles> children = (ArrayList<SysRoles>)map.get(role.getGroupId());
            if (HussarUtils.isEmpty((Object)children)) {
                children = new ArrayList<SysRoles>();
                map.put(role.getGroupId(), children);
            }
            children.add(role);
            roleGroupIds.add(role.getGroupId());
        }
        List groups = this.sysRoleGroupMapper.selectBatchIds(roleGroupIds);
        List orderGroups = groups.stream().sorted(Comparator.comparing(SysRoleGroup::getGroupOrder)).collect(Collectors.toList());
        ArrayList<ReadOnlyRoleTreeVo> result = new ArrayList<ReadOnlyRoleTreeVo>();
        ReadOnlyRoleTreeVo root = new ReadOnlyRoleTreeVo();
        root.setId("11");
        root.setParentId("1");
        root.setIcon("tree-com");
        root.setLabel("\u89d2\u8272\u6811");
        ArrayList<ReadOnlyRoleTreeVo> groupChildren = new ArrayList<ReadOnlyRoleTreeVo>();
        for (SysRoleGroup group : orderGroups) {
            ReadOnlyRoleTreeVo treeVo = new ReadOnlyRoleTreeVo();
            treeVo.setId(group.getId() + "");
            treeVo.setIcon("tree-organ");
            treeVo.setHasChildren(Boolean.valueOf(true));
            treeVo.setLabel(group.getGroupName());
            treeVo.setParentId("11");
            List childrenRoles = (List)map.get(group.getId());
            ArrayList<ReadOnlyRoleTreeVo> children = new ArrayList<ReadOnlyRoleTreeVo>();
            ReadOnlyRoleTreeVo roleTreeVo = null;
            for (SysRoles role : childrenRoles) {
                roleTreeVo = new ReadOnlyRoleTreeVo();
                roleTreeVo.setId(role.getId() + "");
                roleTreeVo.setParentId(group.getId() + "");
                roleTreeVo.setLabel(role.getRoleName());
                roleTreeVo.setHasChildren(Boolean.valueOf(false));
                roleTreeVo.setIcon("tree-role");
                children.add(roleTreeVo);
            }
            treeVo.setChildren(children);
            groupChildren.add(treeVo);
        }
        root.setChildren(groupChildren);
        root.setHasChildren(Boolean.valueOf(true));
        result.add(root);
        return result;
    }

    @Override
    public List<ReadOnlyRoleTreeVo> getRoleTree() {
        List groups = this.sysRoleGroupMapper.selectList(null);
        List orderGroups = groups.stream().sorted(Comparator.comparing(SysRoleGroup::getGroupOrder)).collect(Collectors.toList());
        ArrayList<ReadOnlyRoleTreeVo> result = new ArrayList<ReadOnlyRoleTreeVo>();
        List sysRoles = this.sysRolesMapper.selectList(null);
        List orderSysRoles = sysRoles.stream().sorted(Comparator.comparing(SysRoles::getRoleOrder)).collect(Collectors.toList());
        HashMap<Long, ArrayList<SysRoles>> map = new HashMap<Long, ArrayList<SysRoles>>();
        for (SysRoles role : orderSysRoles) {
            ArrayList<SysRoles> children = (ArrayList<SysRoles>)map.get(role.getGroupId());
            if (HussarUtils.isEmpty((Object)children)) {
                children = new ArrayList<SysRoles>();
                map.put(role.getGroupId(), children);
            }
            children.add(role);
        }
        ReadOnlyRoleTreeVo root = new ReadOnlyRoleTreeVo();
        root.setId("1");
        root.setParentId("11");
        root.setIcon("tree-com");
        root.setLabel("\u89d2\u8272\u6811");
        root.setType("root");
        ArrayList<ReadOnlyRoleTreeVo> groupChildren = new ArrayList<ReadOnlyRoleTreeVo>();
        for (SysRoleGroup group : orderGroups) {
            ReadOnlyRoleTreeVo treeVo = new ReadOnlyRoleTreeVo();
            treeVo.setId(group.getId() + "");
            treeVo.setIcon("tree-organ");
            treeVo.setLabel(group.getGroupName());
            treeVo.setParentId("1");
            treeVo.setType("group");
            treeVo.setDescription(group.getGroupAlias());
            List childrenRoles = (List)map.get(group.getId());
            ArrayList<ReadOnlyRoleTreeVo> children = new ArrayList<ReadOnlyRoleTreeVo>();
            ReadOnlyRoleTreeVo roleTreeVo = null;
            if (HussarUtils.isNotEmpty((Object)childrenRoles)) {
                treeVo.setHasChildren(Boolean.valueOf(true));
                for (SysRoles role : childrenRoles) {
                    roleTreeVo = new ReadOnlyRoleTreeVo();
                    roleTreeVo.setId(role.getId() + "");
                    roleTreeVo.setParentId(group.getId() + "");
                    roleTreeVo.setLabel(role.getRoleName());
                    roleTreeVo.setHasChildren(Boolean.valueOf(false));
                    roleTreeVo.setIcon("tree-role");
                    roleTreeVo.setType("role");
                    roleTreeVo.setDescription(role.getRoleAlias());
                    children.add(roleTreeVo);
                }
            }
            treeVo.setChildren(children);
            groupChildren.add(treeVo);
        }
        root.setChildren(groupChildren);
        if (HussarUtils.isNotEmpty(groupChildren)) {
            root.setHasChildren(Boolean.valueOf(true));
        }
        result.add(root);
        return result;
    }

    @Override
    public Page<GradeRoleListVo> getGradeAdminRoleTree(PageInfo pageInfo, QueryGradeAdminRoleDto queryGradeAdminRoleDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        Long parentId = queryGradeAdminRoleDto.getParentId();
        if (HussarUtils.isEmpty((Object)parentId)) {
            SecurityUser currentUser = BaseSecurityUtil.getUser();
            parentId = currentUser.getDeptId();
        }
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(parentId);
        AssertUtil.isNotNull((Object)sysStru, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f");
        String struFid = sysStru.getStruFid();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("struFid", struFid);
        queryParams.put("name", queryGradeAdminRoleDto.getName());
        List<GradeRoleListVo> data = this.sysRolesMapper.getGradeAdminRoleTree(page, queryParams);
        page.setRecords(data);
        return page;
    }

    @Override
    public List<LoadRelatedRoleVo> loadRelatedRole(List<FuncDumpDto> funcDumpDtoList) {
        ArrayList<LoadRelatedRoleVo> loadRelatedRoleVos = new ArrayList<LoadRelatedRoleVo>();
        if (HussarUtils.isEmpty(funcDumpDtoList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> funcIds = new ArrayList<Long>();
        ArrayList resIds = new ArrayList();
        for (FuncDumpDto funcDumpDto : funcDumpDtoList) {
            funcIds.add(funcDumpDto.getFuncId());
            List resIdList = funcDumpDto.getResIdList();
            if (!HussarUtils.isNotEmpty((Object)resIdList)) continue;
            resIds.addAll(resIdList);
        }
        List roleFunctions = new ArrayList();
        List roleResources = new ArrayList();
        List roleDataRights = new ArrayList();
        if (HussarUtils.isNotEmpty(funcIds)) {
            roleFunctions = this.sysRoleFunctionsService.selectRoleFunsByFunctionIds(funcIds);
            roleDataRights = this.sysRoleDataRightService.selectRoleDataRightsByFuncIds(funcIds);
        }
        if (HussarUtils.isNotEmpty(resIds)) {
            roleResources = this.sysRoleResourceService.selectRoleResByResIds(resIds);
        }
        HashSet roleIds = new HashSet();
        if (HussarUtils.isNotEmpty(roleFunctions)) {
            Set roleIdListByFunc = roleFunctions.stream().map(SysRoleFunctions::getRoleId).collect(Collectors.toSet());
            roleIds.addAll(roleIdListByFunc);
        }
        if (HussarUtils.isNotEmpty(roleResources)) {
            Set roleIdListByRes = roleResources.stream().map(SysRoleResource::getId).collect(Collectors.toSet());
            roleIds.addAll(roleIdListByRes);
        }
        if (HussarUtils.isNotEmpty(roleDataRights)) {
            Set roleIdListByDataRight = roleDataRights.stream().map(SysRoleDataRight::getRoleId).collect(Collectors.toSet());
            roleIds.addAll(roleIdListByDataRight);
        }
        for (Long roleId : roleIds) {
            LoadRelatedRoleVo roleVo = new LoadRelatedRoleVo();
            roleVo.setRoleId(roleId.longValue());
            for (SysRoleFunctions sysRoleFunctions : roleFunctions) {
                if (!HussarUtils.equals((Object)sysRoleFunctions.getRoleId(), (Object)roleId)) continue;
                if (HussarUtils.isEmpty((Object)roleVo.getFuncIds())) {
                    roleVo.setFuncIds(new ArrayList());
                }
                roleVo.getFuncIds().add(sysRoleFunctions.getFunctionId());
            }
            for (SysRoleResource sysRoleResource : roleResources) {
                if (!HussarUtils.equals((Object)sysRoleResource.getId(), (Object)roleId)) continue;
                if (HussarUtils.isEmpty((Object)roleVo.getResIds())) {
                    roleVo.setResIds(new ArrayList());
                }
                if (roleVo.getResIds().contains(sysRoleResource.getResourceId())) continue;
                roleVo.getResIds().add(sysRoleResource.getResourceId());
            }
            for (SysRoleDataRight sysRoleDataRight : roleDataRights) {
                if (!HussarUtils.equals((Object)sysRoleDataRight.getRoleId(), (Object)roleId)) continue;
                if (HussarUtils.isEmpty((Object)roleVo.getDataRightIds())) {
                    roleVo.setDataRightIds(new ArrayList());
                }
                roleVo.getDataRightIds().add(sysRoleDataRight.getDataRightsId());
            }
            loadRelatedRoleVos.add(roleVo);
        }
        return loadRelatedRoleVos;
    }

    @Override
    public List<SysRoles> getRoleByRoleIds(List<Long> roleIds) {
        if (HussarUtils.isEmpty(roleIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long id : roleIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysRoles::getId, (Object)id);
        }
        lambdaQueryWrapper.orderByAsc(SysRoles::getRoleOrder);
        return this.sysRolesMapper.selectList((Wrapper)lambdaQueryWrapper);
    }

    private List<JSTreeModel> getGradeAdminOrganRoleTree() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long empolyeeId = securityUser.getEmployeeId();
        ArrayList<JSTreeModel> list = new ArrayList<JSTreeModel>();
        Long organId = empolyeeId;
        JSTreeModel organ = new JSTreeModel();
        List childSysStruIdList = this.sysStruService.getChildOrgId(securityUser.getDeptId(), "01");
        List<JSTreeModel> roleLists = new ArrayList<JSTreeModel>();
        childSysStruIdList.add(securityUser.getDeptId());
        for (Long id : childSysStruIdList) {
            if (!id.equals(securityUser.getDeptId())) {
                organ = this.sysOrgManageService.getThisOneOrg(id);
                list.add(organ);
            }
            List<JSTreeModel> roleList = this.sysStruMapper.getRoleTree(id);
            if (ToolUtil.isEmpty(roleLists)) {
                roleLists = roleList;
                continue;
            }
            roleLists.addAll(roleList);
        }
        while (ToolUtil.isNotEmpty((Object)organ)) {
            organ = this.sysOrgManageService.getOneOrg(organId);
            if (!ToolUtil.isNotEmpty((Object)organ)) continue;
            organId = organ.getId();
            list.add(organ);
        }
        ArrayList<JSTreeModel> lists = list;
        list = roleLists;
        list.addAll(lists);
        return list;
    }

    @Override
    public List<FuncDataRightTreeVo> getFuncDataRightByRoleId(Long roleId) {
        List<Object> result = new ArrayList<FuncDataRightTreeVo>();
        List<FuncDataRightTreeVo> funcDataRightTreeVoList = this.sysRoleFunctionsMapper.getFuncDataRightByRoleId(roleId);
        if (ToolUtil.isNotEmpty(funcDataRightTreeVoList)) {
            this.putDataRightInFuncTree(roleId, funcDataRightTreeVoList);
            List allFunctionModuleList = this.sysFunctionModulesService.list();
            List<Long> moduleIdList = funcDataRightTreeVoList.stream().map(item -> Long.parseLong(item.getParentId())).collect(Collectors.toList());
            result.addAll(this.getFuncDataRightModule(funcDataRightTreeVoList, moduleIdList, allFunctionModuleList));
            result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FuncDataRightTreeVo>(Comparator.comparing(AbstractNoIconHussarLazyTreeDefinition::getId))), ArrayList::new));
            return HussarTreeParser.getTreeList(result);
        }
        return result;
    }

    @Override
    public List<FuncDataRightTreeVo> getDataRightDetail(Long roleId) {
        List<Object> result = new ArrayList<FuncDataRightTreeVo>();
        List<Object> funcDataRightTreeVoList = this.sysRoleFunctionsMapper.getFuncDataRightByRoleId(roleId);
        if (ToolUtil.isNotEmpty(funcDataRightTreeVoList)) {
            this.putDataRightInFuncTree(roleId, funcDataRightTreeVoList);
            List allFunctionModuleList = this.sysFunctionModulesService.list();
            funcDataRightTreeVoList = funcDataRightTreeVoList.stream().filter(item -> HussarUtils.isNotEmpty((Object)item.getDataRightsId())).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(funcDataRightTreeVoList)) {
                List<Long> moduleIdList = funcDataRightTreeVoList.stream().map(item -> Long.parseLong(item.getParentId())).collect(Collectors.toList());
                result.addAll(this.getFuncDataRightModule(funcDataRightTreeVoList, moduleIdList, allFunctionModuleList));
                result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FuncDataRightTreeVo>(Comparator.comparing(AbstractNoIconHussarLazyTreeDefinition::getId))), ArrayList::new));
                return HussarTreeParser.getTreeList(result);
            }
        }
        return result;
    }

    private List<FuncDataRightTreeVo> getFuncDataRightModule(List<FuncDataRightTreeVo> result, List<Long> idList, List<SysFunctionModules> allFunctionModuleList) {
        if (idList.size() == 1 && idList.get(0) == 1L) {
            return result;
        }
        ArrayList<Long> parentIdList = new ArrayList();
        for (SysFunctionModules item : allFunctionModuleList) {
            if (!idList.contains(item.getId())) continue;
            FuncDataRightTreeVo funcDataRightTreeVo = new FuncDataRightTreeVo();
            funcDataRightTreeVo.setId(item.getId().toString());
            funcDataRightTreeVo.setSort(item.getSeq().intValue());
            funcDataRightTreeVo.setFuncFlag(false);
            funcDataRightTreeVo.setLabel(item.getFunctionModuleName());
            funcDataRightTreeVo.setParentId(item.getParentModuleId().toString());
            funcDataRightTreeVo.setHasChildren(Boolean.valueOf(true));
            funcDataRightTreeVo.setType("isModule");
            parentIdList.add(item.getParentModuleId());
            result.add(funcDataRightTreeVo);
        }
        parentIdList = parentIdList.stream().distinct().collect(Collectors.toList());
        return this.getFuncDataRightModule(result, parentIdList, allFunctionModuleList);
    }

    private void putDataRightInFuncTree(Long roleId, List<FuncDataRightTreeVo> treeVoList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleDataRight::getRoleId, (Object)roleId);
        List dataRightList = this.sysRoleDataRightMapper.selectList((Wrapper)queryWrapper);
        for (SysRoleDataRight item : dataRightList) {
            for (FuncDataRightTreeVo tree : treeVoList) {
                if (!item.getFunctionId().toString().equals(tree.getId())) continue;
                tree.setDataRightsId(item.getDataRightsId());
                tree.setDataScope(item.getDataScope().toString());
            }
        }
    }
}

