/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dto.FuncDumpDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryGradeAdminRoleDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseRoleService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncDataRightTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.GradeRoleListVo;
import com.jxdinfo.hussar.authorization.permit.vo.LoadRelatedRoleVo;
import com.jxdinfo.hussar.authorization.permit.vo.ReadOnlyRoleTreeVo;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u65b0\u7248\u89d2\u8272\u7ef4\u62a4"})
@RestController(value="com.jxdinfo.hussar.authorization.permit.controller.hussarBaseRoleController")
@RequestMapping(value={"/hussarBase/authorization/permit/role"})
public class HussarBaseRoleController {
    @Autowired
    IHussarBaseRoleService baseRoleService;

    @ApiOperation(value="\u89d2\u8272\u6811\u5168\u52a0\u8f7d", notes="\u89d2\u8272\u6811\u5168\u52a0\u8f7d")
    @GetMapping(value={"/roleTree"})
    @CheckPermission(value={"hussarBase:authorization:permit:role:roleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u6811\u5168\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> allRoleTree() {
        return this.baseRoleService.allRoleTree();
    }

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u6811")
    @GetMapping(value={"/getRoleTree"})
    @CheckPermission(value={"hussarBase:authorization:permit:role:getRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ReadOnlyRoleTreeVo>> getRoleTree() {
        return this.baseRoleService.getRoleTree();
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811\u8be6\u60c5", notes="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811\u8be6\u60c5")
    @GetMapping(value={"/getFuncDataRightDetail"})
    @AuditLog(moduleName="\u65b0\u7248\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FuncDataRightTreeVo>> getFuncDataRightDetail(@ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId) {
        return this.baseRoleService.getFuncDataRightDetail(roleId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u7684\u89d2\u8272\u5217\u8868", notes="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u7684\u89d2\u8272\u5217\u8868")
    @GetMapping(value={"/getGradeAdminRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u7684\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<GradeRoleListVo>> getGradeAdminRoleTree(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="\u6839\u57fa\u7ba1\u7406\u89d2\u8272\u67e5\u8be2DTO") QueryGradeAdminRoleDto queryGradeAdminRoleDto) {
        return this.baseRoleService.getGradeAdminRoleTree(pageInfo, queryGradeAdminRoleDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811", notes="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811")
    @GetMapping(value={"/getFuncDataRightByRoleId"})
    @AuditLog(moduleName="\u65b0\u7248\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6570\u636e\u6743\u9650\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FuncDataRightTreeVo>> getFuncDataRightByRoleId(@ApiParam(value="\u89d2\u8272id") @RequestParam Long roleId) {
        return this.baseRoleService.getFuncDataRightByRoleId(roleId);
    }

    @ApiOperation(value="\u8f7d\u5165\u5173\u8054\u89d2\u8272", notes="\u8f7d\u5165\u5173\u8054\u89d2\u8272")
    @PostMapping(value={"/loadRelatedRole"})
    @CheckPermission(value={"hussarBase:authorization:permit:role:loadRelatedRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u8f7d\u5165\u5173\u8054\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<LoadRelatedRoleVo>> loadRelatedRole(@ApiParam(value="\u8f7d\u5165\u5173\u8054\u89d2\u8272Dto") @RequestBody List<FuncDumpDto> funcDumpDtoList) {
        return this.baseRoleService.loadRelatedRole(funcDumpDtoList);
    }
}

