/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.iamdatasync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMTokenToHussarTokenService;
import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityRequest;
import com.jxdinfo.hussar.support.security.core.context.model.SecurityResponse;
import com.jxdinfo.hussar.support.security.core.dto.PasswordEncryptDTO;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityAuthenticationService;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.HussarSecurityOAuth2InterceptorCustomizers;
import com.jxdinfo.hussar.support.security.plugin.oauth2.customizers.dto.SecurityAuthenticationDto;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IAMSecurityOAuth2InterceptorCustomizers
implements HussarSecurityOAuth2InterceptorCustomizers {
    private static final Logger logger = LoggerFactory.getLogger(IAMSecurityOAuth2InterceptorCustomizers.class);
    @Resource
    private HussarSecurityAuthenticationService hussarSecurityAuthenticationService;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    @Resource
    private IAMTokenToHussarTokenService iAMTokenToHussarTokenService;

    public void customize(SecurityRequest securityRequest, SecurityResponse securityResponse) {
        try {
            String iamToken = securityRequest.getHeader("iamToken");
            if (HussarUtils.isNotEmpty((Object)iamToken)) {
                String iamClientId = securityRequest.getHeader("iamClientId");
                String iamRefreshToken = securityRequest.getHeader("iamRefreshToken");
                String iamClientSecret = securityRequest.getHeader("iamClientSecret");
                logger.info("\u89e3\u6790IAMtoken\u53c2\u6570\uff1a====iamToken={}", (Object)iamToken);
                logger.info("\u89e3\u6790IAMtoken\u53c2\u6570\uff1a====iamClientId={}", (Object)iamClientId);
                logger.info("\u89e3\u6790IAMtoken\u53c2\u6570\uff1a====iamRefreshToken={}", (Object)iamRefreshToken);
                logger.info("\u89e3\u6790IAMtoken\u53c2\u6570\uff1a====iamClientSecret={}", (Object)iamClientSecret);
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("accessToken", iamToken);
                param.put("clientId", iamClientId);
                param.put("refreshToken", iamRefreshToken);
                param.put("clientSecret", iamClientSecret);
                String hussarToken = (String)HussarCacheUtil.get((String)"iam_to_hussar_token", (Object)iamToken);
                logger.info("\u7f13\u5b58\u4e2d\u53d6hussarToken\uff1a====hussarToken={}", (Object)hussarToken);
                if (HussarUtils.isEmpty((Object)hussarToken)) {
                    JSONObject userInfo = this.iAMTokenToHussarTokenService.getUserInfo(param);
                    String errcode = userInfo.getString("errcode");
                    if (null != errcode) {
                        if (!"2002".equals(errcode)) {
                            logger.info("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff1amsg\uff1a=============={}", userInfo.get((Object)"msg"));
                            throw new HussarException("iamToken\u4f20\u53c2\u6709\u8bef" + userInfo.get((Object)"msg"));
                        }
                        logger.info("iamToken\u65e0\u6548\u8fdb\u884c\u5237\u65b0Token\uff1a======================");
                        if (null != iamRefreshToken && null != iamClientSecret) {
                            JSONObject refreshTokenObject = this.iAMTokenToHussarTokenService.refreshToken(param);
                            if (null != refreshTokenObject.getString("errcode")) {
                                logger.info("iamToken\u503c\u65e0\u6548 \u4e14\u5237\u65b0token\u5931\u8d25\uff1a{}======", (Object)refreshTokenObject.getString("msg"));
                                throw new HussarException("iamToken\u503c\u65e0\u6548 \u4e14\u5237\u65b0token\u5931\u8d25" + refreshTokenObject.getString("msg"));
                            }
                            iamToken = refreshTokenObject.getString("access_token");
                            userInfo = this.iAMTokenToHussarTokenService.getUserInfo(param);
                        } else {
                            logger.info("iamToken\u503c\u65e0\u6548\u4e14\u6ca1\u6709\u4f20iamRefreshToken\u6216\u8005iamClientSecret\u503c\uff1a================");
                            throw new HussarException("iamToken\u503c\u65e0\u6548\u4e14\u6ca1\u6709\u4f20iamRefreshToken\u6216\u8005iamClientSecret\u503c");
                        }
                    }
                    String userAccount = userInfo.getJSONArray("spRoleList").getString(0);
                    HashMap<String, String> paramsMapExcludeParam = new HashMap<String, String>();
                    paramsMapExcludeParam.put("loginType", "ssoLogin");
                    paramsMapExcludeParam.put("loginCode", "userAccount");
                    PasswordEncryptDTO pwEncryptDTO = this.passwordEncryptService.getPasswordEncryptInfo();
                    Boolean enabled = pwEncryptDTO.getEnabled();
                    String encryptKey = pwEncryptDTO.getEncryptKey();
                    String password = "111111";
                    if (enabled.booleanValue()) {
                        password = SM2Util.encrypt((String)password, (String)encryptKey);
                    }
                    SecurityAuthenticationDto dto = new SecurityAuthenticationDto();
                    dto.setClientId("hussar-base");
                    dto.setUsername(userAccount);
                    dto.setPassword(password);
                    dto.setParamsMapExcludeParam(paramsMapExcludeParam);
                    ApiResponse response = this.hussarSecurityAuthenticationService.securityPassword(dto);
                    if (response == null || !response.isSuccess()) {
                        throw new HussarException("token\u8f6c\u6362\u5f02\u5e38");
                    }
                    hussarToken = ((Map)response.getData()).get("access-token").toString();
                    Long expireTime = Long.parseLong(((Map)response.getData()).get("expires-in").toString());
                    HussarCacheUtil.put((String)"iam_to_hussar_token", (Object)iamToken, (Object)hussarToken, (long)expireTime);
                    securityRequest.setHeader("Authorization", hussarToken);
                } else {
                    JSONObject jsonObject = this.iAMTokenToHussarTokenService.checkTokenValid(param);
                    String result = jsonObject.getString("result");
                    if (null == result) {
                        logger.info("iamToken\u4f20\u53c2\u6709\u8bef\uff1a======================");
                        throw new HussarException("iamToken\u4f20\u53c2\u6709\u8bef");
                    }
                    if ("false".equals(result)) {
                        logger.info("iamToken\u65e0\u6548\u8fdb\u884c\u5237\u65b0Token\uff1a======================");
                        if (null == iamRefreshToken || null == iamClientSecret) {
                            logger.info("iamToken\u503c\u65e0\u6548\u4e14\u6ca1\u6709\u4f20iamRefreshToken\u6216\u8005iamClientSecret\u503c\uff1a================");
                            throw new HussarException("iamToken\u503c\u65e0\u6548\u4e14\u6ca1\u6709\u4f20iamRefreshToken\u6216\u8005iamClientSecret\u503c");
                        }
                        JSONObject refreshTokenObject = this.iAMTokenToHussarTokenService.refreshToken(param);
                        if (null != refreshTokenObject.getString("errcode")) {
                            logger.info("iamToken\u503c\u65e0\u6548 \u4e14\u5237\u65b0token\u5931\u8d25\uff1a{}======", (Object)refreshTokenObject.getString("msg"));
                            throw new HussarException("iamToken\u503c\u65e0\u6548 \u4e14\u5237\u65b0token\u5931\u8d25" + refreshTokenObject.getString("msg"));
                        }
                        iamToken = refreshTokenObject.getString("access_token");
                    }
                    securityRequest.setHeader("Authorization", hussarToken);
                }
            }
        }
        catch (Exception e) {
            logger.info("iamToken\u89e3\u6790\u5931\u8d25\uff1a========{}", (Object)e.getMessage());
            throw new HussarException("iamToken\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

