/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.iamdatasync.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.util.HttpUtil;
import com.jxdinfo.hussar.authorization.iamdatasync.service.IAMAuthcService;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IAMAuthcServiceImpl
implements IAMAuthcService {
    @Value(value="${IAM.auth.address:default}")
    private String ipAddress;
    @Value(value="${IAM.auth.clientId:default}")
    private String clientId;
    @Value(value="${IAM.auth.clientSecret:default}")
    private String clientSecret;
    @Value(value="${IAM.request-way:default}")
    private String requestWay;

    public String getAuthorize(String uri) throws IOException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.clientId));
        params.add(new BasicNameValuePair("redirect_uri", uri));
        params.add(new BasicNameValuePair("response_type", "code"));
        params.add(new BasicNameValuePair("state", "1"));
        String res = HttpUtil.get((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/getToken", params);
        return res.substring(res.indexOf("code=5"), res.indexOf("&"));
    }

    public JSONObject getToken(String code) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.clientId));
        params.add(new BasicNameValuePair("client_secret", this.clientSecret));
        params.add(new BasicNameValuePair("code", code));
        params.add(new BasicNameValuePair("grant_type", "authorization_code"));
        String res = HttpUtil.post((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/getToken", params);
        return JSONObject.parseObject((String)res);
    }

    public JSONObject getUserInfo(String accessToken) {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("client_id", this.clientId));
        params.add(new BasicNameValuePair("access_token", accessToken));
        String res = HttpUtil.get((String)this.requestWay, (String)this.ipAddress, (String)"/idp/oauth2/getUserInfo", params);
        return JSONObject.parseObject((String)res);
    }
}

