/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.unifiedAuth.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authorization.unifiedAuth.service.UnifiedAuthLoginValidateService;
import com.jxdinfo.hussar.authorization.unifiedAuth.util.HttpClientUtil;
import com.jxdinfo.hussar.common.exception.ExtendLoginException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UnifiedAuthLoginValidateServiceImpl
implements UnifiedAuthLoginValidateService {
    @Value(value="${sso-login.clientId:''}")
    String clientId;
    @Value(value="${sso-login.clientSecret:''}")
    String clientSecret;
    @Value(value="${sso-login.grantType:''}")
    String grantType;
    @Value(value="${sso-login.redirectUri:''}")
    String redirectUri;
    @Value(value="${sso-login.ssoUrl:''}")
    String ssoUrl;
    @Value(value="${pm.grantType:''}")
    String pmGrantType;
    @Value(value="${pm.system:''}")
    String system;
    @Value(value="${pm.userType:''}")
    String userType;
    @Value(value="${pm.clientType:''}")
    String clientType;
    @Value(value="${pm.authorization:''}")
    String authorization;
    @Value(value="${pm.pmUrl:''}")
    String pmUrl;
    @Value(value="${pm.pmCountTestUrl:''}")
    String pmCountTestUrl;

    public String getLoginType() {
        return "unifiedAuth";
    }

    public String beforeSelectUser(HttpServletRequest request, String loginCode, AuthcDto authcDto) {
        if (HussarUtils.isEmpty((Object)loginCode)) {
            throw new ExtendLoginException("\u6388\u6743code\u4e3a\u7a7a");
        }
        return this.getUserInfo(loginCode);
    }

    public void validateUser(AuthcDto authcDto, SysUsersDto sysUsersDto) {
    }

    private String getUserInfo(String ssoToken) {
        try {
            String userInfo = HttpClientUtil.sendGet(this.ssoUrl + "profile?access_token=" + ssoToken, "");
            JSONObject userObject = (JSONObject)JSONArray.parse((String)userInfo);
            return userObject.getString("id");
        }
        catch (Exception e) {
            throw new ExtendLoginException("\u8bf7\u6c42\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
        }
    }

    private String getPmToken(String ssoToken, String userAccount) {
        String pmToken;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("auth_center_token", ssoToken);
        map.put("grant_type", this.pmGrantType);
        map.put("system", this.system);
        map.put("user_code", userAccount);
        map.put("user_type", this.userType);
        map.put("client_type", this.clientType);
        try {
            String pmInfo = HttpClientUtil.sendPost(this.pmUrl, map, this.authorization);
            JSONObject resultArray = (JSONObject)JSONArray.parse((String)pmInfo);
            pmToken = resultArray.getString("access_token");
        }
        catch (Exception e) {
            throw new ExtendLoginException("\u83b7\u53d6PM\u7cfb\u7edftoken\u5931\u8d25");
        }
        return pmToken;
    }
}

