/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.permit.service.impl.sysUserRoleServiceImpl")
public class SysUserRoleServiceImpl
extends HussarBaseServiceImpl<SysUserRoleMapper, SysUserRole>
implements ISysUserRoleService {
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysConfRolesService isConfRolesService;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private ISysRolesService sysRolesService;
    private static final String DISABLED = "0";
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;

    public void deleteNotPublicRole(String userId) {
        this.sysUserRoleMapper.deleteNotPublicRole(userId);
    }

    public void addRecord(SysUserRole sysUserRole) {
        this.sysUserRoleMapper.insert(sysUserRole);
    }

    public List<Long> getRolesByUserId(Long userId) {
        if (userId == null) {
            return new ArrayList<Long>();
        }
        return this.sysUserRoleMapper.getRolesByUserId(userId);
    }

    public List<String> selectUserIdByRoleId(String roleId) {
        return this.sysUserRoleMapper.selectUserIdByRoleId(roleId);
    }

    @HussarTransactional
    public ApiResponse saveOrDelUserRole(RoleUserDto roleUserDto) {
        Long roleId = roleUserDto.getRoleId();
        List adds = roleUserDto.getAdds();
        List dels = roleUserDto.getDels();
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Long> hasDel = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)dels)) {
            for (RoleOrgUserVo roleOrgUserVo : dels) {
                hasDel.add(roleOrgUserVo.getId());
            }
        }
        ArrayList<Long> addIds = new ArrayList<Long>();
        ArrayList<Long> addIdsTemp = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)adds)) {
            for (RoleOrgUserVo roleOrgUserVo : adds) {
                addIds.add(roleOrgUserVo.getId());
                addIdsTemp.add(roleOrgUserVo.getId());
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)ADD);
        List se = this.sysUserRoleMapper.selectList((Wrapper)wrapper);
        for (Object sysUserRole : se) {
            for (int i = 0; i < addIdsTemp.size(); ++i) {
                if (!((Long)addIdsTemp.get(i)).equals(sysUserRole.getUserId()) || !ADD.equals(sysUserRole.getAdminOption())) continue;
                addIds.remove(addIdsTemp.get(i));
            }
        }
        ArrayList<Long> delNew = new ArrayList<Long>();
        for (SysUserRole sysUserRole : se) {
            for (Long del : hasDel) {
                if (!del.equals(sysUserRole.getUserId()) || DELETE.equals(sysUserRole.getAdminOption())) continue;
                delNew.add(del);
            }
        }
        Long count = this.sysConfRolesMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getId, (Object)roleId));
        if (count > 0L && addIds.size() > 0) {
            LambdaQueryWrapper userRoleWrapper = new LambdaQueryWrapper();
            for (Long userId : addIds) {
                ((LambdaQueryWrapper)userRoleWrapper.or()).eq(SysUserRole::getUserId, (Object)userId);
            }
            Iterator userRoleList = this.sysUserRoleMapper.selectList((Wrapper)userRoleWrapper);
            HashMap<Long, StringBuilder> map = new HashMap<Long, StringBuilder>();
            Iterator iterator = userRoleList.iterator();
            while (iterator.hasNext()) {
                SysUserRole userRole = (SysUserRole)iterator.next();
                Long userId = userRole.getUserId();
                StringBuilder sb = (StringBuilder)map.get(userId);
                if (ToolUtil.isNotEmpty((Object)sb)) {
                    sb.append(",");
                    sb.append(userRole.getGrantedRole());
                    continue;
                }
                sb = new StringBuilder(String.valueOf(userRole.getGrantedRole()));
                map.put(userId, sb);
            }
            Long userId = this.isConfRolesService.isIncludeConfRole(map, roleId);
            if (userId != null) {
                SysUsers user = (SysUsers)this.sysUsersMapper.selectById(userId);
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08" + user.getUserName() + " \u8fdd\u53cd\u4e86\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u89c4\u5219\uff09");
            }
        }
        List auditList = this.sysUserroleAuditMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)roleId));
        if (this.sysAuditConfig.isRoleAudit() && this.sysAuditConfig.isCriticalOperationsAudit()) {
            SysUserroleAudit sysUserroleAudit;
            if (ToolUtil.isNotEmpty(addIds)) {
                for (Long userId : addIds) {
                    boolean exist = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist = true;
                        audit.setOperationType(ADD);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)userId)).eq(SysUserroleAudit::getRoleId, (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(userId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(ADD);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delNew)) {
                for (Long userId : delNew) {
                    boolean exist = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist = true;
                        audit.setOperationType(DELETE);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)userId)).eq(SysUserroleAudit::getRoleId, (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(userId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(DELETE);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (addIds.size() > 0 || delNew.size() > 0) {
                return ApiResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
        } else {
            if (ToolUtil.isNotEmpty(delNew)) {
                this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, delNew));
                this.bpmAbstractPushMsgMatcher.deleteUserRole(delNew, null, null, roleId);
            }
            ArrayList<SysUserRole> userRoleList2 = new ArrayList<SysUserRole>();
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            for (Long userId : addIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreator(securityUser.getId());
                sysUserRole.setLastEditor(securityUser.getId());
                sysUserRole.setLastTime(now);
                sysUserRole.setCreateTime(now);
                userRoleList2.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(userId);
            }
            if (ToolUtil.isNotEmpty(userRoleList2)) {
                this.saveBatch(userRoleList2, userRoleList2.size());
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList2, "add");
            }
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public List<SysUserRole> getUserRolesByUserIds(List<Long> userIds) {
        if (HussarUtils.isEmpty(userIds)) {
            return Collections.emptyList();
        }
        return this.sysUserRoleMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUserRole::getUserId, userIds));
    }

    public Map<String, Integer> saveOrUpdateBatchUserRoles(List<SysUserRole> userRoles) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<SysUserRole> existedUserRoles = this.getUserRolesByUserRoles(userRoles);
        int repeatCount = 0;
        ArrayList<SysUserRole> newUserRoles = new ArrayList<SysUserRole>();
        if (HussarUtils.isEmpty(existedUserRoles)) {
            this.saveBatch(userRoles);
            map.put("insert", userRoles.size());
            map.put("update", 0);
            return map;
        }
        for (SysUserRole userRole : userRoles) {
            boolean flag = false;
            for (SysUserRole existedUserRole : existedUserRoles) {
                if (!this.userRoleIsEqual(existedUserRole, userRole)) continue;
                ++repeatCount;
                flag = true;
                break;
            }
            if (flag) continue;
            newUserRoles.add(userRole);
        }
        map.put("insert", newUserRoles.size());
        map.put("update", repeatCount);
        this.saveBatch(newUserRoles);
        return map;
    }

    public List<SysUserRole> getUserRolesByUserRoles(List<SysUserRole> userRoles) {
        if (HussarUtils.isEmpty(userRoles)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        int size = userRoles.size();
        ArrayList<SysUserRole> returnList = new ArrayList<SysUserRole>();
        for (int i = 0; i < size; i += 9999) {
            List<SysUserRole> tempList = i + 9999 < size ? userRoles.subList(i, i + 9999) : userRoles.subList(i, size);
            lambdaQueryWrapper.clear();
            for (SysUserRole sysUserRole : tempList) {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysUserRole::getGrantedRole, (Object)sysUserRole.getGrantedRole())).eq(SysUserRole::getUserId, (Object)sysUserRole.getUserId());
            }
            returnList.addAll(this.sysUserRoleMapper.selectList((Wrapper)lambdaQueryWrapper));
        }
        return returnList;
    }

    private boolean userRoleIsEqual(SysUserRole userRole, SysUserRole sysUserRole) {
        return HussarUtils.equals((Object)userRole.getUserId(), (Object)sysUserRole.getUserId()) && HussarUtils.equals((Object)userRole.getGrantedRole(), (Object)sysUserRole.getGrantedRole());
    }

    @HussarDs(value="#connName")
    public void saveUserRole(String connName, Long userId, String clientId) {
        ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(userId);
        sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
        list.add(sysUserRole);
        SysUserRole entity = new SysUserRole();
        entity.setAdminOption(UserRoleStatus.OK.getCode());
        entity.setUserId(userId);
        entity.setGrantedRole(TenantConstant.ADMIN_ROLE);
        list.add(entity);
        if ("hussar-workflow".equals(clientId)) {
            SysUserRole userRole = new SysUserRole();
            userRole.setUserId(TenantConstant.OM_USER);
            userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            userRole.setAdminOption(UserRoleStatus.OK.getCode());
            list.add(userRole);
        }
        this.saveBatch(connName, list);
    }

    @HussarDs(value="#connName")
    public void saveBatchForTenant(String connName, Set<SysUserRole> sysUserRoleCollection) {
        super.saveBatch(sysUserRoleCollection);
    }

    @HussarTransactional
    public ApiResponse<Boolean> addOrDelAppDevRoleUser(RoleUserDto roleUserDto) {
        Long roleId = roleUserDto.getRoleId();
        List adds = roleUserDto.getAdds();
        List removes = roleUserDto.getDels();
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isNotEmpty((Object)removes)) {
            List delUserIds = removes.stream().map(RoleOrgUserVo::getId).collect(Collectors.toList());
            this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, delUserIds));
        }
        boolean addFlag = true;
        if (ToolUtil.isNotEmpty((Object)adds)) {
            List addUserIds = adds.stream().map(RoleOrgUserVo::getId).collect(Collectors.toList());
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            LocalDateTime now = LocalDateTime.now();
            for (Long userId : addUserIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setCreator(securityUser.getId());
                sysUserRole.setLastEditor(securityUser.getId());
                sysUserRole.setLastTime(now);
                sysUserRole.setCreateTime(now);
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                addFlag = this.saveBatch(userRoleList, userRoleList.size());
            }
        }
        return ApiResponse.success((Object)addFlag);
    }
}

