/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesExternalService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.sysRolesExternalServiceImpl")
public class SysRolesExternalServiceImpl
implements ISysRolesExternalService {
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;

    public ApiResponse<Long> addAppDevRole(String appName) {
        return this.sysRolesService.addAppDevRole(appName);
    }

    public ApiResponse<Boolean> addOrDelAppDevRoleUser(RoleUserDto roleUserDto) {
        return this.sysUserRoleService.addOrDelAppDevRoleUser(roleUserDto);
    }

    public List<RoleVo> getRoleInfoByIds(List<Long> roleIds) {
        List roles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIds));
        ArrayList<RoleVo> roleVoList = new ArrayList<RoleVo>();
        for (SysRoles role : roles) {
            RoleVo roleVo = new RoleVo();
            roleVo.setId(role.getId());
            roleVo.setRoleName(role.getRoleName());
            roleVoList.add(roleVo);
        }
        return roleVoList;
    }

    public List<JSTreeModel> loadRoleGruopTree(Long appId) {
        return this.sysRolesService.getRoleGroupTree(appId);
    }

    public List<SysRoles> searchRoleToGroup(Long id, String roleName) {
        return this.sysRolesService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getGroupId, (Object)id)).like(SysRoles::getRoleName, (Object)roleName)).orderByAsc(SysRoles::getRoleOrder));
    }
}

