/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.migration;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleGroupMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleMigrationDumpDto;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.manager.QueryRoleManager;
import com.jxdinfo.hussar.authorization.permit.migration.RoleMigrationPluginMetadata;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleStruRightService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.vo.RoleMigrationDumpVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleMigrationLoadVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.migration.plugin.MigrationPlugin;
import com.jxdinfo.hussar.migration.plugin.MigrationPluginMetadata;
import com.jxdinfo.hussar.migration.plugin.context.MigrationDumpContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationLoadContext;
import com.jxdinfo.hussar.migration.plugin.context.MigrationPreloadContext;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationDumpItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationLoadItemVo;
import com.jxdinfo.hussar.migration.plugin.vo.MigrationPreloadItemVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class RoleMigrationPlugin
implements MigrationPlugin {
    private static final Logger logger = LoggerFactory.getLogger(RoleMigrationPlugin.class);
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysRoleGroupMapper sysRoleGroupMapper;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysRoleDataRightService sysRoleDataRightService;
    @Resource
    private ISysRoleStruRightService sysRoleStruRightService;
    @Resource
    private QueryDataRightManager queryDataRightManager;
    @Resource
    private SysRoleDataRightMapper sysRoleDataRightMapper;
    @Resource
    private SysRoleStruRightsMapper sysRoleStruRightsMapper;
    @Resource
    private QueryRoleManager queryRoleManager;

    public MigrationPluginMetadata metadata() {
        return new RoleMigrationPluginMetadata();
    }

    public MigrationDumpItemVo<Object> dump(MigrationDumpContext context, Map<String, Object> parameters) {
        long total = 0L;
        List dtoList = (List)IdempotentJsonUtils.parse((String)IdempotentJsonUtils.toString((Object)parameters.get("roleData")), (TypeReference)new TypeReference<List<RoleMigrationDumpDto>>(){});
        if (HussarUtils.isEmpty((Object)dtoList)) {
            return MigrationDumpItemVo.success((Long)total, Collections.emptyList());
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        ArrayList<SysRoleFunctions> roleFunctions = new ArrayList<SysRoleFunctions>();
        ArrayList<SysRoleResource> roleResources = new ArrayList<SysRoleResource>();
        ArrayList dataRightIds = new ArrayList();
        for (RoleMigrationDumpDto dumpDto : dtoList) {
            roleIds.add(dumpDto.getRoleId());
            List funcIds = dumpDto.getFuncIds();
            List resIds = dumpDto.getResIds();
            List dataRightIdList = dumpDto.getDataRightIds();
            for (Long funcId : funcIds) {
                SysRoleFunctions roleFunction = new SysRoleFunctions();
                roleFunction.setRoleId(Long.valueOf(dumpDto.getRoleId()));
                roleFunction.setFunctionId(funcId);
                roleFunctions.add(roleFunction);
            }
            for (Long resId : resIds) {
                SysRoleResource roleResource = new SysRoleResource();
                roleResource.setId(Long.valueOf(dumpDto.getRoleId()));
                roleResource.setResourceId(resId);
                roleResources.add(roleResource);
            }
            dataRightIds.addAll(dataRightIdList);
        }
        if (HussarUtils.isNotEmpty(roleFunctions)) {
            List sysRoleFunctions = this.sysRoleFunctionsService.selectRoleFuncByDoubleId(roleFunctions);
            context.setPayloadOfJson("roleFunctionFile.json", (Object)sysRoleFunctions);
            context.setAttribute("roleFunction", (Object)"roleFunctionFile.json");
            total += (long)sysRoleFunctions.size();
        }
        if (HussarUtils.isNotEmpty(roleResources)) {
            List sysRoleResources = this.sysRoleResourceService.selectRoleResByDobuleIdNoRelation(roleResources);
            context.setPayloadOfJson("roleResourceFile.json", (Object)sysRoleResources);
            context.setAttribute("roleResource", (Object)"roleResourceFile.json");
            total += (long)sysRoleResources.size();
        }
        if (HussarUtils.isNotEmpty(dataRightIds)) {
            List sysRoleDataRights = this.sysRoleDataRightMapper.selectBatchIds(dataRightIds);
            List sysRoleStruRights = this.sysRoleStruRightsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysRoleStruRights::getRoleDataRightsId, dataRightIds));
            context.setPayloadOfJson("roleDataRightFile.json", (Object)sysRoleDataRights);
            context.setPayloadOfJson("roleStruRightFile.json", (Object)sysRoleStruRights);
            context.setAttribute("roleDataRight", (Object)"roleDataRightFile.json");
            context.setAttribute("roleStruRight", (Object)"roleStruRightFile.json");
            total = total + (long)sysRoleDataRights.size() + (long)sysRoleStruRights.size();
        }
        List<SysRoles> sysRoles = this.queryRoleManager.getRoleByRoleIds(roleIds);
        List groupIds = sysRoles.stream().map(SysRoles::getGroupId).distinct().collect(Collectors.toList());
        ArrayList<SysRoleGroup> sysRoleGroups = new ArrayList();
        if (HussarUtils.isNotEmpty(groupIds)) {
            sysRoleGroups = this.sysRoleGroupService.selectRoleGroupByIds(groupIds);
        }
        total = total + (long)sysRoleGroups.size() + (long)sysRoles.size();
        context.setPayloadOfJson("roleFile.json", sysRoles);
        context.setPayloadOfJson("roleGroupFile.json", sysRoleGroups);
        context.setAttribute("role", (Object)"roleFile.json");
        context.setAttribute("roleGroup", (Object)"roleGroupFile.json");
        List<RoleMigrationDumpVo> roleMigrationDumpVos = this.getRoleDumpVoList(dtoList, sysRoleGroups, sysRoles);
        List roleTree = HussarTreeParser.getTreeList(roleMigrationDumpVos);
        return MigrationDumpItemVo.success((Long)total, (Object)roleTree);
    }

    private List<RoleMigrationDumpVo> getRoleDumpVoList(List<RoleMigrationDumpDto> dtoList, List<SysRoleGroup> roleGroups, List<SysRoles> roles) {
        RoleMigrationDumpVo dumpVo;
        ArrayList<RoleMigrationDumpVo> roleMigrationDumpVos = new ArrayList<RoleMigrationDumpVo>();
        RoleMigrationDumpVo root = new RoleMigrationDumpVo();
        root.setId(Constants.ROLE_ROOT_ID);
        root.setType(0);
        root.setLabel("\u89d2\u8272\u6811");
        root.setParentId(Constants.ROOT_NODE_PARENT);
        root.setIcon("tree-com");
        root.setHasChildren(Boolean.valueOf(true));
        roleMigrationDumpVos.add(root);
        if (HussarUtils.isNotEmpty(roleGroups)) {
            for (SysRoleGroup roleGroup : roleGroups) {
                dumpVo = new RoleMigrationDumpVo();
                dumpVo.setId(roleGroup.getId());
                dumpVo.setParentId(roleGroup.getParentId());
                dumpVo.setType(1);
                dumpVo.setLabel(roleGroup.getGroupName());
                dumpVo.setAlias(roleGroup.getGroupAlias());
                dumpVo.setIcon("tree-organ");
                dumpVo.setHasChildren(Boolean.valueOf(true));
                roleMigrationDumpVos.add(dumpVo);
            }
        }
        if (HussarUtils.isNotEmpty(roles)) {
            for (SysRoles role : roles) {
                dumpVo = new RoleMigrationDumpVo();
                dumpVo.setId(role.getId());
                dumpVo.setParentId(role.getGroupId());
                dumpVo.setType(2);
                dumpVo.setLabel(role.getRoleName());
                dumpVo.setAlias(role.getRoleAlias());
                dumpVo.setIcon("tree-role");
                for (RoleMigrationDumpDto dumpDto : dtoList) {
                    if (!HussarUtils.equals((Object)dumpDto.getRoleId(), (Object)role.getId())) continue;
                    dumpVo.setHasFuncRelation(HussarUtils.isNotEmpty((Object)dumpDto.getFuncIds()));
                    dumpVo.setHasResRelation(HussarUtils.isNotEmpty((Object)dumpDto.getResIds()));
                    dumpVo.setHasDataRightRelation(HussarUtils.isNotEmpty((Object)dumpDto.getDataRightIds()));
                    break;
                }
                roleMigrationDumpVos.add(dumpVo);
            }
        }
        return roleMigrationDumpVos;
    }

    public MigrationPreloadItemVo<Object> preload(MigrationPreloadContext context) {
        ArrayList<SysRoles> roles = new ArrayList();
        ArrayList<SysRoleGroup> roleGroups = new ArrayList();
        ArrayList<SysRoleFunctions> roleFunctions = new ArrayList();
        ArrayList<SysRoleResource> roleResources = new ArrayList();
        List<Object> roleDataRights = new ArrayList<SysRoleDataRight>();
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("role")))) {
            roles = (List)context.getPayloadAsJson("roleFile.json", (TypeReference)new TypeReference<List<SysRoles>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleGroup")))) {
            roleGroups = (List)context.getPayloadAsJson("roleGroupFile.json", (TypeReference)new TypeReference<List<SysRoleGroup>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleFunction")))) {
            roleFunctions = (List)context.getPayloadAsJson("roleFunctionFile.json", (TypeReference)new TypeReference<List<SysRoleFunctions>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleResource")))) {
            roleResources = (List)context.getPayloadAsJson("roleResourceFile.json", (TypeReference)new TypeReference<List<SysRoleResource>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleDataRight")))) {
            roleDataRights = (List)context.getPayloadAsJson("roleDataRightFile.json", (TypeReference)new TypeReference<List<SysRoleDataRight>>(){});
        }
        List<RoleMigrationLoadVo> roleMigrationLoadVos = this.getRoleLoadVoList(roles, roleGroups, roleFunctions, roleResources, roleDataRights);
        List roleLoadTree = HussarTreeParser.getTreeList(roleMigrationLoadVos);
        return MigrationPreloadItemVo.success((Object)roleLoadTree);
    }

    @HussarTransactional
    @CacheEvict(value={"resource_info"}, allEntries=true)
    public MigrationLoadItemVo<Object> load(MigrationLoadContext context, Map<String, Object> parameters) {
        ArrayList<SysRoles> roles = new ArrayList();
        ArrayList<SysRoleGroup> roleGroups = new ArrayList();
        ArrayList<SysRoleFunctions> roleFunctions = new ArrayList();
        ArrayList<SysRoleResource> roleResources = new ArrayList();
        ArrayList<SysRoleDataRight> roleDataRights = new ArrayList();
        List roleStruRights = new ArrayList();
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("role")))) {
            roles = (List)context.getPayloadAsJson("roleFile.json", (TypeReference)new TypeReference<List<SysRoles>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleGroup")))) {
            roleGroups = (List)context.getPayloadAsJson("roleGroupFile.json", (TypeReference)new TypeReference<List<SysRoleGroup>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleFunction")))) {
            roleFunctions = (List)context.getPayloadAsJson("roleFunctionFile.json", (TypeReference)new TypeReference<List<SysRoleFunctions>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleResource")))) {
            roleResources = (List)context.getPayloadAsJson("roleResourceFile.json", (TypeReference)new TypeReference<List<SysRoleResource>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleDataRight")))) {
            roleDataRights = (List)context.getPayloadAsJson("roleDataRightFile.json", (TypeReference)new TypeReference<List<SysRoleDataRight>>(){});
        }
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute("roleStruRight")))) {
            roleStruRights = (List)context.getPayloadAsJson("roleStruRightFile.json", (TypeReference)new TypeReference<List<SysRoleStruRights>>(){});
        }
        List<RoleMigrationLoadVo> roleMigrationLoadVos = this.getRoleLoadVoList(roles, roleGroups, roleFunctions, roleResources, roleDataRights);
        List roleLoadTree = HussarTreeParser.getTreeList(roleMigrationLoadVos);
        this.sysRolesService.insertOrUpdateRoleList(roles);
        this.sysRoleGroupService.insertOrUpdateRoleGroupList(roleGroups);
        this.sysRoleFunctionsService.insertOrUpdateRoleFunction(roleFunctions);
        this.sysRoleResourceService.insertOrUpdateRoleResource(roleResources);
        this.sysRoleDataRightService.insertOrUpdateRoleDataRightList(roleDataRights);
        this.sysRoleStruRightService.insertOrUpdateRoleStruRightList(roleStruRights);
        if (HussarUtils.isNotEmpty(roleDataRights)) {
            List<Long> roleIds = roleDataRights.stream().map(SysRoleDataRight::getRoleId).distinct().collect(Collectors.toList());
            this.queryDataRightManager.saveDataRightCacheByRoleIds(roleIds);
        }
        long total = roles.size() + roleGroups.size() + roleFunctions.size() + roleResources.size() + roleDataRights.size() + roleStruRights.size();
        return MigrationLoadItemVo.success((Long)total, (Object)roleLoadTree);
    }

    private List<RoleMigrationLoadVo> getRoleLoadVoList(List<SysRoles> roles, List<SysRoleGroup> roleGroups, List<SysRoleFunctions> roleFunctions, List<SysRoleResource> roleResources, List<SysRoleDataRight> roleDataRights) {
        RoleMigrationLoadVo roleVo;
        ArrayList<RoleMigrationLoadVo> roleMigrationLoadVos = new ArrayList<RoleMigrationLoadVo>();
        RoleMigrationLoadVo root = new RoleMigrationLoadVo();
        root.setId(Constants.ROLE_ROOT_ID);
        root.setType(0);
        root.setLabel("\u89d2\u8272\u6811");
        root.setParentId(Constants.ROOT_NODE_PARENT);
        root.setIcon("tree-com");
        root.setHasChildren(Boolean.valueOf(true));
        roleMigrationLoadVos.add(root);
        if (HussarUtils.isEmpty(roles)) {
            ((RoleMigrationLoadVo)roleMigrationLoadVos.get(0)).setHasChildren(Boolean.valueOf(false));
            return roleMigrationLoadVos;
        }
        Set roleIdsByFunc = roleFunctions.stream().map(SysRoleFunctions::getRoleId).collect(Collectors.toSet());
        Set roleIdsByRes = roleResources.stream().map(SysRoleResource::getId).collect(Collectors.toSet());
        Set roleIdsByDataRight = roleDataRights.stream().map(SysRoleDataRight::getRoleId).collect(Collectors.toSet());
        List<Long> roleIds = roles.stream().map(SysRoles::getId).collect(Collectors.toList());
        List<SysRoles> sysRoles = this.queryRoleManager.getRoleByRoleIds(roleIds);
        List groupIds = roleGroups.stream().map(SysRoleGroup::getId).collect(Collectors.toList());
        List sysRoleGroups = this.sysRoleGroupService.selectRoleGroupByIds(groupIds);
        Map<Long, SysRoles> rolesMap = sysRoles.stream().collect(Collectors.toMap(SysRoles::getId, item -> item));
        Map<Long, SysRoleGroup> roleGroupMap = sysRoleGroups.stream().collect(Collectors.toMap(SysRoleGroup::getId, item -> item));
        for (SysRoleGroup group : roleGroups) {
            roleVo = new RoleMigrationLoadVo();
            roleVo.setId(group.getId());
            roleVo.setParentId(group.getParentId());
            roleVo.setType(1);
            roleVo.setLabel(group.getGroupName());
            roleVo.setAlias(group.getGroupAlias());
            roleVo.setIcon("tree-organ");
            roleVo.setChangeType(1);
            roleVo.setHasChildren(Boolean.valueOf(true));
            if (HussarUtils.isNotEmpty((Object)roleGroupMap.get(group.getId()))) {
                SysRoleGroup sysRoleGroup = roleGroupMap.get(group.getId());
                roleVo.setChangeType(HussarUtils.equals((Object)group.getGroupName(), (Object)sysRoleGroup.getGroupName()) && HussarUtils.equals((Object)group.getGroupAlias(), (Object)sysRoleGroup.getGroupAlias()) ? 0 : 2);
            }
            roleMigrationLoadVos.add(roleVo);
        }
        for (SysRoles role : roles) {
            roleVo = new RoleMigrationLoadVo();
            long roleId = role.getId();
            roleVo.setId(Long.valueOf(roleId));
            roleVo.setParentId(role.getGroupId());
            roleVo.setType(2);
            roleVo.setIcon("tree-role");
            roleVo.setLabel(role.getRoleName());
            roleVo.setAlias(role.getRoleAlias());
            roleVo.setChangeType(1);
            roleVo.setHasChildren(Boolean.valueOf(false));
            roleVo.setHasFuncRelation(roleIdsByFunc.contains(roleId));
            roleVo.setHasResRelation(roleIdsByRes.contains(roleId));
            roleVo.setHasDataRightRelation(roleIdsByDataRight.contains(roleId));
            if (HussarUtils.isNotEmpty((Object)rolesMap.get(roleId))) {
                SysRoles sysRole = rolesMap.get(roleId);
                roleVo.setChangeType(HussarUtils.equals((Object)role.getRoleName(), (Object)sysRole.getRoleName()) && HussarUtils.equals((Object)role.getRoleAlias(), (Object)sysRole.getRoleAlias()) ? 0 : 2);
            }
            roleMigrationLoadVos.add(roleVo);
        }
        return roleMigrationLoadVos;
    }
}

