/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.organ.dto.SearchOrganUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonQueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SearchOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.UserTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryCopyRoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetSecureUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleData;
import com.jxdinfo.hussar.authorization.permit.dto.UserInfolVo;
import com.jxdinfo.hussar.authorization.permit.dto.UserPartialVo;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.ResetSecureUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserTreeVo;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserStaffVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.sysuserip.dao.SysUserIpMapper;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.HussarTreeParser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryUserManagerImpl")
public class QueryUserManagerImpl
extends CommonQueryOrganizationManager
implements QueryUserManager {
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysDicRefService dicRefService;
    @Autowired
    private ISysStruService sysStruService;
    @Resource
    private SysUserIpMapper sysUserIpMapper;
    @Autowired
    protected SysStruUserMapper sysStruUserMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;

    @Override
    public Page<SearchUserVo> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        if (currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        if (HussarUtils.isNotEmpty((Object)depStruId.get()) && !Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
            struFid = struTemp.getStruFid();
        } else if (HussarUtils.isBlank((CharSequence)queryUserDto.getUserName()) || HussarUtils.isBlank((CharSequence)queryUserDto.getUserAccount()) || HussarUtils.isBlank((CharSequence)queryUserDto.getAccountStatus()) || HussarUtils.isBlank((CharSequence)queryUserDto.getAccountProperty())) {
            queryParams.put("containSys", StringUtils.trimToNull((String)queryUserDto.getContainSys()));
        }
        Object[] arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()};
        String accountStatus = queryUserDto.getAccountStatus();
        if (ArrayUtils.contains((Object[])arr, (Object)accountStatus)) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if (HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put("depStruId", depStruId.get());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryUserDto.getUserAccount()));
        queryParams.put("userAccountNew", StringUtils.trimToEmpty((String)queryUserDto.getUserAccountNew()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put("userName", StringUtils.trimToEmpty((String)queryUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchUsers((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public Page<SearchUserVo> searchCopyRoleUsers(PageInfo pageInfo, QueryCopyRoleUserDto queryCopyRoleUserDto) {
        String accountStatus;
        Object[] arr;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryCopyRoleUserDto.getDepStruId());
        if (currentUser.isGradeadmin()) {
            ConditionUtils.isTureOrFalse((boolean)HussarUtils.isEmpty((Object)depStruId.get())).trueOrFalseHandle(() -> depStruId.set(currentUser.getDeptId()), () -> {
                SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)queryCopyRoleUserDto.getDepStruId()));
                SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
                if (currentNodeStru.getStruLevel() <= sysStru.getStruLevel()) {
                    depStruId.set(currentUser.getDeptId());
                }
            });
        }
        if (HussarUtils.isNotEmpty((Object)depStruId.get()) && !Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
            struFid = struTemp.getStruFid();
        }
        if (ArrayUtils.contains((Object[])(arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()}), (Object)(accountStatus = queryCopyRoleUserDto.getAccountStatus()))) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            queryCopyRoleUserDto.setLockUserIds(lockUserIds);
            if (CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                Iterator iterator = keyList.iterator();
                while (iterator.hasNext()) {
                    String cacheKey;
                    tmpKey = cacheKey = (String)iterator.next();
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if (UserStatus.LOCKED.getCode().equals(accountStatus) && HussarUtils.isNotEmpty(lockUserIds)) {
                queryParams.put("lockUserIds", lockUserIds);
            }
        }
        queryParams.put("sourceUserId", queryCopyRoleUserDto.getSourceUserId());
        queryParams.put("depStruId", depStruId.get());
        queryParams.put("userAccount", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getAccountStatus()));
        queryParams.put("userName", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryCopyRoleUserDto.getAccountProperty()));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<SearchUserVo> userInfoList = this.sysUsersMapper.searchCopyRoleUsers((Page<SearchUserVo>)page, queryParams);
        this.wrapUsers(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public List<SysUsers> selectUsersByStruIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        return this.sysUsersMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getEmployeeId, struIds));
    }

    @Override
    public List<SysUsers> selectUsersByIds(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.sysUsersMapper.selectList((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysUsers::getId, ids));
    }

    @Override
    public Page<ResetSecureUserVo> searchResetSecureUsers(PageInfo pageInfo, ResetSecureUserDto resetSecureUserDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        String struFid = "/";
        Long depStruId = null;
        if (currentUser.isGradeadmin()) {
            depStruId = currentUser.getDeptId();
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById(depStruId);
            AssertUtil.isNotNull((Object)struTemp, (String)"\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u7ed3\u6784");
            struFid = struTemp.getStruFid();
        } else {
            queryParams.put("containSys", "1");
        }
        String userAccount = StringUtils.trimToEmpty((String)resetSecureUserDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)resetSecureUserDto.getUserName());
        String mail = StringUtils.trimToEmpty((String)resetSecureUserDto.getMail());
        String mobile = StringUtils.trimToEmpty((String)resetSecureUserDto.getMobile());
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)userAccount));
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)userName));
        queryParams.put("mail", SqlQueryUtil.transferSpecialChar((String)mail));
        queryParams.put("mobile", SqlQueryUtil.transferSpecialChar((String)mobile));
        queryParams.put("struFid", StringUtils.trimToNull((String)struFid));
        List<ResetSecureUserVo> userInfoList = this.sysUsersMapper.searchResetSecureUserVo((Page<ResetSecureUserVo>)page, queryParams);
        page.setRecords(userInfoList);
        return page;
    }

    @Override
    public List<UserTreeVo> lazyLoadingUserTree(Long parentId) {
        ArrayList<UserTreeVo> result = new ArrayList<UserTreeVo>();
        List<UserTreeVo> data = this.getUserTree(parentId);
        this.fillUserPermissions(data);
        result.addAll(data);
        return HussarTreeParser.getTreeList(result);
    }

    @Override
    public List<UserTreeVo> getOrderUserTree(Long parentId) {
        HashMap<String, Long> queryParams = new HashMap<String, Long>();
        queryParams.put("parentId", parentId);
        ArrayList<UserTreeVo> result = new ArrayList<UserTreeVo>();
        List<UserTreeVo> data = this.sysUsersMapper.getUserByDepartment(parentId);
        UserTreeVo root = new UserTreeVo();
        OrganizationTreeVo organizationTreeVo = this.queryOrganizationManager.lazyOrganizationById(parentId);
        root.setStruType(organizationTreeVo.getStruType());
        root.setId(organizationTreeVo.getId());
        root.setHasChildren(organizationTreeVo.getHasChildren());
        root.setIcon(organizationTreeVo.getIcon());
        root.setLabel(organizationTreeVo.getLabel());
        root.setDisabled(Boolean.valueOf(true));
        root.setChildren(data);
        result.add(root);
        return result;
    }

    @Override
    public List<UserTreeVo> backUserTree(Long id) {
        List<OrganizationTreeVo> organizations = this.queryOrganizationManager.backOrganizationTree(id);
        return this.convert(organizations);
    }

    private List<UserTreeVo> convert(List<OrganizationTreeVo> children) {
        ArrayList<UserTreeVo> list = new ArrayList<UserTreeVo>();
        if (HussarUtils.isNotEmpty(children)) {
            List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
            for (OrganizationTreeVo vo : children) {
                UserTreeVo temp = new UserTreeVo();
                temp.setDisabled(vo.getDisabled());
                temp.setStruType(vo.getStruType());
                if (HussarUtils.isNotEmpty((Object)vo.getChildren())) {
                    temp.setChildren(this.convert(vo.getChildren()));
                }
                temp.setId(vo.getId());
                temp.setHasChildren(vo.getHasChildren());
                temp.setIcon(vo.getIcon());
                temp.setLabel(vo.getLabel());
                temp.setParentId(vo.getParentId());
                this.fillSingleUserPermissions(temp, staffRuleList);
                list.add(temp);
            }
        }
        return list;
    }

    @Override
    public UserPartialVo viewUser(Long id) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        UserPartialVo vo = new UserPartialVo();
        vo.setId(user.getId());
        vo.setTotpKey(user.getTotpKey());
        vo.setUserAccount(user.getUserAccount());
        if (HussarUtils.isNotEmpty((Object)user.getEmployeeId())) {
            SysStru stru = (SysStru)this.sysStruMapper.selectById(user.getEmployeeId());
            vo.setStaffName(stru.getOrganAlias());
        }
        vo.setMaxSessions(user.getMaxSessions());
        vo.setMail(user.geteMail());
        vo.setWeChat(user.getWeChat());
        vo.setMobile(user.getMobile());
        vo.setTelephone(user.getTelephone());
        if (user.getAccountStatus().equals(UserStatus.CANCEL.getCode())) {
            vo.setAccountStatusName(UserStatus.CANCEL.getMessage());
        } else {
            String accountStatusName = this.dicRefService.getDictLabel("account_state", user.getAccountStatus());
            vo.setAccountStatusName(accountStatusName);
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            String cacheKey = null;
            for (String s : keyList) {
                cacheKey = s;
                UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
                if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
                vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
            }
        }
        String accountPropertyName = this.dicRefService.getDictLabel("account_property", user.getTypeProperty());
        vo.setAccountPropertyName(accountPropertyName);
        vo.setLoginIpLimit(user.getLoginIpLimit().equals("1"));
        if (vo.isLoginIpLimit()) {
            List sysUserIps = this.sysUserIpMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)id)).stream().map(item -> item.getUserIp()).collect(Collectors.toList());
            String allowedIps = String.join((CharSequence)",", sysUserIps);
            vo.setAllowedIps(allowedIps);
        }
        vo.setLoginTimeLimit(user.getLoginTimeLimit().equals("1"));
        if (vo.isLoginTimeLimit()) {
            vo.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginStartTime()));
            vo.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginEndTime()));
        }
        vo.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getStartTime()));
        vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getExpiredTime()));
        List<RoleData> data = null;
        data = this.getCommonUserRoleData(id, isGradeAdmin);
        vo.setRoles(data);
        boolean flag = false;
        if (HussarUtils.isNotEmpty(data)) {
            flag = data.stream().map(item -> item.getId()).collect(Collectors.toList()).contains(SysUserAndRole.GRADEADMIN_ROLE.getValue());
        }
        vo.setGradeAdmin(flag);
        return vo;
    }

    private List<RoleData> getCommonUserRoleData(Long id, boolean gradeAdmin) {
        return this.sysUserRoleMapper.getCommonUserRoleData(id, gradeAdmin);
    }

    @Override
    public UserInfolVo loadUser(Long id) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = currentUser.isGradeadmin();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(id);
        AssertUtil.isNotNull((Object)user, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        UserInfolVo vo = new UserInfolVo();
        vo.setId(user.getId());
        vo.setUserAccount(user.getUserAccount());
        vo.setEmployeeId(user.getEmployeeId());
        if (HussarUtils.isNotEmpty((Object)user.getEmployeeId())) {
            SysStru stru = (SysStru)this.sysStruMapper.selectById(user.getEmployeeId());
            vo.setStaffName(stru.getOrganAlias());
            vo.setParentId(stru.getParentId());
        }
        vo.setMaxSessions(user.getMaxSessions());
        vo.setTotpKey(user.getTotpKey());
        vo.setMail(user.geteMail());
        vo.setWeChat(user.getWeChat());
        vo.setMobile(user.getMobile());
        vo.setTelephone(user.getTelephone());
        vo.setAccountProperty(user.getTypeProperty());
        vo.setAccountStatus(user.getAccountStatus());
        String accountStatusName = this.dicRefService.getDictLabel("account_state", user.getAccountStatus());
        vo.setAccountStatusName(accountStatusName);
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        String cacheKey = null;
        for (String s : keyList) {
            cacheKey = s;
            UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
            if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
            vo.setAccountStatusName(UserStatus.LOCKED.getMessage());
        }
        String accountPropertyName = this.dicRefService.getDictLabel("account_property", user.getTypeProperty());
        vo.setAccountPropertyName(accountPropertyName);
        vo.setLoginIpLimit(user.getLoginIpLimit().equals("1"));
        if (vo.isLoginIpLimit()) {
            List sysUserIps = this.sysUserIpMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)id)).stream().map(item -> item.getUserIp()).collect(Collectors.toList());
            String allowedIps = String.join((CharSequence)",", sysUserIps);
            vo.setAllowedIps(allowedIps);
        }
        vo.setLoginTimeLimit(user.getLoginTimeLimit().equals("1"));
        if (vo.isLoginTimeLimit()) {
            vo.setAccessLoginStartTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginStartTime()));
            vo.setAccessLoginEndTime(Java8DateUtils.convertLocalTimeToString((LocalTime)user.getAccessLoginEndTime()));
        }
        vo.setStartTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getStartTime()));
        vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)user.getExpiredTime()));
        List<RoleData> data = null;
        data = this.getCommonUserRoleData(id, isGradeAdmin);
        vo.setRoles(data);
        boolean flag = false;
        if (HussarUtils.isNotEmpty(data)) {
            flag = data.stream().map(item -> item.getId()).collect(Collectors.toList()).contains(SysUserAndRole.GRADEADMIN_ROLE.getValue());
        }
        vo.setGradeAdmin(flag);
        return vo;
    }

    public List<UserTreeVo> convertUser(List<OrganizationTreeVo> organizations) {
        ArrayList<UserTreeVo> list = new ArrayList<UserTreeVo>();
        UserTreeVo temp = null;
        List<SysStruRule> staffRuleList = this.searchWithStaffRuleList();
        for (OrganizationTreeVo vo : organizations) {
            temp = new UserTreeVo();
            temp.setDisabled(vo.getDisabled());
            temp.setStruType(vo.getStruType());
            List children = vo.getChildren();
            temp.setChildren(this.convertUser(children));
            temp.setId(vo.getId());
            temp.setHasChildren(vo.getHasChildren());
            temp.setIcon(vo.getIcon());
            temp.setLabel(vo.getLabel());
            temp.setParentId(vo.getParentId());
            this.fillSingleUserPermissions(temp, staffRuleList);
            list.add(temp);
        }
        return list;
    }

    private List<UserTreeVo> getUserTree(Long parentId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", parentId);
        return this.sysUsersMapper.searchUserTree(queryParams);
    }

    private void wrapUsers(List<SearchUserVo> userInfoList) {
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType("account_state");
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType("account_property");
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        boolean flag = HussarUtils.isNotEmpty((Object)keyList);
        if (HussarUtils.isNotEmpty(userInfoList)) {
            for (SearchUserVo vo : userInfoList) {
                vo.setAccoutStatusName(mapStatus.get(vo.getAccountStatus()));
                vo.setAccountPropertyName(mapProperty.get(vo.getAccountProperty()));
                if (!flag) continue;
                Optional<String> optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                    String tmpkey = (String)optional.get();
                    UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                    if (null != model && model.getLockTime() != null) {
                        vo.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                });
            }
        }
    }

    @Override
    public List<UserVo> getUsersByOrganUser(List<Long> organIds, List<Long> userIds) {
        List<Object> result = new ArrayList<UserVo>();
        if (HussarUtils.isEmpty(organIds) && HussarUtils.isEmpty(userIds)) {
            return result;
        }
        if (HussarUtils.isNotEmpty(userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            List<UserVo> userList = this.sysUsersMapper.getUserByIds(userIds);
            result.addAll(userList);
        }
        if (HussarUtils.isNotEmpty(organIds)) {
            List list = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, organIds));
            List seqList = list.stream().map(SysStru::getStruSeq).distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            for (String seq : seqList) {
                ((LambdaQueryWrapper)wrapper.or()).likeRight(SysStru::getStruSeq, (Object)seq);
            }
            List sysStrus = this.sysStruService.list((Wrapper)wrapper);
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).distinct().collect(Collectors.toList());
            List<UserVo> userVoList = this.sysUsersMapper.getUserByOrganIds(struIdList);
            result.addAll(userVoList);
        }
        result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<UserVo>(Comparator.comparing(UserVo::getId))), ArrayList::new));
        return result;
    }

    @Override
    public List<OrganUserTreeVo> lazyOrganUserTree(List<Long> parentOrganIds, Boolean needParentOrganInfo, Integer resultType) {
        ArrayList<OrganUserTreeVo> organUserTreeVos = new ArrayList<OrganUserTreeVo>();
        if (HussarUtils.isEmpty(parentOrganIds)) {
            return organUserTreeVos;
        }
        List<Long> organIds = this.getParentOrganIds(parentOrganIds);
        for (Long organId : organIds) {
            if (organId.equals(Constants.ROOT_NODE_ID)) {
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "0", "\u516c\u53f8\u5185\u90e8\u7ec4\u7ec7");
                continue;
            }
            if (organId.equals(Constants.OUT_STRU_NODE_ID)) {
                this.getInAndOutTree(needParentOrganInfo, organUserTreeVos, organId, resultType, "1", "\u516c\u53f8\u5916\u90e8\u7ec4\u7ec7");
                continue;
            }
            this.getOrganUserTree(needParentOrganInfo, organUserTreeVos, organId, resultType);
        }
        return HussarTreeParser.getTreeList(organUserTreeVos);
    }

    @Override
    public Page<SearchUserTreeVo> searchUser(PageInfo pageInfo, SearchOrganUserDto searchOrganUserDto) {
        List<Long> struIdList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        page.setOptimizeCountSql(false);
        HashMap<String, Object> queryUserParams = new HashMap<String, Object>();
        String resultType = searchOrganUserDto.getResultType();
        List organIds = searchOrganUserDto.getOrganIds();
        List userIds = searchOrganUserDto.getUserIds();
        if ("0".equals(resultType)) {
            queryUserParams.put("struIds", organIds);
        } else if ("1".equals(resultType)) {
            struIdList = this.getSubOrganByIds(organIds);
            queryUserParams.put("struIds", struIdList);
        } else if ("2".equals(resultType)) {
            queryUserParams.put("struIds", null);
            queryUserParams.put("userIds", null);
        } else if ("3".equals(resultType)) {
            struIdList = this.getSubOrganByIds(organIds);
            queryUserParams.put("struIds", struIdList);
            queryUserParams.put("userIds", userIds);
        }
        queryUserParams.put("name", SqlQueryUtil.transferSpecialChar((String)searchOrganUserDto.getName()));
        queryUserParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        List<SearchUserTreeVo> searchOrganVos = this.sysUsersMapper.searchUserTreeVo((Page<SearchUserTreeVo>)page, queryUserParams);
        page.setRecords(searchOrganVos);
        return page;
    }

    @Override
    public UserStaffVo getUserAndStaffInfo(Long userId) {
        return this.sysUsersMapper.getUserAndStaffInfo(userId);
    }

    private List<Long> getParentOrganIds(List<Long> struIds) {
        if (!struIds.contains(Constants.ROOT_NODE_ID) && !struIds.contains(Constants.OUT_STRU_NODE_ID)) {
            List sysStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            Map<Long, String> fidMap = sysStrus.stream().collect(Collectors.toMap(SysStru::getId, SysStru::getStruFid));
            ArrayList<Long> removeIds = new ArrayList<Long>();
            block0: for (Long struId : struIds) {
                int num = 0;
                String fidParent = fidMap.get(struId);
                for (Long id : struIds) {
                    String fid = fidMap.get(id);
                    if (fidParent.contains(fid)) {
                        ++num;
                    }
                    if (num <= 1) continue;
                    removeIds.add(struId);
                    continue block0;
                }
            }
            struIds.removeAll(removeIds);
            return new ArrayList<Long>(struIds);
        }
        if (struIds.contains(Constants.ROOT_NODE_ID) && struIds.contains(Constants.OUT_STRU_NODE_ID)) {
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(Constants.ROOT_NODE_ID);
            result.add(Constants.OUT_STRU_NODE_ID);
            return result;
        }
        Long rootId = struIds.contains(Constants.ROOT_NODE_ID) ? Constants.ROOT_NODE_ID : Constants.OUT_STRU_NODE_ID;
        List sysStrus = this.sysStruService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getId, struIds));
        if (HussarUtils.isNotEmpty((Object)sysStrus)) {
            List<Long> struIdList = sysStrus.stream().map(SysStru::getId).collect(Collectors.toList());
            List parentStrus = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)rootId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            List parentFIdList = parentStrus.stream().map(SysStru::getStruFid).collect(Collectors.toList());
            if (HussarUtils.isEmpty((Object)parentStrus)) {
                List<Long> parentOrganIds = this.getParentOrganIds(struIdList);
                ArrayList<Long> result = new ArrayList<Long>();
                result.add(rootId);
                result.addAll(parentOrganIds);
                return result;
            }
            ArrayList<SysStru> strus = new ArrayList<SysStru>();
            for (SysStru stru : sysStrus) {
                String parentFId;
                String struFid = stru.getStruFid();
                int num = 0;
                Iterator iterator = parentFIdList.iterator();
                while (iterator.hasNext() && !struFid.contains(parentFId = (String)iterator.next())) {
                    ++num;
                }
                if (num != parentFIdList.size()) continue;
                strus.add(stru);
            }
            if (HussarUtils.isEmpty(strus)) {
                ArrayList result = new ArrayList();
                result.add(rootId);
                return result;
            }
            List<Long> parentIds = strus.stream().map(SysStru::getId).collect(Collectors.toList());
            List<Long> parentOrganIds = this.getParentOrganIds(parentIds);
            ArrayList<Long> result = new ArrayList<Long>();
            result.add(rootId);
            result.addAll(parentOrganIds);
            return result;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        result.add(rootId);
        return result;
    }

    private void getInAndOutTree(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType, String organProperty, String organName) {
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(0) || resultType.equals(2)) {
            List<OrganUserTreeVo> internalOrgans = this.getOneOrganInfo(organId, resultType, organProperty);
            flag = internalOrgans.size() > 0;
            organUserTreeVos.addAll(internalOrgans);
        }
        if (needParentOrganInfo.booleanValue()) {
            OrganUserTreeVo internalOrganStaffTreeVo = this.initRootTree(organName, String.valueOf(organId));
            internalOrganStaffTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVos.add(internalOrganStaffTreeVo);
        }
    }

    private void getOrganUserTree(Boolean needParentOrganInfo, List<OrganUserTreeVo> organUserTreeVos, Long organId, Integer resultType) {
        List<OrganUserTreeVo> organs;
        if (HussarUtils.isEmpty((Object)resultType)) {
            return;
        }
        boolean flag = false;
        if (resultType.equals(0)) {
            organs = this.getOneOrganInfo(organId, resultType, null);
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (resultType.equals(1)) {
            ArrayList<String> struIds = new ArrayList<String>();
            struIds.add(String.valueOf(organId));
            List<OrganUserTreeVo> userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                flag = true;
                organUserTreeVos.addAll(userTreeVos);
            }
        }
        if (resultType.equals(2)) {
            organs = this.getOneOrganInfo(organId, resultType, null);
            ArrayList<String> struIds = new ArrayList<String>();
            struIds.add(String.valueOf(organId));
            List<OrganUserTreeVo> userTreeVos = this.sysStruUserMapper.getOrganUserTreeOnlyUser(LambdaQueryUtil.getSplitList(struIds));
            if (HussarUtils.isNotEmpty(userTreeVos)) {
                organs.addAll(userTreeVos);
            }
            flag = organs.size() > 0;
            organUserTreeVos.addAll(organs);
        }
        if (needParentOrganInfo.booleanValue()) {
            SearchOrganVo organVo = this.sysStruMapper.getOrganById(organId);
            if (HussarUtils.isEmpty((Object)organVo)) {
                return;
            }
            OrganUserTreeVo organUserTreeVo = this.initRootTree(organVo.getLabel(), String.valueOf(organId));
            ArrayList<Long> struIds = new ArrayList<Long>();
            struIds.add(organId);
            Map<Long, Integer> organIdUserCount = this.getUserCountByOrganId(struIds);
            organUserTreeVo.setUserCount(organIdUserCount.get(organId));
            organUserTreeVo.setHasChildren(Boolean.valueOf(flag));
            organUserTreeVo.setIcon(organVo.getIcon());
            organUserTreeVos.add(organUserTreeVo);
        }
    }

    private List<OrganUserTreeVo> getOneOrganInfo(Long organId, Integer resultType, String organProperty) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("parentId", String.valueOf(organId));
        queryParams.put("organProperty", organProperty);
        List<OrganUserTreeVo> organs = this.sysStruMapper.getOrganUserTreeOnlyOrgan(queryParams);
        if (HussarUtils.isEmpty(organs)) {
            return organs;
        }
        List<Long> oneOrganIds = organs.stream().map(s -> Long.parseLong(s.getId())).distinct().collect(Collectors.toList());
        Map<Long, Integer> organIdUserCount = this.getUserCountByOrganId(oneOrganIds);
        for (OrganUserTreeVo treeVo : organs) {
            int count = organIdUserCount.get(Long.valueOf(treeVo.getId()));
            treeVo.setUserCount(Integer.valueOf(count));
            if (resultType.equals(1)) {
                treeVo.setHasChildren(Boolean.valueOf(count > 0));
                continue;
            }
            if (!resultType.equals(2)) continue;
            treeVo.setHasChildren(Boolean.valueOf(treeVo.getHasChildren() != false || count > 0));
        }
        return organs;
    }

    private OrganUserTreeVo initRootTree(String organName, String parentId) {
        OrganUserTreeVo internalOrganUserTreeVo = new OrganUserTreeVo();
        internalOrganUserTreeVo.setLabel(organName);
        internalOrganUserTreeVo.setId(parentId);
        internalOrganUserTreeVo.setTypes("organ");
        return internalOrganUserTreeVo;
    }
}

