/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataRightMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleStruRightsMapper;
import com.jxdinfo.hussar.authorization.permit.manager.QueryDataRightManager;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataRight;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleStruRights;
import com.jxdinfo.hussar.authorization.permit.vo.DataRightCacheVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.permit.manager.impl.queryDataRightMagagerImpl")
public class QueryDataRightMagagerImpl
implements QueryDataRightManager {
    @Autowired
    private SysRoleDataRightMapper roleDataRightMapper;
    @Autowired
    private SysRoleStruRightsMapper roleStruRightsMapper;

    @Override
    public List<Long> getAbandonDataRight(List<Long> functionIdList, Long roleId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleDataRight::getRoleId, (Object)roleId);
        if (HussarUtils.isNotEmpty(functionIdList)) {
            queryWrapper.notIn(SysRoleDataRight::getFunctionId, functionIdList);
        }
        List sysRoleDataRightList = this.roleDataRightMapper.selectList((Wrapper)queryWrapper);
        return sysRoleDataRightList.stream().map(SysRoleDataRight::getDataRightsId).collect(Collectors.toList());
    }

    @Override
    public void replaceDataRightCache(Long roleId) {
        List<Long> deptIdList;
        List<DataRightCacheVo> dataRightCacheVoList = this.roleDataRightMapper.getDataRightRes(roleId);
        if (HussarUtils.isEmpty(dataRightCacheVoList)) {
            HussarCacheUtil.evict((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
            return;
        }
        List dataRightIdList = dataRightCacheVoList.stream().map(DataRightCacheVo::getDataRightId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleStruRights::getRoleDataRightsId, dataRightIdList);
        List costumDeptList = this.roleStruRightsMapper.selectList((Wrapper)queryWrapper);
        HashMap<Long, ArrayList<Long>> dataRightsDeptMap = new HashMap<Long, ArrayList<Long>>();
        for (SysRoleStruRights sysRoleStruRights : costumDeptList) {
            deptIdList = (ArrayList<Long>)dataRightsDeptMap.get(sysRoleStruRights.getRoleDataRightsId());
            if (ToolUtil.isNotEmpty((Object)deptIdList)) {
                deptIdList.add(sysRoleStruRights.getStruid());
                continue;
            }
            deptIdList = new ArrayList<Long>();
            deptIdList.add(sysRoleStruRights.getStruid());
            dataRightsDeptMap.put(sysRoleStruRights.getRoleDataRightsId(), (ArrayList<Long>)deptIdList);
        }
        for (DataRightCacheVo dataRightCacheVo : dataRightCacheVoList) {
            deptIdList = (List)dataRightsDeptMap.get(dataRightCacheVo.getDataRightId());
            if (!ToolUtil.isNotEmpty(deptIdList)) continue;
            dataRightCacheVo.setDeptId(deptIdList);
        }
        HussarCacheUtil.put((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId), dataRightCacheVoList);
    }

    @Override
    public void saveDataRightCacheByRoleIds(List<Long> roleIds) {
        List<Long> deptIdList;
        List<DataRightCacheVo> dataRightCacheVoList;
        if (HussarUtils.isEmpty(roleIds)) {
            dataRightCacheVoList = this.roleDataRightMapper.getAllDataRicht();
            if (HussarUtils.isEmpty(dataRightCacheVoList)) {
                return;
            }
        } else {
            dataRightCacheVoList = this.roleDataRightMapper.getDataRightResByRoleIdList(roleIds);
            if (HussarUtils.isEmpty(dataRightCacheVoList)) {
                for (Long roleId : roleIds) {
                    HussarCacheUtil.evict((String)"data_scope_type", (Object)("'data_scope_type:'" + roleId));
                }
                return;
            }
            List cacheRoleIds = dataRightCacheVoList.stream().map(DataRightCacheVo::getRoleId).distinct().collect(Collectors.toList());
            for (Long id : roleIds) {
                if (cacheRoleIds.contains(id)) continue;
                HussarCacheUtil.evict((String)"data_scope_type", (Object)("'data_scope_type:'" + id));
            }
        }
        HashMap<Long, ArrayList<DataRightCacheVo>> roleDataRightMap = new HashMap<Long, ArrayList<DataRightCacheVo>>();
        List dataRightIdList = dataRightCacheVoList.stream().map(DataRightCacheVo::getDataRightId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRoleStruRights::getRoleDataRightsId, dataRightIdList);
        List costumDeptList = this.roleStruRightsMapper.selectList((Wrapper)queryWrapper);
        HashMap<Long, ArrayList<Long>> dataRightsDeptMap = new HashMap<Long, ArrayList<Long>>();
        for (SysRoleStruRights sysRoleStruRights : costumDeptList) {
            deptIdList = (ArrayList<Long>)dataRightsDeptMap.get(sysRoleStruRights.getRoleDataRightsId());
            if (ToolUtil.isNotEmpty((Object)deptIdList)) {
                deptIdList.add(sysRoleStruRights.getStruid());
                continue;
            }
            deptIdList = new ArrayList<Long>();
            deptIdList.add(sysRoleStruRights.getStruid());
            dataRightsDeptMap.put(sysRoleStruRights.getRoleDataRightsId(), (ArrayList<Long>)deptIdList);
        }
        for (DataRightCacheVo dataRightCacheVo : dataRightCacheVoList) {
            ArrayList<DataRightCacheVo> resultList;
            deptIdList = (List)dataRightsDeptMap.get(dataRightCacheVo.getDataRightId());
            if (ToolUtil.isNotEmpty(deptIdList)) {
                dataRightCacheVo.setDeptId(deptIdList);
            }
            if (ToolUtil.isNotEmpty((Object)(resultList = (ArrayList<DataRightCacheVo>)roleDataRightMap.get(dataRightCacheVo.getRoleId())))) {
                resultList.add(dataRightCacheVo);
                continue;
            }
            resultList = new ArrayList<DataRightCacheVo>();
            resultList.add(dataRightCacheVo);
            roleDataRightMap.put(dataRightCacheVo.getRoleId(), resultList);
        }
        Set keySey = roleDataRightMap.keySet();
        for (Long roleid : keySey) {
            HussarCacheUtil.put((String)"data_scope_type", (Object)("'data_scope_type:'" + roleid), roleDataRightMap.get(roleid));
        }
    }

    @Override
    @HussarDs(value="#connName")
    public void saveDataRightCacheByRoleIds(String connName, List<Long> roleIds) {
        this.saveDataRightCacheByRoleIds(roleIds);
    }
}

