/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysOrganServiceImpl
extends HussarBaseServiceImpl<SysOrganMapper, SysOrgan>
implements ISysOrganService {
    @Resource
    SysOrganMapper sysOrganMapper;
    @Resource
    private ISysIdtableService sysIdtableService;

    public String getOrganCode(SysOrgan sysOrgan) {
        boolean flag = "9".equals(sysOrgan.getOrganType());
        String fieldName = flag ? "STAFF_CODE" : "ORGAN_CODE_4";
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (flag) {
            lambdaQueryWrapper.eq(SysOrgan::getOrganType, (Object)"9");
        } else {
            lambdaQueryWrapper.ne(SysOrgan::getOrganType, (Object)"9");
        }
        long currentCount = 1L;
        String code = StringUtils.trimToEmpty((String)sysOrgan.getOrganCode());
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                code = this.sysIdtableService.getCurrentCode(fieldName, "SYS_ORGAN");
                lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)code);
                currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)code);
            currentCount = this.sysOrganMapper.selectCount((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                if (flag) {
                    throw new BaseException("\u4eba\u5458\u7f16\u7801\u91cd\u590d\uff01");
                }
                throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d\uff01");
            }
        }
        return code;
    }

    public List<SysOrgan> getOrgansByOrganIds(List<Long> organIds) {
        if (HussarUtils.isEmpty(organIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        for (Long id : organIds) {
            ((LambdaQueryWrapper)lambdaQueryWrapper.or()).eq(SysOrgan::getId, (Object)id);
        }
        return this.list((Wrapper)lambdaQueryWrapper);
    }

    public Map<String, Integer> saveOrUpdateOrganList(List<SysOrgan> organs) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List organIds = organs.stream().map(SysOrgan::getId).collect(Collectors.toList());
        List existedOrgans = new ArrayList();
        if (ToolUtil.isNotEmpty(organIds)) {
            existedOrgans = this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysOrgan::getId, organIds));
        }
        ArrayList<SysOrgan> repeatOrgans = new ArrayList<SysOrgan>();
        ArrayList<SysOrgan> newOrgans = new ArrayList<SysOrgan>();
        if (HussarUtils.isNotEmpty(existedOrgans)) {
            List repeatIds = existedOrgans.stream().map(SysOrgan::getId).collect(Collectors.toList());
            for (SysOrgan organ : organs) {
                if (repeatIds.contains(organ.getId())) {
                    repeatOrgans.add(organ);
                    continue;
                }
                newOrgans.add(organ);
            }
            map.put("insert", newOrgans.size());
            map.put("update", repeatOrgans.size());
            this.saveBatch(newOrgans);
            this.updateBatchById(repeatOrgans);
        } else {
            this.saveBatch(organs);
            map.put("insert", organs.size());
            map.put("update", 0);
        }
        return map;
    }

    @HussarDs(value="#connName")
    public void saveBatchForTenant(String connName, Set<SysOrgan> sysOrganCollection) {
        super.saveBatch(sysOrganCollection);
    }
}

