/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.authentication.dto.LoginUserExtendInfoDto;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.impl.SysStruAssistOrganAuditServiceImpl;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryStaffDetailDto;
import com.jxdinfo.hussar.authorization.organ.dto.StaffSaveDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruChangeDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysStaffDto;
import com.jxdinfo.hussar.authorization.organ.enums.OrganTypeEnums;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.QueryStaffManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.IStaffUserService;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.organ.vo.StaffDetailListVo;
import com.jxdinfo.hussar.authorization.organ.vo.StaffSelectTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStaffVO;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.manager.QueryUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.ValidateUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyAuditService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.authorization.post.service.UserPostMainAuditService;
import com.jxdinfo.hussar.authorization.post.service.UserPostMainService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.EntityUtils;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.common.utils.TreeModelUtils;
import com.jxdinfo.hussar.core.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service
public class SysEmployeeServiceImpl
extends HussarServiceImpl<SysStruMapper, SysStru>
implements ISysEmployeeService {
    private Logger logger = LoggerFactory.getLogger(SysEmployeeServiceImpl.class);
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private IGlobalService globalService;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    ISysOrganAuditService iSysOrganAuditService;
    @Resource
    ISysStruAuditService iSysStruAuditService;
    @Resource
    ISysStaffAuditService iSysStaffAuditService;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    SysStruAssistOrganAuditServiceImpl sysStruAssistOrganAuditService;
    @Autowired
    private ISysStruService sysStruService;
    @Resource
    ISysStruRuleService iSysStruRuleService;
    @Resource
    private IStaffUserService staffUserService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private QueryStaffManager queryStaffManager;
    @Resource
    private QueryUserManager queryUserManager;
    @Resource
    private QueryOrganizationManager queryOrganizationManager;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;
    @Resource
    private UserPostMainService userPostMainService;
    @Resource
    private UserPostConcurrentlyAuditService userPostConcurrentlyAuditService;
    @Resource
    private UserPostMainAuditService userPostMainAuditService;
    @Autowired
    private ValidateUserManager validateUserManager;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};

    public List<Long> selectRole(Long userId) {
        return this.sysStruMapper.selectRole(userId);
    }

    public int selectStruLevel(Long empolyeeId) {
        return this.sysStruMapper.selectStruLevel(empolyeeId);
    }

    public List<Long> selectGradeadminRole(Long userId) {
        return this.sysStruMapper.selectGradeadminRole(userId);
    }

    public List<JSTreeModel> getEmployeeTree(String isEmployee) {
        return this.sysStruMapper.getOrgTree(isEmployee);
    }

    public List<JSTreeModel> getEmployeeTreeById(String orgId) {
        boolean flag = this.createUserConfigService.isUserOnOneEmp();
        return TreeModelUtils.merge(this.sysStruMapper.getEmployeeTreeById(Long.parseLong(orgId), flag));
    }

    public List<JSTreeModel> getEmployeeTree(String isEmployee, Long parentId) {
        return this.sysStruMapper.getLazyLoadingOrgTree(isEmployee, parentId);
    }

    public List<JSTreeModel> getEmployeeTreeVue(String isEmployee, Long parentId) {
        return this.sysStruMapper.getLazyLoadingStfTree(isEmployee, parentId);
    }

    @HussarTransactional
    public String addStaff(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String organIds, StaffSaveDto staffSaveDto) {
        Long sysStruId;
        boolean saveAssistOrgan;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            boolean canOperate = this.iSysStruAuditService.checkCanOperate(sysStru.getParentId());
            if (!canOperate) {
                throw new BaseException("\u65b0\u5efa\u4eba\u5458\u6240\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01");
            }
            sysStru.setOrganAlias(sysOrgan.getOrganName());
            sysStru.setIsLeaf("0");
            sysStru.setStruPath("");
            sysStru.setStruLevel(Integer.valueOf(sysStru.getStruLevel() + 1));
            Integer struOrder = 1;
            Integer maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                struOrder = maxOrder + 1;
            }
            sysStru.setStruOrder(struOrder);
            long sysOrganId = IdWorker.getId((Object)sysOrgan);
            sysOrgan.setId(Long.valueOf(sysOrganId));
            sysStru.setOrganId(sysOrgan.getId());
            long sysStruId2 = IdWorker.getId((Object)sysStru);
            sysStru.setId(Long.valueOf(sysStruId2));
            if (ToolUtil.isNotEmpty((Object)sysStaff)) {
                sysStaff.setStruId(sysStru.getId());
                sysStaff.setName(sysOrgan.getOrganName());
                long sysStaffId = IdWorker.getId((Object)sysStaff);
                sysStaff.setId(Long.valueOf(sysStaffId));
            }
            this.auditAdd(sysOrgan, sysStru, sysStaff, "1", staffSaveDto);
            this.sysStruAssistOrganAuditService.saveAssistOrganAudit(organIds, sysStru.getId());
            return "\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        }
        sysStru.setId(null);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruLevel() + 1));
        Integer struOrder = 1;
        Integer maxOrder = this.orgMaintenanceService.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            struOrder = maxOrder + 1;
        }
        sysStru.setStruOrder(struOrder);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setStruId(sysStru.getId());
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffMapper.insert(sysStaff);
        }
        if (!(saveAssistOrgan = this.iSysStruAssistOrganService.saveAssistOrgan(organIds, sysStruId = sysStru.getId()))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        this.userPostMainService.addMainPost(staffSaveDto.getMainList(), sysStru.getId());
        this.userPostConcurrentlyService.addConcurrentlyPost(staffSaveDto.getConcurrentlyList(), sysStru.getId());
        return "\u65b0\u589e\u6210\u529f\uff01";
    }

    @HussarTransactional
    public String editStaffVue(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, String ids, StaffSaveDto staffSaveDto) {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            this.auditAdd(sysOrgan, sysStru, sysStaff, "2", staffSaveDto);
            this.sysStruAssistOrganAuditService.saveAssistOrganAudit(ids, sysStru.getId());
            return "\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        }
        this.sysOrganMapper.updateById(sysOrgan);
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        this.sysStruMapper.updateById(sysStru);
        this.sysUsersService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysUsers::getEmployeeId, (Object)sysStru.getId())).set(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            this.sysStaffService.saveOrUpdate((Object)sysStaff);
        }
        Long sysStruId = sysStru.getId();
        this.iSysStruAssistOrganService.saveAssistOrgan(ids, sysStruId);
        this.userPostMainService.editMainPost(staffSaveDto.getMainList(), sysStru.getId());
        this.userPostConcurrentlyService.editConcurrentlyPost(staffSaveDto.getConcurrentlyList(), sysStru.getId());
        JSONObject object = new JSONObject();
        object.put("sysOrgan", (Object)sysOrgan);
        object.put("sysStru", (Object)sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            object.put("sysStaff", (Object)sysStaff);
        }
        this.abstractPushMsgMatcher.insertOperation("person", "update", (Object)object, Constants.NONE_ID);
        return "\u4fee\u6539\u6210\u529f\uff01";
    }

    private void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, String flag, StaffSaveDto staffSaveDto) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if ("2".equals(flag) || "1".equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setId(null);
        }
        this.iSysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getId());
        if ("2".equals(flag) || "1".equals(flag)) {
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.iSysStruAuditService.save((Object)sysStruAudit);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getId());
            if ("2".equals(flag) || "1".equals(flag)) {
                sysStaffAudit.setRealStaffId(sysStaff.getId());
                sysStaffAudit.setId(null);
            }
            this.iSysStaffAuditService.save((Object)sysStaffAudit);
            this.userPostMainAuditService.addMainPostAudit(staffSaveDto.getMainListAudit(), sysStruAudit.getId());
            this.userPostConcurrentlyAuditService.addConcurrentlyPostAudit(staffSaveDto.getConcurrentlyListAudit(), sysStruAudit.getId());
        }
    }

    public void exportData(List<String> idList, HttpServletResponse response) {
        List strus = this.sysStruMapper.selectBatchIds(idList);
        List staffs = this.sysStaffMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysStaff::getStruId, idList));
        List users = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, idList));
        ArrayList<Long> organIdList = new ArrayList<Long>();
        for (SysStru sysStru : strus) {
            Long organId = sysStru.getOrganId();
            organIdList.add(organId);
        }
        List organs = this.sysOrganMapper.selectBatchIds(organIdList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("export_type", "employee");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error("\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5e8f\u5217\u5316\u51fa\u9519");
        }
        String fileName = "employee_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    public void exportDataVue(List<String> idList, HttpServletResponse response) {
        List<Long> cdids = idList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        List strus = this.sysStruService.getStruByStruIds(cdids);
        List<SysStaff> staffs = this.queryStaffManager.selectStaffByStruIds(cdids);
        List<SysUsers> users = this.queryUserManager.selectUsersByStruIds(cdids);
        List sysStruAssistOrgan = this.iSysStruAssistOrganService.getStruAssistOrganByStruIds(cdids);
        ArrayList<Long> organIdList = new ArrayList<Long>();
        for (SysStru sysStru : strus) {
            Long organId = sysStru.getOrganId();
            organIdList.add(organId);
        }
        if (ToolUtil.isEmpty(organIdList)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u7ec4\u7ec7\u673a\u6784");
        }
        List<SysOrgan> organs = this.queryOrganizationManager.getOrganByIds(organIdList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("sysStruAssistOrgan", sysStruAssistOrgan);
        data.put("export_type", "employee");
        byte[] serializeData = new byte[]{};
        try {
            serializeData = SerializeUtils.serialize(data);
        }
        catch (Exception e) {
            this.logger.error("\u5e8f\u5217\u5316\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5e8f\u5217\u5316\u51fa\u9519");
        }
        String fileName = "employee_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @HussarTransactional
    public Map<String, String> importVueStaff(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            this.logger.error("\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519", (Throwable)e);
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"employee".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "employee");
            return map;
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List staffs = (List)data.get("staffs");
        List users = (List)data.get("users");
        List sysStruAssistOrgan = (List)data.get("sysStruAssistOrgan");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> staffsCount = this.insertOrUpdateList(staffs);
        Map<String, Integer> usersCount = this.insertOrUpdateList(users);
        Map<String, Integer> sysStruAssistOrganCount = this.insertOrUpdateList(sysStruAssistOrgan);
        Long insertUserCount = 0L;
        if (HussarUtils.isNotEmpty((Object)users) && ((HussarTenantProperties)SpringContextHolder.getBean(HussarTenantProperties.class)).isEnabled()) {
            List userIds = EntityUtils.toList((Collection)users, SysUsers::getId);
            insertUserCount = (long)users.size() - this.sysUsersService.count((Wrapper)new LambdaQueryWrapper().in(SysUsers::getId, (Collection)userIds));
            this.validateUserManager.validateBatchLimit(insertUserCount);
        }
        map.put("success", "true");
        map.put("staffInsert", "" + struCount.get("insert"));
        map.put("staffUpdate", "" + struCount.get("update"));
        map.put("staffsInsert", "" + struCount.get("insertStaff"));
        map.put("staffsUpdate", "" + struCount.get("updateStaff"));
        return map;
    }

    public List<JSTreeModel> getEmployeeTree(String isEmployee, Long parentId, String isExport) {
        List list1;
        Long newParentId = parentId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list1 = this.getEmployeeTree(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.getEmployeeTree(isEmployee);
        }
        List list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel jsTreeModel : result) {
                if (jsTreeModel.getIsEmployee() == null) {
                    jsTreeModel.setState(false, false, true);
                    continue;
                }
                jsTreeModel.setState(false, false, false);
            }
        }
        return result;
    }

    public List<JSTreeModel> getEmployeeTreeVue(OrganTreeDto organTreeDto) {
        List list1;
        if (ToolUtil.isEmpty((Object)organTreeDto)) {
            throw new BaseException("\u67e5\u8be2\u804c\u5de5\u6811\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long newParentId = organTreeDto.getParentId();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.selectStruLevel(empolyeeId);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list1 = this.getEmployeeTreeVue(organTreeDto.getIsEmployee(), newParentId);
        } else {
            result.add(root);
            list1 = this.getEmployeeTree(organTreeDto.getIsEmployee());
        }
        List list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        if (organTreeDto.isExport()) {
            for (JSTreeModel jsTreeModel : result) {
                if (jsTreeModel.getIsEmployee() == null) {
                    jsTreeModel.setState(false, false, true);
                    continue;
                }
                jsTreeModel.setState(false, false, false);
            }
        }
        return TreeModelUtils.merge(result);
    }

    public List<JSTreeModel> getEmployeeDepTreeVue(Long struId) {
        List list;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long currentUserId = shiroUser.getUserId();
        Long currentStruId = shiroUser.getEmployeeId();
        Long deptId = shiroUser.getDeptId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u4eba\u5458\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
            Long empolyeeId = shiroUser.getEmployeeId();
            level = this.sysEmployeeService.selectStruLevel(empolyeeId);
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(deptId);
            String userParentFid = sysStru.getStruFid();
            String paramStruFid = "";
            int paramStruLevel = 1;
            if (struId.equals(0L)) {
                paramStruFid = OrganUtil.convert((String)OrganUtil.getStruFidByLevel((String)userParentFid, (int)1));
                result.add(root);
            } else {
                SysStru sysStruT = (SysStru)this.sysStruMapper.selectById(struId);
                paramStruLevel = sysStruT.getStruLevel() + 1;
                paramStruFid = paramStruLevel >= level ? sysStruT.getStruFid() : OrganUtil.convert((String)OrganUtil.getStruFidByLevel((String)userParentFid, (int)paramStruLevel));
            }
            list = this.orgMaintenanceService.getGradeEmployTree(paramStruLevel, paramStruFid);
            for (JSTreeModel jsTreeModel : list) {
                String type;
                Long modelId = jsTreeModel.getId();
                String struLevelStr = jsTreeModel.getStruLevel();
                int struLevelT = 0;
                if (struLevelStr != null) {
                    struLevelT = Integer.parseInt(struLevelStr);
                }
                if (struLevelT == level - 1) {
                    jsTreeModel.getState().put("changeDisabled", true);
                }
                if (struLevelT < level) {
                    if (struLevelT >= level - 1) continue;
                    jsTreeModel.getState().put("gradeDisabled", true);
                    continue;
                }
                if (struLevelT == level) {
                    if (jsTreeModel.getPrime() != null && "0".equals(jsTreeModel.getPrime())) {
                        jsTreeModel.getState().put("isOrganRoleNode", true);
                        continue;
                    }
                    Long parent = jsTreeModel.getParent();
                    if (!deptId.equals(parent)) continue;
                    type = jsTreeModel.getType();
                    if ("ORGANROLE".equals(type)) {
                        jsTreeModel.getState().put("isOrganRoleNode", true);
                        continue;
                    }
                    if ("USER".equals(type)) {
                        if (!modelId.equals(currentUserId)) continue;
                        jsTreeModel.getState().put("currentUser", true);
                        continue;
                    }
                    if (!modelId.equals(currentStruId)) continue;
                    jsTreeModel.getState().put("currentEmployee", true);
                    continue;
                }
                Long id = jsTreeModel.getId();
                type = jsTreeModel.getType();
                if ("ORGANROLE".equals(type)) {
                    id = jsTreeModel.getParent();
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                }
                if (!"USER".equals(type)) continue;
                id = jsTreeModel.getEmployeeId();
            }
        } else {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)struId)) {
                struId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list = this.getEmployeeTreeVue(null, struId);
        }
        result.addAll(list);
        List merge = TreeModelUtils.merge(result);
        return merge;
    }

    public IPage<SysStaffVO> getStaffInfoByParentStruId(Page page, SysStaffDto sysStaffDto) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysStaffDto)) {
            throw new BaseException("\u4eba\u5458dto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysStaffDto.getParentStruId())) {
            throw new BaseException("\u4eba\u5458\u4e0a\u7ea7\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)sysStaffDto.getParentStruId()));
        String struFid = null;
        if (!Objects.equals(Constants.ROOT_NODE_ID, sysStaffDto.getParentStruId())) {
            struFid = currentNodeStru.getStruFid();
        }
        sysStaffDto.setStruFid(OrganUtil.convert((String)struFid));
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (currentUser.isGradeadmin()) {
            Long deptId = BaseSecurityUtil.getUser().getDeptId();
            int gradeDepStruLevel = this.sysStruMapper.selectStruLevel(deptId);
            int searchStruLevel = 0;
            if (!ToolUtil.equals((Object)Constants.ROOT_NODE_ID, (Object)sysStaffDto.getParentStruId())) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(sysStaffDto.getParentStruId());
            }
            if (searchStruLevel < gradeDepStruLevel) {
                struFid = ((SysStru)this.sysStruMapper.selectById(deptId)).getStruFid();
            }
            sysStaffDto.setStruFid(OrganUtil.convert((String)struFid));
        }
        page.setRecords(this.sysStaffMapper.selectStaffPageByStruId(page, sysStaffDto));
        return page;
    }

    public SysOrganVo getEmployeeInfo(Long struId) {
        if (ToolUtil.isEmpty((Object)struId)) {
            throw new BaseException("\u4eba\u5458\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysOrganVo orgInfo = this.orgMaintenanceService.getOrgInfoById(struId);
        SysStaff staff = (SysStaff)this.sysStaffService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStaff::getStruId, (Object)struId));
        if (ToolUtil.isEmpty((Object)staff)) {
            staff = new SysStaff();
        } else if (StringUtils.isNotEmpty((CharSequence)staff.getSex())) {
            staff.setSex(staff.getSex().trim());
        }
        orgInfo.setSysStaff(staff);
        return orgInfo;
    }

    public boolean judgeAddRules(Long struId) {
        if (ToolUtil.isEmpty((Object)struId)) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysStru parent = (SysStru)this.getById(struId);
        Long count = 0L;
        if (ToolUtil.isNotEmpty((Object)parent)) {
            count = this.iSysStruRuleService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruRule::getSysOrganType, (Object)parent.getStruType())).eq(SysStruRule::getOrganType, (Object)"9"));
        }
        return count >= 1L;
    }

    @HussarTransactional
    public ApiResponse deleteEmployee(Long orgId) {
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            return ApiResponse.success((String)this.staffUserService.deleteStaffUserVue(orgId));
        }
        return ApiResponse.success((String)this.orgMaintenanceService.deleteOrgByIdVue(orgId));
    }

    @HussarTransactional
    public ApiResponse saveEmployee(StaffSaveDto staffSaveDto) {
        String addStaff;
        if (ToolUtil.isEmpty((Object)staffSaveDto)) {
            throw new BaseException("\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean isUpper = false;
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && StringUtils.isNotBlank((CharSequence)staffSaveDto.getSysOrgan().getOrganName()) && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)staffSaveDto.getSysOrgan().getOrganName())) {
            isUpper = true;
        }
        SysStru sysStru = staffSaveDto.getSysStru();
        SysOrgan sysOrgan = staffSaveDto.getSysOrgan();
        SysStaff sysStaff = staffSaveDto.getSysStaff();
        String organIds = staffSaveDto.getOrganIds();
        if (ToolUtil.isEmpty((Object)sysStru)) {
            throw new BaseException("\u4eba\u5458\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrgan)) {
            throw new BaseException("\u4eba\u5458\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysStaff)) {
            throw new BaseException("\u5458\u5de5\u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.judgeAddRules(sysStru.getParentId());
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u65b0\u589e\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff09");
        }
        this.getLevelCode(sysStru);
        if (this.createUserConfigService.isOperateStaffWithUser()) {
            if (this.sysUsersService.isExistAccount(isUpper ? sysOrgan.getOrganName().toUpperCase() : sysOrgan.getOrganName())) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
            this.staffUserService.addStaffUser(sysStru, sysOrgan, sysStaff, isUpper);
            Long sysStruId = sysStru.getId();
            boolean saveAssistOrgan = this.iSysStruAssistOrganService.saveAssistOrgan(organIds, sysStruId);
            if (!saveAssistOrgan) {
                throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            this.userPostMainService.addMainPost(staffSaveDto.getMainList(), sysStru.getId());
            this.userPostConcurrentlyService.addConcurrentlyPost(staffSaveDto.getConcurrentlyList(), sysStru.getId());
            addStaff = "\u65b0\u589e\u6210\u529f\uff01";
        } else {
            addStaff = this.addStaff(sysStru, sysOrgan, sysStaff, organIds, staffSaveDto);
        }
        return ApiResponse.success((String)addStaff);
    }

    private void getLevelCode(SysStru sysStru) {
        Long parentId = sysStru.getParentId();
        String maxLevelCode = this.sysStruMapper.getMaxLevelCodeByparentId(parentId);
        SysStru parentSysStru = (SysStru)this.sysStruMapper.selectById(parentId);
        if (maxLevelCode == null) {
            sysStru.setLevelCode(parentSysStru.getLevelCode() + "10001");
        } else {
            String numStr = maxLevelCode.substring(maxLevelCode.length() - 5);
            long num = Long.parseLong(numStr);
            sysStru.setLevelCode(maxLevelCode.substring(0, maxLevelCode.length() - 5) + (num + 1L));
        }
    }

    @HussarTransactional
    @CacheEvict(value={"resource_info"}, allEntries=true)
    public ApiResponse updateEmployee(StaffSaveDto staffSaveDto) {
        if (ToolUtil.isEmpty((Object)staffSaveDto)) {
            throw new BaseException("\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysStru sysStru = staffSaveDto.getSysStru();
        SysOrgan sysOrgan = staffSaveDto.getSysOrgan();
        SysStaff sysStaff = staffSaveDto.getSysStaff();
        String organIds = staffSaveDto.getOrganIds();
        if (ToolUtil.isEmpty((Object)sysStru)) {
            throw new BaseException("\u4eba\u5458\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrgan)) {
            throw new BaseException("\u4eba\u5458\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysStaff)) {
            throw new BaseException("\u5458\u5de5\u57fa\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getId())) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        return ApiResponse.success((String)this.editStaffVue(sysStru, sysOrgan, sysStaff, organIds, staffSaveDto));
    }

    @Deprecated
    public String getCurrentCode(SysOrganDto sysOrganDto) {
        if (ToolUtil.isEmpty((Object)sysOrganDto)) {
            throw new BaseException("\u7ec4\u7ec7dto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String parentType = sysOrganDto.getParentType();
        String orgType = sysOrganDto.getOrganType();
        String orgParentCode = sysOrganDto.getParentTypeCode();
        if (ToolUtil.isEmpty((Object)parentType) || ToolUtil.isEmpty((Object)orgType) || ToolUtil.isEmpty((Object)orgParentCode)) {
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        String filedName = "ORGAN_CODE_" + orgType;
        String currentCode = this.sysIdtableService.getCurrentCode(filedName, "SYS_STRU");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        if (parentType.equals(orgType)) {
            throw new BaseException(BizExceptionEnum.SERVER_ERROR.getMessage());
        }
        return orgParentCode + currentCode;
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer updateStaff = 0;
        Integer insertStaff = 0;
        Integer insert = 0;
        Long insertUsers = 0L;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Number number;
                Number number2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)object;
                    if (this.updateById((BaseEntity)stru)) {
                        if (stru.getStruType().equals("9")) {
                            number2 = updateStaff;
                            number = updateStaff = Integer.valueOf(updateStaff + 1);
                        }
                        number2 = update;
                        number = update = Integer.valueOf(update + 1);
                    } else {
                        this.save((BaseEntity)stru);
                        if (stru.getStruType().equals("9")) {
                            number2 = insertStaff;
                            number = insertStaff = Integer.valueOf(insertStaff + 1);
                        }
                        number2 = insert;
                        number = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)object;
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById(organ))) {
                        number2 = update;
                        number = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert(organ);
                        number2 = insert;
                        number = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStaff) {
                    SysStaff sysStaff = (SysStaff)object;
                    if (SqlHelper.retBool((Integer)this.sysStaffMapper.updateById(sysStaff))) {
                        number2 = update;
                        number = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStaffMapper.insert(sysStaff);
                        number2 = insert;
                        number = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysUsers) {
                    SysUsers sysUsers = (SysUsers)object;
                    if (SqlHelper.retBool((Integer)this.sysUsersMapper.updateById(sysUsers))) {
                        number2 = update;
                        number = update = Integer.valueOf(update + 1);
                    } else {
                        number2 = insertUsers;
                        insertUsers = insertUsers + 1L;
                        number = insertUsers;
                        this.sysUsersMapper.insert(sysUsers);
                        number2 = insert;
                        number = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysStruAssistOrgan) {
                    SysStruAssistOrgan sysStruAssistOrgan = (SysStruAssistOrgan)object;
                    if (SqlHelper.retBool((Integer)this.sysStruAssistOrganMapper.updateById(sysStruAssistOrgan))) {
                        number2 = update;
                        number = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStruAssistOrganMapper.insert(sysStruAssistOrgan);
                        number2 = insert;
                        number = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
        }
        if (insertUsers > 0L) {
            this.validateUserManager.validateBatchLimit(insertUsers);
        }
        result.put("update", update);
        result.put("updateStaff", updateStaff);
        result.put("insertStaff", insertStaff);
        result.put("insert", insert);
        return result;
    }

    public void checkUserInfo(Object object, String type) {
        ArrayList<String> messageList = new ArrayList<String>();
        switch (type) {
            case "add": 
            case "edit": {
                String idCard;
                StaffSaveDto staffSaveDto = (StaffSaveDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), StaffSaveDto.class);
                if (ToolUtil.isEmpty((Object)staffSaveDto)) {
                    messageList.add("\u4eba\u5458\u4fdd\u5b58dto\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysOrgan())) {
                    messageList.add("\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStaff())) {
                    messageList.add("\u4eba\u5458\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                if (HussarUtils.isNotBlank((CharSequence)staffSaveDto.getSysOrgan().getOrganCode())) {
                    boolean flag;
                    boolean bl = flag = !staffSaveDto.getSysOrgan().getOrganCode().contains("/") && staffSaveDto.getSysOrgan().getOrganCode().length() < 33;
                    if (!flag) {
                        messageList.add("\u4eba\u5458\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/,\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
                    }
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStaff().getName())) {
                    messageList.add("\u672a\u586b\u5199\u4eba\u5458\u59d3\u540d");
                }
                if (staffSaveDto.getSysStaff().getAddress().trim().length() > 32) {
                    messageList.add("\u5bb6\u5ead\u4f4f\u5740\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
                }
                if (staffSaveDto.getSysStaff().getWorkId().trim().length() > 16) {
                    messageList.add("\u5de5\u53f7\u6700\u591a\u53ef\u8f93\u516516\u4e2a\u5b57\u7b26");
                }
                if (staffSaveDto.getSysStaff().getGraduateSchool().trim().length() > 32) {
                    messageList.add("\u6bd5\u4e1a\u9662\u6821\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru().getStruType())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru().getParentId())) {
                    messageList.add("\u672a\u586b\u5199\u6240\u5c5e\u7236\u7ea7id");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru().getStruLevel())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u7ea7\u522b");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru().getIsEmployee())) {
                    messageList.add("\u672a\u586b\u5199\u662f\u5426\u4e3a\u4eba\u5458\u7684\u6807\u5fd7\u4f4d");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysOrgan().getOrganName())) {
                    messageList.add("\u672a\u586b\u5199\u4eba\u5458\u540d\u79f0");
                } else if (staffSaveDto.getSysOrgan().getOrganName().trim().length() > 32) {
                    messageList.add("\u4eba\u5458\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysOrgan().getOrganType())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u7c7b\u578b");
                }
                if (ToolUtil.isNotEmpty((Object)staffSaveDto.getSysStaff().getIdcard()) && !this.isStrNum(idCard = staffSaveDto.getSysStaff().getIdcard())) {
                    messageList.add("\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                if (!"edit".equals(type)) break;
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStaff().getId())) {
                    messageList.add("\u4eba\u5458id\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStaff().getStruId())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784id\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru().getId())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784id\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru().getOrganId())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784\u7684\u7ec4\u7ec7id\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)staffSaveDto.getSysStru().getStruOrder())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784\u6210\u5458\u5c40\u90e8\u6392\u5e8f\u503c\u4e3a\u7a7a");
                }
                if (!ToolUtil.isEmpty((Object)staffSaveDto.getSysOrgan().getId())) break;
                messageList.add("\u7ec4\u7ec7\u673a\u6784id\u4e3a\u7a7a");
                break;
            }
            case "delete": {
                if (!ToolUtil.isEmpty((Object)object)) break;
                messageList.add("\u8981\u5220\u9664\u7684\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "transfer": {
                StruChangeDto struChangeDtoForChange = (StruChangeDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), StruChangeDto.class);
                if (ToolUtil.isEmpty((Object)struChangeDtoForChange.getParentId())) {
                    messageList.add("\u8bf7\u586b\u5199\u8981\u8f6c\u79fb\u5230\u7684\u8282\u70b9id");
                }
                if (ToolUtil.isEmpty((Object)struChangeDtoForChange.getParentLevel())) {
                    messageList.add("\u8bf7\u586b\u5199\u8981\u8f6c\u79fb\u5230\u7684\u8282\u70b9\u7ea7\u522b");
                }
                if (!ToolUtil.isEmpty((Object)struChangeDtoForChange.getStruId())) break;
                messageList.add("\u8bf7\u586b\u5199\u8981\u8f6c\u79fb\u7684\u8282\u70b9id");
                break;
            }
        }
        if (ToolUtil.isNotEmpty(messageList)) {
            String allMessage = StringUtils.join((Object[])messageList.toArray(), (String)",");
            throw new BaseException(allMessage);
        }
    }

    public IPage<StaffDetailListVo> getStaffDetailInfoList(Page page, QueryStaffDetailDto queryStaffDetailDto) {
        String levelCode = queryStaffDetailDto.getStruId() != 11L ? this.sysStruMapper.selectLevelCode(queryStaffDetailDto.getStruId()) + "%" : "/0001%";
        queryStaffDetailDto.setLevelCode(levelCode);
        if (queryStaffDetailDto.getIsMainPosition() == 1) {
            return this.sysStaffMapper.getStaffDetailInfoListMain(page, queryStaffDetailDto);
        }
        return this.sysStaffMapper.getStaffDetailInfoList(page, queryStaffDetailDto);
    }

    public List<StaffSelectTreeVo> employeeSelectByMobile(QueryStaffDetailDto queryStaffDetailDto) {
        StaffSelectTreeVo staffSelectTreeVo;
        Long struId = queryStaffDetailDto.getStruId();
        String userSearch = queryStaffDetailDto.getUserName();
        Integer isMainPosition = queryStaffDetailDto.getIsMainPosition();
        if (isMainPosition == null) {
            queryStaffDetailDto.setIsMainPosition(Integer.valueOf(-1));
        }
        List<StaffSelectTreeVo> treeModels = new ArrayList<StaffSelectTreeVo>();
        if (struId == null && StringUtils.isEmpty((CharSequence)userSearch)) {
            staffSelectTreeVo = this.initRootNode();
            queryStaffDetailDto.setStruId(staffSelectTreeVo.getStruIdCsp());
            staffSelectTreeVo.setChildrenInfo(this.sysStaffMapper.getAllChildInfo(queryStaffDetailDto));
            treeModels.add(staffSelectTreeVo);
        }
        if (struId != null && StringUtils.isEmpty((CharSequence)userSearch)) {
            treeModels = this.sysStaffMapper.getAllChildInfo(queryStaffDetailDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)userSearch)) {
            staffSelectTreeVo = this.initRootNode();
            if (staffSelectTreeVo == null) {
                return null;
            }
            struId = staffSelectTreeVo.getStruIdCsp();
            String fid = ((SysStru)this.sysStruMapper.selectById(struId)).getStruFid() + '%';
            queryStaffDetailDto.setLevelCode(fid);
            queryStaffDetailDto.setStruId(null);
            queryStaffDetailDto.setUserName(SqlQueryUtil.transferSpecialChar((String)userSearch));
            staffSelectTreeVo.setChildrenInfo(this.sysStaffMapper.getStaffInfoByMobile(queryStaffDetailDto, SqlQueryUtil.ESCAPE_SYMBOL));
            treeModels.add(staffSelectTreeVo);
        }
        return treeModels;
    }

    public boolean isStrNum(String idWorkNum) {
        Pattern pattern = Pattern.compile("^[1-9][0-9]{5}([1][9][0-9]{2}|[2][0][0|1][0-9])([0][1-9]|[1][0|1|2])([0][1-9]|[1|2][0-9]|[3][0|1])[0-9]{3}([0-9]|[X])$");
        Matcher isNum = pattern.matcher(idWorkNum);
        return isNum.matches();
    }

    private StaffSelectTreeVo initRootNode() {
        JSTreeModel jsTreeModel;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ObjectUtils.isEmpty((Object)user)) {
            return null;
        }
        LoginUserExtendInfoDto deptInfo = (LoginUserExtendInfoDto)JSON.parseObject((String)JSON.toJSONString((Object)user.getExtendUserMap("deptInfo")), LoginUserExtendInfoDto.class);
        String deptType = deptInfo.getType();
        if (OrganTypeEnums.PROJECT.getType().equals(deptType)) {
            jsTreeModel = this.orgMaintenanceService.getThisOneOrg(Long.valueOf(deptInfo.getId()));
        } else {
            LoginUserExtendInfoDto directCompanyInfo = (LoginUserExtendInfoDto)JSON.parseObject((String)JSON.toJSONString(((Map)user.getExtendUserMap("companyInfo")).get("direct")), LoginUserExtendInfoDto.class);
            String companyType = directCompanyInfo.getType();
            Long nodeId = Long.valueOf(directCompanyInfo.getId());
            if (OrganTypeEnums.ORGAN.getType().equals(companyType)) {
                SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)Long.valueOf(directCompanyInfo.getId()));
                nodeId = sysStru.getParentId();
            }
            jsTreeModel = this.orgMaintenanceService.getThisOneOrg(nodeId);
        }
        return this.jsTreeModelCast(jsTreeModel);
    }

    private StaffSelectTreeVo jsTreeModelCast(JSTreeModel jsTreeModel) {
        StaffSelectTreeVo staffSelectTreeVo = new StaffSelectTreeVo();
        staffSelectTreeVo.setStruIdCsp(jsTreeModel.getId());
        staffSelectTreeVo.setDeptName(jsTreeModel.getText());
        staffSelectTreeVo.setDeptCode(jsTreeModel.getCode());
        staffSelectTreeVo.setDeptIdCsp(jsTreeModel.getParent());
        staffSelectTreeVo.setOrderNo(jsTreeModel.getStruOrder());
        return staffSelectTreeVo;
    }
}

