/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.SysStruOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class ISysStruServiceImpl
extends HussarBaseServiceImpl<SysStruMapper, SysStru>
implements ISysStruService {
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruAssistOrganService sysStruAssistOrganService;

    public SysOrgan getOrganInfoByDeparmentId(Long deparmentId) {
        return this.sysStruMapper.getOrganInfoByDeparmentId(deparmentId);
    }

    public void getDataScopeOrgList(Set<String> orgList, String type, SysUsers sysUsers, SecurityUser shiroUser) {
        List<String> codeList;
        List allAssistOrgan = this.sysStruAssistOrganService.getAllAssistOrgan(shiroUser.getEmployeeId());
        ArrayList<String> deptList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)allAssistOrgan)) {
            for (Map map : allAssistOrgan) {
                if (!ToolUtil.isNotEmpty(map.get("ASSISTDEPTNAME"))) continue;
                deptList.add(map.get("ASSISTDEPIDS").toString());
            }
        }
        deptList.add(String.valueOf(sysUsers.getDepartmentId()));
        if ("3".equals(type)) {
            orgList.addAll(deptList);
        }
        if ("2".equals(type) && ToolUtil.isNotEmpty(codeList = this.sysStruMapper.getOrgCodeListByIdList(deptList))) {
            for (int i = 0; i < codeList.size(); ++i) {
                String code = codeList.get(i) + "%";
                codeList.set(i, code);
            }
            List<String> orgIds = this.sysStruMapper.getStruListByOrganCode(codeList);
            orgList.addAll(orgIds);
        }
    }

    public void updateOrderById(String id, Integer order) {
        this.sysStruMapper.updateOrderById(id, order);
    }

    public SysOrganVo getOrgInfoByOrgId(Long struId) {
        return this.sysStruMapper.getOrgInfoByOrgId(struId);
    }

    public List<Long> getChildOrgId(Long struId, String type) {
        List allSysStruList = this.list();
        boolean flag = true;
        List<Object> childrenStruList = new ArrayList();
        List<Long> parentStruIdList = new ArrayList<Long>();
        parentStruIdList.add(struId);
        if (ToolUtil.isNotEmpty((Object)struId)) {
            while (flag) {
                Object finalParentStruIdList = parentStruIdList;
                List childList = allSysStruList.stream().filter(arg_0 -> ISysStruServiceImpl.lambda$getChildOrgId$0((List)finalParentStruIdList, arg_0)).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(childList)) {
                    if (ToolUtil.isEmpty(childrenStruList)) {
                        childrenStruList = childList;
                    } else {
                        childrenStruList.addAll(childList);
                    }
                    parentStruIdList = childList.stream().map(SysStru::getId).collect(Collectors.toList());
                    continue;
                }
                flag = false;
            }
        }
        switch (type) {
            case "01": {
                childrenStruList = childrenStruList.stream().filter(o -> !"9".equals(o.getStruType())).collect(Collectors.toList());
                break;
            }
            case "02": {
                childrenStruList = childrenStruList.stream().filter(o -> "9".equals(o.getStruType())).collect(Collectors.toList());
                break;
            }
        }
        List<Long> childrenStruIdList = childrenStruList.stream().map(SysStru::getId).collect(Collectors.toList());
        return childrenStruIdList;
    }

    public List<SysStru> getStruByStruIds(List<Long> struIds) {
        if (HussarUtils.isEmpty(struIds)) {
            return Collections.emptyList();
        }
        return this.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysStru::getId, struIds));
    }

    public Map<String, Integer> saveOrUpdateStruList(List<SysStru> strus) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<Long> struIds = strus.stream().map(SysStru::getId).collect(Collectors.toList());
        List<SysStru> existedStrus = this.getStruByStruIds(struIds);
        ArrayList<SysStru> repeatStrus = new ArrayList<SysStru>();
        ArrayList<SysStru> newStrus = new ArrayList<SysStru>();
        if (HussarUtils.isNotEmpty(existedStrus)) {
            List repeatIds = existedStrus.stream().map(SysStru::getId).collect(Collectors.toList());
            for (SysStru sysStru : strus) {
                if (repeatIds.contains(sysStru.getId())) {
                    repeatStrus.add(sysStru);
                    continue;
                }
                newStrus.add(sysStru);
            }
            map.put("insert", newStrus.size());
            map.put("update", repeatStrus.size());
            this.saveBatch(newStrus);
            this.updateBatchById(repeatStrus);
        } else {
            this.saveBatch(strus);
            map.put("insert", strus.size());
            map.put("update", 0);
        }
        return map;
    }

    public List<SysStru> getStruList(List<String> list) {
        return ((SysStruMapper)this.baseMapper).getStruList(list);
    }

    public List<Map<String, String>> getOrganTypeList(SysUsers sysUsers) {
        List<Map<String, String>> result = ((SysStruMapper)this.baseMapper).getOrganTypeList(sysUsers);
        if (HussarUtils.isNotEmpty(result)) {
            result.forEach(map -> {
                if (HussarUtils.isNotEmpty((Object)map) && map.containsKey("oType")) {
                    map.put("type", map.get("oType"));
                    map.remove("oType");
                }
            });
        }
        return result;
    }

    @HussarDs(value="#connName")
    public void saveBatchForTenant(String connName, Set<SysStru> sysStruCollection) {
        super.saveBatch(sysStruCollection);
    }

    public List<Long> getOrganIds(Long struId) {
        ArrayList<Long> organIds = new ArrayList<Long>();
        Long masterId = 11L;
        while (!masterId.equals(struId) && ToolUtil.isNotEmpty((Object)struId)) {
            organIds.add(struId);
            SysStru sysStru = (SysStru)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)struId));
            if (ToolUtil.isNotEmpty((Object)sysStru)) {
                struId = sysStru.getParentId();
                continue;
            }
            struId = null;
        }
        return organIds;
    }

    public String getByStruId(String struId) {
        return HussarUtils.isNull((Object)((SysStruMapper)this.baseMapper).selectById((Serializable)((Object)struId))) ? "" : ((SysStru)((SysStruMapper)this.baseMapper).selectById((Serializable)((Object)struId))).getOutOriginId();
    }

    public Long getHussarDeptIdBy(String originDeptId, String mdmDeptId) {
        SysStru stru = null;
        if (HussarUtils.isNotEmpty((Object)originDeptId)) {
            stru = (SysStru)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOutOriginId, (Object)originDeptId));
            return stru != null ? stru.getId() : null;
        }
        if (HussarUtils.isNotEmpty((Object)mdmDeptId)) {
            stru = (SysStru)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOutStruId, (Object)mdmDeptId));
            return stru != null ? stru.getId() : null;
        }
        return null;
    }

    public Long getMainDeptIdBy(Long employeeId) {
        SysStru stru;
        if (HussarUtils.isNotEmpty((Object)employeeId) && HussarUtils.isNotEmpty((Object)(stru = (SysStru)this.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)employeeId))))) {
            return HussarUtils.isNotEmpty((Object)stru.getCompanyId()) ? Long.valueOf(Long.parseLong(stru.getCompanyId())) : null;
        }
        return null;
    }

    public List<SysStruOrgan> selectUnits(List<String> resolvedFid) {
        return this.sysStruMapper.selectUnits(resolvedFid);
    }

    private static /* synthetic */ boolean lambda$getChildOrgId$0(List finalParentStruIdList, SysStru o) {
        return finalParentStruIdList.contains(o.getParentId());
    }
}

