/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganOutMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysPostOutNewMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.OutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.OutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryErrorOrganDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryErrorPostDto;
import com.jxdinfo.hussar.authorization.organ.dto.QueryErrorUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseSyncOrganizationService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganOutService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersOutMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseSyncUserService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.post.dto.SysPostOut;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.service.IHussarBaseSyncPostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.sequence.builder.SeqBuilder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.organ.service.impl.hussarBaseSyncOrganizationServiceImpl")
public class HussarBaseSyncOrganizationServiceImpl
implements IHussarBaseSyncOrganizationService {
    private static final Logger logger = LoggerFactory.getLogger(HussarBaseSyncOrganizationServiceImpl.class);
    private static final String CACHE = "hussarOrganizationJob";
    @Autowired
    private AddOutsideOrganizationManager addOutsideOrganizationManager;
    @Autowired
    private AddBatchOutsideOrganizationManager addBatchOutsideOrganizationManager;
    @Autowired
    private EditOutsideOrganizationManager editOutsideOrganizationManager;
    @Autowired
    private EditBatchOutsideOrganizationManager editBatchOutsideOrganizationManager;
    @Autowired
    private DeleteOutsideOrganizationManager deleteOutsideOrganizationManager;
    @Autowired
    private DeleteBatchOutsideOrganizationManager deleteBatchOutsideOrganizationManager;
    @Autowired
    protected ISysOrganOutService sysOrganOutService;
    @Autowired
    private IHussarBaseSyncPostService hussarBaseSyncPostService;
    @Autowired
    private IHussarBaseSyncUserService hussarBaseSyncUserService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruService sysStruService;
    @Autowired
    private ISysUsersService sysUsersService;
    @Autowired
    private UserPostConcurrentlyService userPostConcurrentlyService;
    @Autowired
    private SeqBuilder seqBuilder;
    @Resource
    private ISysTenantService tenantService;
    @Autowired
    protected ISysOrganTypeService organTypeService;
    @Autowired
    protected ISysOrganService organService;
    @Resource
    private SysPostOutNewMapper sysPostOutNewMapper;
    @Resource
    private SysUsersOutMapper sysUsersOutMapper;
    @Resource
    private SysOrganOutMapper sysOrganOutMapper;

    @HussarTransactional
    public synchronized R<AddOutsideOrganizationDto> addOrganization(AddOutsideOrganizationDto addOrganizationDto) {
        R<AddOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.addOutsideOrganizationManager.addOrganization(addOrganizationDto);
        }
        catch (BaseException e) {
            throw new BaseException("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<AddOutsideOrganizationDto> addBatchOrganizations(List<AddOutsideOrganizationDto> organs) {
        R<AddOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.addBatchOutsideOrganizationManager.addBatchOrganizations(organs);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideOrganizationDto> editOrganization(EditOutsideOrganizationDto editOrganizationDto) {
        R<EditOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u4fee\u6539\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.editOutsideOrganizationManager.editOrganization(editOrganizationDto);
        }
        catch (BaseException e) {
            throw new BaseException("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<EditOutsideOrganizationDto> editBatchOrganizations(List<EditOutsideOrganizationDto> organs) {
        R<EditOutsideOrganizationDto> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u4fee\u6539\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.editBatchOutsideOrganizationManager.editBatchOrganizations(organs);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteOrganization(String organCode) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.deleteOutsideOrganizationManager.deleteOrganization(organCode);
        }
        catch (BaseException e) {
            throw new BaseException("\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    @HussarTransactional
    public synchronized R<String> deleteBatchOrganizations(List<String> organCodes) {
        R<String> r = null;
        try {
            Object flag = HussarCacheUtil.get((String)"refresh_organ", (Object)CACHE);
            if (flag != null) {
                logger.error("\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
                throw new BaseException("\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u64cd\u4f5c\u88ab\u9501\u5b9a\uff01");
            }
            HussarCacheUtil.put((String)"refresh_organ", (Object)CACHE, (Object)CACHE);
            r = this.deleteBatchOutsideOrganizationManager.deleteBatchOrganizations(organCodes);
        }
        catch (BaseException e) {
            throw new BaseException("\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u673a\u6784\u51fa\u9519\uff1a" + (Object)((Object)e));
        }
        finally {
            HussarCacheUtil.evict((String)"refresh_organ", (Object)CACHE);
        }
        return r;
    }

    public Map<String, Object> saveOrgan(OutsideOrganizationDto addOrganizationDto, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (addOrganizationDto == null) {
            map.put("success", false);
            map.put("message", "\u63a5\u6536\u6570\u636e\u4e3a\u7a7a\u3002");
        } else {
            try {
                HussarTenantDefinition tenant = this.tenantService.getTenantByTenantCode(tenantCode);
                String connName = null != tenant && null != tenant.getConnName() && !"".equals(tenant.getConnName()) ? tenant.getConnName() : "master";
                addOrganizationDto.setPushTime(LocalDateTime.now());
                addOrganizationDto.setProcessingState(0);
                addOrganizationDto.setFailReason(null);
                if (StringUtils.isNotEmpty((CharSequence)addOrganizationDto.getOriginId())) {
                    boolean bl = this.sysOrganOutService.saveOrUpdateByTenant(connName, addOrganizationDto);
                    map.put("success", bl);
                    if (bl) {
                        map.put("message", "\u63a5\u6536\u6570\u636e\u6210\u529f\u3002");
                    } else {
                        map.put("message", "\u63a5\u6536\u6570\u636e\u5931\u8d25\u3002");
                    }
                }
            }
            catch (Exception e) {
                map.put("success", false);
                map.put("message", "\u63a5\u6536\u6570\u636e\u5931\u8d25,\u7cfb\u7edf\u5f02\u5e38\u3002");
            }
        }
        return map;
    }

    public void asyncOrganization() {
        this.operationOrganization();
    }

    public Map<String, Object> operationOrganization() {
        logger.info("\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u5f00\u59cb");
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<OutsideOrganizationDto> list = this.sysStruMapper.existStru();
        try {
            logger.info("\u9700\u8981\u5904\u7406\u7684\u7ec4\u7ec7\u673a\u6784" + list.size() + "\u6761");
            if (list.size() > 0) {
                this.sysStruMapper.updateStruStateById(list);
            }
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.ne(SysStru::getStruType, (Object)9);
            List struList = this.sysStruMapper.selectList((Wrapper)wrapper);
            ArrayList<OutsideOrganizationDto> addList = new ArrayList<OutsideOrganizationDto>();
            ArrayList<OutsideOrganizationDto> editList = new ArrayList<OutsideOrganizationDto>();
            ArrayList<OutsideOrganizationDto> deletelist = new ArrayList<OutsideOrganizationDto>();
            for (OutsideOrganizationDto outsideOrganizationDto : list) {
                if (outsideOrganizationDto.getIsDeleted() == 1) {
                    deletelist.add(outsideOrganizationDto);
                    continue;
                }
                if (HussarUtils.isEmpty((Object)outsideOrganizationDto.getStruId())) {
                    addList.add(outsideOrganizationDto);
                    continue;
                }
                editList.add(outsideOrganizationDto);
            }
            ArrayList<OutsideOrganizationDto> resultList = new ArrayList<OutsideOrganizationDto>();
            logger.info("\u7ec4\u7ec7\u673a\u6784\u65b0\u589e\u6570\u636e" + addList.size() + "\u6761");
            if (CollectionUtils.isNotEmpty(addList)) {
                this.addOrgan(addList, resultList, struList);
            }
            logger.info("\u7ec4\u7ec7\u673a\u6784\u4fee\u6539\u6570\u636e" + editList.size() + "\u6761");
            if (CollectionUtils.isNotEmpty(editList)) {
                this.changeOrganization(editList);
                this.editOrgan(editList, resultList, struList);
            }
            if (CollectionUtils.isNotEmpty(deletelist)) {
                this.editOrgan(deletelist, resultList, struList);
            }
            map.put("success", true);
            map.put("message", "\u5904\u7406\u6570\u636e\u6210\u529f\u3002");
        }
        catch (Exception e) {
            map.put("success", false);
            map.put("message", e.getMessage());
            this.sysStruMapper.updateStruStatusToZero();
        }
        logger.info("\u7ec4\u7ec7\u673a\u6784\u540c\u6b65\u7ed3\u675f");
        this.hussarBaseSyncPostService.operationPost();
        this.hussarBaseSyncUserService.operationUser();
        logger.info("\u5237\u65b0\u4e3b\u673a\u6784\u7801\u5f00\u59cb");
        this.refreshOrgan();
        logger.info("\u5237\u65b0\u4e3b\u673a\u6784\u7801\u7ed3\u675f");
        return map;
    }

    public Page<OutsideOrganizationDto> struErrorList(QueryErrorOrganDto queryErrorOrganDto, Page<OutsideOrganizationDto> page) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(OutsideOrganizationDto::getProcessingState, (Object)2);
        if (HussarUtils.isNotEmpty((Object)queryErrorOrganDto.getName())) {
            lambdaQueryWrapper.like(OutsideOrganizationDto::getName, (Object)queryErrorOrganDto.getName());
        }
        if (HussarUtils.isNotEmpty((Object)queryErrorOrganDto.getStartTime())) {
            lambdaQueryWrapper.ge(OutsideOrganizationDto::getPushTime, (Object)queryErrorOrganDto.getStartTime());
        }
        if (HussarUtils.isNotEmpty((Object)queryErrorOrganDto.getEndTime())) {
            lambdaQueryWrapper.le(OutsideOrganizationDto::getPushTime, (Object)queryErrorOrganDto.getEndTime());
        }
        lambdaQueryWrapper.orderByDesc(OutsideOrganizationDto::getPushTime);
        return (Page)this.sysOrganOutMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
    }

    public Page<SysPostOut> postErrorList(QueryErrorPostDto queryErrorPostDto, Page<SysPostOut> page) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SysPostOut::getProcessingState, (Object)2);
        if (HussarUtils.isNotEmpty((Object)queryErrorPostDto.getName())) {
            lambdaQueryWrapper.like(SysPostOut::getName, (Object)queryErrorPostDto.getName());
        }
        if (HussarUtils.isNotEmpty((Object)queryErrorPostDto.getStartTime())) {
            lambdaQueryWrapper.ge(SysPostOut::getPushTime, (Object)queryErrorPostDto.getStartTime());
        }
        if (HussarUtils.isNotEmpty((Object)queryErrorPostDto.getEndTime())) {
            lambdaQueryWrapper.le(SysPostOut::getPushTime, (Object)queryErrorPostDto.getEndTime());
        }
        lambdaQueryWrapper.orderByDesc(SysPostOut::getPushTime);
        return (Page)this.sysPostOutNewMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
    }

    public Page<OutsideUserDto> userErrorList(QueryErrorUserDto queryErrorUserDto, Page<OutsideUserDto> page) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(OutsideUserDto::getProcessingState, (Object)2);
        if (HussarUtils.isNotEmpty((Object)queryErrorUserDto.getName())) {
            lambdaQueryWrapper.like(OutsideUserDto::getRealName, (Object)queryErrorUserDto.getName());
        }
        if (HussarUtils.isNotEmpty((Object)queryErrorUserDto.getStartTime())) {
            lambdaQueryWrapper.ge(OutsideUserDto::getPushTime, (Object)queryErrorUserDto.getStartTime());
        }
        if (HussarUtils.isNotEmpty((Object)queryErrorUserDto.getEndTime())) {
            lambdaQueryWrapper.le(OutsideUserDto::getPushTime, (Object)queryErrorUserDto.getEndTime());
        }
        lambdaQueryWrapper.orderByDesc(OutsideUserDto::getPushTime);
        return (Page)this.sysUsersOutMapper.selectPage((IPage)page, (Wrapper)lambdaQueryWrapper);
    }

    private void refreshOrgan() {
        String cacheKey = CACHE;
        String cacheName = "refresh_organ";
        try {
            Object flag = HussarCacheUtil.get((String)cacheName, (Object)cacheKey);
            if (flag != null) {
                logger.error("\u4e0a\u4e00\u6b21\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u8fd8\u672a\u6267\u884c\u5b8c\u6bd5\uff01");
                throw new BaseException("\u4e0a\u4e00\u6b21\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u8fd8\u672a\u6267\u884c\u5b8c\u6bd5\uff01");
            }
            HussarCacheUtil.put((String)cacheName, (Object)cacheKey, (Object)CACHE);
            ((IHussarBaseOrganizationService)SpringContextHolder.getBean(IHussarBaseOrganizationService.class)).refreshOrgan();
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u7ec4\u7ec7\u673a\u6784\u51fa\u9519", (Throwable)e);
            throw e;
        }
        finally {
            HussarCacheUtil.evict((String)cacheName, (Object)cacheKey);
        }
    }

    public void changeOrganization(List<OutsideOrganizationDto> editList) {
        List allStruList = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ne(SysStru::getStruType, (Object)9)).isNotNull(SysStru::getOutStruId));
        List sysStruList = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getOutEnabled, (Object)"1")).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        for (OutsideOrganizationDto outsideOrganizationDto : editList) {
            Optional<SysStru> any;
            SysStru stru = this.sysStruMapper.getParentIdOut(outsideOrganizationDto.getId());
            if (!HussarUtils.isNotEmpty((Object)stru) || outsideOrganizationDto.getParentId().equals(stru.getOutStruId()) || !(any = allStruList.stream().filter(s -> outsideOrganizationDto.getParentId().equals(s.getOutStruId())).findAny()).isPresent()) continue;
            SysStru stru8 = allStruList.stream().filter(s -> outsideOrganizationDto.getParentId().equals(s.getOutStruId())).findAny().get();
            if (HussarUtils.isEmpty((Object)sysStruList)) continue;
            ArrayList<SysStru> childList = new ArrayList<SysStru>();
            ArrayList<Long> struIdList = new ArrayList<Long>();
            ArrayList<SysStru> struList2 = new ArrayList<SysStru>();
            for (SysStru sysStru : sysStruList) {
                if (!sysStru.getParentId().equals(stru8.getId())) continue;
                struIdList.add(sysStru.getId());
                childList.add(sysStru);
                struList2.add(sysStru);
            }
            if (HussarUtils.isNotEmpty(childList)) {
                this.getChild(childList, struIdList, sysStruList, struList2);
            }
            if (null == outsideOrganizationDto.getCompanyId() || "".equals(outsideOrganizationDto.getCompanyId())) continue;
            SysStru stru7 = allStruList.stream().filter(s -> s.getOutStruId() != null && s.getOutStruId().equals(outsideOrganizationDto.getCompanyId())).findAny().get();
            ArrayList userStruIds = Lists.newArrayList();
            for (SysStru sysStru : struList2) {
                sysStru.setCompanyId(String.valueOf(stru7.getId()));
                if (!"9".equals(sysStru.getStruType())) continue;
                userStruIds.add(sysStru.getId());
            }
            if (CollectionUtils.isNotEmpty((Collection)userStruIds)) {
                LambdaQueryWrapper wrapper6 = new LambdaQueryWrapper();
                wrapper6.in(SysUsers::getEmployeeId, (Collection)userStruIds);
                List usList = this.sysUsersService.list((Wrapper)wrapper6);
                List usersList = usList.stream().peek(u -> u.setCorporationId(stru7.getId())).collect(Collectors.toList());
                this.sysUsersService.updateBatchById(usersList);
            }
            if (CollectionUtils.isNotEmpty(struList2)) {
                this.sysStruService.updateBatchById(struList2);
            }
            List list = this.userPostConcurrentlyService.getConcurrentlyByStruId(struIdList);
            for (SysUserPostConcurrently sysUserPostConcurrently : list) {
                sysUserPostConcurrently.setUpCompanyId(stru7.getId());
            }
        }
    }

    private void getChild(List<SysStru> childList, List<Long> struIdList, List<SysStru> sysStruList, List<SysStru> allChidlList) {
        for (SysStru childSysStru : childList) {
            ArrayList<SysStru> childs = new ArrayList<SysStru>();
            for (SysStru sysStru : sysStruList) {
                if (!childSysStru.getId().equals(sysStru.getParentId())) continue;
                struIdList.add(sysStru.getId());
                childs.add(sysStru);
                allChidlList.add(sysStru);
            }
            if (!HussarUtils.isNotEmpty(childs)) continue;
            this.getChild(childs, struIdList, sysStruList, allChidlList);
        }
    }

    public boolean getLevelCode(List<OutsideOrganizationDto> list, String levelCode, List<SysStru> struList) {
        List myList = list.stream().filter(res -> res.getParentId() == null || "".equals(res.getParentId())).collect(Collectors.toList());
        if (HussarUtils.isEmpty((Object)levelCode)) {
            levelCode = "1001";
        }
        if (myList.size() > 0) {
            ArrayList<OutsideOrganizationDto> resultList = new ArrayList<OutsideOrganizationDto>();
            int num = 0;
            for (OutsideOrganizationDto outsideOrganizationDto : list) {
                if (!HussarUtils.isEmpty((Object)outsideOrganizationDto.getParentId())) continue;
                outsideOrganizationDto.setLevelCode(String.valueOf(Long.parseLong(levelCode) + (long)num * 1000L));
                resultList.add(outsideOrganizationDto);
                outsideOrganizationDto.setLayer(1);
                ++num;
            }
            this.getLevel(resultList, list);
        }
        Long num = 10000L;
        int count = 1;
        for (OutsideOrganizationDto outsideOrganizationDto : list) {
            List pList;
            if (HussarUtils.isEmpty((Object)outsideOrganizationDto.getLevelCode()) && (pList = struList.stream().filter(res -> outsideOrganizationDto.getParentId().equals(res.getOutStruId())).collect(Collectors.toList())).size() > 0 && HussarUtils.isNotEmpty((Object)((SysStru)pList.get(0)).getLevelCode())) {
                List childrenList = struList.stream().filter(e -> ((SysStru)pList.get(0)).getId().equals(e.getParentId())).collect(Collectors.toList());
                if (childrenList.size() > 0) {
                    List chList = childrenList.stream().filter(res -> res.getLevelCode() != null && !"".equals(res.getLevelCode())).collect(Collectors.toList());
                    if (chList.size() == 0) {
                        Long l = num;
                        Long l2 = num = Long.valueOf(num + 1L);
                    } else {
                        SysStru info = chList.stream().max(Comparator.comparing(SysStru::getLevelCode)).get();
                        logger.info("LecelCode:{}", (Object)info.getLevelCode());
                        String numCode = info.getLevelCode().substring(((SysStru)pList.get(0)).getLevelCode().length(), String.valueOf(info.getLevelCode()).length());
                        num = Long.valueOf(numCode) + (long)count;
                    }
                    outsideOrganizationDto.setLevelCode(((SysStru)pList.get(0)).getLevelCode() + num);
                } else {
                    outsideOrganizationDto.setLevelCode(((SysStru)pList.get(0)).getLevelCode() + "10001");
                }
                outsideOrganizationDto.setLayer(((SysStru)pList.get(0)).getStruLevel() + 1);
            }
            ++count;
        }
        return true;
    }

    public boolean getLevel(List<OutsideOrganizationDto> resultList, List<OutsideOrganizationDto> list) {
        ArrayList<OutsideOrganizationDto> nonEmptyList = new ArrayList<OutsideOrganizationDto>();
        for (int i = 0; i < resultList.size(); ++i) {
            Long n = 0L;
            for (int k = 0; k < list.size(); ++k) {
                if (!resultList.get(i).getId().equals(list.get(k).getParentId())) continue;
                Long number = 10001L + n;
                list.get(k).setLevelCode(resultList.get(i).getLevelCode() + number);
                list.get(k).setLayer(resultList.get(i).getLayer() + 1);
                nonEmptyList.add(list.get(k));
                Long l = n;
                Long l2 = n = Long.valueOf(n + 1L);
            }
        }
        if (nonEmptyList.size() == 0) {
            return true;
        }
        this.getLevel(nonEmptyList, list);
        return true;
    }

    public boolean addOrgan(List<OutsideOrganizationDto> addList, List<OutsideOrganizationDto> resultList, List<SysStru> struList) {
        List organTypes = this.organTypeService.list();
        if (addList.size() > 0) {
            for (OutsideOrganizationDto outsideOrganizationDto : addList) {
                Long id = this.seqBuilder.build().nextValue();
                outsideOrganizationDto.setStruId(id);
                resultList.add(outsideOrganizationDto);
            }
        }
        List outIds = addList.stream().map(OutsideOrganizationDto::getId).collect(Collectors.toList());
        List sysStruList = this.sysOrganOutService.getStruByOutIds(outIds);
        sysStruList.removeAll(Collections.singleton(null));
        HashMap<String, List<SysStru>> returnMap = new HashMap();
        returnMap = sysStruList.stream().collect(Collectors.groupingBy(SysStru::getOutStruId));
        ArrayList addReturnList = Lists.newArrayList();
        for (OutsideOrganizationDto outsideOrganizationDto : addList) {
            OutsideOrganizationDto add = this.addOutsideOrganizationManager.add(outsideOrganizationDto, resultList, struList, returnMap, organTypes);
            addReturnList.add(add);
        }
        this.sysOrganOutService.updateBatchById((Collection)addReturnList);
        return true;
    }

    public boolean editOrgan(List<OutsideOrganizationDto> editList, List<OutsideOrganizationDto> resultList, List<SysStru> struList) {
        List organList = this.organService.list((Wrapper)Wrappers.lambdaQuery().ne(SysOrgan::getOrganType, (Object)"9"));
        ArrayList editReturnList = Lists.newArrayList();
        for (OutsideOrganizationDto outsideOrganizationDto : editList) {
            OutsideOrganizationDto edit = this.editOutsideOrganizationManager.edit(outsideOrganizationDto, resultList, struList, organList);
            editReturnList.add(edit);
        }
        this.sysOrganOutService.updateBatchById((Collection)editReturnList);
        return true;
    }
}

