/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.dto.EditOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.OutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganOutService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editOutsideOrganizationManagerImpl")
public class EditOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements EditOutsideOrganizationManager {
    @Autowired
    protected ISysOrganOutService sysOrganOutService;

    @Override
    public R<EditOutsideOrganizationDto> editOrganization(EditOutsideOrganizationDto editOrganizationDto) {
        R result = new R();
        List errors = OrganUtil.validateOne((Object)editOrganizationDto);
        String organCode = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganCode());
        SysOrgan sysOrganTemp = (SysOrgan)this.organService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)StringUtils.trimToEmpty((String)organCode))).ne(SysOrgan::getOrganType, (Object)"9"));
        if (sysOrganTemp == null) {
            OrganUtil.addErrorMsg((List)errors, (Object)editOrganizationDto, (String)"organCode", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            BeanUtils.copyProperties((Object)sysOrganTemp, (Object)sysOrgan);
            SysStru sysStru = new SysStru();
            this.initializationEdit(editOrganizationDto, sysStru, sysOrgan, sysOffice);
            this.sysStruMapper.updateById(sysStru);
            this.organService.updateById((Object)sysOrgan);
            if (HussarUtils.isNotEmpty((Object)sysOffice)) {
                this.sysOfficeService.updateById((Object)sysOffice);
            }
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationEdit(EditOutsideOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String organName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)editOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)editOrganizationDto.getOrganDescription());
        String organAddress = editOrganizationDto.getOrganAddress();
        String currentFname = sysOrgan.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
        if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrgan.getOrganName())) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode());
            wrapper.ne(SysOrgan::getId, (Object)sysOrgan.getId());
            List sysOrgans = this.organService.list((Wrapper)wrapper);
            for (SysOrgan temp : sysOrgans) {
                temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
            }
            this.organService.updateBatchById((Collection)sysOrgans);
        }
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrgan.getId()));
        Long struId = sysStruT.getId();
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        if (StringUtils.isNotBlank((CharSequence)organAlias)) {
            sysStru.setOrganAlias(organAlias);
        }
        if (StringUtils.isNotBlank((CharSequence)userAccount)) {
            Long userId = this.getUserId(userAccount);
            sysStru.setPrincipalId(userId);
        }
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            sysOrgan.setOrganName(organName);
        }
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        if (StringUtils.isNotBlank((CharSequence)organShortName)) {
            sysOrgan.setShortName(organShortName);
        }
        if (StringUtils.isNotBlank((CharSequence)organAddress)) {
            sysOffice.setOfficeAddress(organAddress);
        }
        if (StringUtils.isNotBlank((CharSequence)organDescription)) {
            sysOffice.setOfficeAlias(organDescription);
        }
    }

    @Override
    public OutsideOrganizationDto edit(OutsideOrganizationDto organ, List<OutsideOrganizationDto> resultList, List<SysStru> struList, List<SysOrgan> organList) {
        if (organ.getParentId() == null || "".equals(organ.getParentId())) {
            organ.setProcessingState(1);
        } else {
            List existList1 = struList.stream().filter(item -> organ.getParentId().equals(item.getOutStruId())).collect(Collectors.toList());
            List existList2 = resultList.stream().filter(item -> organ.getParentId().equals(item.getId())).collect(Collectors.toList());
            if (existList1.size() > 0 || existList2.size() > 0 || HussarUtils.isEmpty((Object)organ.getParentId())) {
                organ.setProcessingState(1);
            } else {
                organ.setProcessingState(2);
                organ.setFailReason("\u5904\u7406\u5931\u8d25\uff0c\u7236\u7ea7id\u672a\u627e\u5230\u3002");
            }
        }
        R result = new R();
        List errors = OrganUtil.validateOne((Object)organ);
        SysOrgan sysOrganTemp = new SysOrgan();
        if (HussarUtils.isEmpty((Object)organ.getStruId())) {
            OrganUtil.addErrorMsg((List)errors, (Object)organ, (String)"struId", (String[])new String[]{"\u63a8\u9001\u7684\u6b64\u6761\u6570\u636e\uff0cstru_id\u4e3a\u7a7a\uff0csys_stru\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c"});
        } else {
            SysStru stru = struList.stream().filter(s -> organ.getId().equals(s.getOutStruId())).findAny().get();
            sysOrganTemp = organList.stream().filter(o -> stru.getOrganId().equals(o.getId())).findAny().orElse(null);
            if (sysOrganTemp == null) {
                OrganUtil.addErrorMsg((List)errors, (Object)organ, (String)"outOrganId", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u8be5\u7ec4\u7ec7\u673a\u6784\u7f16\u7801"});
            }
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            BeanUtils.copyProperties((Object)sysOrganTemp, (Object)sysOrgan);
            SysStru sysStru = new SysStru();
            String mes = this.initialization(organ, sysStru, sysOrgan, sysOffice, errors, resultList, struList);
            if (mes == null) {
                this.sysStruMapper.updateById(sysStru);
                this.organService.updateById((Object)sysOrgan);
                if (HussarUtils.isNotEmpty((Object)sysOffice.getId()) && organ.getIsDeleted() != 1) {
                    this.sysOfficeService.updateById((Object)sysOffice);
                }
                result.setSuccess(true);
                result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
            } else {
                result.setSuccess(false);
                result.setErrorList(errors);
            }
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        if (!result.isSuccess()) {
            organ.setProcessingState(2);
            organ.setFailReason(String.valueOf(((Error)result.getErrorList().get(0)).getErrMsg()));
        } else {
            organ.setProcessingState(1);
        }
        return organ;
    }

    private String initialization(OutsideOrganizationDto organizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice, List<Error<OutsideOrganizationDto>> errors, List<OutsideOrganizationDto> resultList, List<SysStru> struList) {
        String delFlag = StringUtils.trimToEmpty((String)String.valueOf(organizationDto.getIsDeleted()));
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrgan.getId()));
        Long struId = sysStruT.getId();
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        if (HussarUtils.isNotEmpty((Object)sysStruT)) {
            BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        }
        if (HussarUtils.isNotEmpty((Object)sysOfficeT)) {
            BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        }
        if ("1".equals(delFlag)) {
            sysStru.setDelFlag(delFlag);
            sysOrgan.setDelFlag(delFlag);
        } else {
            Long stId;
            String organName = StringUtils.trimToEmpty((String)organizationDto.getName());
            String organType = StringUtils.trimToEmpty((String)organizationDto.getCompanyCategoryCode());
            String organAlias = StringUtils.trimToEmpty((String)(HussarUtils.isEmpty((Object)organizationDto.getAlias()) ? organizationDto.getName() : organizationDto.getAlias()));
            String parentId = StringUtils.trimToEmpty((String)organizationDto.getParentId());
            String organShortName = StringUtils.trimToEmpty((String)(HussarUtils.isEmpty((Object)organizationDto.getAlias()) ? organizationDto.getName() : organizationDto.getAlias()));
            String organDescription = StringUtils.trimToEmpty((String)organizationDto.getRemark());
            String companyId = StringUtils.trimToEmpty((String)organizationDto.getCompanyId());
            String path = StringUtils.trimToEmpty((String)organizationDto.getPath());
            String pathName = StringUtils.trimToEmpty((String)organizationDto.getPathName());
            String levelCode = StringUtils.trimToEmpty((String)organizationDto.getLevelCode());
            String originId = StringUtils.trimToEmpty((String)organizationDto.getOriginId());
            String projectStatusId = StringUtils.trimToEmpty((String)organizationDto.getProjectStatusId());
            int enabled = organizationDto.getEnabled();
            int level = organizationDto.getLayer();
            int isVirtual = organizationDto.getIsVirtual();
            sysStru.setStruLevel(Integer.valueOf(level));
            if (StringUtils.isNotBlank((CharSequence)organAlias)) {
                sysStru.setOrganAlias(organAlias);
            }
            if (StringUtils.isNotBlank((CharSequence)organType)) {
                sysStru.setStruType(organType);
            }
            if (parentId == null || "".equals(parentId)) {
                sysStru.setParentId(Long.valueOf(11L));
            } else {
                stId = this.getSysStru(parentId, resultList, struList);
                if (HussarUtils.isEmpty((Object)stId)) {
                    OrganUtil.addErrorMsg(errors, (Object)organizationDto, (String)"parentStru", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f"});
                    return "\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f";
                }
                sysStru.setParentId(stId);
            }
            if (companyId != null && !"".equals(companyId)) {
                stId = this.getSysStru(companyId, resultList, struList);
                if (HussarUtils.isEmpty((Object)stId)) {
                    OrganUtil.addErrorMsg(errors, (Object)organizationDto, (String)"companyId", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u6240\u5c5e\u673a\u6784\u4fe1\u606f"});
                    return "\u672a\u67e5\u8be2\u5230\u6240\u5c5e\u673a\u6784\u4fe1\u606f";
                }
                sysStru.setCompanyId(String.valueOf(stId));
            }
            sysStru.setPath(path);
            sysStru.setPathName(pathName);
            sysStru.setOutEnabled(enabled);
            sysStru.setIsVirtual(isVirtual);
            sysStru.setOutOriginId(originId);
            sysStru.setOutProjectStatusId(projectStatusId);
            if (StringUtils.isNotBlank((CharSequence)organName)) {
                sysOrgan.setOrganName(organName);
            }
            if (StringUtils.isNotBlank((CharSequence)organShortName)) {
                sysOrgan.setShortName(organShortName);
            }
            if (StringUtils.isNotBlank((CharSequence)organDescription)) {
                sysOffice.setOfficeAlias(organDescription);
            }
        }
        return null;
    }

    public Long getSysStru(String outId, List<OutsideOrganizationDto> resultList, List<SysStru> struList) {
        List list = struList.stream().filter(item -> outId.equals(item.getOutStruId())).collect(Collectors.toList());
        List parentList = resultList.stream().filter(item -> outId.equals(item.getId())).collect(Collectors.toList());
        if (list != null && list.size() > 0) {
            return ((SysStru)list.get(0)).getId();
        }
        if (parentList != null && parentList.size() > 0) {
            return ((OutsideOrganizationDto)parentList.get(0)).getStruId();
        }
        return null;
    }
}

