/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.dto.EditOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.EditOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.editOrganizationManagerImpl")
public class EditOrganizationManagerImpl
extends CommonOrganizationManager
implements EditOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditOrganizationManagerImpl.class);

    @Override
    public String editOrganization(EditOrganizationDto editOrganizationDto) {
        String validateMsg = this.validateService.validate((Object)editOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(editOrganizationDto, sysStru, sysOrgan, sysOffice);
        this.organizationAuditDataExists(editOrganizationDto.getId());
        this.beforeEditOrganization(sysStru, sysOrgan, sysOffice);
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysOffice);
        this.afterEditOrganization(sysStru, sysOrgan, sysOffice);
        return result;
    }

    @Override
    public synchronized void refreshOrgan() {
        List strus = this.sysStruMapper.selectList(null);
        List organs = this.sysOrganMapper.selectList(null);
        Map organsMap = organs.stream().collect(Collectors.toMap(SysOrgan::getId, Function.identity()));
        AtomicInteger index = new AtomicInteger(1);
        strus.stream().filter(organsEntity -> organsEntity.getParentId().equals(Constants.ROOT_NODE_ID)).sorted(Comparator.comparing(SysStru::getIsEmployee, Comparator.nullsLast(String::compareTo)).thenComparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            SysOrgan sysOrgan = (SysOrgan)organsMap.get(stru.getOrganId());
            sysOrgan.setOrganFname("/" + sysOrgan.getOrganName());
            sysOrgan.setOrganFcode(sysOrgan.getOrganCode().equals("1") ? "/1/" : OrganUtil.convert((String)sysOrgan.getOrganCode()));
            stru.setStruSeq("/" + String.format("%04d", index.getAndIncrement()));
            stru.setStruFid(Objects.equals(stru.getId(), 1L) ? "/1/" : OrganUtil.convert((Long)stru.getId()));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            stru.setIsLeaf("Y");
            this.setInfo((SysStru)stru, strus, organsMap);
            return stru;
        }).collect(Collectors.toList());
        this.sysStruService.updateBatchById((Collection)strus);
        this.sysOrganService.updateBatchById(organsMap.values());
    }

    private void setInfo(SysStru root, List<SysStru> all, Map<Long, SysOrgan> organsMap) {
        AtomicInteger index = new AtomicInteger(1);
        root.setIsLeaf("Y");
        SysOrgan rootOrgan = organsMap.get(root.getOrganId());
        all.stream().filter(stru -> stru.getParentId().equals(root.getId())).sorted(Comparator.comparing(SysStru::getIsEmployee, Comparator.nullsLast(String::compareTo)).thenComparing(SysStru::getStruLevel, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getStruOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getGlobalOrder, Comparator.nullsLast(Integer::compareTo)).thenComparing(SysStru::getId)).map(stru -> {
            SysOrgan sysOrgan = (SysOrgan)organsMap.get(stru.getOrganId());
            AssertUtil.isNotNull((Object)sysOrgan, (String)("\u6570\u636e\u5e93\u6570\u636e\u9519\u4e71\uff0c\u6839\u636eSYS_STRU\u67e5\u8be2\u5230ORGAN_ID:" + stru.getOrganId() + ",\u4f46\u662f\u5728SYS_ORGAN\u4e2d\u672a\u67e5\u8be2\u5230\u6570\u636e"));
            sysOrgan.setOrganFname(rootOrgan.getOrganFname() + "/" + sysOrgan.getOrganName());
            sysOrgan.setOrganFcode(OrganUtil.convert((String)(rootOrgan.getOrganFcode() + sysOrgan.getOrganCode())));
            stru.setStruFid(OrganUtil.convert((String)(root.getStruFid() + stru.getId())));
            stru.setStruLevel(Integer.valueOf(stru.getStruFid().split("/").length - 1));
            if (!Objects.equals("9", stru.getStruType())) {
                root.setIsLeaf("N");
                stru.setStruSeq(root.getStruSeq() + "/" + String.format("%04d", index.getAndIncrement()));
            } else {
                stru.setStruSeq(root.getStruSeq());
            }
            this.setInfo((SysStru)stru, all, organsMap);
            return stru;
        }).collect(Collectors.toList());
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        boolean needAudit;
        LOGGER.info("\u5224\u65ad\u9700\u4e0d\u9700\u8981\u5ba1\u6838,\u5982\u679c\u9700\u8981\u5ba1\u6838\uff0c\u5219\u5148\u52a0\u5165\u5ba1\u6838\u8868");
        String msg = "";
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (needAudit) {
            LOGGER.debug("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u9700\u8981\u5ba1\u6838");
            this.auditAdd(sysOrgan, sysStru, null, sysOffice, "2");
            msg = "\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            LOGGER.debug("\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u4e0d\u9700\u8981\u5ba1\u6838");
            this.sysStruMapper.updateById(sysStru);
            this.sysOrganMapper.updateById(sysOrgan);
            if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                this.sysOfficeService.saveOrUpdate((Object)sysOffice);
            }
            msg = "\u4fee\u6539\u6210\u529f\uff01";
        }
        return msg;
    }

    private void afterEditOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u4fee\u6539\u540e\u7684\u65b9\u6cd5");
        this.sysOrgEventService.afterEdit(sysStru, sysOrgan, sysOffice);
    }

    private void beforeEditOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u4fee\u6539\u524d\u7684\u65b9\u6cd5");
        this.sysOrgEventService.beforeEdit(sysStru, sysOrgan, sysOffice);
    }

    private void organizationAuditDataExists(Long struId) {
        LOGGER.debug("\u5224\u65ad\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u6240\u5728\u7684\u7236\u7ec4\u7ec7\u673a\u6784\uff1a{}\u662f\u5426\u5b58\u5728\u5ba1\u6838\u6570\u636e", (Object)struId);
        if (!this.sysStruAuditService.checkCanOperate(struId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
    }

    private void initialization(EditOrganizationDto editOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        boolean needAudit;
        LOGGER.info("\u6839\u636eEditOrganizationDto\u521d\u59cb\u5316SysStru,SysOrgan,SysOffice,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)editOrganizationDto));
        Long struId = editOrganizationDto.getId();
        SysStru sysStruT = (SysStru)this.sysStruMapper.selectById(struId);
        SysOrgan sysOrganT = (SysOrgan)this.sysOrganMapper.selectById(sysStruT.getOrganId());
        String currentFname = sysOrganT.getOrganFname();
        String newFname = currentFname.substring(0, currentFname.lastIndexOf("/")) + "/" + editOrganizationDto.getOrganName().trim();
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (!Objects.equals(editOrganizationDto.getOrganName().trim(), sysOrganT.getOrganName()) && !needAudit) {
            LOGGER.debug("\u5982\u679c\u4e0d\u9700\u8981\u5ba1\u6838\uff0c\u800c\u4e14\u4fee\u6539\u4e86\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\uff0c\u5219\u9700\u8981\u66f4\u65b0\u4e0b\u7ea7\u7684\u7ec4\u7ec7\u673a\u6784\u5168\u8def\u5f84");
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.likeRight(SysOrgan::getOrganFcode, (Object)sysOrganT.getOrganFcode());
            wrapper.ne(SysOrgan::getId, (Object)sysOrganT.getId());
            List sysOrgans = this.sysOrganMapper.selectList((Wrapper)wrapper);
            for (SysOrgan temp : sysOrgans) {
                temp.setOrganFname(temp.getOrganFname().replaceFirst(currentFname, newFname));
            }
            this.sysOrganService.updateBatchById((Collection)sysOrgans);
        }
        SysOffice sysOfficeT = (SysOffice)this.sysOfficeMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysOffice::getStruId, (Object)struId));
        BeanUtils.copyProperties((Object)sysOrganT, (Object)sysOrgan);
        BeanUtils.copyProperties((Object)sysStruT, (Object)sysStru);
        BeanUtils.copyProperties((Object)sysOfficeT, (Object)sysOffice);
        sysStru.setOrganAlias(StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias()));
        sysStru.setPrincipalId(editOrganizationDto.getPrincipalId());
        sysOrgan.setOrganName(StringUtils.trimToEmpty((String)editOrganizationDto.getOrganName()));
        sysOrgan.setOrganAlias(StringUtils.trimToEmpty((String)editOrganizationDto.getOrganAlias()));
        sysOrgan.setOrganFname(sysOrgan.getOrganFname().replaceFirst(currentFname, newFname));
        sysOrgan.setShortName(StringUtils.trimToEmpty((String)editOrganizationDto.getShortName()));
        sysOffice.setOfficeAddress(StringUtils.trimToEmpty((String)editOrganizationDto.getOfficeAddress()));
        sysOffice.setOfficeAlias(StringUtils.trimToEmpty((String)editOrganizationDto.getOfficeAlias()));
        sysStru.setOutStruId(String.valueOf(sysStru.getId()));
        sysStru.setOutOriginId(String.valueOf(sysStru.getId()));
        sysStru.setOutEnabled(1);
    }
}

