/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteOutsideOrganizationManagerImpl")
public class DeleteOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements DeleteOutsideOrganizationManager {
    @Override
    public R<String> deleteOrganization(String organCode) {
        R result = new R();
        ArrayList errors = new ArrayList();
        if (HussarUtils.isBlank((CharSequence)organCode)) {
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            String code = StringUtils.trimToEmpty((String)organCode);
            SysOrgan sysOrgan = (SysOrgan)this.organService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysOrgan::getOrganCode, (Object)code)).ne(SysOrgan::getOrganType, (Object)"9"));
            SysStru sysStru = (SysStru)this.struService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)sysOrgan.getId()));
            Long parentId = sysStru.getParentId();
            SysStru parentSysStru = (SysStru)this.struService.getById((Serializable)parentId);
            Long count = this.struService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)parentId)).ne(SysStru::getId, (Object)sysStru.getId()));
            if (count == null || count < 1L) {
                parentSysStru.setIsLeaf("Y");
            }
            this.organService.remove((Wrapper)new LambdaQueryWrapper().likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode()));
            String struFid = sysStru.getStruFid();
            this.sysUserRoleMapper.deleteBatchByStruFid(struFid);
            this.sysUsersMapper.deleteBatchByStruFid(struFid);
            this.sysOfficeMapper.deleteBatchByStruFid(struFid);
            this.sysStaffMapper.deleteBatchByStruFid(struFid);
            this.sysStruMapper.delete((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            this.sysStruMapper.updateById(parentSysStru);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), code)}));
        }
        return result;
    }
}

