/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteBatchOutsideUserManagerImpl")
public class DeleteBatchOutsideUserManagerImpl
extends CommonOutsideUserManager
implements DeleteBatchOutsideUserManager {
    @Override
    public R<String> deleteBatchUsers(List<String> accounts) {
        boolean canEdit = false;
        if (HussarUtils.isNotEmpty(accounts) && accounts.size() <= 50) {
            canEdit = true;
        }
        if (!canEdit) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        boolean getLoginUpperOpen = this.hussarLoginConfigService.getLoginUpperOpen();
        ArrayList<SysUsers> usersList = new ArrayList<SysUsers>();
        for (String account : accounts) {
            SysUsers sysUsers;
            boolean convert;
            String userAccount = StringUtils.trimToEmpty((String)account);
            if (!HussarUtils.isNotBlank((CharSequence)userAccount)) continue;
            boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(userAccount);
            if (convert) {
                userAccount = userAccount.toUpperCase();
            }
            if ((sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)account)).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false)) == null) {
                OrganUtil.addErrorMsg(errors, (Object)account, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u4e0d\u5b58\u5728"});
                continue;
            }
            usersList.add(sysUsers);
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> mappings = new ArrayList<DataMapping>();
            ArrayList<Long> struIds = new ArrayList<Long>();
            ArrayList<Long> userIds = new ArrayList<Long>();
            for (SysUsers sysUsers : usersList) {
                mappings.add(new DataMapping(sysUsers.getId(), sysUsers.getUserAccount()));
                struIds.add(sysUsers.getEmployeeId());
                userIds.add(sysUsers.getId());
            }
            List struList = this.sysStruService.listByIds(struIds);
            List organIds = struList.stream().map(item -> item.getOrganId()).collect(Collectors.toList());
            this.sysStaffService.remove((Wrapper)new LambdaQueryWrapper().in(SysStaff::getStruId, struIds));
            this.sysOrganService.removeByIds(organIds);
            this.sysStruService.removeByIds(struIds);
            this.sysUsersService.removeByIds(userIds);
            result.setSuccessList(mappings);
        }
        return result;
    }
}

