/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.manager.DeleteBatchOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.deleteBatchOutsideOrganizationManagerImpl")
public class DeleteBatchOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements DeleteBatchOutsideOrganizationManager {
    @Override
    public R<String> deleteBatchOrganizations(List<String> organCodes) {
        boolean canDelete = false;
        if (HussarUtils.isNotEmpty(organCodes) && organCodes.size() <= 50) {
            canDelete = true;
        }
        if (!canDelete) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        ArrayList errors = new ArrayList();
        for (String organCode : organCodes) {
            if (!HussarUtils.isBlank((CharSequence)organCode)) continue;
            OrganUtil.addErrorMsg(errors, (Object)organCode, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        if (HussarUtils.isEmpty(errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
            LinkedHashMap<Long, OragnMapping> map = new LinkedHashMap<Long, OragnMapping>();
            ArrayList<SysStru> update = new ArrayList<SysStru>();
            List collect = organCodes.stream().map(item -> item.trim()).collect(Collectors.toList());
            List organs = this.organService.list((Wrapper)new LambdaQueryWrapper().in(SysOrgan::getOrganCode, collect));
            List organIds = organs.stream().map(item -> item.getId()).collect(Collectors.toList());
            List strus = this.struService.list((Wrapper)new LambdaQueryWrapper().in(SysStru::getOrganId, organIds));
            List struFids = strus.stream().map(item -> item.getStruFid()).filter(item -> HussarUtils.isNotBlank((CharSequence)item)).collect(Collectors.toList());
            for (String struFid : struFids) {
                this.sysUserRoleMapper.deleteBatchByStruFid(struFid);
                this.sysUsersMapper.deleteBatchByStruFid(struFid);
                this.sysOfficeMapper.deleteBatchByStruFid(struFid);
                this.sysStaffMapper.deleteBatchByStruFid(struFid);
            }
            for (SysStru sysStru : strus) {
                Long parentId = sysStru.getParentId();
                SysStru parentSysStru = (SysStru)this.struService.getById((Serializable)parentId);
                Long count = this.struService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)parentId)).ne(SysStru::getId, (Object)sysStru.getId()));
                if (count == null || count < 1L) {
                    parentSysStru.setIsLeaf("Y");
                    update.add(parentSysStru);
                }
                map.put(sysStru.getOrganId(), new OragnMapping(sysStru.getId(), sysStru.getOrganId()));
                this.sysStruMapper.delete((Wrapper)new LambdaQueryWrapper().likeRight(SysStru::getStruFid, (Object)sysStru.getStruFid()));
            }
            for (SysOrgan sysOrgan : organs) {
                OragnMapping oragnMapping = (OragnMapping)map.get(sysOrgan.getId());
                if (oragnMapping != null) {
                    dataMappings.add(new DataMapping(oragnMapping.getStruId(), sysOrgan.getOrganCode()));
                }
                this.organService.remove((Wrapper)new LambdaQueryWrapper().likeRight(SysOrgan::getOrganFcode, (Object)sysOrgan.getOrganFcode()));
            }
            if (HussarUtils.isNotEmpty(update)) {
                this.struService.updateBatchById(update);
            }
            result.setSuccessList(dataMappings);
        }
        return result;
    }

    static class OragnMapping {
        private Long organId;
        private Long struId;

        public OragnMapping() {
        }

        public OragnMapping(Long struId, Long organId) {
            this.organId = organId;
            this.struId = struId;
        }

        public Long getOrganId() {
            return this.organId;
        }

        public void setOrganId(Long organId) {
            this.organId = organId;
        }

        public Long getStruId() {
            return this.struId;
        }

        public void setStruId(Long struId) {
            this.struId = struId;
        }
    }
}

