/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.dto.OutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.SysUsersPositionOut;
import com.jxdinfo.hussar.authorization.post.service.IHussarBaseSyncPostService;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addOutsideUserManagerImpl")
public class AddOutsideUserManagerImpl
extends CommonOutsideUserManager
implements AddOutsideUserManager {
    @Resource
    protected HussarBaseProperties hussarBaseProperties;
    @Resource
    private IHussarBaseSyncPostService hussarBaseSyncPostService;

    @Override
    public R<AddOutsideUserDto> addUser(AddOutsideUserDto user, boolean dealWithSelf) {
        boolean exists;
        boolean convert;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)user);
        String account = StringUtils.trimToEmpty((String)user.getUserAccount());
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if (exists = this.existUser(account)) {
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u91cd\u590d"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStru sysStru = new SysStru();
            SysStaff sysStaff = new SysStaff();
            SysOrgan sysOrgan = new SysOrgan();
            SysUsers sysUsers = new SysUsers();
            user.setUserAccount(account);
            this.initializationAdd(convert, user, sysStru, sysOrgan, sysStaff, sysUsers);
            if (dealWithSelf) {
                sysUsers.setPassword(StringUtils.trimToEmpty((String)user.getSecure()));
            }
            this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
            this.addStaffUser(sysStru, sysOrgan, sysStaff, sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAdd(boolean convert, AddOutsideUserDto userDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers) {
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        Long departmentId = userDto.getDepartmentId();
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(departmentId);
        sysStru.setStruType("9");
        sysStru.setOrganAlias(userName);
        sysStru.setStaffPosition(staffPosition);
        sysStru.setIsEmployee("1");
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setStruId(Long.valueOf(sysStruId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganName(sysStaff.getName());
        sysOrgan.setOrganType("9");
        String newCode = this.getCode();
        sysOrgan.setOrganCode(newCode);
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
    }

    @Override
    @HussarTransactional
    public R<OutsideUserDto> add(OutsideUserDto user, int num) {
        boolean exists;
        boolean convert;
        R result = new R();
        result.setSuccess(true);
        List errors = OrganUtil.validateOne((Object)user);
        String account = StringUtils.trimToEmpty((String)user.getUserCode());
        boolean bl = convert = this.hussarLoginConfigService.getLoginUpperOpen() == false && !OrganConstants.EXCLUDE_USERS.contains(account);
        if (convert) {
            account = account.toUpperCase();
        }
        if (exists = this.existUser(account)) {
            String str = "\u7528\u6237\u8d26\u53f7\u91cd\u590d";
            user.setProcessingState(2);
            user.setFailReason(str);
            this.sysUsersOutService.updateById((Object)user);
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u91cd\u590d"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStru sysStru = new SysStru();
            SysStaff sysStaff = new SysStaff();
            SysOrgan sysOrgan = new SysOrgan();
            SysUsers sysUsers = new SysUsers();
            user.setUserCode(account);
            this.initialization(convert, user, sysStru, sysOrgan, sysStaff, sysUsers, num);
            long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
            sysStru.setId(Long.valueOf(struIdTemp));
            this.addStaffUserBySnyc(sysStru, sysOrgan, sysStaff, sysUsers);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysUsers.getId(), sysUsers.getUserAccount())}));
            this.hussarBaseSyncPostService.savePostList(user.getPositionList(), user.getId());
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers) {
        try {
            boolean tenantFlag;
            sysStru.setOrganAlias(sysOrgan.getOrganName());
            sysStru.setOrganId(null);
            sysStru.setIsLeaf("0");
            sysStru.setStruPath("");
            Integer order = 1;
            Integer maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                order = maxOrder + 1;
            }
            sysStru.setStruOrder(order);
            this.sysOrganMapper.insert(sysOrgan);
            sysStru.setOrganId(sysOrgan.getId());
            this.sysStruMapper.insert(sysStru);
            if (ToolUtil.isNotEmpty((Object)sysStaff)) {
                sysStaff.setName(sysOrgan.getOrganName());
                sysStaff.setStruId(sysStru.getId());
                this.staffUserMapper.insert(sysStaff);
            }
            if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
                String pass = "";
                pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "site81@95." : this.pwdConfigService.getDefaultPassword();
                String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
                sysUsers.setPassword(pwd);
            }
            sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
            sysUsers.setAccountStatus(UserStatus.OK.getCode());
            sysUsers.setSecurityLevel(Integer.valueOf(1));
            sysUsers.setMaxSessions(Integer.valueOf(-1));
            sysUsers.setLoginIpLimit("0");
            sysUsers.setLoginTimeLimit("0");
            sysUsers.setIsSys("0");
            sysUsers.setIsCpublic("0");
            sysUsers.setCorporationId(sysStru.getParentId());
            sysUsers.setDepartmentId(sysStru.getParentId());
            sysUsers.setEmployeeId(sysStru.getId());
            sysUsers.setTypeProperty("1");
            Integer userOrder = this.sysUsersService.getMaxOrder(sysUsers.getDepartmentId());
            userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
            sysUsers.setUserOrder(userOrder);
            this.sysUsersService.save((Object)sysUsers);
            SysUserRole userRole = new SysUserRole();
            userRole.setUserId(sysUsers.getId());
            userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            userRole.setAdminOption("1");
            userRole.setOutUserId(sysUsers.getOutUserId());
            userRole.setOutOriginId(sysUsers.getOutUserId());
            this.sysUserRoleMapper.insert(userRole);
            boolean bl = tenantFlag = this.hussarBaseProperties.isTenantOpen() && "2".equals(this.hussarBaseProperties.getTenantUserModel());
            if (tenantFlag) {
                SysUsers users = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
                boolean existAccount = this.sysLoginUserService.validateAccount(sysOrgan.getOrganName());
                if (existAccount) {
                    throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
                }
                this.sysLoginUserService.syncAddUser(users);
            }
        }
        catch (Exception e) {
            String str = "\u4eba\u5458\uff1a" + sysUsers.getUserAccount() + "\u5bf9\u5e94\u7684\u673a\u6784\u6570\u636e\u4e3a\u95ee\u9898\u6570\u636e";
            throw new BaseException(str);
        }
    }

    private void addStaffUserBySnyc(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers) {
        boolean tenantFlag;
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        Integer order = 1;
        Integer maxOrder = this.staffUserMapper.getMaxOrderUnderParent(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            order = maxOrder + 1;
        }
        sysStru.setStruOrder(order);
        this.sysOrganMapper.insert(sysOrgan);
        sysStru.setOrganId(sysOrgan.getId());
        this.sysStruMapper.insert(sysStru);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            sysStaff.setName(sysOrgan.getOrganName());
            sysStaff.setStruId(sysStru.getId());
            this.staffUserMapper.insert(sysStaff);
        }
        if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "site81@95." : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(-1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setEmployeeId(sysStru.getId());
        sysUsers.setTypeProperty("1");
        Integer userOrder = this.sysUsersService.getMaxOrder(sysUsers.getDepartmentId());
        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(userOrder);
        this.sysUsersService.save((Object)sysUsers);
        SysUserRole userRole = new SysUserRole();
        userRole.setUserId(sysUsers.getId());
        userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        userRole.setAdminOption("1");
        userRole.setOutUserId(sysUsers.getOutUserId());
        userRole.setOutOriginId(sysUsers.getOutUserId());
        this.sysUserRoleMapper.insert(userRole);
        boolean bl = tenantFlag = this.hussarBaseProperties.isTenantOpen() && "2".equals(this.hussarBaseProperties.getTenantUserModel());
        if (tenantFlag) {
            SysUsers users = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserName, (Object)sysOrgan.getOrganName()));
            boolean existAccount = this.sysLoginUserService.validateAccount(sysOrgan.getOrganName());
            if (existAccount) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
            this.sysLoginUserService.syncAddUser(users);
        }
    }

    private void initialization(boolean convert, OutsideUserDto userDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers, int num) {
        OutsideUserDto sysUsersOut;
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserCode());
        String userName = StringUtils.trimToEmpty((String)userDto.getRealName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeixin());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getOfficePhone());
        String sex = StringUtils.trimToEmpty((String)String.valueOf(userDto.getGender()));
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdNumber());
        String address = StringUtils.trimToEmpty((String)userDto.getOfficeAddress());
        String workDate = StringUtils.trimToEmpty((String)userDto.getJoinDate());
        String outUserId = StringUtils.trimToEmpty((String)userDto.getId());
        String outUserIdNew = StringUtils.trimToEmpty((String)userDto.getUserCodeNew());
        String avatarUrl = StringUtils.trimToEmpty((String)userDto.getAvatarUrl());
        int isDeleted = userDto.getIsDeleted();
        int jobStatus = userDto.getJobStatus();
        int userTypeCOde = userDto.getUserTypeCode();
        String sortNumber = userDto.getSortNumber();
        String originId = StringUtils.trimToEmpty((String)userDto.getOriginId());
        String email = StringUtils.trimToEmpty((String)userDto.getEmail());
        Long department = null;
        Long company = null;
        try {
            sysUsersOut = (OutsideUserDto)this.sysUsersOutService.getById((Serializable)((Object)outUserId));
        }
        catch (Exception e) {
            String str = "\u4eba\u5458\u4e3b\u6570\u636eid\uff1a" + outUserId + "\u5bf9\u5e94\u7684\u7528\u6237\u6570\u636e\u4e3a\u95ee\u9898\u6570\u636e\uff0c\u9700\u8981\u6309\u6b64id\u53bbsys_users_out\u8868\u4e2d\u6392\u67e5";
            throw new BaseException(str);
        }
        if (userDto.getPositionList() != null && userDto.getPositionList().size() > 0) {
            List struList;
            ArrayList<String> departmenIds = new ArrayList<String>();
            ArrayList<String> companyIds = new ArrayList<String>();
            if (userDto.getUserTypeCode() == 0 || userDto.getUserTypeCode() == 5) {
                for (SysUsersPositionOut sysUsersPositionOut : userDto.getPositionList()) {
                    if (sysUsersPositionOut.getMainPosition() != 1 || sysUsersPositionOut.getEnabled() != 1) continue;
                    departmenIds.add(sysUsersPositionOut.getDepartmentId());
                    companyIds.add(sysUsersPositionOut.getCompanyId());
                }
            } else {
                for (SysUsersPositionOut sysUsersPositionOut : userDto.getPositionList()) {
                    if (sysUsersPositionOut.getMainPosition() != 1 || sysUsersPositionOut.getEnabled() != 1) continue;
                    departmenIds.add(sysUsersPositionOut.getCompanyId());
                    companyIds.add(sysUsersPositionOut.getDepartmentId());
                }
            }
            if ((struList = this.sysStruService.getStruList(departmenIds)).size() <= 0) {
                sysUsersOut.setProcessingState(2);
                if (HussarUtils.isEmpty(departmenIds)) {
                    sysUsersOut.setFailReason("\u4e3b\u5c97\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    sysUsersOut.setFailReason("\u4e3b\u5c97\u7ec4\u7ec7id\u627e\u4e0d\u5230\uff0c\u4e3b\u5c97id\uff1a" + (String)departmenIds.get(0));
                }
                this.sysUsersOutService.updateById((Object)sysUsersOut);
                throw new BaseException(sysUsersOut.getFailReason());
            }
            department = Long.valueOf(String.valueOf(((SysStru)struList.get(0)).getId()));
            String struLevelCode = String.valueOf(((SysStru)struList.get(0)).getLevelCode());
            sysStru.setLevelCode(struLevelCode + num);
            List companyList = this.sysStruService.getStruList(companyIds);
            if (companyList.size() > 0) {
                company = Long.valueOf(String.valueOf(((SysStru)companyList.get(0)).getId()));
            } else {
                sysUsersOut.setProcessingState(2);
                if (HussarUtils.isEmpty(companyIds)) {
                    sysUsersOut.setFailReason("\u4e3b\u5c97\u6240\u5c5e\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    sysUsersOut.setFailReason("\u6240\u5c5e\u5355\u4f4did\u627e\u4e0d\u5230\uff0c\u6240\u5c5e\u5355\u4f4did\uff1a" + (String)companyIds.get(0));
                }
                this.sysUsersOutService.updateById((Object)sysUsersOut);
                throw new BaseException(sysUsersOut.getFailReason());
            }
        }
        if (HussarUtils.isEmpty(department)) {
            sysUsersOut.setProcessingState(2);
            sysUsersOut.setFailReason("\u65e0\u4e3b\u5c97\u4fe1\u606f\u3002");
            this.sysUsersOutService.updateById((Object)sysUsersOut);
            throw new BaseException("\u65e0\u4e3b\u5c97\u4fe1\u606f\u3002");
        }
        if (HussarUtils.isEmpty(company)) {
            sysUsersOut.setProcessingState(2);
            sysUsersOut.setFailReason("\u65e0\u6240\u5c5e\u5355\u4f4d\u4fe1\u606f\u3002");
            this.sysUsersOutService.updateById((Object)sysUsersOut);
            throw new BaseException("\u65e0\u6240\u5c5e\u5355\u4f4d\u4fe1\u606f\u3002");
        }
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setStruType("9");
        sysStru.setOrganAlias(userName);
        sysStru.setIsEmployee("1");
        sysStru.setParentId(department);
        sysStru.setDelFlag(String.valueOf(userDto.getIsDeleted()));
        sysStru.setOutStruId(outUserId);
        sysStru.setDepartmentId(department);
        sysStru.setCompanyId(String.valueOf(company));
        sysStru.setOutEnabled(1);
        int level = 0;
        try {
            SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
            level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
            sysStru.setStruLevel(Integer.valueOf(level));
            Integer orderTree = 1;
            Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                orderTree = maxOrder + 1;
            }
            Integer struOrder = orderTree;
            sysStru.setStruOrder(struOrder);
        }
        catch (Exception e) {
            String str = "\u4eba\u5458\uff1a" + userAccount + "\u5bf9\u5e94\u7684\u673a\u6784\u6570\u636e\u4e3a\u95ee\u9898\u6570\u636e";
            throw new BaseException(str);
        }
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setStruId(Long.valueOf(sysStruId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setWorkDate(workDate);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganName(sysStaff.getName());
        sysOrgan.setOrganType("9");
        sysOrgan.setDelFlag(String.valueOf(userDto.getIsDeleted()));
        String filedName = "ORGAN_CODE_9";
        String currentCode = this.sysIdtableService.getCurrentCode(filedName, "SYS_STRU");
        sysOrgan.setOrganCode(currentCode);
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(-1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        sysUsers.setOutUserId(outUserId);
        sysUsers.setCorporationId(company);
        sysUsers.setDepartmentId(department);
        sysUsers.setAccountStatus(userDto.getIsDeleted() == 0 && userDto.getJobStatus() == 1 || userDto.getIsDeleted() == 0 && userDto.getJobStatus() == 3 ? "1" : "2");
        sysUsers.setAvatarUrl(avatarUrl);
        sysUsers.setUserAccountNew(outUserIdNew);
        sysUsers.setOutIsDeleted(isDeleted);
        sysUsers.setOutJobStatus(jobStatus);
        sysUsers.setOutUserTypeCode(userTypeCOde);
        sysUsers.setOutOriginId(originId);
        sysUsers.setOutSortNumber(sortNumber);
        sysUsers.seteMail(email);
    }
}

