/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.dto.OutsideOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganOutService;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.Error;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addOutsideOrganizationManagerImpl")
public class AddOutsideOrganizationManagerImpl
extends CommonOutsideOrganizationManager
implements AddOutsideOrganizationManager {
    @Autowired
    protected ISysOrganOutService sysOrganOutService;

    @Override
    public R<AddOutsideOrganizationDto> addOrganization(AddOutsideOrganizationDto addOrganizationDto) {
        boolean existType;
        boolean existCode;
        R result = new R();
        List errors = OrganUtil.validateOne((Object)addOrganizationDto);
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganType());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.ne(SysOrgan::getOrganType, (Object)"9");
        lambdaQueryWrapper.eq(SysOrgan::getOrganCode, (Object)organCode);
        boolean bl = existCode = this.organService.count((Wrapper)lambdaQueryWrapper) > 0L;
        if (existCode) {
            OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organCode", (String[])new String[]{"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u91cd\u590d"});
        }
        LambdaQueryWrapper typeLambdaQueryWrapper = new LambdaQueryWrapper();
        typeLambdaQueryWrapper.eq(SysOrganType::getOrganType, (Object)organType);
        boolean bl2 = existType = this.organTypeService.count((Wrapper)typeLambdaQueryWrapper) > 0L;
        if (!existType) {
            OrganUtil.addErrorMsg((List)errors, (Object)addOrganizationDto, (String)"organType", (String[])new String[]{"\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            SysStru sysStru = new SysStru();
            SysOffice sysOffice = new SysOffice();
            SysOrgan sysOrgan = new SysOrgan();
            this.initializationAdd(addOrganizationDto, sysStru, sysOrgan, sysOffice);
            this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
            this.organService.save((Object)sysOrgan);
            this.sysStruMapper.insert(sysStru);
            this.sysOfficeService.save((Object)sysOffice);
            result.setSuccess(true);
            result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
        } else {
            result.setSuccess(false);
            result.setErrorList(errors);
        }
        return result;
    }

    private void initializationAdd(AddOutsideOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        String parentOrganCode = StringUtils.trimToEmpty((String)addOrganizationDto.getParentOrganCode());
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganType());
        String organName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganName());
        String organAlias = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias());
        String userAccount = StringUtils.trimToEmpty((String)addOrganizationDto.getUserAccount());
        String organShortName = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganShortName());
        String organDescription = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganDescription());
        String organAddress = StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAddress());
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        Long parentId = this.getOrganId(parentOrganCode);
        sysStru.setParentId(parentId);
        Long userId = this.getUserId(userAccount);
        sysStru.setPrincipalId(userId);
        sysStru.setStruType(organType);
        sysStru.setOrganAlias(organAlias);
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAddress(organAddress);
        sysOffice.setOfficeAlias(organDescription);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(organCode);
        sysOrgan.setOrganName(organName);
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)organShortName) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)organShortName));
        sysOrgan.setOrganType(organType);
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getOrganAlias()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias()));
        sysOrgan.setOrganCode(organCode);
        sysStru.setIsLeaf("Y");
    }

    @Override
    public OutsideOrganizationDto add(OutsideOrganizationDto organizationDto, List<OutsideOrganizationDto> resultList, List<SysStru> struList, Map<String, List<SysStru>> returnMap, List<SysOrganType> organTypes) {
        try {
            R result = new R();
            List errors = OrganUtil.validateOne((Object)organizationDto);
            String organType = StringUtils.trimToEmpty((String)organizationDto.getCompanyCategoryCode());
            boolean existType = organTypes.stream().anyMatch(o -> o.getOrganType().equals(organType));
            if (!existType) {
                organizationDto.setProcessingState(2);
                organizationDto.setFailReason("\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b");
                OrganUtil.addErrorMsg((List)errors, (Object)organizationDto, (String)"organType", (String[])new String[]{"\u4e0d\u5b58\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b"});
            }
            if (HussarUtils.isEmpty((Object)errors)) {
                SysStru sysStru = new SysStru();
                SysOrgan sysOrgan = new SysOrgan();
                SysOffice sysOffice = new SysOffice();
                String mes = this.initialization(organizationDto, sysStru, sysOrgan, sysOffice, errors, resultList, struList, returnMap);
                if (mes == null) {
                    long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
                    sysStru.setId(Long.valueOf(struIdTemp));
                    this.organService.save((Object)sysOrgan);
                    this.sysStruMapper.insert(sysStru);
                    this.sysOfficeService.save((Object)sysOffice);
                    result.setSuccess(true);
                    result.setSuccessList((List)Lists.newArrayList((Object[])new DataMapping[]{new DataMapping(sysStru.getId(), sysOrgan.getOrganCode())}));
                } else {
                    result.setSuccess(false);
                    result.setErrorList(errors);
                }
            } else {
                result.setSuccess(false);
                result.setErrorList(errors);
            }
            if (!result.isSuccess()) {
                organizationDto.setProcessingState(2);
                organizationDto.setFailReason(String.valueOf(((Error)result.getErrorList().get(0)).getErrMsg()));
            } else {
                organizationDto.setProcessingState(1);
            }
        }
        catch (Exception e) {
            organizationDto.setProcessingState(2);
            organizationDto.setFailReason(e.getMessage());
        }
        return organizationDto;
    }

    private String initialization(OutsideOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice, List<Error<OutsideOrganizationDto>> errors, List<OutsideOrganizationDto> resultList, List<SysStru> struList, Map<String, List<SysStru>> returnMap) {
        Long stId;
        String outId = StringUtils.trimToEmpty((String)addOrganizationDto.getId());
        String outParentId = StringUtils.trimToEmpty((String)addOrganizationDto.getParentId());
        String organCode = StringUtils.trimToEmpty((String)addOrganizationDto.getCode());
        String organType = StringUtils.trimToEmpty((String)addOrganizationDto.getCompanyCategoryCode());
        String organName = StringUtils.trimToEmpty((String)addOrganizationDto.getName());
        String organAlias = StringUtils.trimToEmpty((String)addOrganizationDto.getAlias());
        String userAccount = StringUtils.trimToEmpty(null);
        String organShortName = StringUtils.trimToEmpty((String)addOrganizationDto.getAlias());
        String organDescription = StringUtils.trimToEmpty((String)addOrganizationDto.getRemark());
        String companyId = StringUtils.trimToEmpty((String)addOrganizationDto.getCompanyId());
        String path = StringUtils.trimToEmpty((String)addOrganizationDto.getPath());
        String pathName = StringUtils.trimToEmpty((String)addOrganizationDto.getPathName());
        String levelCode = StringUtils.trimToEmpty((String)addOrganizationDto.getLevelCode());
        int enabled = addOrganizationDto.getEnabled();
        int level = addOrganizationDto.getLayer();
        int isVirtual = addOrganizationDto.getIsVirtual();
        String originId = StringUtils.trimToEmpty((String)addOrganizationDto.getOriginId());
        String projectStatusId = StringUtils.trimToEmpty((String)addOrganizationDto.getProjectStatusId());
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        List<SysStru> sysStruList = returnMap.get(addOrganizationDto.getId());
        long sysStruId = CollectionUtils.isEmpty(sysStruList) ? (addOrganizationDto.getStruId() != null ? addOrganizationDto.getStruId() : IdWorker.getId((Object)sysStru)) : sysStruList.get(0).getParentId();
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        if (outParentId == null || "".equals(outParentId)) {
            sysStru.setParentId(Long.valueOf(11L));
        } else {
            stId = this.getSysStru(outParentId, resultList, struList);
            if (HussarUtils.isEmpty((Object)stId)) {
                OrganUtil.addErrorMsg(errors, (Object)addOrganizationDto, (String)"parentStru", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f"});
                return "\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f";
            }
            sysStru.setParentId(stId);
        }
        if (companyId != null && !"".equals(companyId)) {
            stId = this.getSysStru(companyId, resultList, struList);
            if (HussarUtils.isEmpty((Object)stId)) {
                OrganUtil.addErrorMsg(errors, (Object)addOrganizationDto, (String)"companyId", (String[])new String[]{"\u672a\u67e5\u8be2\u5230\u6240\u5c5e\u673a\u6784\u4fe1\u606f"});
                return "\u672a\u67e5\u8be2\u5230\u6240\u5c5e\u673a\u6784\u4fe1\u606f";
            }
            sysStru.setCompanyId(String.valueOf(stId));
        }
        Long userId = this.getUserId(userAccount);
        sysStru.setPrincipalId(userId);
        sysStru.setStruType(organType);
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAlias(organDescription);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(organCode);
        sysOrgan.setOrganName(organName);
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)organShortName) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)organShortName));
        sysOrgan.setOrganType(organType);
        sysOrgan.setDelFlag(String.valueOf(addOrganizationDto.getIsDeleted()));
        sysOrgan.setBeginDate(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        sysOrgan.setEndDate("2099-12-30");
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getAlias()) ? sysOrgan.getOrganName() : organAlias);
        sysStru.setIsLeaf("0");
        sysStru.setDelFlag(String.valueOf(addOrganizationDto.getIsDeleted()));
        sysStru.setOutStruId(outId);
        sysStru.setPath(path);
        sysStru.setPathName(pathName);
        sysStru.setLevelCode(levelCode);
        sysStru.setOutEnabled(enabled);
        sysStru.setIsVirtual(isVirtual);
        sysStru.setOutOriginId(originId);
        sysStru.setOutProjectStatusId(projectStatusId);
        return null;
    }

    public Long getSysStru(String outId, List<OutsideOrganizationDto> resultList, List<SysStru> struList) {
        List list = struList.stream().filter(item -> outId.equals(item.getOutStruId())).collect(Collectors.toList());
        List parentList = resultList.stream().filter(item -> outId.equals(item.getId())).collect(Collectors.toList());
        if (list != null && list.size() > 0) {
            return ((SysStru)list.get(0)).getId();
        }
        if (parentList != null && parentList.size() > 0) {
            return ((OutsideOrganizationDto)parentList.get(0)).getStruId();
        }
        return null;
    }
}

