/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.organ.dto.AddOrganizationDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addOrganizationManagerImpl")
public class AddOrganizationManagerImpl
extends CommonOrganizationManager
implements AddOrganizationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddOrganizationManagerImpl.class);

    @Override
    public ApiResponse<Long> addOrganization(AddOrganizationDto addOrganizationDto) {
        String validateMsg = this.validateService.validate((Object)addOrganizationDto);
        AssertUtil.isEmpty((String)validateMsg, (String)validateMsg);
        String organCode = addOrganizationDto.getOrganCode();
        if (HussarUtils.isNotBlank((CharSequence)organCode)) {
            boolean flag;
            boolean bl = flag = !organCode.contains("/") && organCode.length() < 33;
            if (!flag) {
                LOGGER.warn("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801:{}\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/,\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732", (Object)organCode);
                return ApiResponse.fail((String)"\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26/,\u4e14\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc732");
            }
        }
        SysStru sysStru = new SysStru();
        SysOffice sysOffice = new SysOffice();
        SysOrgan sysOrgan = new SysOrgan();
        this.initialization(addOrganizationDto, sysStru, sysOrgan, sysOffice);
        this.parentOrganizationAuditDataExists(addOrganizationDto.getParentId());
        this.wrapAddOrgan(sysStru, sysOrgan);
        this.beforeAddOrganization(sysStru, sysOrgan, sysOffice);
        String result = this.processAuditIfNecessary(sysStru, sysOrgan, sysOffice);
        this.afterAddOrganization(sysStru, sysOrgan, sysOffice);
        return ApiResponse.success((Object)sysStru.getId(), (String)result);
    }

    @Override
    public void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan) {
        LOGGER.debug("\u586b\u5145\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u7801\u76f8\u5173\u5b57\u6bb5");
        this.wrapAddOrgan(sysStru, sysOrgan, true);
    }

    @Override
    public void wrapAddOrgan(SysStru sysStru, SysOrgan sysOrgan, boolean updateStruSeq) {
        String organFcode = "/" + sysOrgan.getOrganCode();
        String organFname = "/" + sysOrgan.getOrganName();
        long struIdTemp = HussarUtils.isEmpty((Object)sysStru.getId()) ? IdWorker.getId((Object)sysStru) : sysStru.getId();
        String struFid = "/" + struIdTemp;
        String pSeq = "";
        String pFid = "/";
        int level = sysStru.getStruLevel();
        if (level > 1) {
            boolean needAudit;
            SysStru pSysStru = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
            SysOrgan pSysOrgan = (SysOrgan)this.sysOrganMapper.selectById(pSysStru.getOrganId());
            pSeq = pSysStru.getStruSeq();
            pFid = pSysStru.getStruFid();
            sysOrgan.setParentTypeCode(pSysOrgan.getOrganType());
            organFcode = pSysOrgan.getOrganFcode() + organFcode;
            struFid = pFid + struFid;
            organFname = pSysOrgan.getOrganFname() + organFname;
            boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
            if (!sysOrgan.getOrganType().equals("9") && !needAudit) {
                pSysStru.setIsLeaf("N");
                this.sysStruMapper.updateById(pSysStru);
            }
        }
        if (updateStruSeq) {
            if (!sysOrgan.getOrganType().equals("9")) {
                sysStru.setStruSeq(this.getStruSeq(pFid, pSeq, level));
            } else {
                sysStru.setStruSeq(pSeq);
            }
        }
        sysOrgan.setOrganFcode(OrganUtil.convert((String)organFcode));
        sysOrgan.setOrganFname(organFname);
        sysStru.setId(Long.valueOf(struIdTemp));
        sysStru.setStruFid(OrganUtil.convert((String)struFid));
        sysStru.setStruLevel(Integer.valueOf(sysStru.getStruFid().split("/").length - 1));
        LambdaQueryWrapper sysOrganTypeLambdaQueryWrapper = new LambdaQueryWrapper();
        sysOrganTypeLambdaQueryWrapper.eq(SysOrganType::getCompanyType, (Object)"0");
        List types = this.sysOrganTypeService.list((Wrapper)sysOrganTypeLambdaQueryWrapper).stream().map(SysOrganType::getOrganType).collect(Collectors.toList());
        String[] ids = OrganUtil.convert((String)struFid).split("/");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.in(SysStru::getId, Arrays.asList(ids))).orderByDesc(SysStru::getStruFid);
        List list = this.sysStruService.list((Wrapper)queryWrapper);
        String companyId = "";
        Optional<SysStru> first = list.stream().filter(a -> types.contains(a.getStruType())).findFirst();
        if (first.isPresent()) {
            companyId = String.valueOf(first.get().getId());
        }
        sysStru.setCompanyId(companyId);
    }

    private String processAuditIfNecessary(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        boolean needAudit;
        LOGGER.info("\u5224\u65ad\u9700\u4e0d\u9700\u8981\u5ba1\u6838,\u5982\u679c\u9700\u8981\u5ba1\u6838\uff0c\u5219\u5148\u52a0\u5165\u5ba1\u6838\u8868");
        String msg = "\u65b0\u589e\u6210\u529f\uff01";
        boolean bl = needAudit = this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit();
        if (needAudit) {
            Set organIds;
            List sysStruAuditList;
            LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u9700\u8981\u5ba1\u6838");
            List sysOrganAuditList = this.sysOrganAuditService.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganAudit::getOrganCode, (Object)sysOrgan.getOrganCode()));
            if (HussarUtils.isNotEmpty((Object)sysOrganAuditList) && HussarUtils.isNotEmpty((Object)(sysStruAuditList = this.sysStruAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruAudit::getOrganId, organIds = sysOrganAuditList.stream().map(SysOrganAudit::getId).collect(Collectors.toSet()))).eq(SysStruAudit::getState, (Object)"0"))))) {
                throw new BaseException("\u5f85\u5ba1\u6838\u6570\u636e\u4e2d\u5b58\u5728\u91cd\u590d\u7f16\u7801");
            }
            this.auditAdd(sysOrgan, sysStru, null, sysOffice, "1");
            msg = "\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u4e0d\u9700\u8981\u5ba1\u6838");
            this.sysOrganMapper.insert(sysOrgan);
            this.sysStruMapper.insert(sysStru);
            if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                this.sysOfficeService.saveOrUpdate((Object)sysOffice);
            }
        }
        return msg;
    }

    private void beforeAddOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u65b0\u589e\u524d\u7684\u65b9\u6cd5");
        this.sysOrgEventService.beforeAdd(sysStru, sysOrgan, sysOffice);
    }

    private void afterAddOrganization(SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.debug("\u8c03\u7528\u7ec4\u7ec7\u673a\u6784\u65b0\u589e\u540e\u7684\u65b9\u6cd5");
        this.sysOrgEventService.afterAdd(sysStru, sysOrgan, sysOffice);
    }

    private void initialization(AddOrganizationDto addOrganizationDto, SysStru sysStru, SysOrgan sysOrgan, SysOffice sysOffice) {
        LOGGER.info("\u6839\u636eAddOrganizationDto\u521d\u59cb\u5316SysStru,SysOrgan,SysOffice,\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)addOrganizationDto));
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysOfficeId = IdWorker.getId((Object)sysOffice);
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(addOrganizationDto.getParentId());
        sysStru.setPrincipalId(addOrganizationDto.getPrincipalId());
        sysStru.setStruType(addOrganizationDto.getStruType());
        sysStru.setPrincipalId(addOrganizationDto.getPrincipalId());
        int level = 0;
        SysStru temp = (SysStru)this.sysStruMapper.selectById(sysStru.getParentId());
        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer orderTree = 1;
        Integer maxOrder = this.sysStruMapper.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1;
        }
        Integer struOrder = orderTree;
        sysStru.setStruOrder(struOrder);
        sysOffice.setId(Long.valueOf(sysOfficeId));
        sysOffice.setStruId(Long.valueOf(sysStruId));
        sysOffice.setOfficeAddress(StringUtils.trimToEmpty((String)addOrganizationDto.getOfficeAddress()));
        sysOffice.setOfficeAlias(StringUtils.trimToEmpty((String)addOrganizationDto.getOfficeAlias()));
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganCode(StringUtils.trimToEmpty((String)addOrganizationDto.getOrganCode()));
        sysOrgan.setOrganName(StringUtils.trimToEmpty((String)addOrganizationDto.getOrganName()));
        sysOrgan.setShortName(HussarUtils.isBlank((CharSequence)addOrganizationDto.getShortName()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getShortName()));
        sysOrgan.setOrganType(addOrganizationDto.getStruType());
        sysOrgan.setOrganAlias(addOrganizationDto.getOrganAlias());
        sysStru.setOrganAlias(HussarUtils.isBlank((CharSequence)addOrganizationDto.getOrganAlias()) ? sysOrgan.getOrganName() : StringUtils.trimToEmpty((String)addOrganizationDto.getOrganAlias()));
        String newCode = this.getCode(sysOrgan);
        sysOrgan.setOrganCode(newCode);
        sysStru.setIsLeaf("Y");
        sysStru.setOutStruId(String.valueOf(sysStruId));
        sysStru.setOutOriginId(String.valueOf(sysStruId));
        sysStru.setOutEnabled(1);
    }

    private void parentOrganizationAuditDataExists(Long parentId) {
        LOGGER.info("\u5224\u65ad\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u6240\u5728\u7684\u7236\u7ec4\u7ec7\u673a\u6784{}\u662f\u5426\u5b58\u5728\u5ba1\u6838\u6570\u636e", (Object)parentId);
        if (!this.sysStruAuditService.checkCanOperate(parentId)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01(\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01)");
        }
    }
}

