/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.manager.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.dto.AddOutsideUserDto;
import com.jxdinfo.hussar.authorization.organ.manager.AddBatchOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.manager.impl.CommonOutsideUserManager;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.util.OrganUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.common.base.DataMapping;
import com.jxdinfo.hussar.common.base.R;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.LinkedMultiValueMap;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.authorization.organ.manager.impl.addBatchOutsideUserManagerImpl")
public class AddBatchOutsideUserManagerImpl
extends CommonOutsideUserManager
implements AddBatchOutsideUserManager {
    @Resource
    private IHussarBaseTenantService hussarBaseTenantService;

    @Override
    public R<AddOutsideUserDto> addBatchUsers(List<AddOutsideUserDto> users, boolean dealWithSelf) {
        boolean canAdd = false;
        if (HussarUtils.isNotEmpty(users) && users.size() <= 50) {
            canAdd = true;
        }
        if (!canAdd) {
            throw new BaseException("\u6279\u91cf\u64cd\u4f5c\u6700\u591a\u53ea\u5141\u8bb8\u4e00\u6b21\u64cd\u4f5c50");
        }
        R result = new R();
        List errors = OrganUtil.validateMany(users);
        boolean getLoginUpperOpen = this.hussarLoginConfigService.getLoginUpperOpen();
        for (AddOutsideUserDto user : users) {
            String userAccount = StringUtils.trimToEmpty((String)user.getUserAccount());
            boolean convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(userAccount);
            if (!this.duplicateUserAccount(convert, user, users)) continue;
            OrganUtil.addErrorMsg((List)errors, (Object)user, (String)"userAccount", (String[])new String[]{"\u7528\u6237\u8d26\u53f7\u91cd\u590d"});
        }
        if (HussarUtils.isEmpty((Object)errors)) {
            result.setSuccess(true);
            result.setErrorList(null);
        } else {
            result.setErrorList(errors);
            result.setSuccess(false);
        }
        if (result.isSuccess()) {
            Map<String, List<AddOutsideUserDto>> mapByTenantCode = users.stream().collect(Collectors.groupingBy(AddOutsideUserDto::getTenantCode));
            for (Map.Entry<String, List<AddOutsideUserDto>> tenantCodeEntry : mapByTenantCode.entrySet()) {
                String tenantCode = tenantCodeEntry.getKey();
                HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
                String connName = null != tenant && null != tenant.getConnName() && !"".equals(tenant.getConnName()) ? tenant.getConnName() : "master";
                List<AddOutsideUserDto> insertList = tenantCodeEntry.getValue();
                ArrayList<DataMapping> dataMappings = new ArrayList<DataMapping>();
                LinkedHashSet<SysStru> sysStruCollection = new LinkedHashSet<SysStru>();
                LinkedHashSet<SysOrgan> sysOrganCollection = new LinkedHashSet<SysOrgan>();
                LinkedHashSet<SysStaff> sysStaffCollection = new LinkedHashSet<SysStaff>();
                LinkedHashSet<SysUsers> sysUsersCollection = new LinkedHashSet<SysUsers>();
                LinkedHashSet<SysUserRole> sysUserRoleCollection = new LinkedHashSet<SysUserRole>();
                LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
                for (AddOutsideUserDto user : insertList) {
                    multiValueMap.add((Object)user.getDepartmentId(), (Object)user);
                }
                for (Map.Entry entry : multiValueMap.entrySet()) {
                    Long departmentId = (Long)entry.getKey();
                    List children = (List)entry.getValue();
                    for (AddOutsideUserDto userDto : children) {
                        SysStru sysStru = new SysStru();
                        SysStaff sysStaff = new SysStaff();
                        SysOrgan sysOrgan = new SysOrgan();
                        SysUsers sysUsers = new SysUsers();
                        SysUserRole sysUserRole = new SysUserRole();
                        int level = 0;
                        SysStru temp = (SysStru)this.sysStruService.getById((Serializable)departmentId);
                        level = HussarUtils.isEmpty((Object)temp) ? 1 : temp.getStruLevel() + 1;
                        Integer orderTree = 1;
                        Integer maxOrder = this.sysStruMapper.getMaxOrderById(departmentId);
                        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                            orderTree = maxOrder + 1;
                        }
                        Integer struOrder = orderTree;
                        Integer userOrder = this.sysUsersService.getMaxOrder(departmentId);
                        userOrder = ToolUtil.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
                        this.initializationAdd(dealWithSelf, getLoginUpperOpen, level, struOrder, userOrder, userDto, sysStru, sysOrgan, sysStaff, sysUsers);
                        this.addOrganizationManager.wrapAddOrgan(sysStru, sysOrgan);
                        this.addStaffUser(sysStru, sysOrgan, sysStaff, sysUsers, sysUserRole);
                        sysStruCollection.add(sysStru);
                        sysOrganCollection.add(sysOrgan);
                        sysStaffCollection.add(sysStaff);
                        sysUsersCollection.add(sysUsers);
                        sysUserRoleCollection.add(sysUserRole);
                        dataMappings.add(new DataMapping(sysUsers.getId(), sysUsers.getUserAccount()));
                    }
                }
                result.setSuccessList(dataMappings);
                this.sysStruService.saveBatchForTenant(connName, sysStruCollection);
                this.sysOrganService.saveBatchForTenant(connName, sysOrganCollection);
                this.sysStaffService.saveBatchForTenant(connName, sysStaffCollection);
                this.sysUsersService.saveBatchForTenant(connName, sysUsersCollection);
                this.userRoleService.saveBatchForTenant(connName, sysUserRoleCollection);
            }
        }
        return result;
    }

    private void addStaffUser(SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers, SysUserRole sysUserRole) {
        sysStru.setOrganAlias(sysOrgan.getOrganName());
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        sysStru.setOrganId(sysOrgan.getId());
        sysStaff.setName(sysOrgan.getOrganName());
        sysStaff.setStruId(sysStru.getId());
        if (StringUtils.isBlank((CharSequence)sysUsers.getPassword())) {
            String pass = "";
            pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "site81@95." : this.pwdConfigService.getDefaultPassword();
            String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
            sysUsers.setPassword(pwd);
        }
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setLoginIpLimit("0");
        sysUsers.setLoginTimeLimit("0");
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setCorporationId(sysStru.getParentId());
        sysUsers.setDepartmentId(sysStru.getParentId());
        sysUsers.setEmployeeId(sysStru.getId());
        sysUsers.setTypeProperty("1");
        sysUserRole.setUserId(sysUsers.getId());
        sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
        sysUserRole.setAdminOption("1");
    }

    private void initializationAdd(boolean dealWithSelf, boolean getLoginUpperOpen, int level, Integer struOrder, Integer userOrder, AddOutsideUserDto userDto, SysStru sysStru, SysOrgan sysOrgan, SysStaff sysStaff, SysUsers sysUsers) {
        boolean convert;
        long sysStruId = IdWorker.getId((Object)sysStru);
        long sysOrganId = IdWorker.getId((Object)sysOrgan);
        long sysStaffId = IdWorker.getId((Object)sysStaff);
        long sysUserId = IdWorker.getId((Object)sysUsers);
        Long departmentId = userDto.getDepartmentId();
        String userAccount = StringUtils.trimToEmpty((String)userDto.getUserAccount());
        String userName = StringUtils.trimToEmpty((String)userDto.getUserName());
        String weChat = StringUtils.trimToEmpty((String)userDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)userDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)userDto.getTelephone());
        String staffPosition = StringUtils.trimToEmpty((String)userDto.getStaffPosition());
        String sex = StringUtils.trimToEmpty((String)userDto.getSex());
        String birthday = StringUtils.trimToEmpty((String)userDto.getBirthday());
        String idcard = StringUtils.trimToEmpty((String)userDto.getIdcard());
        String address = StringUtils.trimToEmpty((String)userDto.getAddress());
        String workId = StringUtils.trimToEmpty((String)userDto.getWorkId());
        String workDate = StringUtils.trimToEmpty((String)userDto.getWorkDate());
        String graduateDate = StringUtils.trimToEmpty((String)userDto.getGraduateDate());
        String graduateSchool = StringUtils.trimToEmpty((String)userDto.getGraduateSchool());
        String secure = StringUtils.trimToEmpty((String)userDto.getSecure());
        boolean bl = convert = !getLoginUpperOpen && !OrganConstants.EXCLUDE_USERS.contains(userAccount);
        if (convert) {
            userAccount = userAccount.toUpperCase();
        }
        sysStru.setId(Long.valueOf(sysStruId));
        sysStru.setOrganId(Long.valueOf(sysOrganId));
        sysStru.setParentId(departmentId);
        sysStru.setStruType("9");
        sysStru.setOrganAlias(userName);
        sysStru.setStaffPosition(staffPosition);
        sysStru.setIsEmployee("1");
        sysStru.setStruLevel(Integer.valueOf(level));
        Integer n = struOrder;
        Integer n2 = struOrder = Integer.valueOf(struOrder + 1);
        sysStru.setStruOrder(n);
        sysStaff.setId(Long.valueOf(sysStaffId));
        sysStaff.setStruId(Long.valueOf(sysStruId));
        sysStaff.setName(userName);
        sysStaff.setAddress(address);
        sysStaff.setBirthday(birthday);
        sysStaff.setSex(sex);
        sysStaff.setIdcard(idcard);
        sysStaff.setGraduateDate(graduateDate);
        sysStaff.setGraduateSchool(graduateSchool);
        sysStaff.setWorkDate(workDate);
        sysStaff.setWorkId(workId);
        sysOrgan.setId(Long.valueOf(sysOrganId));
        sysOrgan.setOrganName(sysStaff.getName());
        sysOrgan.setOrganType("9");
        String newCode = this.getCode();
        sysOrgan.setOrganCode(newCode);
        sysUsers.setId(Long.valueOf(sysUserId));
        sysUsers.setSecurityLevel(Integer.valueOf(1));
        sysUsers.setIsSys("0");
        sysUsers.setIsCpublic("0");
        sysUsers.setMaxSessions(Integer.valueOf(1));
        sysUsers.setUserAccount(convert ? userAccount.toUpperCase() : userAccount);
        sysUsers.setUserName(userName);
        sysUsers.setWeChat(weChat);
        sysUsers.setMobile(mobile);
        sysUsers.setTelephone(telephone);
        if (dealWithSelf) {
            sysUsers.setPassword(secure);
        }
        n2 = userOrder;
        Integer n3 = userOrder = Integer.valueOf(userOrder + 1);
        sysUsers.setUserOrder(n2);
    }

    private boolean duplicateUserAccount(boolean convert, AddOutsideUserDto user, List<AddOutsideUserDto> users) {
        if (HussarUtils.isNotEmpty(users)) {
            for (AddOutsideUserDto dto : users) {
                if (dto == user) break;
                if (dto == user || !dto.getUserAccount().trim().equals(user.getUserAccount().trim())) continue;
                return true;
            }
        }
        String userAccount = StringUtils.trimToEmpty((String)user.getUserAccount());
        if (convert) {
            userAccount = userAccount.toUpperCase();
        }
        return this.existUser(userAccount);
    }
}

