/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.appuserecord.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.appuserecord.model.AppUseRecordModel;
import com.jxdinfo.hussar.authorization.appuserecord.service.AppUseRecordService;
import com.jxdinfo.hussar.authorization.appuserecord.vo.AppUseRecordVo;
import com.jxdinfo.hussar.authorization.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.authorization.post.model.SysUserPostConcurrently;
import com.jxdinfo.hussar.authorization.post.service.ISysPostService;
import com.jxdinfo.hussar.authorization.post.service.UserPostConcurrentlyService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import io.swagger.annotations.Api;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e94\u7528\u4f7f\u7528\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/appUseRecord"})
public class AppUseRecordController
extends HussarBaseController<AppUseRecordModel, AppUseRecordService> {
    @Resource
    private AppUseRecordService appUseRecordService;
    @Resource
    private ISysPostService sysPostService;
    @Resource
    private UserPostConcurrentlyService userPostConcurrentlyService;

    @PostMapping(value={"/saveRecord"})
    public ApiResponse viewUpdate(@RequestBody AppUseRecordModel appUseRecordModel) {
        boolean result = true;
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        String cacheId = securityUser.getUserId() + "-" + appUseRecordModel.getAppId();
        AppUseRecordModel appCache = (AppUseRecordModel)HussarCacheUtil.get((String)"recordCache", (Object)cacheId, AppUseRecordModel.class);
        if (HussarUtils.isNotEmpty((Object)appCache)) {
            appCache.setClickNumber(Integer.valueOf(appCache.getClickNumber() + 1));
            HussarCacheUtil.put((String)"recordCache", (Object)cacheId, (Object)appCache);
        } else {
            AppUseRecordModel app = this.appUseRecordService.selectUserRecord(securityUser.getUserId(), appUseRecordModel.getAppId());
            if (HussarUtils.isEmpty((Object)app)) {
                appUseRecordModel.setClickNumber(Integer.valueOf(1));
                appUseRecordModel.setCreateTime(LocalDateTime.now());
                appUseRecordModel.setUserId(securityUser.getUserId());
                appUseRecordModel.setCreator(securityUser.getUserId());
                appUseRecordModel.setLastTime(LocalDateTime.now());
                result = this.appUseRecordService.save((Object)appUseRecordModel);
            }
            String cache = securityUser.getUserId() + "-" + appUseRecordModel.getAppId();
            HussarCacheUtil.put((String)"recordCache", (Object)cache, (Object)app);
        }
        if (!result) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"/selectUseList"})
    public ApiResponse selectUseList() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long userId = securityUser.getUserId();
        List list = new ArrayList();
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        assert (currentUser != null);
        if (currentUser.getRolesList().contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
            list = this.appUseRecordService.selectUseListAdmin(userId);
        } else {
            Long positionId;
            List roleIds = ConstantFactory.me().getRolesIdByShiroUser(currentUser);
            Long l = positionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrent")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrent")));
            if (ToolUtil.isNotEmpty(positionId)) {
                Long mainPositionId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postMain")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postMain")));
                Long struId = null;
                if (!positionId.equals(mainPositionId)) {
                    Long currentId = ToolUtil.isEmpty((Object)currentUser.getExtendUserMap("postCurrentId")) ? null : Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrentId")));
                    SysUserPostConcurrently userPostConcurrently = (SysUserPostConcurrently)this.userPostConcurrentlyService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUserPostConcurrently::getUpId, (Object)currentId));
                    if (ToolUtil.isNotEmpty((Object)userPostConcurrently)) {
                        struId = userPostConcurrently.getUpStruId();
                    }
                } else {
                    struId = currentUser.getDeptId();
                }
                List roleId = this.sysPostService.getRoleIdByPostAndStru(positionId, struId);
                roleIds.addAll(roleId);
            }
            list = HussarUtils.isNotEmpty((Object)currentUser.getExtendUserMap("postCurrent")) ? this.appUseRecordService.selectUseList(userId, Long.valueOf(String.valueOf(currentUser.getExtendUserMap("postCurrent"))), roleIds) : this.appUseRecordService.selectUseList(userId, null, roleIds);
        }
        for (AppUseRecordVo appUseRecordVo : list) {
            String cacheKey = userId + "-" + appUseRecordVo.getAppId();
            AppUseRecordModel appCache = (AppUseRecordModel)HussarCacheUtil.get((String)"recordCache", (Object)cacheKey, AppUseRecordModel.class);
            if (!HussarUtils.isNotEmpty((Object)appCache)) continue;
            appUseRecordVo.setClickNumber(appCache.getClickNumber());
        }
        List newList = list.stream().sorted(Comparator.comparing(AppUseRecordVo::getClickNumber).reversed()).collect(Collectors.toList());
        return ApiResponse.success(newList);
    }
}

