/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.audit.dao.SysStruAuditMapper;
import com.jxdinfo.hussar.authorization.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dao.SysGetBackPasswordMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysPasswordHistMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserProxyMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RepeatPwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResetPwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.SelfInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.UpdatePwdDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserQueryReqDto;
import com.jxdinfo.hussar.authorization.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUserProxy;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.authorization.permit.vo.SysUsersVo;
import com.jxdinfo.hussar.authorization.permit.vo.UpdateInfoVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrgVo;
import com.jxdinfo.hussar.authorization.sysuserip.dao.SysUserIpMapper;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.core.encrypt.CryptoUtil;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"springContextHolder"})
public class SysUsersServiceImpl
extends HussarServiceImpl<SysUsersMapper, SysUsers>
implements ISysUsersService {
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private SysGetBackPasswordMapper sysGetBackPasswordMapper;
    @Resource
    private SysPasswordHistMapper sysPasswordHistMapper;
    @Resource
    private SysUserProxyMapper sysUserProxyMapper;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private IGlobalService globalService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private ISysUserIpService iSysUserIpService;
    @Resource
    private ISysUserIpAuditService iSysUserIpAuditService;
    @Resource
    private SysUserIpMapper sysUserIpMapper;
    @Resource
    private ISysConfRolesService iSysConfRolesService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private SysStruAuditMapper sysStruAuditMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    @Lazy
    private SysLoginUserService sysLoginUserService;
    @Resource
    @Lazy
    private ISysUsersAuditService iSysUsersAuditService;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;
    @Resource
    private ISysStruAuditService iSysStruAuditService;
    @Resource
    private ISysOrganTypeService organTypeService;
    @Resource
    private ISysBaseConfigService sysBaseConfigService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;

    private void insertAndUpdateUserRoleAudit(List<Long> roleIds, List<SysUserroleAudit> auditList, Long userId, String operationType) {
        ArrayList<SysUserroleAudit> updateAuditList = new ArrayList<SysUserroleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<SysUserroleAudit> addAuditList = new ArrayList<SysUserroleAudit>();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Long account = ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser()) ? BaseSecurityUtil.getUser().getId() : null;
        for (Long roleId : roleIds) {
            boolean isExist = false;
            for (SysUserroleAudit sysUserroleAudit : auditList) {
                if (!roleId.equals(sysUserroleAudit.getRoleId())) continue;
                isExist = true;
                updateAuditList.add(sysUserroleAudit);
                break;
            }
            if (isExist) continue;
            SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
            sysUserroleAudit.setUserId(userId);
            sysUserroleAudit.setRoleId(roleId);
            sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
            sysUserroleAudit.setOperationType(operationType);
            addAuditList.add(sysUserroleAudit);
        }
        if (updateAuditList.size() > 0) {
            updateMap.put("userId", userId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("lastTime", currentDate);
            updateMap.put("lastEditor", account);
            updateMap.put("updateAuditList", updateAuditList);
            this.sysUserroleAuditMapper.updateAuditBatch(updateMap);
        }
        if (addAuditList.size() > 0) {
            this.sysUserroleAuditService.saveBatch(addAuditList);
        }
    }

    public ApiResponse changeOrg(Map<String, Object> map) {
        String userId = map.get("userId").toString();
        Long corporationId = Long.valueOf(map.get("corporationId").toString());
        String permitId = map.get("permitId").toString();
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById((Serializable)((Object)userId));
        sysUsers.setCorporationId(corporationId);
        sysUsers.setDepartmentId(corporationId);
        sysUsers.setPermissionStruId(Long.valueOf(permitId));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsers);
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("3");
            if (this.sysUsersAuditMapper.insert(sysUsersAudit) == 1) {
                return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
            return ApiResponse.fail((String)"\u8f6c\u79fb\u5931\u8d25\uff01");
        }
        if (this.sysUsersMapper.updateById(sysUsers) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
            return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01");
        }
        return ApiResponse.fail((String)"\u8f6c\u79fb\u5931\u8d25\uff01");
    }

    public boolean isExistAccount(String userAccount) {
        boolean flag = false;
        List<Map<String, Object>> result = this.sysUsersMapper.isExistAccount(userAccount);
        if (result.size() > 0) {
            flag = true;
        }
        return flag;
    }

    @DSTransactional
    public ArrayList<Object> getUserInfo(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(userId);
        List userRole = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)UserStatus.OK.getCode()));
        List userProxy = this.sysUserProxyMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserProxy::getUserId, (Object)userId));
        List byProxy = this.sysUserProxyMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserProxy::getProxyUserId, (Object)userId));
        List userIps = this.iSysUserIpService.selectUserIp(userId);
        StringBuilder ips = new StringBuilder();
        String ipsStr = "";
        if (userIps != null && userIps.size() > 0) {
            for (String sysUserIp : userIps) {
                ips.append(sysUserIp);
                ips.append(",");
            }
            ipsStr = ips.toString();
            ipsStr = ipsStr.substring(0, ipsStr.length() - 1);
        }
        if (user != null) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            boolean isNotRedis = this.sysBaseConfigService.isNotRedis();
            String cacheKey = null;
            for (String s : keyList) {
                cacheKey = isNotRedis ? s : s.substring(s.lastIndexOf("::") + 2);
                UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)cacheKey);
                if (model == null || model.getLockTime() == null || !String.valueOf(user.getId()).equals(cacheKey)) continue;
                user.setAccountStatus(UserStatus.LOCKED.getCode());
            }
        }
        user.setPassword("");
        result.add(user);
        result.add(userRole);
        result.add(userProxy);
        result.add(byProxy);
        result.add(userIps);
        result.add(ipsStr);
        return result;
    }

    @DSTransactional
    public IPage<UserOrgVo> getUserInfoList(Page<UserOrgVo> page, UserQueryReqDto userQueryReqDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (currentUser.isGradeadmin()) {
            SysStru currentNodeStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)userQueryReqDto.getDepStruId()));
            SysStru sysStru = (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getId, (Object)currentUser.getDeptId()));
            if (sysStru == null || currentNodeStru == null || currentNodeStru.getStruLevel().intValue() < sysStru.getStruLevel().intValue() || currentNodeStru.getStruLevel().intValue() == sysStru.getStruLevel().intValue() && !currentNodeStru.getId().equals(sysStru.getId())) {
                return page;
            }
        }
        ArrayList depStruIdList = Lists.newArrayList();
        if (ToolUtil.isNotEmpty((Object)userQueryReqDto.getDepStruId())) {
            depStruIdList.add(userQueryReqDto.getDepStruId());
        }
        userQueryReqDto.setUserDepStruIdList((List)depStruIdList);
        if ("0".equals(userQueryReqDto.getUserStatus()) || ADD.equals(userQueryReqDto.getUserStatus())) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            boolean flag = this.sysBaseConfigService.isNotRedis();
            ArrayList<Long> lockUserIds = new ArrayList<Long>();
            userQueryReqDto.setLockUserIds(lockUserIds);
            Object[] arr = new String[]{"0", ADD};
            if (userQueryReqDto.getUserStatus() != null && ArrayUtils.contains((Object[])arr, (Object)userQueryReqDto.getUserStatus()) && CollectionUtils.isNotEmpty((Collection)keyList)) {
                String tmpKey = null;
                for (String cacheKey : keyList) {
                    tmpKey = flag ? cacheKey : cacheKey.substring(cacheKey.lastIndexOf("::") + 2);
                    lockUserIds.add(Long.parseLong(tmpKey));
                }
            }
            if ("0".equals(userQueryReqDto.getUserStatus()) && ToolUtil.isEmpty(lockUserIds)) {
                return page;
            }
        }
        List<UserOrgVo> userInfoList = this.sysUsersMapper.findAccountUserList(page, userQueryReqDto);
        if (currentUser.isGradeadmin()) {
            userInfoList.forEach(o -> {
                if (currentUser.getId().equals(o.getId())) {
                    o.setIsLanding(ADD);
                }
            });
        }
        this.updateAccountStatus(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    private void updateAccountStatus(List<UserOrgVo> userInfoList) {
        boolean flag = this.sysBaseConfigService.isNotRedis();
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        UserLockModel model = null;
        if (CollectionUtils.isNotEmpty((Collection)keyList) && CollectionUtils.isNotEmpty(userInfoList)) {
            for (UserOrgVo vo : userInfoList) {
                Optional<String> optional = keyList.parallelStream().filter(item -> {
                    if (flag) {
                        return item.equalsIgnoreCase(String.valueOf(vo.getId()));
                    }
                    return item.substring(item.lastIndexOf("::") + 2).equals(String.valueOf(vo.getId()));
                }).findAny();
                if (!optional.isPresent()) continue;
                try {
                    String tmpkey = optional.get();
                    model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)(flag ? tmpkey : tmpkey.substring(tmpkey.lastIndexOf("::") + 2)));
                    if (null == model || model.getLockTime() == null) continue;
                    vo.setAccountStatus(UserStatus.LOCKED.getCode());
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isFirstLogin(Long userId) {
        boolean flag = false;
        Long count = this.sysGetBackPasswordMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysGetBackPassword::getId, (Object)userId));
        if (count == 0L) {
            flag = true;
        }
        return flag;
    }

    public boolean isPwdOverdue(Long userId) {
        boolean flag = false;
        List<SysPasswordHist> list = this.sysPasswordHistMapper.lastCreateTime(userId);
        if (ToolUtil.isNotEmpty(list)) {
            SysPasswordHist sysPasswordHist = list.get(0);
            Duration duration = Duration.between(sysPasswordHist.getCreateTime(), LocalDateTime.now());
            if (duration.toDays() >= this.hussarPwdConfigService.getPasswordHist()) {
                flag = true;
            }
        } else {
            flag = true;
        }
        return flag;
    }

    public SysUsers getUser(Long userId) {
        return (SysUsers)this.sysUsersMapper.selectById(userId);
    }

    public List<SysPasswordHist> getPwdHist(Long userId) {
        return this.sysPasswordHistMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPasswordHist::getId, (Object)userId)).orderByDesc(HussarBaseEntity::getCreateTime));
    }

    @DSTransactional
    public void updatePwd(SysUsers sysUsers) {
        SysUsers user = (SysUsers)this.sysUsersMapper.selectById(sysUsers.getId());
        user.setPassword(sysUsers.getPassword());
        user.setPswdUptTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        String pwdExtinctTime = DateUtil.getAfterDayDate((String)(this.hussarPwdConfigService.getPasswordHist() + ""));
        user.setPswdTime(DateUtil.parseTime((String)pwdExtinctTime));
        this.updateById(user);
        List<SysPasswordHist> list = this.sysPasswordHistMapper.lastCreateTime(sysUsers.getId());
        if (list.size() >= this.hussarPwdConfigService.getPwdRepeatTime() && list.size() != 0) {
            SysPasswordHist sysPasswordHist = list.get(list.size() - 1);
            this.sysPasswordHistMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPasswordHist::getId, (Object)sysPasswordHist.getId())).eq(SysPasswordHist::getPassword, (Object)sysPasswordHist.getPassword()));
        }
        SysPasswordHist sph = new SysPasswordHist();
        sph.setId(sysUsers.getId());
        sph.setPassword(sysUsers.getPassword());
        this.sysPasswordHistMapper.insert(sph);
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        if (this.hussarBaseProperties.isTenantOpen()) {
            loginLock.removeUserCache(String.valueOf(sysUsers.getId()), connName);
        } else {
            loginLock.removeUserCache(String.valueOf(sysUsers.getId()));
        }
    }

    public ApiResponse<Tip> saveGetBackPwd(SysGetBackPassword sysGetBackPassword) {
        if (ToolUtil.isEmpty((Object)sysGetBackPassword)) {
            throw new BaseException("\u5bc6\u4fdd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        sysGetBackPassword.setId(BaseSecurityUtil.getUser().getId());
        if (!this.iSysGetBackPasswordService.saveOrUpdate((Object)sysGetBackPassword)) {
            throw new BaseException("\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u8bbe\u7f6e\u6210\u529f\uff01");
    }

    public long resetAllPwd(Map<String, Object> map) {
        String newPwd = map.get("newPwd").toString();
        String[] userIds = (String[])map.get("userIds");
        long count = 0L;
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        for (String userId : userIds) {
            if (!ToolUtil.isNotEmpty((Object)userId)) continue;
            SysUsers sysUsers = new SysUsers();
            sysUsers.setPassword(newPwd);
            count += (long)this.sysUsersMapper.update(sysUsers, (Wrapper)new LambdaUpdateWrapper().eq(SysUsers::getId, (Object)userId));
            if (this.hussarBaseProperties.isTenantOpen()) {
                loginLock.removeUserCache(userId, connName);
                continue;
            }
            loginLock.removeUserCache(userId);
        }
        return count;
    }

    @DSTransactional
    public void resetVueAllPwd(Map<String, Object> map) {
    }

    @DSTransactional
    public ApiResponse saveUserOrder(List<Long> idList) {
        if (ToolUtil.isEmpty(idList)) {
            throw new BaseException("\u6ca1\u6709\u9700\u8981\u4fdd\u5b58\u6392\u5e8f\u7684\u7528\u6237\uff01");
        }
        ArrayList<SysUsers> sysUsersList = new ArrayList<SysUsers>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysUsers sysUsers = new SysUsers();
            sysUsers.setId(id);
            sysUsers.setUserOrder(new BigDecimal(i + 1));
            sysUsersList.add(sysUsers);
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
        }
        if (ToolUtil.isNotEmpty(sysUsersList) && super.updateBatchById(sysUsersList, sysUsersList.size())) {
            return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
        }
        throw new BaseException("\u6392\u5e8f\u5931\u8d25\uff01");
    }

    public Long getMaxOrder(Long corporationId) {
        return this.sysUsersMapper.getMaxOrder(corporationId);
    }

    @DSTransactional
    public boolean copyRole(Long copyFrom, Long copyTo) {
        if (copyTo == null || "".equals(copyTo)) {
            return true;
        }
        List rolesFrom = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)copyFrom)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        List rolesTo = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)copyTo)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        ArrayList<Long> adds = new ArrayList<Long>();
        for (SysUserRole from : rolesFrom) {
            if (ToolUtil.isEmpty((Object)from.getGrantedRole())) continue;
            boolean isSame = false;
            for (SysUserRole to : rolesTo) {
                if (!from.getGrantedRole().equals(to.getGrantedRole())) continue;
                isSame = true;
                break;
            }
            if (isSame) continue;
            adds.add(from.getGrantedRole());
        }
        int size = adds.size();
        Long[] toRolesArray = new Long[rolesTo.size()];
        Long[] addArray = adds.toArray(new Long[size]);
        for (int i = 0; i < rolesTo.size(); ++i) {
            toRolesArray[i] = ((SysUserRole)rolesTo.get(i)).getGrantedRole();
        }
        int arryLen1 = addArray.length;
        int arryLen2 = toRolesArray.length;
        if ((addArray = Arrays.copyOf(addArray, arryLen1 + arryLen2)).length == 0) {
            return true;
        }
        System.arraycopy(toRolesArray, 0, addArray, arryLen1, arryLen2);
        if (this.iSysConfRolesService.isIncludeConfRole(addArray)) {
            return false;
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(copyTo);
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, copyTo, ADD);
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (Long roleId : adds) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(copyTo);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, Constants.NONE_ID);
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList, "add");
            }
        }
        return true;
    }

    public Page<SysUsers> getUserList(Page<SysUsers> page, SysUsers sysUsers) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userAccount = sysUsers.getUserAccount();
        String userName = sysUsers.getUserName();
        if (ToolUtil.isNotEmpty((Object)userAccount)) {
            userAccount = userAccount.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        if (ToolUtil.isNotEmpty((Object)userName)) {
            userName = userName.replace("%", "\\\\%").replace("_", "\\\\_");
        }
        page.setRecords(this.sysUsersMapper.getUserList(page, userAccount, userName));
        return page;
    }

    public List<JSTreeModel> getUserTreeByRole(String roleId) {
        return this.sysUsersMapper.getUserTreeByRole(roleId);
    }

    public List<JSTreeModel> getLazyUserTreeByRole(Long roleId) {
        return this.sysUsersMapper.getLazyUserTreeByRole(roleId);
    }

    public void updateUserStatus() {
        SysBaseConfig noLogin = this.iSysBaseConfigService.getSysBaseConfig("nologin_day");
        String days = noLogin.getConfigValue();
        String status = UserStatus.DORMANCY.getCode();
        Instant now = Instant.now();
        Instant before = now.minus(Duration.ofDays(Integer.valueOf(days).intValue()));
        Date dateBefore = Date.from(before);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Timestamp previous = Timestamp.valueOf(df.format(dateBefore));
        this.sysUsersMapper.updateUserStatus(previous, status);
    }

    public boolean reChecking(RepeatPwdDto repeatPwdDto) {
        String userName = BaseSecurityUtil.getUser().getAccount();
        String pass = repeatPwdDto.getCipher();
        if (this.hussarLoginConfigService.getTotpOpen().booleanValue()) {
            SysUsers sysUsers = (SysUsers)super.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userName));
            String totpKey = sysUsers.getTotpKey();
            return this.abstractOTPCredentialsMatcher.verify(totpKey, pass, this.hussarLoginConfigService.getTotpOffsetMin());
        }
        String password = CryptoUtil.decode((String)pass);
        SysUsers sysUsers = (SysUsers)super.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)userName)).eq(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode()));
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(password).getBytes());
        return sysUsers.getPassword().equals(pwd);
    }

    @DSTransactional
    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public ApiResponse<Tip> cancelUser(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = this.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException("\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            throw new BaseException("\u6ce8\u9500\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u6ce8\u9500\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u6ce8\u9500\uff01");
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("4");
            if (this.sysUsersAuditMapper.insert(sysUsersAudit) == 1) {
                return ApiResponse.success((String)"\u6ce8\u9500\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
            throw new BaseException("\u6ce8\u9500\u5931\u8d25\uff01");
        }
        Long employeeId = sysUser.getEmployeeId();
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUser.getId()));
        sysUser.setAccountStatus(UserStatus.CANCEL.getCode());
        sysUser.setEmployeeId(Long.valueOf(0L));
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        if (this.sysUsersMapper.updateById(sysUser) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUser, Constants.NONE_ID);
            sysUser.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUser.getId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUser.getId(), "deleteByUserId");
            return ApiResponse.success((String)"\u6ce8\u9500\u6210\u529f\uff01");
        }
        throw new BaseException("\u6ce8\u9500\u5931\u8d25\uff01");
    }

    @DSTransactional
    private boolean saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(ip);
                sysUserIps.add(sysUserIp);
            }
        }
        if (sysUserIps.size() > 0) {
            flag = this.iSysUserIpService.saveBatch(sysUserIps);
        }
        return flag;
    }

    @DSTransactional
    private boolean saveUserAuditIP(Long userId, String accessLoginIp, String currentStatus) {
        boolean flag = false;
        ArrayList<SysUserIpAudit> listAudit = new ArrayList<SysUserIpAudit>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
                sysUserIpAudit.setUserId(userId);
                sysUserIpAudit.setUserIp(ip);
                sysUserIpAudit.setIsAudit("0");
                sysUserIpAudit.setCurrentStatus(currentStatus);
                listAudit.add(sysUserIpAudit);
            }
        }
        if (listAudit.size() > 0) {
            flag = this.iSysUserIpAuditService.saveBatch(listAudit);
        }
        return flag;
    }

    public void exportData(List<String> idList, HttpServletResponse response) {
        ArrayList ids = new ArrayList();
        idList.forEach(id -> ids.add(Long.valueOf(id)));
        List users = this.sysUsersMapper.selectBatchIds(ids);
        List userIp = this.sysUserIpMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUserIp::getUserId, ids));
        ArrayList<Long> employeeIds = new ArrayList<Long>();
        for (SysUsers sysUsers : users) {
            Long employeeId = sysUsers.getEmployeeId();
            if (employeeId == null) continue;
            employeeIds.add(employeeId);
        }
        List strus = new ArrayList();
        if (employeeIds.size() > 0) {
            strus = this.sysStruMapper.selectBatchIds(employeeIds);
        }
        List userRoles = this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, ids));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("users", users);
        data.put("userIp", userIp);
        data.put("userRoles", userRoles);
        data.put("strus", strus);
        data.put("export_type", "user");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "user_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @DSTransactional
    public ApiResponse importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"user".equals(export_type)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("user")));
        }
        List users = (List)data.get("users");
        List userRoles = (List)data.get("userRoles");
        List strus = (List)data.get("strus");
        Map<String, Integer> userCount = this.insertOrUpdateList(users);
        Map<String, Integer> userRoleCount = this.insertOrUpdateList(userRoles);
        Map<String, Integer> strusCount = this.insertOrUpdateList(strus);
        return ApiResponse.success((String)("\u5bfc\u5165\u6210\u529f\u3002\u7528\u6237\u65b0\u589e\u6570\u636e" + userCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + userCount.get("update") + "\u6761\uff1b\u7528\u6237\u89d2\u8272\u5173\u7cfb\u65b0\u589e\u6570\u636e" + userRoleCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + userRoleCount.get("update") + "\u6761\u3002"));
    }

    @DSTransactional
    public Map<String, String> importVueData(byte[] content) {
        Map data;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"user".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "employee");
            return map;
        }
        List users = (List)data.get("users");
        List userIps = (List)data.get("userIp");
        List userRoles = (List)data.get("userRoles");
        List strus = (List)data.get("strus");
        Map<String, Integer> userCount = this.insertOrUpdateList(users);
        Map<String, Integer> userIp = this.insertOrUpdateList(userIps);
        Map<String, Integer> userRoleCount = this.insertOrUpdateList(userRoles);
        Map<String, Integer> strusCount = this.insertOrUpdateList(strus);
        map.put("success", "true");
        map.put("userInsert", "" + userCount.get("insert"));
        map.put("userUpdate", "" + userCount.get("update"));
        map.put("userRoleInsert", "" + userRoleCount.get("insert"));
        map.put("userRoleUpdate", "" + userRoleCount.get("update"));
        return map;
    }

    public List<JSTreeModel> getUserTreeVue(String isExport, Long parentId) {
        Long newParentId = parentId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long empolyeeId = shiroUser.getEmployeeId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String struLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText("\u7cfb\u7edf\u7528\u6237");
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List list = new ArrayList();
        List list1 = new ArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.getUserTree(newParentId);
        } else {
            result.add(jsTreeModel);
            list1 = this.sysOrgManageService.getUserTree();
        }
        list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel model : result) {
                String type = model.getType();
                if (type != null && "USER".equals(type)) {
                    model.setState(false, false, false);
                    continue;
                }
                model.setState(false, false, true);
            }
        }
        return result;
    }

    public List<JSTreeModel> getUserTreeVueForCopy(String isExport, Long parentId) {
        Long newParentId = parentId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long empolyeeId = shiroUser.getEmployeeId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String struLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeModel = new JSTreeModel();
        jsTreeModel.setId(Constants.ROOT_NODE_ID);
        jsTreeModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeModel.setText("\u7cfb\u7edf\u7528\u6237");
        jsTreeModel.setParent(Constants.ROOT_NODE_PARENT);
        jsTreeModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeModel.getState().put("gradeDisabled", true);
        }
        List list = new ArrayList();
        List list1 = new ArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(jsTreeModel);
            }
            list1 = this.sysOrgManageService.getUserTree(newParentId);
        } else {
            result.add(jsTreeModel);
            list1 = this.sysOrgManageService.getUserTree();
        }
        list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTreeForCopy(list1, level) : list1;
        result.addAll(list);
        if (Boolean.parseBoolean(isExport)) {
            for (JSTreeModel model : result) {
                String type = model.getType();
                if (type != null && "USER".equals(type)) {
                    model.setState(false, false, false);
                    continue;
                }
                model.setState(false, false, true);
            }
        }
        return result;
    }

    public List<JSTreeModel> getUserDepTreeVue(Long parentId, String reqModule) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long empolyeeId = shiroUser.getEmployeeId();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            String struLevel = this.sysStruMapper.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel jsTreeRootModel = new JSTreeModel();
        jsTreeRootModel.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        jsTreeRootModel.setId(Constants.ROOT_NODE_ID);
        jsTreeRootModel.setParent(Constants.ROOT_NODE_PARENT);
        String rootText = "role".equals(reqModule) ? "\u89d2\u8272\u6811" : "\u7cfb\u7edf\u7528\u6237";
        rootText = Objects.requireNonNull(BaseSecurityUtil.getUser()).isGradeadmin() ? "\u7ec4\u7ec7\u673a\u6784" : rootText;
        jsTreeRootModel.setText(rootText);
        jsTreeRootModel.setType("isRoot");
        if (isGradeAdmin) {
            jsTreeRootModel.getState().put("gradeDisabled", true);
        }
        List list1 = Lists.newArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentId)) {
                parentId = (long)Constants.ROOT_NODE_ID;
                result.add(jsTreeRootModel);
            }
            list1 = this.sysOrgManageService.getUserDepChildTree(parentId);
        }
        List list = isGradeAdmin ? this.sysOrgManageService.getGradeStruTree(list1, level) : list1;
        result.addAll(list);
        List listOrganType = this.organTypeService.list();
        Map mapOrganType = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getId, Function.identity()));
        mapOrganType.get(1);
        if (CollectionUtils.isNotEmpty(result)) {
            for (JSTreeModel jsTreeModel : result) {
                if (!StringUtils.isNotBlank((CharSequence)jsTreeModel.getStruType())) continue;
                jsTreeModel.setImgUrl(((SysOrganType)mapOrganType.get(Long.parseLong(jsTreeModel.getStruType()))).getImgUrl());
            }
        }
        return result;
    }

    @DSTransactional
    public ApiResponse saveUser(SysUsersVo sysUsersVo) {
        if (ToolUtil.isEmpty((Object)sysUsersVo)) {
            throw new BaseException("\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysUsersVo, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        SysUsers sysUsers = new SysUsers();
        BeanUtils.copyProperties((Object)sysUsersVo, (Object)sysUsers);
        String roleIds = sysUsersVo.getRoleIds() == null ? "" : sysUsersVo.getRoleIds();
        String[] ids = roleIds.split(",");
        Long[] idLs = new Long[ids.length];
        int i = 0;
        for (String id : ids) {
            Long idL = ToolUtil.isNotEmpty((Object)id) ? Long.valueOf(id) : 0L;
            idLs[i++] = idL;
        }
        if (this.iSysConfRolesService.isIncludeConfRole(idLs)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
        boolean tenantFlag = this.isCanAdd(sysUsers);
        Boolean userAccountInAudit = this.userAccountInAudit(sysUsers.getUserAccount());
        if (userAccountInAudit.booleanValue()) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01\uff09");
        }
        sysUsers.setDepartmentId(sysUsers.getCorporationId());
        Long order = this.getMaxOrder(sysUsers.getCorporationId());
        order = ToolUtil.isEmpty((Object)order) ? Long.valueOf(1L) : Long.valueOf(order + 1L);
        BigDecimal userOrder = BigDecimal.valueOf(order);
        sysUsers.setUserOrder(userOrder);
        sysUsers.setTotpKey(this.abstractOTPCredentialsMatcher.getRandomSecretBase32());
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("sysUsers", sysUsers);
        map.put("roleIds", roleIds);
        String pass = "";
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && !this.createUserConfigService.getCreateUserUseDefaultPass().booleanValue()) {
            if (StringUtils.isBlank((CharSequence)sysUsers.getEMail())) {
                throw new BaseException("\u4f7f\u7528\u7cfb\u7edf\u7684\u5bc6\u7801\u89c4\u5219\u751f\u6210\u7684\u5bc6\u7801\u65f6\uff0c\u5fc5\u987b\u586b\u5199\u90ae\u4ef6\uff01");
            }
            pass = GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule());
        } else {
            pass = this.hussarPwdConfigService.getDefaultPassword();
        }
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        sysUsers.setPassword(pwd);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            boolean canOperate1 = this.iSysStruAuditService.checkCanOperate(sysUsers.getDepartmentId());
            if (!canOperate1) {
                throw new BaseException("\u65b0\u5efa\u7528\u6237\u6240\u5728\u7684\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01");
            }
            long userId = IdWorker.getId((Object)sysUsers);
            sysUsers.setId(Long.valueOf(userId));
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(Long.valueOf(userId));
            sysUsersAudit.setCurrentStatus("0");
            sysUsersAudit.setIsAudit("0");
            this.iSysUsersAuditService.save((Object)sysUsersAudit);
            this.saveUserAuditIP(userId, sysUsersVo.getAccessLoginIp(), "0");
            stringBuffer.append("\u65b0\u589e\u7528\u6237\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
                ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
                if (ids.length > 0) {
                    for (String roleId : ids) {
                        if (ToolUtil.isEmpty((Object)roleId)) continue;
                        SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                        sysUserroleAudit.setUserId(sysUsers.getId());
                        sysUserroleAudit.setRoleId(Long.valueOf(roleId));
                        sysUserroleAudit.setStatus(UserRoleStatus.UserAuditButRoleNotAudit.getCode());
                        sysUserroleAudit.setOperationType(ADD);
                        sysUserroleAuditList.add(sysUserroleAudit);
                    }
                }
                if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                    this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
                    if (sysUserroleAuditList.size() != 1 || !((SysUserroleAudit)sysUserroleAuditList.get(0)).getRoleId().equals(SysUserAndRole.PUBLIC_ROLE.getValue())) {
                        stringBuffer.append("\u65b0\u589e\u7528\u6237\u89d2\u8272\u6210\u529f\uff01");
                    }
                }
            }
        } else {
            this.save(sysUsers);
            this.saveUserIP(sysUsers.getId(), sysUsersVo.getAccessLoginIp());
            if (tenantFlag) {
                SysUsers users = (SysUsers)this.getById(sysUsers.getId());
                this.sysLoginUserService.syncAddUser(users);
            }
            stringBuffer.append("\u65b0\u589e\u7528\u6237\u6210\u529f\uff01");
            if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isRoleAudit()) {
                this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId()));
                ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
                for (String roleId : ids) {
                    if (ToolUtil.isEmpty((Object)roleId)) continue;
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(sysUsers.getId());
                    sysUserRole.setGrantedRole(Long.valueOf(roleId));
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    userRoleList.add(sysUserRole);
                }
                if (ToolUtil.isNotEmpty(userRoleList)) {
                    this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                    if (userRoleList.size() != 1 || !((SysUserRole)userRoleList.get(0)).getGrantedRole().equals(SysUserAndRole.PUBLIC_ROLE.getValue())) {
                        stringBuffer.append("\u65b0\u589e\u7528\u6237\u89d2\u8272\u6210\u529f\uff01");
                    }
                }
            }
        }
        Long sysUsersId = sysUsers.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            SysUserRole sysUserRole = new SysUserRole();
            sysUserRole.setUserId(sysUsersId);
            sysUserRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
            this.sysUserRoleMapper.insert(sysUserRole);
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            if (ids.length > 0) {
                for (String roleId : ids) {
                    if (ToolUtil.isEmpty((Object)roleId) || SysUserAndRole.PUBLIC_ROLE.getValue().equals(Long.valueOf(roleId))) continue;
                    if (SysUserAndRole.GRADEADMIN_ROLE.getValue().equals(Long.valueOf(roleId))) {
                        SysUserRole sysUserGradeRole = new SysUserRole();
                        sysUserGradeRole.setUserId(sysUsersId);
                        sysUserGradeRole.setGrantedRole(SysUserAndRole.GRADEADMIN_ROLE.getValue());
                        sysUserGradeRole.setAdminOption(UserRoleStatus.OK.getCode());
                        this.sysUserRoleMapper.insert(sysUserGradeRole);
                        continue;
                    }
                    SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(sysUsersId);
                    sysUserroleAudit.setRoleId(Long.valueOf(roleId));
                    sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(ADD);
                    sysUserroleAuditList.add(sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
                stringBuffer.append("\u65b0\u589e\u7528\u6237\u89d2\u8272\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
        }
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.getEMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)pass);
        }
        return ApiResponse.success((String)stringBuffer.toString());
    }

    public IPage<UserOrgVo> getAccountList(UserQueryReqDto userQueryReqDto, Page<UserOrgVo> pages) {
        if (ToolUtil.isEmpty(pages)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userName = userQueryReqDto.getUserName();
        String userAccount = userQueryReqDto.getUserAccount();
        String userStatus = userQueryReqDto.getUserStatus();
        String userProperty = userQueryReqDto.getUserProperty();
        String orgId = userQueryReqDto.getDepStruId();
        return pages.setRecords(this.sysUsersMapper.getAccountList(userName, userAccount, userStatus, userProperty, orgId, pages));
    }

    public List<SysUsers> updateUserStatusToDormancy(String status) {
        int nologinDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("nologin_day").getConfigValue());
        if (nologinDay == -1) {
            return new ArrayList<SysUsers>();
        }
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Date previous = DateUtil.addDay((Date)date, (int)(-nologinDay));
        List<SysUsers> noLoginList = this.sysUsersMapper.getNoLoginList(previous, UserStatus.OK.getCode());
        noLoginList.removeIf(sysUsers -> ArrayUtils.contains((Object[])Constants.ADMINS, (Object)sysUsers.getId()));
        if (ToolUtil.isNotEmpty(noLoginList)) {
            this.sysUsersMapper.updateToDormancy(date, status, noLoginList);
        } else {
            noLoginList = new ArrayList<SysUsers>();
        }
        return noLoginList;
    }

    public List<SysUsers> getWillCancel() {
        int logoutDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("logout_day").getConfigValue());
        int warnDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("email_before_logout_day").getConfigValue());
        int days = logoutDay - warnDay;
        Date previous = DateUtil.addDay((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)(-days));
        return ((SysUsersMapper)this.baseMapper).getWillCancel(previous, UserStatus.DORMANCY.getCode());
    }

    public boolean updateUserStatusToCancel() {
        int logoutDay = Integer.parseInt(this.iSysBaseConfigService.getSysBaseConfig("logout_day").getConfigValue());
        Date previous = DateUtil.addDay((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)(-logoutDay));
        return ((SysUsersMapper)this.baseMapper).updateToCancel(previous, UserStatus.CANCEL.getCode());
    }

    public List<SysUsers> getExpireTemporaty(Date date) {
        return ((SysUsersMapper)this.baseMapper).getExpireTemporaty(date);
    }

    public IPage<UserOrgVo> getSysUserInfo(Page<UserOrgVo> page, UserQueryReqDto userQueryReqDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!BaseSecurityUtil.getUser().isGradeadmin()) {
            userQueryReqDto.setIsSys(ADD);
            if ("0".equals(userQueryReqDto.getUserStatus()) || ADD.equals(userQueryReqDto.getUserStatus())) {
                List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
                boolean flag = this.sysBaseConfigService.isNotRedis();
                ArrayList<Long> lockUserIds = new ArrayList<Long>();
                userQueryReqDto.setLockUserIds(lockUserIds);
                Object[] arr = new String[]{"0", ADD};
                if (userQueryReqDto.getUserStatus() != null && ArrayUtils.contains((Object[])arr, (Object)userQueryReqDto.getUserStatus()) && CollectionUtils.isNotEmpty((Collection)keyList)) {
                    String tmpKey = null;
                    for (String cacheKey : keyList) {
                        tmpKey = flag ? cacheKey : cacheKey.substring(cacheKey.lastIndexOf("::") + 2);
                        lockUserIds.add(Long.parseLong(tmpKey));
                    }
                }
                if ("0".equals(userQueryReqDto.getUserStatus()) && ToolUtil.isEmpty(lockUserIds)) {
                    return page;
                }
            }
            List<UserOrgVo> userInfoList = this.sysUsersMapper.findAccountUserList(page, userQueryReqDto);
            this.updateAccountStatus(userInfoList);
            page.setRecords(userInfoList);
        }
        return page;
    }

    @DSTransactional
    public ApiResponse updateUser(SysUsersVo sysUsersVo) {
        String roleIds;
        if (ToolUtil.isEmpty((Object)sysUsersVo)) {
            throw new BaseException("\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysUsersVo, "edit");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        sysUsersVo.setAccountStatus(((SysUsers)this.sysUsersMapper.selectById(sysUsersVo.getId())).getAccountStatus());
        SysUsers sysUsers = new SysUsers();
        BeanUtils.copyProperties((Object)sysUsersVo, (Object)sysUsers);
        this.checkTypeProperty(sysUsers);
        Long userId = sysUsers.getId();
        String string = roleIds = sysUsersVo.getRoleIds() == null ? "" : sysUsersVo.getRoleIds().trim();
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        String[] ids = roleIds.split(",");
        Long[] idList = new Long[ids.length];
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        for (String id : ids) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            Long[] idL = Long.valueOf(id);
            idList[i++] = idL;
            if (list.contains(id)) continue;
            list.add(id);
        }
        if (this.iSysConfRolesService.isIncludeConfRole(idList)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u6240\u9009\u89d2\u8272\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u57fa\u6570\uff01\uff09");
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.iSysUsersAuditService.adjustEdit(sysUsers.getId())) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        sysUsers.setDepartmentId(sysUsers.getCorporationId());
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List<SysUserroleAudit> auditList = this.sysUserroleAuditMapper.getHasReviewList(userId);
            String[] connList = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
            ArrayList<Long> adds = new ArrayList<Long>();
            ArrayList<Long> dels = new ArrayList<Long>();
            for (SysUserRole sysUserRole : connList) {
                boolean isSame = false;
                for (Long l : idList) {
                    if (ToolUtil.isEmpty((Object)l) || !l.equals(sysUserRole.getGrantedRole())) continue;
                    isSame = true;
                    break;
                }
                if (isSame) continue;
                dels.add(sysUserRole.getGrantedRole());
            }
            for (Long roleId : idList) {
                if (ToolUtil.isEmpty((Object)roleId)) continue;
                boolean isSame = false;
                for (SysUserRole sysUserRole : connList) {
                    if (!roleId.equals(sysUserRole.getGrantedRole())) continue;
                    isSame = true;
                    break;
                }
                if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                adds.add(roleId);
            }
            if (ToolUtil.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, userId, ADD);
            }
            if (ToolUtil.isNotEmpty(dels)) {
                this.insertAndUpdateUserRoleAudit(dels, auditList, userId, DELETE);
            }
        } else {
            List<String> roleList;
            this.sysRolesService.delAuthCacheInfo(userId);
            if (BaseSecurityUtil.getUser().isGradeadmin()) {
                roleList = this.sysUserRoleMapper.delOrganRoleIdByUserId(userId);
                if (roleList.size() > 0) {
                    this.sysUserRoleMapper.delUserRoleByRoleId(userId, roleList);
                }
                this.abstractPushMsgMatcher.insertOperation("userRole", "delete", (Object)userId, Constants.NONE_ID);
            } else {
                roleList = this.sysUserRoleMapper.getSysRolesByUserId(userId);
                if (CollectionUtils.isNotEmpty(roleList)) {
                    this.sysUserRoleMapper.delSysRolesByUserId(userId, roleList);
                }
                this.abstractPushMsgMatcher.insertOperation("userRole", "delete", (Object)userId, Constants.NONE_ID);
            }
            this.bpmAbstractPushMsgMatcher.delete("userRole", userId, "deleteByUserId");
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (String roleId : ids) {
                if (ToolUtil.isEmpty((Object)roleId) || SysUserAndRole.PUBLIC_ROLE.getValue().toString().equals(roleId) && BaseSecurityUtil.getUser().isGradeadmin()) continue;
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(Long.valueOf(roleId));
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
            }
            String isSys = sysUsers.getIsSys();
            this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUsers.getId())).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.GRADEADMIN_ROLE.getValue()));
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
                this.abstractPushMsgMatcher.insertOperation("userRole", "add", userRoleList, Constants.NONE_ID);
                this.bpmAbstractPushMsgMatcher.pushUserRole(userRoleList, "add");
            }
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsers user = this.getUser(sysUsers.getId());
            String oldEmployeeId = user.getEmployeeId().toString();
            String newEmployeeId = sysUsers.getEmployeeId().toString();
            if (!this.iSysStruAuditService.checkCanOperate(user.getEmployeeId())) {
                throw new BaseException("\u7528\u6237\u5173\u8054\u7684\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff0c\u7981\u6b62\u4fee\u6539!");
            }
            if (!oldEmployeeId.equals(newEmployeeId) && !this.iSysStruAuditService.checkCanOperate(sysUsers.getEmployeeId())) {
                throw new BaseException("\u7528\u6237\u65b0\u5173\u8054\u7684\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff0c\u7981\u6b62\u4fee\u6539\uff01");
            }
            BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit, (String[])new String[]{"id"});
            sysUsersAudit.setUserId(sysUsers.getId());
            sysUsersAudit.setCurrentStatus(ADD);
            sysUsersAudit.setIsAudit("0");
            this.sysUsersAuditMapper.insert(sysUsersAudit);
            this.saveUserAuditIP(userId, sysUsersVo.getAccessLoginIp(), ADD);
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        }
        SysUsers old = (SysUsers)this.sysUsersMapper.selectById(sysUsers.getId());
        if (!ADD.equals(old.getAccountStatus()) && ADD.equals(sysUsers.getAccountStatus())) {
            sysUsers.setLastLoginTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
            String connName = this.dynamicDataSourceService.currentDsName();
            if (this.hussarBaseProperties.isTenantOpen()) {
                loginLock.removeUserCache(String.valueOf(sysUsers.getId()), connName);
            } else {
                loginLock.removeUserCache(String.valueOf(sysUsers.getId()));
            }
        }
        this.sysUsersMapper.updateById(sysUsers);
        this.abstractPushMsgMatcher.insertOperation("user", "update", (Object)sysUsers, Constants.NONE_ID);
        this.bpmAbstractPushMsgMatcher.pushUser(sysUsers, "update", null);
        this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userId));
        this.saveUserIP(userId, sysUsersVo.getAccessLoginIp());
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @DSTransactional
    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public ApiResponse dormancyUser(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUsers sysUsers = (SysUsers)this.sysUsersMapper.selectById(userId);
        sysUsers.setAccountStatus(UserStatus.DORMANCY.getCode());
        this.sysUsersMapper.updateById(sysUsers);
        return ApiResponse.success((String)"\u4f11\u7720\u7528\u6237\u6210\u529f\uff01");
    }

    @DSTransactional
    @CacheEvict(value={"authorization_info"}, key="'hussar_authInfo:'+#userId")
    public ApiResponse deleteUser(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = this.getUser(userId);
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u7ba1\u7406\u5458\u7528\u6237\uff01\uff09");
        }
        if (shiroUser.getId().equals(userId)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\uff08\u4e0d\u80fd\u5220\u9664\u5f53\u524d\u7528\u6237\uff01\uff09");
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.iSysUsersAuditService.adjustEdit(userId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus(DELETE);
            if (this.sysUsersAuditMapper.insert(sysUsersAudit) == 1) {
                return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        Long employeeId = sysUser.getEmployeeId();
        sysUser.setAccountStatus(UserStatus.DELETE.getCode());
        sysUser.setEmployeeId(Long.valueOf(0L));
        this.sysStruMapper.updatePrincipal(sysUser.getId());
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)sysUser.getId()));
        this.iSysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)sysUser.getId()));
        if (this.sysUsersMapper.updateById(sysUser) == 1) {
            this.abstractPushMsgMatcher.insertOperation("user", "delete", (Object)sysUser, Constants.NONE_ID);
            sysUser.setEmployeeId(employeeId);
            this.bpmAbstractPushMsgMatcher.delete("organ", sysUser.getId(), null);
            this.bpmAbstractPushMsgMatcher.delete("userRole", sysUser.getId(), "deleteByUserId");
            return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
        }
        throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
    }

    public ApiResponse updateLockAccountStatus(Long userId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new BaseException("\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysUsers sysUsers = this.getUser(userId);
        this.dealLock(sysUsers);
        boolean flag = true;
        if ("0".equals(sysUsers.getTypeProperty())) {
            String nowDay = DateUtil.getDay((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            String expiredDay = sysUsers.getExpiredTime();
            String startDay = sysUsers.getStartTime();
            flag = DateUtil.compareDate((String)nowDay, (String)startDay);
            if (flag) {
                flag = DateUtil.compareDate((String)expiredDay, (String)nowDay);
            }
        }
        if (!flag) {
            throw new BaseException("\u4e0d\u80fd\u6fc0\u6d3b\u6709\u6548\u671f\u5916\u7684\u4e34\u65f6\u8d26\u53f7");
        }
        String connName = this.dynamicDataSourceService.currentDsName();
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).set(SysUsers::getLastLoginTime, (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()))).eq(SysUsers::getId, (Object)userId));
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    private void dealLock(SysUsers sysUsers) {
        if (sysUsers != null) {
            HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsers.getId()));
        }
    }

    public ApiResponse<UpdateInfoVo> updatePassword(UpdatePwdDto updatePwdDto) {
        String oldPwd = updatePwdDto.getOldPwd() == null ? "" : updatePwdDto.getOldPwd();
        String newPwd = updatePwdDto.getNewPwd() == null ? "" : updatePwdDto.getNewPwd();
        String cPwd = updatePwdDto.getConfirmPwd() == null ? "" : updatePwdDto.getConfirmPwd();
        oldPwd = CryptoUtil.decode((String)oldPwd);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replace("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        UpdateInfoVo updateInfoVo = new UpdateInfoVo();
        if (!newPwd.matches(regular)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("unmatchedHintMark");
            updateInfoVo.setPwdRule(pwdRule);
            updateInfoVo.setHintMark(hint);
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (!newPwd.equals(cPwd)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("resetFailPwdNotSame");
            return ApiResponse.success((Object)updateInfoVo);
        }
        String oPwd = this.credentialsMatcher.passwordEncode(oldPwd.getBytes());
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        Long userId = BaseSecurityUtil.getUser().getId();
        SysUsers user = this.getUser(userId);
        String userAccount = user.getUserAccount();
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("updateFailPwdNotUser");
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (!oPwd.equals(user.getPassword())) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("updateFailPwdNotOld");
            return ApiResponse.success((Object)updateInfoVo);
        }
        List<SysPasswordHist> list = this.getPwdHist(userId);
        if (ToolUtil.isEmpty(list) && this.hussarPwdConfigService.getDefaultPassword().equals(newPwd)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("updateFailPwdNotDefault");
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (this.hussarPwdConfigService.getPwdRepeatTime() != 0) {
            for (int i = 0; i < list.size() && i < this.hussarPwdConfigService.getPwdRepeatTime(); ++i) {
                SysPasswordHist sysPasswordHist = list.get(i);
                if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
                updateInfoVo.setSuccess(false);
                updateInfoVo.setRepeatTime(this.hussarPwdConfigService.getPwdRepeatTime());
                updateInfoVo.setError("updateFail");
                return ApiResponse.success((Object)updateInfoVo);
            }
        }
        user.setPassword(nPwd);
        this.updatePwd(user);
        updateInfoVo.setSuccess(true);
        result.put("success", true);
        return ApiResponse.success((Object)updateInfoVo);
    }

    public ApiResponse<UpdateInfoVo> updatePasswordToReset(ResetPwdDto resetPwdDto) {
        Object[] userIds = resetPwdDto.getUserIds() == null ? "".split(",") : resetPwdDto.getUserIds().split(",");
        String adminPwd = resetPwdDto.getSuperPws() == null ? "" : resetPwdDto.getSuperPws();
        String newPwd = resetPwdDto.getPassword() == null ? "" : resetPwdDto.getPassword();
        String cPwd = resetPwdDto.getPasswordRepeat() == null ? "" : resetPwdDto.getPasswordRepeat();
        adminPwd = CryptoUtil.decode((String)adminPwd);
        newPwd = CryptoUtil.decode((String)newPwd);
        cPwd = CryptoUtil.decode((String)cPwd);
        String aPwd = this.credentialsMatcher.passwordEncode(adminPwd.getBytes());
        Long userId = BaseSecurityUtil.getUser().getId();
        SysUsers user = this.getUser(userId);
        UpdateInfoVo updateInfoVo = new UpdateInfoVo();
        if (!aPwd.equals(user.getPassword())) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("resetFailPwdError");
            return ApiResponse.success((Object)updateInfoVo);
        }
        if (!newPwd.equals(cPwd)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("resetFailPwdNotSame");
            return ApiResponse.success((Object)updateInfoVo);
        }
        String str = this.hussarPwdConfigService.getPwdComplexityRegular();
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replace("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        if (!newPwd.matches(regular)) {
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("unmatchedHintMark");
            updateInfoVo.setPwdRule(pwdRule);
            updateInfoVo.setHintMark(hint);
            return ApiResponse.success((Object)updateInfoVo);
        }
        List sysUsers = this.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getEmployeeId, userIds));
        for (SysUsers users : sysUsers) {
            if (!newPwd.toLowerCase().contains(users.getUserAccount().toLowerCase())) continue;
            updateInfoVo.setSuccess(false);
            updateInfoVo.setError("pwdContainUsernameMark");
            updateInfoVo.setUserName(users.getUserName());
            return ApiResponse.success((Object)updateInfoVo);
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String connName = this.dynamicDataSourceService.currentDsName();
        this.sysUsersMapper.resetAllPwd((String[])userIds, nPwd);
        for (Object id : userIds) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            if (this.hussarBaseProperties.isTenantOpen()) {
                loginLock.removeUserCache((String)id, connName);
                continue;
            }
            loginLock.removeUserCache((String)id);
        }
        updateInfoVo.setSuccess(true);
        return ApiResponse.success((Object)updateInfoVo);
    }

    public ApiResponse saveCopyRole(Long copyFrom, String copyTos) {
        String[] tos;
        Long from = copyFrom == null ? 0L : copyFrom;
        if (StringUtils.isBlank((CharSequence)copyTos)) {
            throw new BaseException("\u590d\u5236\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (String copyTo : tos = copyTos.split(",")) {
            boolean result = this.copyRole(from, Long.valueOf(copyTo));
            if (result) continue;
            throw new BaseException("\u89d2\u8272\u590d\u5236\u5931\u8d25\uff01\uff08\u590d\u5236\u7684\u89d2\u8272\u4e0e\u539f\u89d2\u8272\u4e2d\u6709\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01\uff09");
        }
        return ApiResponse.success((String)"\u89d2\u8272\u590d\u5236\u6210\u529f\uff01");
    }

    public ApiResponse updateSelfInfo(SelfInfoDto selfInfoDto) {
        Long shiroUserId = BaseSecurityUtil.getUser().getId();
        String userId = selfInfoDto.getUserId() == null ? "" : selfInfoDto.getUserId().trim();
        userId = CryptoUtil.decode((String)userId);
        String shiroUserIdStr = shiroUserId + "";
        if (shiroUserId != null && shiroUserIdStr.equals(userId)) {
            String eMail = selfInfoDto.geteMail() == null ? "" : selfInfoDto.geteMail().trim();
            eMail = CryptoUtil.decode((String)eMail);
            String weChat = selfInfoDto.getWeChat() == null ? "" : selfInfoDto.getWeChat().trim();
            weChat = CryptoUtil.decode((String)weChat);
            String mobile = selfInfoDto.getMobile() == null ? "" : selfInfoDto.getMobile().trim();
            mobile = CryptoUtil.decode((String)mobile);
            String telephone = selfInfoDto.getTelephone() == null ? "" : selfInfoDto.getTelephone().trim();
            telephone = CryptoUtil.decode((String)telephone);
            SysUsers user = (SysUsers)this.getById((Serializable)((Object)userId));
            user.setEMail(eMail);
            user.setWeChat(weChat);
            user.setMobile(mobile);
            user.setTelephone(telephone);
            this.updateById(user);
            this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
            return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        throw new BaseException("\u975e\u6cd5\u8bf7\u6c42\uff01");
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                SysUserIp userIp;
                Integer n;
                Integer n2;
                Object obj = objects.get(i);
                if (obj instanceof SysUsers) {
                    SysUsers user = (SysUsers)obj;
                    if (this.updateById(user)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save(user);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysUserIp && !this.iSysUserIpService.update((Object)(userIp = (SysUserIp)obj), (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userIp.getUserId())).eq(SysUserIp::getUserIp, (Object)userIp.getUserIp()))) {
                    this.saveUserIP(userIp.getUserId(), userIp.getUserIp());
                }
                if (obj instanceof SysUserRole) {
                    SysUserRole userRole = (SysUserRole)obj;
                    if (this.sysUserRoleService.update((Object)userRole, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userRole.getUserId())).eq(SysUserRole::getGrantedRole, (Object)userRole.getGrantedRole()))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysUserRoleService.save((Object)userRole);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (obj instanceof SysStru) {
                    SysStru sysStru = (SysStru)obj;
                    if (SqlHelper.retBool((Integer)this.sysStruMapper.updateById(sysStru))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysStruMapper.insert(sysStru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public boolean isCanAdd(SysUsers sysUsers) {
        boolean existAccount;
        boolean tenantFlag;
        this.checkTypeProperty(sysUsers);
        boolean bl = tenantFlag = this.hussarBaseProperties.isTenantOpen() && DELETE.equals(this.hussarBaseProperties.getTenantUserModel());
        if (tenantFlag && (existAccount = this.sysLoginUserService.validateAccount(sysUsers.getUserAccount()).booleanValue())) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        if (this.isExistAccount(sysUsers.getUserAccount())) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u7528\u6237\u540d\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysStruAudit::getRealStruId, (Object)sysUsers.getEmployeeId())).eq(SysStruAudit::getState, (Object)"0");
        Long count = this.sysStruAuditMapper.selectCount((Wrapper)wrapper);
        if (count > 0L) {
            throw new BaseException("\u5f53\u524d\u4eba\u5458\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u65b0\u589e\uff01");
        }
        return tenantFlag;
    }

    private Boolean userAccountInAudit(String userAccount) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUsersAudit::getUserAccount, (Object)userAccount)).eq(SysUsersAudit::getIsAudit, (Object)"0");
        List list = this.iSysUsersAuditService.list((Wrapper)wrapper);
        return HussarUtils.isNotEmpty((Object)list);
    }

    private void checkTypeProperty(SysUsers sysUsers) {
        if (UserStatus.TEMPORARY.getCode().equals(sysUsers.getTypeProperty())) {
            String beginTime = sysUsers.getStartTime();
            String endTime = sysUsers.getExpiredTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    sysUsers.setAccountStatus(UserStatus.DORMANCY.getCode());
                }
            }
            catch (ParseException e) {
                throw new BaseException("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
        }
    }

    private void validateParam(Object o, String mdType) {
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysUsers) {
            SysUsers reqBO = (SysUsers)o;
            if ("edit".equals(mdType) && null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getUserAccount())) {
                sBuffer.append(",");
                sBuffer.append("\u767b\u5f55\u8d26\u53f7\u4e0d\u80fd\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getUserAccount()) && 16 < reqBO.getUserAccount().length()) {
                sBuffer.append(",");
                sBuffer.append("\u767b\u5f55\u8d26\u53f7\u6700\u591a\u53ef\u8f93\u516516\u4e2a\u5b57\u7b26");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getIsSys())) {
                sBuffer.append(",");
                sBuffer.append("\u662f\u5426\u662f\u5206\u7ea7\u7ba1\u7406\u5458\u4e0d\u80fd\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getUserName())) {
                sBuffer.append(",");
                sBuffer.append("\u4eba\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getUserName()) && 32 < reqBO.getUserName().length()) {
                sBuffer.append(",");
                sBuffer.append("\u4eba\u5458\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
            }
            if (null == reqBO.getMaxSessions()) {
                sBuffer.append(",");
                sBuffer.append("\u4f1a\u8bdd\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAccountStatus())) {
                sBuffer.append(",");
                sBuffer.append("\u8d26\u53f7\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getSecurityLevel()) {
                sBuffer.append(",");
                sBuffer.append("\u8d26\u53f7\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getMobile()) && 11 != reqBO.getMobile().length()) {
                sBuffer.append(",");
                sBuffer.append("\u8bf7\u8f93\u5165\u6709\u6548\u7684\u624b\u673a\u53f7");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getTelephone())) {
                String regTel = "^\\d{3,4}-\\d{8}$";
                if (!reqBO.getTelephone().matches(regTel)) {
                    sBuffer.append(",");
                    sBuffer.append("\u8bf7\u8f93\u5165\u6709\u6548\u7684\u529e\u516c\u7535\u8bdd\u53f7\u7801");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getEMail())) {
                String regEx1 = "^([a-z0-9A-Z]+[-|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$";
                if (!reqBO.getEMail().matches(regEx1)) {
                    sBuffer.append(",");
                    sBuffer.append("\u8bf7\u8f93\u5165\u6709\u6548\u7684\u90ae\u7bb1");
                }
            }
        }
        if (0 < sBuffer.length()) {
            String rspStr = sBuffer.substring(1);
            throw new BaseException(rspStr);
        }
    }

    private void validateImportData(List<SysUsers> users) {
        StringBuffer sBuffer = new StringBuffer();
        if (CollectionUtils.isEmpty(users)) {
            throw new BaseException("\u5bfc\u5165\u6570\u636e\u4e2d\u5e76\u672a\u68c0\u7d22\u5230\u7528\u6237\u6570\u636e");
        }
        for (int i = 0; i < users.size(); ++i) {
            int rowNum = i + 1;
            try {
                this.validateParam(users.get(i), "add");
                continue;
            }
            catch (BaseException e) {
                sBuffer.append(";");
                sBuffer.append("\u7b2c" + rowNum + "\u884c\uff1a" + e.getMessage());
            }
        }
        if (0 < sBuffer.length()) {
            throw new BaseException(sBuffer.substring(1));
        }
    }

    public List<JSTreeModel> getUserByRole(String roleId) {
        List<JSTreeModel> list = this.getUserTreeByRole(roleId);
        List<JSTreeModel> retList = this.computUserByRole(list);
        this.listOrder(retList);
        return retList;
    }

    public List<JSTreeModel> getLazyUserByRole(Long roleId, Long nodeId) {
        Long newNodeId = nodeId;
        ArrayList<JSTreeModel> jsTreeModels = new ArrayList<JSTreeModel>();
        if (newNodeId.equals(Constants.ROOT_NODE_PARENT)) {
            newNodeId = Constants.ROOT_NODE_ID;
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.ROOT_NODE_ID);
            root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
            root.setText("\u5173\u8054\u7528\u6237");
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setType("isRoot");
            jsTreeModels.add(root);
        }
        List<JSTreeModel> list = this.getLazyUserTreeByRole(roleId);
        ArrayList<JSTreeModel> retList = new ArrayList<JSTreeModel>(this.computUserByRole(list));
        for (JSTreeModel jsTreeModel : retList) {
            if (!jsTreeModel.getParent().equals(newNodeId)) continue;
            jsTreeModels.add(jsTreeModel);
        }
        this.listOrder(jsTreeModels);
        for (JSTreeModel model : jsTreeModels) {
            if ("USER".equals(model.getType())) {
                model.setState(true, false, true);
                continue;
            }
            model.setState(false, false, true);
        }
        return jsTreeModels;
    }

    private List<JSTreeModel> computUserByRole(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> resultList = new ArrayList<JSTreeModel>();
        this.computeUserRecursion(list, resultList, 0L);
        return resultList;
    }

    private void computeUserRecursion(List<JSTreeModel> listData, List<JSTreeModel> resultList, Long pId) {
        for (int i = 0; i < listData.size(); ++i) {
            JSTreeModel tmp;
            if (i > listData.size()) {
                i = 0;
            }
            if (!"USER".equals((tmp = listData.get(i)).getType()) && !pId.equals(tmp.getId())) continue;
            resultList.add(tmp);
            listData.remove(tmp);
            this.computeUserRecursion(listData, resultList, tmp.getParent());
        }
    }

    private void listOrder(List<JSTreeModel> list) {
        Collections.sort(list, new Comparator<JSTreeModel>(){

            @Override
            public int compare(JSTreeModel o1, JSTreeModel o2) {
                if (SysUsersServiceImpl.this.formateObj(o1.getFirstOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getFirstOrder())) == 0) {
                    if (SysUsersServiceImpl.this.formateObj(o1.getStruLevel()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruLevel())) == 0) {
                        if (SysUsersServiceImpl.this.formateObj(o1.getStruOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruOrder())) == 0) {
                            return SysUsersServiceImpl.this.formateObj(o1.getText()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getText()));
                        }
                        return SysUsersServiceImpl.this.formateObj(o1.getStruOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruOrder()));
                    }
                    return SysUsersServiceImpl.this.formateObj(o1.getStruLevel()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getStruLevel()));
                }
                return SysUsersServiceImpl.this.formateObj(o1.getFirstOrder()).compareTo(SysUsersServiceImpl.this.formateObj(o2.getFirstOrder()));
            }
        });
    }

    private String formateObj(Object object) {
        return object == null ? "" : object.toString();
    }
}

