/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dto.UserRoleAduitDto;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserRoleVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysUserroleAuditServiceImpl
extends HussarServiceImpl<SysUserroleAuditMapper, SysUserroleAudit>
implements ISysUserroleAuditService {
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysRolesService iSysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;

    public IPage<SysUserRoleVo> getUserRoleReviewList(Page<SysUserRoleVo> page, UserRoleAduitDto userRoleAduitDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (userRoleAduitDto == null) {
            userRoleAduitDto = new UserRoleAduitDto();
        }
        String userName = userRoleAduitDto.getUserName();
        String userAccount = userRoleAduitDto.getUserAccount();
        String type = userRoleAduitDto.getStatus();
        return page.setRecords(this.sysUserroleAuditMapper.getUserRoleReviewList(page, userName, userAccount, type));
    }

    @DSTransactional
    public void reviewSubmit(UserRoleAduitDto sysUserroleAudit) {
        if (ToolUtil.isEmpty((Object)sysUserroleAudit)) {
            throw new BaseException("\u7528\u6237\u89d2\u8272\u5ba1\u6838\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userId = sysUserroleAudit.getUserIds();
        String roleId = sysUserroleAudit.getRoleIds();
        String opsType = sysUserroleAudit.getOperationType();
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        for (String uid : uids) {
            this.iSysRolesService.delAuthCacheInfo(Long.valueOf(uid));
        }
        if (uids.length == oids.length && rids.length == oids.length) {
            ArrayList<SysUserRole> addBpmList = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> deleteBpmList = new ArrayList<SysUserRole>();
            List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, Arrays.asList(uids)));
            ArrayList<SysUserRole> addList = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> updateList = new ArrayList<SysUserRole>();
            ArrayList<SysUserroleAudit> auditList = new ArrayList<SysUserroleAudit>();
            for (int i = 0; i < uids.length; ++i) {
                int count = 0;
                for (SysUserRole userRole : userRoleList) {
                    if (!uids[i].equals(userRole.getUserId().toString()) || !rids[i].equals(userRole.getGrantedRole().toString())) continue;
                    ++count;
                    break;
                }
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                sysUserRole.setUserId(Long.valueOf(uids[i]));
                sysUserRole.setGrantedRole(Long.valueOf(rids[i]));
                if (ADD.equals(oids[i])) {
                    sysUserRole.setAdminOption(UserStatus.OK.getCode());
                } else {
                    sysUserRole.setAdminOption(UserStatus.LOCKED.getCode());
                }
                if (count == 0) {
                    addList.add(sysUserRole);
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else {
                        deleteBpmList.add(sysUserRole);
                    }
                } else {
                    updateList.add(sysUserRole);
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else {
                        deleteBpmList.add(sysUserRole);
                    }
                }
                SysUserroleAudit userroleAudit = new SysUserroleAudit();
                userroleAudit.setStatus(UserRoleStatus.OK.getCode());
                userroleAudit.setUserId(Long.valueOf(uids[i]));
                userroleAudit.setRoleId(Long.valueOf(rids[i]));
                userroleAudit.setOperationType(oids[i]);
                auditList.add(userroleAudit);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                this.sysUserRoleMapper.insertUserRoleBatch(addList);
            }
            if (ToolUtil.isNotEmpty(updateList)) {
                this.sysUserRoleMapper.updateUserRoleBatch(updateList);
            }
            if (ToolUtil.isNotEmpty(auditList)) {
                auditList.forEach(auditLog -> this.sysUserroleAuditMapper.updateIsAuditBatch((SysUserroleAudit)auditLog));
            }
            this.abstractPushMsgMatcher.insertOperation("userRole", "add", addBpmList, Constants.NONE_ID);
            this.abstractPushMsgMatcher.insertOperation("userRole", "delete", deleteBpmList, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushUserRole(addBpmList, "add");
            this.bpmAbstractPushMsgMatcher.pushUserRole(deleteBpmList, "delete");
        }
    }

    @DSTransactional
    public void refuseSubmit(UserRoleAduitDto sysUserroleAudit) {
        if (ToolUtil.isEmpty((Object)sysUserroleAudit)) {
            throw new BaseException("\u7528\u6237\u89d2\u8272\u5ba1\u6838\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userId = sysUserroleAudit.getUserIds();
        String roleId = sysUserroleAudit.getRoleIds();
        String opsType = sysUserroleAudit.getOperationType();
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        ArrayList<SysUserroleAudit> auditList = new ArrayList<SysUserroleAudit>();
        if (uids.length == oids.length && rids.length == oids.length) {
            for (int i = 0; i < uids.length; ++i) {
                SysUserroleAudit userroleAudit = new SysUserroleAudit();
                userroleAudit.setStatus(UserRoleStatus.REFUSE.getCode());
                userroleAudit.setUserId(Long.valueOf(uids[i]));
                userroleAudit.setRoleId(Long.valueOf(rids[i]));
                userroleAudit.setOperationType(oids[i]);
                auditList.add(userroleAudit);
            }
            if (ToolUtil.isNotEmpty(auditList)) {
                auditList.forEach(auditLog -> this.sysUserroleAuditMapper.updateIsAuditBatch((SysUserroleAudit)auditLog));
            }
        }
    }

    public int isDelete(Long id) {
        return this.sysUserroleAuditMapper.isDelete(id);
    }
}

