/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRole>
implements ISysUserRoleService {
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysConfRolesService isConfRolesService;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private ISysRolesService sysRolesService;
    private static final String DISABLED = "0";
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;

    public void deleteNotPublicRole(String userId) {
        this.sysUserRoleMapper.deleteNotPublicRole(userId);
    }

    public void addRecord(SysUserRole sysUserRole) {
        this.sysUserRoleMapper.insert(sysUserRole);
    }

    public List<Long> getRolesByUserId(Long userId) {
        if (userId == null) {
            return new ArrayList<Long>();
        }
        return this.sysUserRoleMapper.getRolesByUserId(userId);
    }

    public List<String> selectUserIdByRoleId(String roleId) {
        return this.sysUserRoleMapper.selectUserIdByRoleId(roleId);
    }

    @DSTransactional
    public ApiResponse<Tip> saveOrDelUserRole(RoleUserDto roleUserDto) {
        Long roleId = roleUserDto.getRoleId();
        List adds = roleUserDto.getAdds();
        List dels = roleUserDto.getDels();
        if (ToolUtil.isEmpty((Object)roleId)) {
            throw new BaseException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Long> hasDel = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)dels)) {
            for (RoleOrgUserVo roleOrgUserVo : dels) {
                hasDel.add(roleOrgUserVo.getId());
            }
        }
        ArrayList<Long> addIds = new ArrayList<Long>();
        ArrayList<Long> addIdsTemp = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty((Object)adds)) {
            for (RoleOrgUserVo roleOrgUserVo : adds) {
                addIds.add(roleOrgUserVo.getId());
                addIdsTemp.add(roleOrgUserVo.getId());
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)ADD);
        List se = this.sysUserRoleMapper.selectList((Wrapper)wrapper);
        for (Object sysUserRole : se) {
            for (int i = 0; i < addIdsTemp.size(); ++i) {
                if (!((Long)addIdsTemp.get(i)).equals(sysUserRole.getUserId()) || !ADD.equals(sysUserRole.getAdminOption())) continue;
                addIds.remove(addIdsTemp.get(i));
            }
        }
        ArrayList<Long> delNew = new ArrayList<Long>();
        for (SysUserRole sysUserRole : se) {
            for (Long del : hasDel) {
                if (!del.equals(sysUserRole.getUserId()) || DELETE.equals(sysUserRole.getAdminOption())) continue;
                delNew.add(del);
            }
        }
        Long count = this.sysConfRolesMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getId, (Object)roleId));
        if (count > 0L) {
            for (Long l : addIds) {
                List<Long> rolesList = this.getRolesByUserId(l);
                if (!rolesList.contains(roleId)) {
                    rolesList.add(roleId);
                }
                if (!this.isConfRolesService.isIncludeConfRole(rolesList.toArray(new Long[rolesList.size()]))) continue;
                SysUsers user = (SysUsers)this.sysUsersMapper.selectById(l);
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08" + user.getUserName() + " \u8fdd\u53cd\u4e86\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u89c4\u5219\uff09");
            }
        }
        List auditList = this.sysUserroleAuditMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)roleId));
        if (this.sysAuditConfig.isRoleAudit() && this.sysAuditConfig.isCriticalOperationsAudit()) {
            SysUserroleAudit sysUserroleAudit;
            boolean exist;
            if (ToolUtil.isNotEmpty(addIds)) {
                for (Long userId : addIds) {
                    exist = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist = true;
                        audit.setOperationType(ADD);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)userId)).eq(SysUserroleAudit::getRoleId, (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(userId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(ADD);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delNew)) {
                for (Long userId : delNew) {
                    exist = false;
                    for (SysUserroleAudit audit : auditList) {
                        if (!userId.equals(audit.getUserId())) continue;
                        exist = true;
                        audit.setOperationType(DELETE);
                        audit.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)audit, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)userId)).eq(SysUserroleAudit::getRoleId, (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(userId);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(DELETE);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (addIds.size() > 0 || delNew.size() > 0) {
                return ApiResponse.success((String)"\u63d0\u4ea4\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
        } else {
            if (ToolUtil.isNotEmpty(delNew)) {
                this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, delNew));
                this.bpmAbstractPushMsgMatcher.deleteUserRole(delNew, null, null, roleId);
            }
            ArrayList<SysUserRole> arrayList = new ArrayList<SysUserRole>();
            for (Long userId : addIds) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                arrayList.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(userId);
            }
            if (ToolUtil.isNotEmpty(arrayList)) {
                this.saveBatch(arrayList, arrayList.size());
                this.bpmAbstractPushMsgMatcher.pushUserRole(arrayList, "add");
            }
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

