/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncPermitDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysStruFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruFunctionsService;
import com.jxdinfo.hussar.authorization.permit.vo.StruFunVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysStruFunctionsServiceImpl
extends HussarServiceImpl<SysStruFunctionsMapper, SysStruFunctions>
implements ISysStruFunctionsService {
    @Autowired
    private ISysFunctionResourcesService iSysFunctionResourcesService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private SysStruFunctionsMapper sysStruFunctionsMapper;

    public List<Long> getStruFunctionCountMap(List<JSTreeModel> list, List<Long> functionIdList) {
        ArrayList<Long> struIdList = new ArrayList<Long>();
        for (JSTreeModel jsTreeModel : list) {
            Long struId = jsTreeModel.getId();
            struIdList.add(struId);
        }
        int maxSize = functionIdList.size();
        ArrayList<Long> rtnList = new ArrayList<Long>();
        List<StruFunVo> result = this.sysStruFunctionsMapper.getStruFunctionCountMap(struIdList, functionIdList);
        for (StruFunVo struFunVo : result) {
            Long struId = struFunVo.getStruId();
            String countStr = struFunVo.getStruCount();
            Long count = Long.parseLong(countStr);
            if (count.intValue() != maxSize) continue;
            rtnList.add(struId);
        }
        return rtnList;
    }

    @DSTransactional
    public ApiResponse<Tip> saveDelegateFunction(FuncPermitDto funcPermitDto) {
        String functionId = funcPermitDto.getFunctionIdHidden();
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new HussarException("\u4e0b\u653e\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] struIdArr = funcPermitDto.getStruIdHidden() == null ? "".split(",") : funcPermitDto.getStruIdHidden().split(",");
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        ArrayList<Long> struIds = new ArrayList<Long>();
        struIdList.forEach(struId -> struIds.add(Long.valueOf(struId)));
        ArrayList<Long> funtionIdList = new ArrayList<Long>();
        funtionIdList.add(Long.valueOf(functionId));
        this.sysStruFunctionsMapper.deleteStruFuncton(struIds, funtionIdList);
        ArrayList<SysStruFunctions> functionsList = new ArrayList<SysStruFunctions>();
        for (String tmpStruId : struIdList) {
            for (Long tmpFunctionId : funtionIdList) {
                SysStruFunctions sysStruFunctions = new SysStruFunctions();
                sysStruFunctions.setStruId(Long.valueOf(tmpStruId));
                sysStruFunctions.setFunctionId(tmpFunctionId);
                functionsList.add(sysStruFunctions);
            }
        }
        if (ToolUtil.isEmpty(functionsList)) {
            throw new HussarException("\u6240\u9009\u529f\u80fd\u5df2\u5168\u90e8\u4e0b\u653e\u5230\u9009\u4e2d\u7684\u7ec4\u7ec7\uff01");
        }
        if (!super.saveBatch(functionsList, functionsList.size())) {
            throw new HussarException("\u4e0b\u653e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4e0b\u653e\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse<Tip> saveRetrieveFunction(FuncPermitDto funcPermitDto) {
        String functionId = funcPermitDto.getFunctionIdHidden();
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new HussarException("\u56de\u6536\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] struIdArr = funcPermitDto.getStruIdHidden() == null ? "".split(",") : funcPermitDto.getStruIdHidden().split(",");
        String[] orginalIds = funcPermitDto.getOriginal() == null ? "".split(",") : funcPermitDto.getOriginal().split(",");
        List<String> originalIdList = Arrays.asList(orginalIds);
        ArrayList<Long> originalIds = new ArrayList<Long>();
        originalIdList.forEach(id -> originalIds.add(Long.valueOf(id)));
        ArrayList<String> struIdList = new ArrayList<String>(Arrays.asList(struIdArr));
        ArrayList<Long> funtionIdList = new ArrayList<Long>();
        funtionIdList.add(Long.valueOf(functionId));
        QueryWrapper sysFunctionResourcesQueryWrapper = new QueryWrapper();
        sysFunctionResourcesQueryWrapper.lambda().in(SysFunctionResources::getFunctionId, funtionIdList);
        List sysFunctionResourcesList = this.iSysFunctionResourcesService.list((Wrapper)sysFunctionResourcesQueryWrapper);
        ArrayList<Long> resourceIdList = ToolUtil.isNotEmpty((Object)sysFunctionResourcesList) ? sysFunctionResourcesList.stream().map(SysFunctionResources::getResourceId).collect(Collectors.toList()) : new ArrayList<Long>();
        this.sysStruFunctionsMapper.deleteStruFuncton(originalIds, funtionIdList);
        this.sysStruFunctionsMapper.deleteStruRoleFunction(originalIds, funtionIdList);
        if (ToolUtil.isNotEmpty(resourceIdList)) {
            this.sysRoleResourceMapper.deleteStruRoleResource(originalIds, resourceIdList);
        }
        ArrayList<SysStruFunctions> functionsList = new ArrayList<SysStruFunctions>();
        for (String tmpStruId : struIdList) {
            if ("".equals(tmpStruId)) continue;
            for (Long tmpFunctionId : funtionIdList) {
                SysStruFunctions sysStruFunctions = new SysStruFunctions();
                sysStruFunctions.setStruId(Long.valueOf(tmpStruId));
                sysStruFunctions.setFunctionId(tmpFunctionId);
                functionsList.add(sysStruFunctions);
            }
        }
        if (ToolUtil.isNotEmpty(functionsList) && !super.saveBatch(functionsList, functionsList.size())) {
            throw new HussarException("\u56de\u6536\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u56de\u6536\u6210\u529f\uff01");
    }
}

