/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.SysRoleResourceVo;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysRoleResourceServiceImpl
extends ServiceImpl<SysRoleResourceMapper, SysRoleResource>
implements ISysRoleResourceService {
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysUserroleAuditService sysUserroleAuditService;
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    private IGlobalService globalService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    @Lazy
    private ISysConfRolesService isConfRolesService;
    @Resource
    @Lazy
    private ISysUsersService sysUsersService;

    @DSTransactional
    public void saveRoleResource(String resourceIds, Long roleId) {
        this.sysRoleResourceMapper.deleteById(roleId);
        String[] id = resourceIds.split(",");
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String reId : id) {
            if (ToolUtil.isEmpty((Object)reId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setId(roleId);
            sysRoleResource.setResourceId(Long.valueOf(reId));
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            super.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
    }

    @DSTransactional
    public void saveRoleResourceAndRelation(String resourceIds, Long roleId) {
        this.sysRoleResourceMapper.deleteRoleResourceOfRelation(roleId, DELETE);
        String[] id = resourceIds.split(",");
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String reId : id) {
            if (ToolUtil.isEmpty((Object)reId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setId(roleId);
            sysRoleResource.setResourceId(Long.valueOf(reId));
            sysRoleResource.setRelationSource(DELETE);
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            super.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        List userIds = this.sysRolesService.delCacheAuthInfo(roleId);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
    }

    @DSTransactional
    public void reclaimPerm(Long id) {
        this.sysRoleResourceMapper.deleteById(id);
        List userIds = this.sysRolesService.delCacheAuthInfo(id);
        for (Long userId : userIds) {
            this.sysRolesService.delAuthCacheInfo(userId);
        }
    }

    public List<SysRoleResource> queryPerm(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sysRoleResourceMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getId, (Object)id));
    }

    @DSTransactional
    public void saveRoleUserAdd(String userIds, Long roleId) {
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        if (this.sysAuditConfig.isRoleAudit()) {
            ArrayList<SysUserroleAudit> sysUserroleAuditList = new ArrayList<SysUserroleAudit>();
            for (String string : ids) {
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setUserId(Long.valueOf(string));
                sysUserroleAudit.setRoleId(roleId);
                sysUserroleAudit.setStatus(UserStatus.LOCKED.getCode());
                sysUserroleAudit.setOperationType(ADD);
                sysUserroleAuditList.add(sysUserroleAudit);
            }
            if (ToolUtil.isNotEmpty(sysUserroleAuditList)) {
                this.sysUserroleAuditService.saveBatch(sysUserroleAuditList, sysUserroleAuditList.size());
            }
        } else {
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            for (String string : ids) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(Long.valueOf(string));
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(Long.valueOf(string));
            }
            if (ToolUtil.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
    }

    @DSTransactional
    public void updateRoleUserEdit(String userIds, Long roleId) {
        boolean exist;
        List confRolesList;
        List<Object> ids = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)userIds)) {
            ids = Arrays.asList(userIds.split(","));
        }
        if (ToolUtil.isNotEmpty((Object)(confRolesList = this.isConfRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getId, (Object)roleId))))) {
            for (String string : ids) {
                List rolesList = this.sysUserRoleService.getRolesByUserId(Long.valueOf(string));
                if (!rolesList.contains(roleId)) {
                    rolesList.add(Long.valueOf(roleId));
                }
                if (!this.isConfRolesService.isIncludeConfRole(rolesList.toArray(new Long[rolesList.size()]))) continue;
                SysUsers user = (SysUsers)this.sysUsersService.getById((Serializable)((Object)string));
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08" + user.getUserName() + " \u8fdd\u53cd\u4e86\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u89c4\u5219\uff09");
            }
        }
        List userRoleList = this.sysUserRoleMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
        List list = this.sysUserroleAuditMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getRoleId, (Object)roleId));
        ArrayList<Long> addList = new ArrayList<Long>();
        ArrayList<Long> delList = new ArrayList<Long>();
        for (SysUserRole sysUserRole : userRoleList) {
            exist = false;
            for (String string : ids) {
                if (ToolUtil.isEmpty((Object)string) || !string.equals(sysUserRole.getUserId())) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            delList.add(sysUserRole.getUserId());
        }
        for (String string : ids) {
            if (ToolUtil.isEmpty((Object)string)) continue;
            exist = false;
            for (SysUserRole sysUserRole : userRoleList) {
                if (!sysUserRole.getUserId().equals(string)) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            addList.add(Long.valueOf(string));
        }
        if (this.sysAuditConfig.isRoleAudit()) {
            SysUserroleAudit sysUserroleAudit;
            if (ToolUtil.isNotEmpty(addList)) {
                for (Long l : addList) {
                    exist = false;
                    for (SysUserroleAudit sysUserroleAudit2 : list) {
                        if (!l.equals(sysUserroleAudit2.getUserId())) continue;
                        exist = true;
                        sysUserroleAudit2.setOperationType(ADD);
                        sysUserroleAudit2.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)sysUserroleAudit2, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)l)).eq(SysUserroleAudit::getRoleId, (Object)sysUserroleAudit2.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(l);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(ADD);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delList)) {
                for (Long l : delList) {
                    exist = false;
                    for (SysUserroleAudit sysUserroleAudit3 : list) {
                        if (!l.equals(sysUserroleAudit3.getUserId())) continue;
                        exist = true;
                        sysUserroleAudit3.setOperationType(DELETE);
                        sysUserroleAudit3.setStatus(UserRoleStatus.LOCKED.getCode());
                        this.sysUserroleAuditService.update((Object)sysUserroleAudit3, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)l)).eq(SysUserroleAudit::getRoleId, (Object)sysUserroleAudit3.getRoleId()));
                    }
                    if (exist) continue;
                    sysUserroleAudit = new SysUserroleAudit();
                    sysUserroleAudit.setUserId(l);
                    sysUserroleAudit.setRoleId(roleId);
                    sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                    sysUserroleAudit.setOperationType(DELETE);
                    this.sysUserroleAuditService.save((Object)sysUserroleAudit);
                }
            }
        } else {
            if (ToolUtil.isNotEmpty(delList)) {
                this.sysUserRoleMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getGrantedRole, (Object)roleId)).in(SysUserRole::getUserId, delList));
            }
            for (Long l : delList) {
                this.sysRolesService.delAuthCacheInfo(l);
            }
            ArrayList<SysUserRole> userRoleList2 = new ArrayList<SysUserRole>();
            for (Long userId : addList) {
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(userId);
                sysUserRole.setGrantedRole(roleId);
                sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                userRoleList2.add(sysUserRole);
                this.sysRolesService.delAuthCacheInfo(userId);
            }
            if (ToolUtil.isNotEmpty(userRoleList2)) {
                this.sysUserRoleService.saveBatch(userRoleList2, userRoleList2.size());
            }
        }
    }

    public List<SysRoleResourceVo> selectResource(Long roleId, String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return new ArrayList<SysRoleResourceVo>();
        }
        String[] resourceIds = ids == null ? "".split(",") : ids.split(",");
        ArrayList<Long> resourceIdList = new ArrayList<Long>();
        for (String resourceId : resourceIds) {
            if (!ToolUtil.isNotEmpty((Object)resourceId)) continue;
            resourceIdList.add(Long.valueOf(resourceId));
        }
        List<Object> voList = new ArrayList<SysRoleResourceVo>();
        if (this.globalService.isRoleResourceCheck()) {
            voList = ((SysRoleResourceMapper)this.baseMapper).checkResource(roleId, resourceIdList).stream().collect(Collectors.groupingBy(SysRoleResource::getResourceId)).entrySet().stream().map(stEntity -> {
                ArrayList roleIds = new ArrayList();
                ArrayList roleNames = new ArrayList();
                String resourceName = ((SysRoleResourceVo)((List)stEntity.getValue()).get(0)).getResourceName();
                ((List)stEntity.getValue()).stream().peek(st -> roleIds.add(String.valueOf(st.getId()))).forEach(st -> {
                    if (HussarUtils.isNotEmpty((Object)st.getRoleName())) {
                        roleNames.add(st.getRoleName());
                    }
                });
                SysRoleResourceVo sysRoleResourceVo = new SysRoleResourceVo();
                sysRoleResourceVo.setResourceId((Long)stEntity.getKey());
                sysRoleResourceVo.setResourceName(resourceName);
                sysRoleResourceVo.setRoleId(String.join((CharSequence)",", roleIds));
                sysRoleResourceVo.setRoleName(String.join((CharSequence)",", roleNames));
                return sysRoleResourceVo;
            }).collect(Collectors.toList());
        }
        return voList;
    }

    public List<SysRoleResource> getRealResource(String roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ROLE_ID", (Object)roleId);
        queryWrapper.eq((Object)"RELATION_SOURCE", (Object)DELETE);
        return super.list((Wrapper)queryWrapper);
    }

    public List<JSTreeModel> selfResourceTree(String resourceIds) {
        String[] resourceIdArr = ToolUtil.isEmpty((Object)resourceIds) ? "".split(",") : resourceIds.trim().split(",");
        Long[] resourceIdLongArr = new Long[resourceIdArr.length];
        if (ToolUtil.isNotEmpty((Object)resourceIds)) {
            for (int i = 0; i < resourceIdArr.length; ++i) {
                resourceIdLongArr[i] = Long.valueOf(resourceIdArr[i]);
            }
        }
        List<JSTreeModel> resourceTreeData = this.sysRoleResourceMapper.selfResourceTree(resourceIdLongArr);
        return this.doRecursive(resourceTreeData);
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, Constants.NONE_NODE_ID);
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setCode("GROUP");
        model.setText("\u6a21\u5757\u8d44\u6e90\u5217\u8868");
        model.setId(Constants.RES_NODE_ID);
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, Long parentId) {
        Long newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!ADD.equals(map.getIsRes()) && !newParentId.equals(map.getId())) continue;
            newParentId = map.getParent();
            result.add(map);
            list.remove(map);
            if (--i == 0) {
                i = -1;
            }
            this.recursive(list, result, newParentId);
        }
    }

    public List<SysRoleResource> getResourceRoles(String resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId)).ne(SysRoleResource::getRelationSource, (Object)ADD));
    }
}

