/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysRoleFunctionsServiceImpl
extends ServiceImpl<SysRoleFunctionsMapper, SysRoleFunctions>
implements ISysRoleFunctionsService {
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private ISysFunctionResourcesService iSysFunctionResourcesService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;

    public void saveFunctions(String functionsIds, Long roleId) {
        Object[] ids = functionsIds.split(",");
        this.sysRoleFunctionsMapper.deleteById(roleId);
        this.sysRoleResourceMapper.deleteRoleResourceOfRelation(roleId, "1");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"FUNCTION_ID", ids);
        ArrayList<SysRoleFunctions> sysRoleFunctionsList = new ArrayList<SysRoleFunctions>();
        for (Object functionId : ids) {
            if (ToolUtil.isEmpty((Object)functionId)) continue;
            SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
            sysRoleFunctions.setRoleId(roleId);
            sysRoleFunctions.setFunctionId(Long.valueOf((String)functionId));
            sysRoleFunctionsList.add(sysRoleFunctions);
        }
        if (ToolUtil.isNotEmpty(sysRoleFunctionsList)) {
            super.saveBatch(sysRoleFunctionsList, sysRoleFunctionsList.size());
            List sysFunctionResources = this.iSysFunctionResourcesService.list((Wrapper)queryWrapper);
            ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
            for (SysFunctionResources functionResources : sysFunctionResources) {
                SysRoleResource sysRoleResource = new SysRoleResource();
                sysRoleResource.setId(roleId);
                sysRoleResource.setResourceId(functionResources.getResourceId());
                sysRoleResource.setRelationSource("1");
                sysRoleResourceList.add(sysRoleResource);
            }
            if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
                this.iSysRoleResourceService.saveBatch(sysRoleResourceList);
            }
        }
    }

    public List<SysRoleFunctions> getRoleFunctions(String roleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"ROLE_ID", (Object)roleId);
        return super.list((Wrapper)queryWrapper);
    }

    public List<JSTreeModel> selfFunctionTree(String functionIds) {
        String[] functionIdArr = ToolUtil.isEmpty((Object)functionIds) ? "".split(",") : functionIds.trim().split(",");
        List<JSTreeModel> functionTreeData = this.sysRoleFunctionsMapper.selfFunctionTree(functionIdArr);
        return this.doRecursive(functionTreeData);
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList childList = new ArrayList();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        list.forEach(m -> {
            if ("1".equals(m.getIsRes())) {
                childList.add(m);
                parentIdList.add(m.getParent());
            } else {
                otherList.add((JSTreeModel)m);
            }
        });
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>(childList);
        if (ToolUtil.isNotEmpty(otherList)) {
            this.recursive(otherList, result, parentIdList);
        }
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setCode("GROUP");
        model.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        model.setId(Constants.RES_NODE_ID);
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, List<Long> idList) {
        ArrayList currentList = new ArrayList();
        ArrayList<Long> parentIdList = new ArrayList<Long>();
        ArrayList<JSTreeModel> otherList = new ArrayList<JSTreeModel>();
        list.forEach(model -> {
            if (idList.contains(model.getId())) {
                currentList.add(model);
                parentIdList.add(model.getParent());
            } else {
                otherList.add((JSTreeModel)model);
            }
        });
        if (ToolUtil.isNotEmpty(currentList)) {
            result.addAll(currentList);
            this.recursive(otherList, result, parentIdList);
        }
    }
}

