/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleDataScopeMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleDataScope;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataScopeService;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysRoleDataScopeServiceImpl
extends ServiceImpl<SysRoleDataScopeMapper, SysRoleDataScope>
implements ISysRoleDataScopeService {
    @Resource
    private SysRoleDataScopeMapper sysRoleDataScopeMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;

    public List<Long> getOrgListByRoleId(Long roleId) {
        return this.sysRoleDataScopeMapper.getOrgListByRoleId(roleId);
    }

    @DSTransactional
    public ApiResponse<Tip> saveDateScope(DataScopeVo dataScopeVo) {
        boolean flag;
        Long roleId = dataScopeVo.getRoleId();
        List orgIds = dataScopeVo.getOrgIds();
        String type = dataScopeVo.getType();
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleDataScope::getRoleId, (Object)roleId));
        if ("5".equals(type) && ToolUtil.isNotEmpty((Object)orgIds)) {
            ArrayList<SysRoleDataScope> list = new ArrayList<SysRoleDataScope>();
            for (Long id : orgIds) {
                SysRoleDataScope sysRoleDataScope = new SysRoleDataScope();
                sysRoleDataScope.setRoleId(roleId);
                sysRoleDataScope.setOrgId(id);
                list.add(sysRoleDataScope);
            }
            this.saveBatch(list);
        }
        if (!(flag = SqlHelper.retBool((Integer)this.sysRolesMapper.update(null, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysRoles::getDataScopeType, (Object)type)).eq(SysRoles::getId, (Object)roleId))))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public DataScopeVo getRoleDateScope(Long roleId) {
        SysRoles sysRoles = (SysRoles)this.sysRolesMapper.selectById(roleId);
        String dataScopeType = ToolUtil.isNotEmpty((Object)sysRoles.getDataScopeType()) ? sysRoles.getDataScopeType() : "";
        List<Long> orgIds = this.getOrgListByRoleId(roleId);
        DataScopeVo dataScopeVo = new DataScopeVo();
        dataScopeVo.setType(dataScopeType);
        dataScopeVo.setOrgIds(orgIds);
        dataScopeVo.setRoleId(roleId);
        return dataScopeVo;
    }
}

