/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleResourceMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FunResourceEntity;
import com.jxdinfo.hussar.authorization.permit.dto.ResListDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourcePathDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeByIdDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceUniqueDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.CheckResourceVo;
import com.jxdinfo.hussar.authorization.permit.vo.ImportVueResVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysFunctionVO;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleResourcesVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleVO;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.ResourceWithAdminException;
import com.jxdinfo.hussar.common.exception.ResourceWithFunctionException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysResManageServiceImpl
extends HussarServiceImpl<SysResourcesMapper, SysResources>
implements ISysResManageService {
    @Resource
    private SysResourcesMapper sysResourcesMapper;
    @Resource
    private SysModulesMapper sysModulesMapper;
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Resource
    private SysRoleResourceMapper sysRoleResourceMapper;
    @Resource
    private ISysModulesService sysModulesService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IGlobalService globalService;
    @Resource
    @Lazy
    ISysRoleResourceService sysRoleResourceService;
    @Resource
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private ISysFunctionModulesService sysFunctionModulesService;
    @Resource
    private ISysResourceMosulesService sysResourceMosulesService;
    @Resource
    private SysResourceModulesMapper sysResourceModulesMapper;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Resource
    private ISysFunctionResourcesService iSysFunctionResourcesService;
    @Resource
    private ISysResourcesService iSysResourcesService;

    public List<JSTreeModel> getResTree() {
        return this.sysModulesMapper.getModulesTree();
    }

    public SysResourceModules getModuleInfoById(String moduleId) {
        this.checkParams(moduleId, "getModuleInfoById");
        return this.sysResourceModulesMapper.getModuleInfoById(moduleId);
    }

    public ApiResponse<Tip> saveModules(SysResourceModules sysResourceModules) {
        this.checkParams(sysResourceModules, "saveModules");
        if (ToolUtil.isEmpty((Object)sysResourceModules)) {
            throw new BaseException("\u6a21\u5757\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long userId = null;
        if (sysResourceModules.getCreator() != null && "godaxe".equals(sysResourceModules.getCreator())) {
            userId = sysResourceModules.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysResourceModules.getId())) {
            sysResourceModules.setId(null);
            Long max = this.sysResourceModulesMapper.getMaxOrderByParentId(sysResourceModules.getParentModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysResourceModules.setSeq(order.add(num));
            } else {
                sysResourceModules.setSeq(new BigDecimal(1));
            }
            sysResourceModules.setCreator(userId);
            if (!this.sysResourceMosulesService.save((Object)sysResourceModules)) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
            }
            return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
        }
        sysResourceModules.setLastEditor(userId);
        if (!this.sysResourceMosulesService.updateById((Object)sysResourceModules)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> updateModules(SysModules sysModules) {
        if (ToolUtil.isEmpty((Object)sysModules)) {
            throw new BaseException("\u6a21\u5757\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkParams(sysModules, "updateModules");
        boolean isAllowEditModule = this.isAllowEditModule(sysModules);
        if (!isAllowEditModule) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u5b58\u5728\u4e0b\u7ea7\u6a21\u5757\u6216\u4e0b\u7ea7\u529f\u80fd\u65f6\u4e0d\u80fd\u4fee\u6539\u6a21\u5757\u7c7b\u578b\uff01\uff09");
        }
        if (!this.sysModulesService.updateById((Object)sysModules)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public List<JSTreeModel> moduleTreeById(String moduleId, boolean isRoot) {
        this.checkParams(moduleId, "moduleTreeById");
        List<JSTreeModel> result = this.sysResourceModulesMapper.moduleTreeById(moduleId);
        if (isRoot) {
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.RES_NODE_ID);
            root.setCode(String.valueOf(Constants.RES_NODE_ID));
            root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    public ApiResponse<Tip> saveFunction(SysFunctions sysFunctions) {
        if (ToolUtil.isEmpty((Object)sysFunctions)) {
            throw new BaseException("\u529f\u80fd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkParams(sysFunctions, "saveFunction");
        sysFunctions.setId(null);
        Long max = this.sysFunctionsMapper.getMaxOrderByParentId(sysFunctions.getFunctionModuleId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            BigDecimal order = BigDecimal.valueOf(max);
            sysFunctions.setSeq(order.add(num));
        } else {
            sysFunctions.setSeq(new BigDecimal(1));
        }
        if (!this.sysFunctionsService.save((Object)sysFunctions)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> updateFunction(SysFunctions sysFunctions) {
        if (ToolUtil.isEmpty((Object)sysFunctions)) {
            throw new BaseException("\u529f\u80fd\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkParams(sysFunctions, "updateFunction");
        if (!this.sysFunctionsService.updateById((Object)sysFunctions)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    public SysFunctionVO getFunctionInfoById(String functionId) {
        this.checkParams(functionId, "getFunctionInfoById");
        return this.sysFunctionsMapper.getFunctionInfoById(functionId);
    }

    public Long resourceSave(SysResources sysResources) {
        Date date = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Long userId = null;
        if (sysResources.getCreator() != null && "godaxe".equals(sysResources.getCreator())) {
            userId = sysResources.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysResources.getId())) {
            sysResources.setId(null);
            Long max = this.sysResourcesMapper.getMaxOrderByParentId(sysResources.getModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysResources.setSeq(order.add(num));
            } else {
                sysResources.setSeq(new BigDecimal(1));
            }
            sysResources.setCreator(userId);
            this.sysResourcesMapper.insert(sysResources);
        } else {
            sysResources.setLastEditor(userId);
            this.sysResourcesMapper.updateById(sysResources);
        }
        return sysResources.getId();
    }

    public Long saveResource(SysResources sysResources) {
        if (ToolUtil.isEmpty((Object)sysResources)) {
            throw new BaseException("\u8d44\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((CharSequence)sysResources.getPermissions())) {
            List allResources;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysResources::getPermissions, (Object)sysResources.getPermissions());
            if (ToolUtil.isNotEmpty((Object)sysResources.getId())) {
                queryWrapper.and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wrapper.ne(SysResources::getId, (Object)sysResources.getId());
                });
            }
            if ((allResources = this.list((Wrapper)queryWrapper)).size() > 0) {
                throw new BaseException("\u6743\u9650\u6807\u8bc6\u5df2\u7ecf\u5b58\u5728\uff01");
            }
        }
        Long userId = null;
        if (sysResources.getCreator() != null && "godaxe".equals(sysResources.getCreator())) {
            userId = sysResources.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysResources.getId())) {
            sysResources.setId(null);
            Long max = this.sysResourcesMapper.getMaxOrderByParentId(sysResources.getModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysResources.setSeq(order.add(num));
            } else {
                sysResources.setSeq(new BigDecimal(1));
            }
            sysResources.setCreator(userId);
            if (!this.sysResourcesService.save((Object)sysResources)) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
            }
        } else {
            sysResources.setLastEditor(userId);
            if (!this.sysResourcesService.updateById((Object)sysResources)) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
            }
        }
        return sysResources.getId();
    }

    public Long updateResource(SysResources sysResources) {
        if (ToolUtil.isEmpty((Object)sysResources)) {
            throw new BaseException("\u8d44\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("res_menu".equals(sysResources.getResTypeId())) {
            sysResources.setIsRepeatAuthenticate("0");
        }
        if (!this.sysResourcesService.updateById((Object)sysResources)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return sysResources.getId();
    }

    public SysResources getResourceInfoById(String resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sysResourcesMapper.getResourceInfoById(resourceId);
    }

    @DSTransactional
    public void updateModuleTreeOrder(List<Long> idList) {
        this.checkParams(idList, "updateModuleTreeOrder");
        ArrayList<SysModules> sysModulesList = new ArrayList<SysModules>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysModules sysModules = new SysModules();
            sysModules.setId(id);
            sysModules.setSeq(new BigDecimal(i + 1));
            sysModulesList.add(sysModules);
        }
        if (ToolUtil.isNotEmpty(sysModulesList)) {
            this.sysModulesService.updateBatchById(sysModulesList, sysModulesList.size());
        }
    }

    public List<JSTreeModel> getFunctionTreeByModuleId(Long moduleId, String moduleName) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<JSTreeModel> result = this.sysFunctionsMapper.functionTreeByModuleId(moduleId);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return result;
    }

    public void updateFunctionTreeOrder(List<Long> idList) {
        this.checkParams(idList, "updateModuleTreeOrder");
        ArrayList<SysFunctions> sysFunctionsList = new ArrayList<SysFunctions>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysFunctions sysFunctions = new SysFunctions();
            sysFunctions.setId(id);
            sysFunctions.setSeq(new BigDecimal(i + 1));
            sysFunctionsList.add(sysFunctions);
        }
        if (ToolUtil.isNotEmpty(sysFunctionsList)) {
            this.sysFunctionsService.updateBatchById(sysFunctionsList, sysFunctionsList.size());
        }
    }

    public List<JSTreeModel> getResourceTreeByModuleId(ResourceTreeByIdDto resourceTreeByIdDto) {
        if (ToolUtil.isEmpty((Object)resourceTreeByIdDto.getFunctionId())) {
            throw new BaseException("\u529f\u80fdID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<JSTreeModel> result = this.sysResourcesMapper.resourceTreeByModuleId(resourceTreeByIdDto.getFunctionId());
        JSTreeModel root = new JSTreeModel();
        root.setId(resourceTreeByIdDto.getFunctionId());
        root.setText(resourceTreeByIdDto.getFunctionName());
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isFun");
        result.add(root);
        return result;
    }

    public boolean updateResourceTreeOrder(List<Long> idList) {
        ArrayList<SysResources> sysResourcesList = new ArrayList<SysResources>();
        boolean flag = false;
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysResources sysResources = new SysResources();
            sysResources.setId(id);
            sysResources.setSeq(new BigDecimal(i + 1));
            sysResourcesList.add(sysResources);
        }
        if (ToolUtil.isNotEmpty(sysResourcesList)) {
            flag = this.sysResourcesService.updateBatchById(sysResourcesList, sysResourcesList.size());
        }
        return flag;
    }

    public List<JSTreeModel> getModuleChangeById(String moduleId, String isLeaf) {
        List<JSTreeModel> jsTreeModelList = this.sysModulesMapper.moduleChangeTreeById(moduleId, isLeaf);
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        jsTreeModelList.add(root);
        return jsTreeModelList;
    }

    public void updateFunctionTreeChange(Long functionId, Long parentId) {
        if (ToolUtil.isEmpty((Object)functionId) || ToolUtil.isEmpty((Object)parentId)) {
            throw new BaseException("\u529f\u80fdID\u53ca\u5176\u7236\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long max = this.sysFunctionsMapper.getMaxOrderByParentId(parentId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysFunctionsMapper.functionTreeChange(functionId, parentId, order);
    }

    public void updateFunctionModulesTreeChange(Long functionModuleId, Long parentId) {
        SysFunctionModules byId;
        List list = this.sysFunctionModulesService.list();
        List collect = list.stream().filter(o -> functionModuleId.longValue() == o.getId().longValue()).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(collect) && (byId = (SysFunctionModules)collect.get(0)).getParentModuleId().longValue() == parentId.longValue()) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u529f\u80fd\u6a21\u5757\u89c4\u5219\uff01\uff09");
        }
        Long parentModuleId = parentId;
        Long rootId = 1L;
        while (parentModuleId.longValue() != rootId.longValue()) {
            SysFunctionModules one = new SysFunctionModules();
            for (SysFunctionModules o2 : list) {
                if (parentModuleId.longValue() != o2.getId().longValue()) continue;
                one = o2;
            }
            parentModuleId = one.getParentModuleId();
            if (functionModuleId.longValue() != parentModuleId.longValue()) continue;
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u529f\u80fd\u6a21\u5757\u89c4\u5219\uff01\uff09");
        }
        Long max = this.sysFunctionModulesMapper.getMaxOrderByParentId(functionModuleId);
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysFunctionModulesMapper.functionModulesTreeChange(functionModuleId, parentId, order);
    }

    public List<JSTreeModel> getResourceChangeById(String resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<JSTreeModel> result = this.sysResourceModulesMapper.resourceChangeById(resourceId);
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        result.add(root);
        return result;
    }

    public void updateResourceTreeChange(ResourceTreeChangeDto resourceTreeChangeDto) {
        if (ToolUtil.isEmpty((Object)resourceTreeChangeDto)) {
            throw new BaseException("\u8d44\u6e90\u8f6c\u79fb\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long max = this.sysResourcesMapper.getMaxOrderByParentId(BaseSecurityUtil.formatToLong((Object)resourceTreeChangeDto.getParentId()));
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysResourcesMapper.resourceTreeChange(resourceTreeChangeDto.getResourceId(), resourceTreeChangeDto.getParentId(), order);
    }

    public void updateModuleTreeChange(String moduleId, String parentId) {
        if (ToolUtil.isEmpty((Object)moduleId) || ToolUtil.isEmpty((Object)parentId)) {
            throw new BaseException("\u6a21\u5757ID\u548c\u7236\u7ea7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long max = this.sysResourceModulesMapper.getMaxOrderByParentId(BaseSecurityUtil.formatToLong((Object)parentId));
        BigDecimal order = new BigDecimal(1);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        this.sysResourceModulesMapper.moduleTreeChange(moduleId, parentId, order);
    }

    public List<JSTreeModel> getSelfResourceTree(String resourceIds) {
        this.checkParams(resourceIds, "getSelfResourceTree");
        String[] ids = resourceIds == null ? "".split(",") : resourceIds.split(",");
        List<JSTreeModel> result = this.sysResourcesMapper.selfResourceTree(ids);
        return this.doRecursive(result);
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, 0L);
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        JSTreeModel model = new JSTreeModel();
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setCode("GROUP");
        model.setText("\u89d2\u8272\u8d44\u6e90\u6811");
        model.setId(Constants.RES_NODE_ID);
        model.setType("isRoot");
        model.setState(true, true, true);
        result.add(model);
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, Long parentId) {
        Long newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!"1".equals(map.getIsRes()) && !newParentId.equals(map.getId())) continue;
            newParentId = map.getParent();
            result.add(map);
            list.remove(map);
            --i;
            this.recursive(list, result, newParentId);
        }
    }

    public List<JSTreeModel> getMenuResTree(String resType) {
        return this.sysModulesMapper.getMenuModulesTree(resType);
    }

    public boolean isAllowEditModule(SysModules sysModules) {
        boolean flag = false;
        List<Map<String, Object>> modulesResult = this.sysModulesMapper.getModulesByParentId(sysModules.getId());
        List<Map<String, Object>> functionsResult = this.sysFunctionsMapper.getFunctionsByModuleId(sysModules.getId());
        SysModuleVO oldModule = this.sysModulesMapper.getModuleInfoById(sysModules.getId());
        if (oldModule.getIsLeaf().equals(sysModules.getIsLeaf())) {
            flag = true;
        } else if (ToolUtil.isEmpty(modulesResult) && ToolUtil.isEmpty(functionsResult)) {
            flag = true;
        }
        return flag;
    }

    public List<JSTreeModel> getMoudleAndFunctionTree(Long parentId) {
        return this.sysModulesMapper.getLazyLoadModulesTree(parentId);
    }

    public List<JSTreeModel> getFunctionAndResTree(String nodeId) {
        return this.sysModulesMapper.getFunctionAndResTree(nodeId);
    }

    public void exportRes(String ids, HttpServletResponse response) {
        List<String> idList = Arrays.asList(ids.split(","));
        List modules = this.sysResourceModulesMapper.selectBatchIds(idList);
        List resources = this.sysResourcesMapper.selectBatchIds(idList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("modules", modules);
        data.put("resources", resources);
        data.put("export_type", "resource");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "resource_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @DSTransactional
    public ImportVueResVo importVueRes(byte[] content) {
        Map data;
        HashMap map = new HashMap();
        ImportVueResVo importVueResVo = new ImportVueResVo();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"resource".equals(export_type)) {
            importVueResVo.setSuccess("false");
            importVueResVo.setErrorImport(export_type);
            importVueResVo.setImportType("resource");
            return importVueResVo;
        }
        List modules = (List)data.get("modules");
        List resources = (List)data.get("resources");
        Map moduleCount = this.sysResourceMosulesService.insertOrUpdateList(modules);
        Map resourceCount = this.sysResourcesService.insertOrUpdateList(resources);
        importVueResVo.setSuccess("true");
        importVueResVo.setModuleInsert("" + moduleCount.get("insert"));
        importVueResVo.setModuleUpdate("" + moduleCount.get("update"));
        importVueResVo.setResourceInsert("" + resourceCount.get("insert"));
        importVueResVo.setResourceUpdate("" + resourceCount.get("update"));
        return importVueResVo;
    }

    public List<JSTreeModel> getFunResource(ResTreeDto resTreeDto) {
        List<JSTreeModel> list1;
        Long gradeParentId;
        this.checkParams(resTreeDto, "getFunResource");
        Long newNodeId = resTreeDto.getNodeId();
        String type = resTreeDto.getType();
        String nodeType = resTreeDto.getNodeType();
        String leaf = resTreeDto.getIsLeaf();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long struId = 0L;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u6a21\u5757\u8d44\u6e90\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List resourceIdList = new ArrayList();
        ArrayList moduleIdList = new ArrayList();
        ArrayList<Long> moduleIdList1 = new ArrayList<Long>();
        ArrayList<Long> list = new ArrayList<Long>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId).getId()))).size() > 0) {
            moduleIdList.addAll(this.sysResourceMosulesService.getGradeAdminResModuleId(resourceIdList));
            for (SysResourceModules modules : moduleIdList) {
                Long moduleId = modules.getId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(moduleIdList1);
        }
        if ("menuRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getMenuResourcesTree();
            result.add(root);
        } else if ("authorityRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getAuthorityModulesResTree();
            result.add(root);
        } else {
            boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType);
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newNodeId)) {
                newNodeId = Constants.RES_NODE_ID;
                result.add(root);
                list1 = this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId);
            } else {
                list1 = isModule ? this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId) : new ArrayList<JSTreeModel>();
            }
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                Long id = model.getId();
                if (!list.contains(id)) continue;
                model.getState().put("gradeDisabled", true);
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel model : result) {
            String isLeaf = model.getIsLeaf();
            String isModule = model.getType();
            if (!"isModule".equals(isModule) || !"0".equals(isLeaf)) continue;
            model.getState().put("notLeafModule", true);
        }
        return result;
    }

    public List<JSTreeModel> getFunResourceForOrg(ResTreeDto resTreeDto) {
        Long gradeParentId;
        this.checkParams(resTreeDto, "getFunResourceForOrg");
        Long newNodeId = resTreeDto.getNodeId();
        String type = resTreeDto.getType();
        String nodeType = resTreeDto.getNodeType();
        String leaf = resTreeDto.getIsLeaf();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long struId = 0L;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        List<Object> list1 = new ArrayList();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u6a21\u5757\u8d44\u6e90\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List<Long> resourceIdList = new ArrayList();
        ArrayList<SysResourceModules> moduleIdList = new ArrayList<SysResourceModules>();
        ArrayList<Long> moduleIdList1 = new ArrayList<Long>();
        ArrayList<Long> list = new ArrayList<Long>();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId).getId()))).size() > 0) {
            moduleIdList.addAll(this.sysResourceMosulesService.getGradeAdminResModuleId(resourceIdList));
            for (SysResourceModules modules : moduleIdList) {
                Long moduleId = modules.getId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(moduleIdList1);
        }
        if ("menuRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getMenuResourcesTree();
            result.add(root);
        } else if ("authorityRes".equals(type)) {
            list1 = this.sysResourceModulesMapper.getAuthorityModulesResTree();
            result.add(root);
        } else {
            boolean isModule = ToolUtil.equals((Object)"isModule", (Object)nodeType);
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newNodeId)) {
                newNodeId = Constants.RES_NODE_ID;
                result.add(root);
                list1 = this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId);
            } else {
                list1 = isModule ? this.sysResourceModulesMapper.getLazyLoadModulesResTree(newNodeId) : new ArrayList();
            }
        }
        if (isGradeAdmin) {
            list1 = this.getJsTreeModelListForModAndRes(moduleIdList, resourceIdList);
            list1.add(root);
            for (JSTreeModel jSTreeModel : list1) {
                Long id = jSTreeModel.getId();
                if (list.contains(id)) {
                    jSTreeModel.getState().put("gradeDisabled", true);
                }
                result.add(jSTreeModel);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel jSTreeModel : result) {
            String isLeaf = jSTreeModel.getIsLeaf();
            String isModule = jSTreeModel.getType();
            if (!"isModule".equals(isModule) || !"0".equals(isLeaf)) continue;
            jSTreeModel.getState().put("notLeafModule", true);
        }
        return result;
    }

    public List<JSTreeModel> getResFunTree(ResTreeDto resTreeDto) {
        Long struId;
        Long gradeParentId;
        List resourceIdList;
        this.checkParams(resTreeDto, "getResFunTree");
        String nodeType = resTreeDto.getNodeType();
        Long parentNodeId = resTreeDto.getNodeId();
        String isLeafModule = resTreeDto.getIsLeaf();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        JSTreeModel rootNode = new JSTreeModel();
        rootNode.setId(Constants.RES_NODE_ID);
        rootNode.setCode(String.valueOf(Constants.RES_NODE_ID));
        rootNode.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        rootNode.setParent(Constants.ROOT_NODE_PARENT);
        rootNode.setIsLeaf("0");
        rootNode.setIsModule("1");
        rootNode.setType("isRoot");
        rootNode.setConstant("0");
        if (isGradeAdmin) {
            rootNode.getState().put("gradeDisabled", true);
        }
        boolean leafModuleYes = ToolUtil.equals((Object)Constants.RES_NODE_ID, (Object)isLeafModule);
        boolean funModuleYes = ToolUtil.equals((Object)"isModule", (Object)nodeType);
        HashSet gradeRefFunModuleIds = Sets.newHashSet();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId = shiroUser.getEmployeeId()).getId()))).size() > 0) {
            List functionIdList = this.sysStruResourcesService.getFunId(resourceIdList);
            gradeRefFunModuleIds.addAll(functionIdList);
            if (!leafModuleYes) {
                List leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
                List moduleIdList = leafModules.stream().map(SysModules::getId).collect(Collectors.toList());
                gradeRefFunModuleIds.addAll(moduleIdList);
                ArrayList tmpModuleIds = Lists.newArrayList();
                tmpModuleIds.clear();
                for (SysModules sysModules : leafModules) {
                    Long parentId = sysModules.getParentModuleId();
                    if ("1".equals(parentId)) continue;
                    tmpModuleIds.add(parentId);
                }
                List parentModules = this.sysModulesService.getParentModuleTree((List)tmpModuleIds);
                gradeRefFunModuleIds.addAll(parentModules.stream().map(SysModules::getId).collect(Collectors.toSet()));
            }
        }
        ArrayList<JSTreeModel> treeNodeResult = new ArrayList<JSTreeModel>();
        List<Object> lazyTreeNodeList = Lists.newArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)parentNodeId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentNodeId)) {
                parentNodeId = Constants.RES_NODE_ID;
                treeNodeResult.add(rootNode);
                lazyTreeNodeList = this.getMoudleAndFunctionTree(parentNodeId);
            } else {
                lazyTreeNodeList = funModuleYes && !leafModuleYes ? this.getMoudleAndFunctionTree(parentNodeId) : (funModuleYes && leafModuleYes ? this.sysFunctionsMapper.functionTreeByModuleId(parentNodeId) : new ArrayList());
            }
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : lazyTreeNodeList) {
                Long moduleOrFunId = model.getId();
                if (!gradeRefFunModuleIds.contains(moduleOrFunId)) continue;
                model.getState().put("gradeDisabled", true);
                treeNodeResult.add(model);
            }
        } else {
            treeNodeResult.addAll(lazyTreeNodeList);
        }
        for (JSTreeModel model : treeNodeResult) {
            String isLeaf = model.getIsLeaf();
            String isModule = model.getType();
            if ("isModule".equals(isModule) && "0".equals(isLeaf)) {
                model.getState().put("notLeafModule", true);
            }
            if (!"isFun".equals(isModule)) continue;
            model.setChildren("false");
        }
        return treeNodeResult;
    }

    public List<JSTreeModel> getEditResTree() {
        Iterator gradeParentId;
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        List<JSTreeModel> list1 = this.getResTree();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long struId = 0L;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
        }
        List resourceIdList = new ArrayList();
        ArrayList functionIdList = new ArrayList();
        ArrayList moduleIdList = new ArrayList();
        ArrayList<Long> moduleIdList1 = new ArrayList<Long>();
        ArrayList list = new ArrayList();
        if (isGradeAdmin && (resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId = Long.valueOf(this.orgMaintenanceService.getOneOrg(struId).getId()))).size() > 0) {
            functionIdList.addAll(this.sysStruResourcesService.getFunId(resourceIdList));
            List leafModules = this.sysStruResourcesService.getGradeAdminModuleId(functionIdList);
            moduleIdList.addAll(leafModules);
            ArrayList<Long> tmpModuleIds = new ArrayList<Long>();
            tmpModuleIds.clear();
            for (SysModules sysModules : leafModules) {
                Long parentId = sysModules.getParentModuleId();
                if ("1".equals(parentId)) continue;
                tmpModuleIds.add(parentId);
            }
            List parentModules = this.sysModulesService.getParentModuleTree(tmpModuleIds);
            moduleIdList.addAll(parentModules);
            for (SysModules sysModules : moduleIdList) {
                Long moduleId = sysModules.getId();
                if (moduleIdList1.contains(moduleId)) continue;
                moduleIdList1.add(moduleId);
            }
            list.addAll(resourceIdList);
            list.addAll(functionIdList);
            list.addAll(moduleIdList1);
        }
        if (isGradeAdmin) {
            for (JSTreeModel model : list1) {
                Long id = model.getId();
                if (list.contains(id)) {
                    model.getState().put("gradeDisabled", true);
                }
                result.add(model);
            }
        } else {
            result.addAll(list1);
        }
        for (JSTreeModel js : result) {
            js.setState(false, false, false);
            if (!ToolUtil.equals((Object)js.getConstant(), (Object)"1")) continue;
            js.setState(false, false, true);
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        result.add(root);
        return result;
    }

    public IPage getResNodeSubList(Page page, ResTreeQueryDto resTreeQueryDto) {
        this.checkParams(resTreeQueryDto, "getResNodeSubList");
        resTreeQueryDto.setResourceCode(resTreeQueryDto.getResourceCode().replace("%", "\\%").replace("_", "\\_"));
        resTreeQueryDto.setResourceName(resTreeQueryDto.getResourceName().replace("%", "\\%").replace("_", "\\_"));
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        Long nodeId = resTreeQueryDto.getNodeId();
        String nodeType = resTreeQueryDto.getNodeType();
        String isLeafModule = resTreeQueryDto.getIsLeaf();
        HashMap resPageMap = new HashMap(4);
        if (ToolUtil.equals((Object)Constants.RES_NODE_ID, (Object)nodeId)) {
            nodeType = "isModule";
        }
        boolean funModuleYes = false;
        boolean leafModuleYes = ToolUtil.equals((Object)Constants.RES_NODE_ID, (Object)isLeafModule);
        boolean funNodeYes = true;
        if (funModuleYes) {
            if (leafModuleYes) {
                List<Object> functionVOList;
                HashMap queryFuncParams = Maps.newHashMap();
                queryFuncParams.put("moduleId", nodeId);
                String functionName = StringUtils.isBlank((CharSequence)resTreeQueryDto.getFunctionName()) ? null : resTreeQueryDto.getFunctionName().trim();
                String functionCode = StringUtils.isBlank((CharSequence)resTreeQueryDto.getFunctionCode()) ? null : resTreeQueryDto.getFunctionCode().trim();
                queryFuncParams.put("functionName", functionName);
                queryFuncParams.put("functionCode", functionCode);
                if (isGradeAdmin) {
                    List functionIdList = Lists.newArrayList();
                    Long struId = shiroUser.getEmployeeId();
                    Long gradeParentId = (long)this.orgMaintenanceService.getOneOrg(struId).getId();
                    List resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId);
                    if (resourceIdList.size() > 0) {
                        functionIdList = this.sysStruResourcesService.getFunId(resourceIdList);
                    }
                    if (functionIdList.size() > 0) {
                        queryFuncParams.put("functionIdList", functionIdList);
                        functionVOList = this.sysFunctionsMapper.findFunctionByModuleId(page, queryFuncParams);
                        for (SysFunctionVO sysFunctionVO : functionVOList) {
                            if (!functionIdList.contains(sysFunctionVO.getId())) {
                                sysFunctionVO.setGradeDisabled(Boolean.TRUE);
                                continue;
                            }
                            sysFunctionVO.setGradeDisabled(Boolean.FALSE);
                        }
                    } else {
                        functionVOList = Lists.newArrayList();
                    }
                } else {
                    functionVOList = this.sysFunctionsMapper.findFunctionByModuleId(page, queryFuncParams);
                }
                page.setRecords(functionVOList);
            } else {
                List<Object> moduleVOList;
                HashMap queryModuleParams = Maps.newHashMap();
                queryModuleParams.put("parentModuleId", nodeId);
                String moduleName = StringUtils.isBlank((CharSequence)resTreeQueryDto.getModuleName()) ? null : resTreeQueryDto.getModuleName().trim();
                String moduleCode = StringUtils.isBlank((CharSequence)resTreeQueryDto.getModuleCode()) ? null : resTreeQueryDto.getModuleCode().trim();
                queryModuleParams.put("moduleName", moduleName);
                queryModuleParams.put("moduleCode", moduleCode);
                if (isGradeAdmin) {
                    List list;
                    ArrayList moduleIdList = Lists.newArrayList();
                    Long struId = shiroUser.getEmployeeId();
                    Long gradeParentId = (long)this.orgMaintenanceService.getOneOrg(struId).getId();
                    List resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId);
                    if (resourceIdList.size() > 0 && !(list = this.sysStruResourcesService.getFunId(resourceIdList)).isEmpty()) {
                        List list2 = this.sysStruResourcesService.getGradeAdminModuleId(list);
                        moduleIdList.addAll(list2.stream().map(SysModules::getId).collect(Collectors.toList()));
                        ArrayList tmpModuleIds = Lists.newArrayList();
                        tmpModuleIds.clear();
                        for (SysModules sysModules : list2) {
                            Long parentId = sysModules.getParentModuleId();
                            if ("1".equals(parentId)) continue;
                            tmpModuleIds.add(parentId);
                        }
                        List parentModules = this.sysModulesService.getParentModuleTree((List)tmpModuleIds);
                        moduleIdList.addAll(parentModules.stream().map(SysModules::getId).collect(Collectors.toSet()));
                    }
                    if (moduleIdList.size() > 0) {
                        queryModuleParams.put("moduleIdList", moduleIdList);
                        moduleVOList = this.sysModulesMapper.findModuleByParentModuleId(page, queryModuleParams);
                        for (SysModuleVO sysModuleVO : moduleVOList) {
                            if (!moduleIdList.contains(sysModuleVO.getId())) {
                                sysModuleVO.setGradeDisabled(Boolean.TRUE);
                                continue;
                            }
                            sysModuleVO.setGradeDisabled(Boolean.FALSE);
                        }
                    } else {
                        moduleVOList = Lists.newArrayList();
                    }
                } else {
                    moduleVOList = this.sysModulesMapper.findModuleByParentModuleId(page, queryModuleParams);
                }
                page.setRecords(moduleVOList);
            }
        } else if (funNodeYes) {
            List<Object> moduleResourcesVoList;
            HashMap queryResParams = Maps.newHashMap();
            queryResParams.put("moduleId", nodeId);
            String resourceName = StringUtils.isBlank((CharSequence)resTreeQueryDto.getResourceName()) ? null : resTreeQueryDto.getResourceName().trim();
            String resourceCode = StringUtils.isBlank((CharSequence)resTreeQueryDto.getResourceCode()) ? null : resTreeQueryDto.getResourceCode().trim();
            queryResParams.put("resourceName", resourceName);
            queryResParams.put("resourceCode", resourceCode);
            queryResParams.put("resType", "res_type");
            if (isGradeAdmin) {
                Long struId = shiroUser.getEmployeeId();
                Long gradeParentId = (long)this.orgMaintenanceService.getOneOrg(struId).getId();
                List resourceIdList = this.sysStruResourcesService.getResIdList(gradeParentId);
                if (resourceIdList.isEmpty()) {
                    moduleResourcesVoList = Lists.newArrayList();
                } else {
                    queryResParams.put("resourceIdList", resourceIdList);
                    moduleResourcesVoList = this.sysResourcesMapper.selectResourceListByModuleId(page, queryResParams);
                    for (SysModuleResourcesVo sysModuleResourcesVo : moduleResourcesVoList) {
                        if (!resourceIdList.contains(sysModuleResourcesVo.getId())) {
                            sysModuleResourcesVo.setGradeDisabled(Boolean.TRUE);
                            continue;
                        }
                        sysModuleResourcesVo.setGradeDisabled(Boolean.FALSE);
                    }
                }
            } else {
                moduleResourcesVoList = this.sysResourcesMapper.selectResourceListByModuleId(page, queryResParams);
            }
            page.setRecords(moduleResourcesVoList);
        }
        return page;
    }

    @DSTransactional
    public ApiResponse<Tip> deleteModules(Long moduleId) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.delCascade(moduleId, null, null);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse<Tip> deleteFunctions(String functionId) {
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.delCascade(null, functionId, null);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse<Tip> deleteResource(String resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u8d44\u6e90id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean flag = this.delCascade(null, null, resourceId);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Deprecated
    public List<SysResources> getSameUrl(String url) {
        if (ToolUtil.isEmpty((Object)url)) {
            throw new BaseException("\u8d44\u6e90\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sysResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)url));
    }

    public List<SysResources> getSameUrl(ResourceUniqueDto resourceUniqueDto) {
        if (ToolUtil.isEmpty((Object)resourceUniqueDto.getUrl())) {
            throw new BaseException("\u8d44\u6e90\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String serviceName = ToolUtil.isEmpty((Object)resourceUniqueDto.getServiceName()) ? "" : resourceUniqueDto.getServiceName();
        return this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)resourceUniqueDto.getUrl())).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysResources::getServiceName, (Object)serviceName)).or(ToolUtil.isEmpty((Object)serviceName))).isNull(ToolUtil.isEmpty((Object)serviceName), SysResources::getServiceName);
        }));
    }

    public List<JSTreeModel> getRoleTreeByResourceId(String resourceId) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List roleResourceList = this.sysRoleResourceMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId)).ne(SysRoleResource::getRelationSource, (Object)"1"));
        if (ToolUtil.isEmpty((Object)roleResourceList)) {
            ArrayList<JSTreeModel> emptyList = new ArrayList<JSTreeModel>();
            JSTreeModel model = new JSTreeModel();
            model.setId(Constants.RES_NODE_ID);
            model.setCode("GROUP");
            model.setParent(Constants.ROOT_NODE_PARENT);
            model.setText("\u5173\u8054\u89d2\u8272");
            model.setType("isRoot");
            model.setState(false, false, true);
            emptyList.add(model);
            return emptyList;
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        for (Object roleResource : roleResourceList) {
            roleIds.add(roleResource.getId());
        }
        ArrayList<String> roleIds2 = new ArrayList<String>();
        for (Long roleId : roleIds) {
            roleIds2.add(roleId.toString());
        }
        List result = this.orgMaintenanceService.selfRoleTree(roleIds2.toArray(new String[roleIds2.size()]));
        List<JSTreeModel> tree = this.getRoleTree(result);
        block2: for (JSTreeModel js : tree) {
            for (Long id : roleIds) {
                if (ToolUtil.equals((Object)js.getId(), (Object)id)) {
                    js.setState(true, true, true);
                    continue block2;
                }
                js.setState(false, false, true);
            }
        }
        return tree;
    }

    @DSTransactional
    public ApiResponse<Tip> saveResourceRelationRole(Long resourceId, String roleIds) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids = roleIds == null ? "".split(",") : roleIds.split(",");
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String roleId : ids) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setId(Long.valueOf(roleId));
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setRelationSource("2");
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            this.sysRoleResourceService.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse<Tip> updateResourceRelationRole(ResRoleDto resRoleDto) {
        Long resourceId = resRoleDto.getResourceId();
        String roleIds = resRoleDto.getRoleIds();
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids = roleIds == null ? "".split(",") : roleIds.split(",");
        boolean flag = false;
        ArrayList<SysRoleResource> sysRoleResourceList = new ArrayList<SysRoleResource>();
        for (String roleId : ids) {
            if (ToolUtil.isEmpty((Object)roleId)) continue;
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setId(Long.valueOf(roleId));
            sysRoleResource.setResourceId(resourceId);
            sysRoleResource.setRelationSource("2");
            sysRoleResourceList.add(sysRoleResource);
        }
        if (ToolUtil.isNotEmpty(sysRoleResourceList)) {
            this.sysRoleResourceService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resourceId)).ne(SysRoleResource::getRelationSource, (Object)"1"));
            flag = this.sysRoleResourceService.saveBatch(sysRoleResourceList, sysRoleResourceList.size());
        }
        if (!flag) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    public JSONObject queryIsCheckResource(String resourceUrl) {
        if (ToolUtil.isEmpty((Object)resourceUrl)) {
            throw new BaseException("\u8d44\u6e90URL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject json = new JSONObject();
        json.put("flag", (Object)this.sysResourcesService.checkResource(resourceUrl));
        json.put("totp", (Object)this.hussarLoginConfigService.getTotpOpen());
        this.abstractOTPCredentialsMatcher.getClass();
        json.put("csrfToken", (Object)this.abstractOTPCredentialsMatcher.generate("FCUD3YLMJYG2F72L2NFDXYPL6UJBUUN24BGBK6JDEIKHUA4ZOD2A"));
        return json;
    }

    private List<JSTreeModel> getRoleTree(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursiveRoleTree(list, result, 0L);
        JSTreeModel model = new JSTreeModel();
        model.setId(Constants.RES_NODE_ID);
        model.setCode("GROUP");
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setText("\u5173\u8054\u89d2\u8272");
        model.setType("isRoot");
        result.add(model);
        return result;
    }

    private void recursiveRoleTree(List<JSTreeModel> list, List<JSTreeModel> result, Long parentId) {
        Long newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel map = list.get(i);
            if (!"ROLE".equals(map.getCode()) && !newParentId.equals(map.getId())) continue;
            newParentId = map.getParent();
            result.add(map);
            list.remove(map);
            --i;
            this.recursiveRoleTree(list, result, newParentId);
        }
    }

    private Boolean delCascade(Long moduleId, String functionId, String resId) {
        ArrayList<Long> functionIdList = new ArrayList<Long>();
        ArrayList resourceIdList = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            List moduleList = this.sysModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysModules::getParentModuleId, (Object)moduleId));
            for (SysModules sysModules : moduleList) {
                this.delCascade(sysModules.getId(), null, null);
            }
            List functionList = this.sysFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getFunctionModuleId, (Object)moduleId));
            for (SysFunctions sysFunctions : functionList) {
                functionIdList.add(sysFunctions.getId());
            }
        }
        if (ToolUtil.isNotEmpty((Object)resId)) {
            this.sysRoleResourceMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resId));
            this.sysResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResources::getId, (Object)resId));
        }
        if (resourceIdList.size() != 0) {
            this.sysRoleResourceMapper.deleteBatchIds(resourceIdList);
            this.sysResourcesService.removeByIds(resourceIdList);
        }
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            this.sysFunctionsService.remove((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getId, (Object)functionId));
        }
        this.sysFunctionsService.removeByIds(functionIdList);
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            this.sysModulesService.removeById((Serializable)moduleId);
        }
        return true;
    }

    public SysModuleFunctionsVo functionsDetail(Long functionId, Long functionModuleId) {
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            return this.sysFunctionsService.getFunctionDetail(functionId);
        }
        return this.sysFunctionModulesService.getFunctionModuleDetail(functionModuleId);
    }

    public Integer functionSave(SysFunctions sysFunctions) {
        int count;
        Long userId = null;
        if (sysFunctions.getCreator() != null && "godaxe".equals(sysFunctions.getCreator())) {
            userId = sysFunctions.getCreator();
        } else if (ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
            userId = BaseSecurityUtil.getUser().getId();
        }
        if (ToolUtil.isEmpty((Object)sysFunctions.getId())) {
            sysFunctions.setId(null);
            Long max = this.sysFunctionsMapper.getMaxOrderByParentId(sysFunctions.getFunctionModuleId());
            if (ToolUtil.isNotEmpty((Object)max)) {
                BigDecimal num = new BigDecimal(1);
                BigDecimal order = BigDecimal.valueOf(max);
                sysFunctions.setSeq(order.add(num));
            } else {
                sysFunctions.setSeq(new BigDecimal(1));
            }
            sysFunctions.setCreator(userId);
            count = this.sysFunctionsMapper.insert(sysFunctions);
        } else {
            sysFunctions.setLastEditor(userId);
            count = this.sysFunctionsMapper.updateById(sysFunctions);
        }
        return count;
    }

    public List<JSTreeModel> getFunctionModuleTreeByModuleId(Long moduleId, String moduleName) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List result = this.sysFunctionModulesService.functionModuleTreeByModuleId(moduleId);
        JSTreeModel root = new JSTreeModel();
        root.setId(moduleId);
        root.setText(moduleName);
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setSeq("0");
        root.setType("isModule");
        result.add(root);
        return result;
    }

    public CheckResourceVo checkHasResources(Long resourceId, String type) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.sysStruResourcesService.getResourceIdList(resourceId, type);
        CheckResourceVo result = new CheckResourceVo();
        List moduleList = this.sysResourceMosulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getParentModuleId, (Object)resourceId));
        if (list.size() > 0) {
            result.setResource(true);
        } else {
            result.setResource(false);
        }
        if (moduleList.size() > 0) {
            result.setModule(true);
        } else {
            result.setModule(false);
        }
        return result;
    }

    public ApiResponse<Tip> delModuleResCascade(Long moduleId, Long resId) {
        ArrayList<Long> moduleIdList = new ArrayList<Long>();
        ArrayList<Long> resourceIdList = new ArrayList<Long>();
        if (ToolUtil.isEmpty((Object)moduleId) && ToolUtil.isEmpty((Object)resId)) {
            throw new BaseException("\u6a21\u5757id\u6216\u8005\u8d44\u6e90id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            this.getDelModule(moduleId, moduleIdList);
            List resourcesList = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().in(SysResources::getModuleId, moduleIdList));
            for (SysResources sysResources : resourcesList) {
                resourceIdList.add(sysResources.getId());
            }
        }
        if (resourceIdList.size() > 0) {
            int count;
            ArrayList<Long> resourceIds = new ArrayList<Long>(resourceIdList);
            if (ToolUtil.isNotEmpty((Object)resId)) {
                resourceIds.add(resId);
            }
            if ((count = this.getAdminResourceCount(Constants.ADMIN_ROLE_IDS, resourceIds)) > 0) {
                throw new ResourceWithAdminException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u7ba1\u7406\u5458\u5173\u8054\u7684\u8d44\u6e90\uff01");
            }
            List functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFunctionResources::getResourceId, resourceIds));
            List functionsList = this.sysFunctionsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFunctions::getDefaultResourceId, resourceIds));
            if (functionResourcesList.size() > 0 || functionsList.size() > 0) {
                throw new ResourceWithFunctionException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u529f\u80fd\u7684\u8d44\u6e90\uff01");
            }
        }
        if (ToolUtil.isNotEmpty((Object)resId)) {
            int count = this.getAdminResourceCount(Constants.ADMIN_ROLE_IDS, Collections.singletonList(resId));
            if (count > 0) {
                throw new ResourceWithAdminException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u7ba1\u7406\u5458\u5173\u8054\u7684\u8d44\u6e90\uff01");
            }
            int roleCounts = this.getAdminResourceCount(null, Arrays.asList(resId));
            if (roleCounts > 0) {
                throw new ResourceWithAdminException("\u5220\u9664\u5931\u8d25\uff01\u5df2\u5e94\u7528\u7684\u8d44\u6e90\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            this.sysRoleResourceService.remove((Wrapper)new LambdaQueryWrapper().eq(SysRoleResource::getResourceId, (Object)resId));
            this.sysResourcesService.remove((Wrapper)new LambdaQueryWrapper().eq(SysResources::getId, (Object)resId));
        }
        if (resourceIdList.size() != 0) {
            this.sysRoleResourceService.removeByIds(resourceIdList);
            this.sysResourcesService.removeByIds(resourceIdList);
        }
        if (ToolUtil.isNotEmpty((Object)moduleId)) {
            this.sysResourceMosulesService.removeById((Serializable)moduleId);
        }
        if (ToolUtil.isNotEmpty(moduleIdList)) {
            this.sysResourceMosulesService.removeByIds(moduleIdList);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private void getDelModule(Long moduleId, List<Long> moduleIds) {
        List moduleList = this.sysResourceMosulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getParentModuleId, (Object)moduleId));
        if (moduleList.size() > 0) {
            for (SysResourceModules modules : moduleList) {
                this.getDelModule(modules.getId(), moduleIds);
            }
        }
        moduleIds.add(moduleId);
    }

    public int getAdminResourceCount(List<Long> roleIds, List<Long> resourceIds) {
        return this.sysRoleResourceMapper.getAdminResourceCount(roleIds, resourceIds);
    }

    public List<SysResources> getResources(String type) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List roleIdList = ConstantFactory.me().getRolesIdByShiroUser(shiroUser);
        List<SysResources> resourcesList = new ArrayList<SysResources>();
        if (ToolUtil.isNotEmpty((Object)roleIdList)) {
            if (roleIdList.contains(SysUserAndRole.SUPERADMIN_ROLE.getValue())) {
                return this.sysResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper());
            }
            resourcesList = this.sysResourcesMapper.getResourcesByIds(roleIdList, type);
        }
        return resourcesList;
    }

    private void updateComponentByType(List<SysResources> resources, String extra) {
        for (SysResources resource : resources) {
            String component = resource.getComponent();
            if (!ToolUtil.isNotEmpty((Object)component) || component.contains(extra)) continue;
            int index = component.indexOf("@");
            String pre = component.substring(0, index + 1);
            String suf = component.substring(index + 1);
            String newComponent = pre + extra + suf;
            resource.setComponent(newComponent);
        }
    }

    public List<SysResources> getResourcesListByApp(String type) {
        return new ArrayList<SysResources>();
    }

    public IPage getResourceList(ResListDto resListDto, Page<SysResources> pages) {
        HashMap result = new HashMap();
        String resourceAlias = resListDto.getResourceName();
        String permissions = resListDto.getPermissions();
        String urlNames = resListDto.getUrlNames();
        String path = resListDto.getPath();
        String component = resListDto.getComponent();
        if (ToolUtil.isNotEmpty((Object)resourceAlias)) {
            resourceAlias = resourceAlias.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setResourceName(resourceAlias);
        }
        if (ToolUtil.isNotEmpty((Object)permissions)) {
            permissions = permissions.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setPermissions(permissions);
        }
        if (ToolUtil.isNotEmpty((Object)urlNames)) {
            urlNames = urlNames.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setUrlNames(urlNames);
        }
        if (ToolUtil.isNotEmpty((Object)path)) {
            path = path.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setPath(path);
        }
        if (ToolUtil.isNotEmpty((Object)component)) {
            component = component.replace("%", "\\\\%").replace("_", "\\\\_");
            resListDto.setComponent(component);
        }
        List<SysResources> list = this.sysResourcesMapper.getResourceList(resListDto, pages);
        pages.setRecords(list);
        return pages;
    }

    public List<JSTreeModel> getJsTreeModelListForModAndRes(List<SysResourceModules> moduleIdList, List<Long> resourceIdList) {
        JSTreeModel jsTreeModel;
        ArrayList<JSTreeModel> jsTreeModelList = new ArrayList<JSTreeModel>();
        List sysResourcesList = new ArrayList();
        if (ToolUtil.isNotEmpty(resourceIdList)) {
            QueryWrapper sysResourcesQueryWrapper = new QueryWrapper();
            sysResourcesQueryWrapper.lambda().in(SysResources::getId, resourceIdList);
            sysResourcesList = this.sysResourcesService.list((Wrapper)sysResourcesQueryWrapper);
        }
        if (ToolUtil.isNotEmpty(sysResourcesList)) {
            for (SysResources sysResources : sysResourcesList) {
                jsTreeModel = new JSTreeModel();
                jsTreeModel.setId(sysResources.getId());
                jsTreeModel.setText(sysResources.getResourceName());
                jsTreeModel.setParent(Long.valueOf(sysResources.getModuleId()));
                jsTreeModel.setIsLeaf("1");
                jsTreeModel.setSeq(String.valueOf(sysResources.getSeq()));
                jsTreeModel.setIsFun("0");
                jsTreeModel.setIsRes("1");
                jsTreeModel.setType("isRes");
                jsTreeModel.setCode(sysResources.getResourceCode());
                jsTreeModel.setConstant("0");
                jsTreeModelList.add(jsTreeModel);
            }
        }
        if (ToolUtil.isNotEmpty(moduleIdList = moduleIdList.stream().distinct().collect(Collectors.toList()))) {
            for (SysResourceModules sysResourceModules : moduleIdList) {
                jsTreeModel = new JSTreeModel();
                jsTreeModel.setId(sysResourceModules.getId());
                jsTreeModel.setText(sysResourceModules.getModuleName());
                jsTreeModel.setParent(Long.valueOf(sysResourceModules.getParentModuleId()));
                jsTreeModel.setIsLeaf("0");
                jsTreeModel.setSeq(String.valueOf(sysResourceModules.getSeq()));
                jsTreeModel.setIsFun("0");
                jsTreeModel.setIsRes("0");
                jsTreeModel.setType("isModule");
                jsTreeModel.setCode(sysResourceModules.getModuleCode());
                jsTreeModel.setConstant("0");
                jsTreeModelList.add(jsTreeModel);
            }
        }
        return jsTreeModelList;
    }

    private void checkParams(Object params, String functions) {
        switch (functions) {
            case "getModuleInfoById": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "saveModules": {
                SysResourceModules sysResourceModules = (SysResourceModules)JSONObject.parseObject((String)JSON.toJSONString((Object)params), SysResourceModules.class);
                if (ToolUtil.isEmpty((Object)sysResourceModules.getModuleName())) {
                    throw new BaseException("\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (sysResourceModules.getModuleName().trim().length() <= 32) break;
                throw new BaseException("\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
            }
            case "updateModules": {
                SysResourceModules updateSysModules = (SysResourceModules)JSONObject.parseObject((String)JSON.toJSONString((Object)params), SysResourceModules.class);
                if (ToolUtil.isEmpty((Object)updateSysModules.getId())) {
                    throw new BaseException("\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)updateSysModules.getModuleName())) {
                    throw new BaseException("\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (updateSysModules.getModuleName().trim().length() <= 32) break;
                throw new BaseException("\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
            }
            case "moduleTreeById": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "saveFunction": {
                SysFunctions newFunction = (SysFunctions)JSONObject.parseObject((String)JSON.toJSONString((Object)params), SysFunctions.class);
                if (ToolUtil.isEmpty((Object)newFunction.getFunctionName())) {
                    throw new BaseException("\u529f\u80fd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (newFunction.getFunctionName().trim().length() > 32) {
                    throw new BaseException("\u529f\u80fd\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)newFunction.getFunctionCode())) {
                    throw new BaseException("\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ToolUtil.isEmpty((Object)newFunction.getDefaultResourceId())) break;
                throw new BaseException("\u529f\u80fd\u5165\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "updateFunction": {
                SysFunctions editFunction = (SysFunctions)JSONObject.parseObject((String)JSON.toJSONString((Object)params), SysFunctions.class);
                if (ToolUtil.isEmpty((Object)editFunction.getId())) {
                    throw new BaseException("\u529f\u80fdID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)editFunction.getFunctionName())) {
                    throw new BaseException("\u529f\u80fd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (editFunction.getFunctionName().trim().length() > 32) {
                    throw new BaseException("\u529f\u80fd\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
                }
                if (!ToolUtil.isEmpty((Object)editFunction.getFunctionCode())) break;
                throw new BaseException("\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "getSelfResourceTree": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u8d44\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "getFunResourceForOrg": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u8d44\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "getFunResource": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u8d44\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "getResFunTree": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u529f\u80fd\u6811\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "getResNodeSubList": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u8d44\u6e90\u6811\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "getFunctionInfoById": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u529f\u80fdID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            case "updateModuleTreeOrder": {
                if (!ToolUtil.isEmpty((Object)params)) break;
                throw new BaseException("\u6392\u5e8f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    public String getResourceCurrentCode(String moduleCode) {
        String currentCode = this.sysIdtableService.getCurrentCode("RESOURCE_CODE", "SYS_RESOURCES");
        if (ToolUtil.isEmpty((Object)currentCode)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u8d44\u6e90\u7f16\u7801");
        }
        return moduleCode + currentCode;
    }

    public List<SysResources> getSamePath(ResourcePathDto resourcePathDto) {
        String serviceName;
        String path = resourcePathDto.getPath();
        String string = serviceName = ToolUtil.isEmpty((Object)resourcePathDto.getServiceName()) ? "" : resourcePathDto.getServiceName();
        if (ToolUtil.isEmpty((Object)path)) {
            throw new BaseException("\u8d44\u6e90\u8def\u7531\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getPath, (Object)path)).and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysResources::getServiceName, (Object)serviceName)).or(ToolUtil.isEmpty((Object)serviceName))).isNull(ToolUtil.isEmpty((Object)serviceName), SysResources::getServiceName);
        }));
    }

    public ApiResponse<List<FunResourceEntity>> getFunResource() {
        List result = this.iSysFunctionModulesService.getFunModuleTreeForOrg("true");
        List sysFunctionResourceList = this.iSysFunctionResourcesService.list();
        List sysResourcesList = this.iSysResourcesService.list();
        Map<Long, SysResources> mapSysResources = sysResourcesList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        ArrayList<FunResourceEntity> list = new ArrayList<FunResourceEntity>();
        for (JSTreeModel jsTreeModel : result) {
            FunResourceEntity fr = new FunResourceEntity();
            BeanUtils.copyProperties((Object)jsTreeModel, (Object)fr);
            long functionId = fr.getId();
            List tempSysFunList = sysFunctionResourceList.stream().filter(item -> item.getFunctionId() == functionId).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tempSysFunList)) {
                for (SysFunctionResources sf : tempSysFunList) {
                    Long resourceId = sf.getResourceId();
                    SysResources sysResourcesTemp = mapSysResources.get(resourceId);
                    if (sysResourcesTemp == null || !sysResourcesTemp.getResTypeId().equalsIgnoreCase("res_menu")) continue;
                    fr.getResources().add(sysResourcesTemp);
                }
            }
            list.add(fr);
        }
        return ApiResponse.success(list);
    }
}

