/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.annotation.Master;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysLoginUserMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysLoginUser;
import com.jxdinfo.hussar.authorization.permit.model.SysUserTenant;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.SysLoginUserService;
import com.jxdinfo.hussar.authorization.permit.service.SysUserTenantService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
@Master
public class SysLoginUserServiceImpl
extends HussarServiceImpl<SysLoginUserMapper, SysLoginUser>
implements SysLoginUserService {
    @Resource
    private SysLoginUserMapper sysLoginUserMapper;
    @Resource
    private SysUserTenantService sysUserTenantService;

    public String getTenantCodeByAccount(String account) {
        List userTenantList;
        String tenantCode = "";
        SysLoginUser loginUser = (SysLoginUser)this.sysLoginUserMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysLoginUser::getAccount, (Object)account));
        if (ToolUtil.isNotEmpty((Object)loginUser)) {
            userTenantList = this.sysUserTenantService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserTenant::getUserId, (Object)loginUser.getId())).orderByAsc(SysUserTenant::getTenantCode));
            if (!ToolUtil.isNotEmpty((Object)userTenantList)) {
                throw new BaseException("\u7528\u6237\u6ca1\u6709\u79df\u6237\uff01");
            }
        } else {
            throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728\uff01");
        }
        tenantCode = ((SysUserTenant)userTenantList.get(0)).getTenantCode();
        return tenantCode;
    }

    public Boolean validateAccount(String account) {
        Long count = this.sysLoginUserMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(SysLoginUser::getAccount, (Object)account));
        return count > 0L;
    }

    @DSTransactional
    public void syncAddUser(SysUsers user) {
        String tenantCode;
        SysLoginUser loginUser = new SysLoginUser();
        SysUserTenant userTenant = new SysUserTenant();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        String string = tenantCode = ToolUtil.isEmpty((Object)shiroUser) ? "" : shiroUser.getTenantCode();
        if (ToolUtil.isNotEmpty((Object)user)) {
            loginUser.setId(user.getId());
            loginUser.setAccount(user.getUserAccount());
            loginUser.setPassword(user.getPassword());
            userTenant.setUserId(user.getId());
            userTenant.setTenantCode(tenantCode);
        }
        this.sysLoginUserMapper.insert(loginUser);
        this.sysUserTenantService.save((Object)userTenant);
    }

    @DSTransactional
    public ApiResponse<Tip> syncTenantUser(List<SysUsers> userList, String tenantCode) {
        ArrayList<SysUserTenant> userTenantList = new ArrayList<SysUserTenant>();
        for (SysUsers user : userList) {
            SysUserTenant userTenant = new SysUserTenant();
            userTenant.setUserId(user.getId());
            userTenant.setTenantCode(tenantCode);
            userTenantList.add(userTenant);
        }
        if (!this.sysUserTenantService.saveBatch(userTenantList)) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

