/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRoleFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncOrderDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.exception.ResourceWithFunctionException;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.ibatis.session.SqlSession;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysFunctionsServiceImpl
extends HussarServiceImpl<SysFunctionsMapper, SysFunctions>
implements ISysFunctionsService {
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    @Lazy
    private ISysResManageService sysResManageService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    private SysRoleFunctionsMapper sysRoleFunctionsMapper;
    @Resource
    private SysMenuMapper sysMenuMapper;

    public Map<String, Integer> insertOrUpdateList(List<SysFunctions> functionsList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(functionsList)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = functionsList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((Object)functionsList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.save((Object)functionsList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    public SysModuleFunctionsVo getFunctionDetail(Long functionId) {
        return this.sysFunctionsMapper.getFunctionDetail(functionId);
    }

    @DSTransactional
    public boolean saveOrUpdateFunction(FuncInfoDto funcInfoDto) {
        if (ToolUtil.isEmpty((Object)funcInfoDto.getFunctionName())) {
            throw new BaseException("\u529f\u80fd\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (funcInfoDto.getFunctionName().length() > 32) {
            throw new BaseException("\u529f\u80fd\u540d\u79f0\u6700\u591a\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
        }
        Long functionId = funcInfoDto.getFunctionId();
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            SysFunctions functions = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
            if (ToolUtil.isNotEmpty((Object)functions)) {
                functions.setFunctionName(funcInfoDto.getFunctionName());
                functions.setDefaultResourceId(funcInfoDto.getDefaultResourceId());
                return this.sysResManageService.functionSave(functions) > 0 && this.sysFunctionResourcesService.saveFunctionRes(functionId, funcInfoDto.getResources());
            }
            return false;
        }
        SysFunctions functions = new SysFunctions();
        String functionCode = this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
        functions.setFunctionCode(functionCode);
        functions.setFunctionModuleId(funcInfoDto.getParentModuleId());
        functions.setFunctionName(funcInfoDto.getFunctionName());
        functions.setDefaultResourceId(funcInfoDto.getDefaultResourceId());
        return this.sysResManageService.functionSave(functions) > 0 && this.sysFunctionResourcesService.saveFunctionRes(functions.getId(), funcInfoDto.getResources());
    }

    @DSTransactional
    public boolean deleteFunction(String functionId) {
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException("\u529f\u80fdID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List menuList = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysMenu::getFunctionId, (Object)functionId));
        if (menuList.size() > 0) {
            throw new ResourceWithFunctionException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u83dc\u5355\u7684\u529f\u80fd\uff01");
        }
        List roleFunctionList = this.sysRoleFunctionsMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysRoleFunctions::getFunctionId, (Object)functionId));
        if (roleFunctionList.size() > 0) {
            throw new ResourceWithFunctionException("\u5220\u9664\u5931\u8d25\uff01\u5b58\u5728\u5173\u8054\u89d2\u8272\u7684\u529f\u80fd\uff01");
        }
        return this.sysFunctionsMapper.deleteById((Serializable)((Object)functionId)) > 0 && this.sysFunctionResourcesMapper.delete((Wrapper)new LambdaUpdateWrapper().eq(SysFunctionResources::getFunctionId, (Object)functionId)) > 0;
    }

    public ApiResponse<Tip> updateMoveNode(FuncOrderDto funcOrderDto) {
        SysFunctions thatFunction;
        Long functionId = funcOrderDto.getFunctionId();
        Boolean isUp = funcOrderDto.getIsUp();
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new BaseException("\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFunctions thisFunction = (SysFunctions)this.sysFunctionsMapper.selectById(functionId);
        List<SysFunctions> thatFunctions = isUp != false ? this.sysFunctionsMapper.seletListLt(thisFunction.getFunctionModuleId(), thisFunction.getSeq()) : this.sysFunctionsMapper.seletListGt(thisFunction.getFunctionModuleId(), thisFunction.getSeq());
        if (thatFunctions.size() > 0 && (thatFunction = thatFunctions.get(0)) != null) {
            BigDecimal temp = thisFunction.getSeq();
            thisFunction.setSeq(thatFunction.getSeq());
            thatFunction.setSeq(temp);
            this.sysFunctionsMapper.updateById(thisFunction);
            this.sysFunctionsMapper.updateById(thatFunction);
        }
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

