/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncResDelDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SysFunctionResourcesServiceImpl
extends ServiceImpl<SysFunctionResourcesMapper, SysFunctionResources>
implements ISysFunctionResourcesService {
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Resource
    @Lazy
    private ISysRoleFunctionsService iSysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;

    public Map<String, Object> getFunctionResourceList(String functionId, String page, String limit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Page pages = new Page((long)Integer.parseInt(page), (long)Integer.parseInt(limit));
        List<Map<String, String>> list = this.sysFunctionResourcesMapper.getFunctionResourceList(pages, functionId);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    public int deleteFunRes(FuncResDelDto funcResDelDto) {
        String functionId = ToolUtil.isNotEmpty((Object)funcResDelDto.getFunctionId()) ? funcResDelDto.getFunctionId() : "";
        List resourceIds = ToolUtil.isNotEmpty((Object)funcResDelDto.getResourceIds()) ? funcResDelDto.getResourceIds() : new ArrayList();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleFunctions::getFunctionId, (Object)functionId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list((Wrapper)queryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctionsList)) {
            for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
                roleIds.add(sysRoleFunctions.getRoleId());
            }
        }
        if (ToolUtil.isNotEmpty(roleIds)) {
            LambdaQueryWrapper queryWrapperRr = new LambdaQueryWrapper();
            queryWrapperRr.in(SysRoleResource::getId, roleIds);
            queryWrapperRr.in(SysRoleResource::getResourceId, (Collection)resourceIds);
            this.iSysRoleResourceService.remove((Wrapper)queryWrapperRr);
        }
        return this.sysFunctionResourcesMapper.deleteFunRes(functionId, resourceIds);
    }

    public boolean saveFunctionRes(Long functionId, List<Map<String, String>> resources) {
        QueryWrapper queryWrapperFr = new QueryWrapper();
        queryWrapperFr.eq((Object)"FUNCTION_ID", (Object)functionId);
        List<FuncResVo> sysFunctionResourcesMap = this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
        ArrayList resourceIds = new ArrayList();
        ArrayList<Long> delResourceIds = new ArrayList<Long>();
        sysFunctionResourcesMap.parallelStream().forEach(sysFunctionResources -> {
            Long resourceId = sysFunctionResources.getResourceId();
            resourceIds.add(resourceId);
            delResourceIds.add(resourceId);
        });
        if (ToolUtil.isNotEmpty(resourceIds)) {
            this.remove((Wrapper)queryWrapperFr);
        }
        ArrayList<Long> roleIds = new ArrayList<Long>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"FUNCTION_ID", (Object)functionId);
        List sysRoleFunctionsList = this.iSysRoleFunctionsService.list((Wrapper)queryWrapper);
        if (ToolUtil.isNotEmpty((Object)sysRoleFunctionsList)) {
            for (SysRoleFunctions sysRoleFunctions : sysRoleFunctionsList) {
                roleIds.add(sysRoleFunctions.getRoleId());
            }
        }
        for (Map map : resources) {
            delResourceIds.add(Long.valueOf((String)map.get("id")));
        }
        if (ToolUtil.isNotEmpty(roleIds) && ToolUtil.isNotEmpty(delResourceIds)) {
            QueryWrapper queryWrapperRr = new QueryWrapper();
            queryWrapperRr.in((Object)"ROLE_ID", roleIds);
            queryWrapperRr.in((Object)"RESOURCE_ID", delResourceIds);
            queryWrapperRr.eq((Object)"RELATION_SOURCE", (Object)"1");
            this.iSysRoleResourceService.remove((Wrapper)queryWrapperRr);
        }
        ArrayList<SysFunctionResources> sysFunctionResourcesSaveList = new ArrayList<SysFunctionResources>();
        for (Map<String, String> resource : resources) {
            if (!"isRes".equals(resource.get("type"))) continue;
            SysFunctionResources sysFunctionResources2 = new SysFunctionResources();
            sysFunctionResources2.setResourceId(Long.valueOf(resource.get("id")));
            sysFunctionResources2.setFunctionId(Long.valueOf(functionId));
            sysFunctionResourcesSaveList.add(sysFunctionResources2);
            ArrayList<SysRoleResource> saveRoleResList = new ArrayList<SysRoleResource>();
            if (ToolUtil.isNotEmpty(roleIds)) {
                for (Long roleId : roleIds) {
                    SysRoleResource sysRoleResource = new SysRoleResource();
                    sysRoleResource.setResourceId(Long.valueOf(resource.get("id")));
                    sysRoleResource.setId(roleId);
                    sysRoleResource.setRelationSource("1");
                    saveRoleResList.add(sysRoleResource);
                }
            }
            if (!ToolUtil.isNotEmpty(saveRoleResList)) continue;
            this.iSysRoleResourceService.saveBatch(saveRoleResList);
        }
        return this.saveBatch(sysFunctionResourcesSaveList);
    }

    public List<FuncResVo> getFunctionResourceList(Long functionId) {
        return this.sysFunctionResourcesMapper.getFunctionResourceList(functionId);
    }
}

