/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysFunctionsMapper;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResModuleTreeDto;
import com.jxdinfo.hussar.authorization.permit.model.SeqStatic;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysStruFunctions;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruFunctionsService;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysFunctionModulesServiceImpl
extends ServiceImpl<SysFunctionModulesMapper, SysFunctionModules>
implements ISysFunctionModulesService {
    @Resource
    private SysFunctionsMapper sysFunctionsMapper;
    @Resource
    private SysFunctionModulesMapper sysFunctionModulesMapper;
    @Resource
    private SysFunctionResourcesMapper sysFunctionResourcesMapper;
    @Autowired
    private ISysStruFunctionsService iSysStruFunctionsService;
    @Autowired
    private ISysStruService iSysStruService;
    @Autowired
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Resource
    private SysOrgManageService orgMaintenanceService;

    public List<JSTreeModel> getFunModuleTree(String functionFlag) {
        boolean flag = ToolUtil.isEmpty((Object)functionFlag) ? false : Boolean.valueOf(functionFlag);
        List<JSTreeModel> jsTreeModelList = this.sysFunctionsMapper.getModuleFunctionTree();
        if (flag) {
            jsTreeModelList.addAll(this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionData());
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        jsTreeModelList.add(root);
        return jsTreeModelList;
    }

    public List<JSTreeModel> getFunModuleTreeForOrg(String functionFlag) {
        boolean flag = ToolUtil.isEmpty((Object)functionFlag) ? false : Boolean.valueOf(functionFlag);
        List<Object> jsTreeModelList = this.sysFunctionsMapper.getModuleFunctionTree();
        jsTreeModelList.addAll(this.sysFunctionsMapper.getModuleFunctionTreeWithFunctionData());
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        assert (shiroUser != null);
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        Long struId = 0L;
        if (isGradeAdmin) {
            struId = shiroUser.getEmployeeId();
            Long gradeParentId = (long)this.orgMaintenanceService.getOneOrg(struId).getId();
            QueryWrapper sysStruFunctionsQueryWrapper = new QueryWrapper();
            sysStruFunctionsQueryWrapper.lambda().eq(SysStruFunctions::getStruId, (Object)gradeParentId);
            List sysStruFunctionsList = this.iSysStruFunctionsService.list((Wrapper)sysStruFunctionsQueryWrapper);
            List<Long> downFunctionIdList = sysStruFunctionsList.stream().map(SysStruFunctions::getFunctionId).collect(Collectors.toList());
            jsTreeModelList = this.getFunModuleTreeForOrgWithOutOtherNode(jsTreeModelList, downFunctionIdList);
        }
        if (!flag) {
            jsTreeModelList = jsTreeModelList.stream().filter(item -> "1".equals(item.getIsModule())).collect(Collectors.toList());
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u529f\u80fd\u6a21\u5757\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        jsTreeModelList.add(root);
        if (isGradeAdmin) {
            jsTreeModelList.forEach(item -> item.getState().put("gradeDisabled", true));
        }
        return jsTreeModelList;
    }

    private List<JSTreeModel> getFunModuleTreeForOrgWithOutOtherNode(List<JSTreeModel> jsTreeModelList, List<Long> downFunctionIdList) {
        List<Long> childrenList = new ArrayList<Long>();
        childrenList.addAll(downFunctionIdList);
        List<Long> parentJSTreeModelIdList = downFunctionIdList;
        boolean flag = true;
        if (ToolUtil.isNotEmpty(downFunctionIdList)) {
            while (flag) {
                ArrayList<Long> finalChildrenStruIdList = childrenList;
                List parentList = jsTreeModelList.stream().filter(o -> finalChildrenStruIdList.contains(o.getId())).collect(Collectors.toList());
                List parentIdList = parentList.stream().map(JSTreeModel::getParent).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(parentIdList)) {
                    if (ToolUtil.isEmpty(parentJSTreeModelIdList)) {
                        parentJSTreeModelIdList = parentIdList;
                    } else {
                        parentJSTreeModelIdList.addAll(parentIdList);
                    }
                    childrenList = parentIdList;
                    continue;
                }
                flag = false;
            }
        }
        parentJSTreeModelIdList = parentJSTreeModelIdList.stream().distinct().collect(Collectors.toList());
        List<Long> finalParentJSTreeModelIdList = parentJSTreeModelIdList;
        jsTreeModelList = jsTreeModelList.stream().filter(o -> finalParentJSTreeModelIdList.contains(o.getId())).collect(Collectors.toList());
        return jsTreeModelList;
    }

    public List<JSTreeModel> getResModuleTree(ResModuleTreeDto resModuleTreeDto) {
        List<JSTreeModel> jsTreeModelList;
        boolean isSelectRes;
        Long functionId = resModuleTreeDto.getFunctionId();
        boolean bl = isSelectRes = ToolUtil.isNotEmpty((Object)resModuleTreeDto.getIsSelectRes()) && Boolean.valueOf(resModuleTreeDto.getIsSelectRes()) != false;
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            List functionResourcesList = this.sysFunctionResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)functionId));
            ArrayList<Long> resourceIds = new ArrayList<Long>();
            functionResourcesList.forEach(functionResource -> resourceIds.add(functionResource.getResourceId()));
            if (ToolUtil.isNotEmpty(resourceIds)) {
                List<JSTreeModel> moduleResTree = this.sysFunctionsMapper.getModuleResTree(resourceIds, isSelectRes);
                jsTreeModelList = this.doRecursive(moduleResTree);
            } else {
                jsTreeModelList = new ArrayList<JSTreeModel>();
            }
        } else {
            jsTreeModelList = isSelectRes ? this.sysFunctionsMapper.getModuleResTree(new ArrayList<Long>(), isSelectRes) : this.sysFunctionsMapper.getModuleResTree(new ArrayList<Long>(), isSelectRes);
        }
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.RES_NODE_ID);
        root.setCode(String.valueOf(Constants.RES_NODE_ID));
        root.setText("\u6a21\u5757\u8d44\u6e90\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setIsModule("1");
        root.setType("isRoot");
        root.setConstant("0");
        jsTreeModelList.add(root);
        return jsTreeModelList;
    }

    private List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        this.recursive(list, result, 0L);
        if (result.size() == 0) {
            for (JSTreeModel map : list) {
                if (!Constants.ROOT_NODE_PARENT.equals(map.getParent())) continue;
                result.add(map);
            }
        }
        return result;
    }

    private void recursive(List<JSTreeModel> list, List<JSTreeModel> result, Long parentId) {
        Long newParentId = parentId;
        for (int i = 0; i < list.size(); ++i) {
            JSTreeModel jsTreeModel = list.get(i);
            if (!"1".equals(jsTreeModel.getIsRes()) && !newParentId.equals(jsTreeModel.getId())) continue;
            newParentId = jsTreeModel.getParent();
            result.add(jsTreeModel);
            list.remove(jsTreeModel);
            if (--i == 0) {
                i = -1;
            }
            this.recursive(list, result, newParentId);
        }
    }

    public IPage getFunctionAndModuleList(Page page, FuncModuleTreeQueryDto funcModuleTreeQueryDto) {
        SysFunctionModules functionModules;
        String functionName = funcModuleTreeQueryDto.getFunctionName();
        String parentModuleId = funcModuleTreeQueryDto.getParentModuleId();
        funcModuleTreeQueryDto.setParentModuleName("");
        if (ToolUtil.isNotEmpty((Object)functionName)) {
            functionName = functionName.replace("%", "\\\\%").replace("_", "\\\\_");
            funcModuleTreeQueryDto.setFunctionName(functionName);
        }
        if (ToolUtil.isNotEmpty((Object)parentModuleId) && ToolUtil.isNotEmpty((Object)(functionModules = (SysFunctionModules)this.sysFunctionModulesMapper.selectById((Serializable)((Object)parentModuleId))))) {
            funcModuleTreeQueryDto.setParentModuleName(functionModules.getFunctionModuleName());
        }
        SeqStatic functionSeq = this.sysFunctionsMapper.getSeqFunction(funcModuleTreeQueryDto);
        SeqStatic moduleSeq = this.sysFunctionsMapper.getSeqModule(funcModuleTreeQueryDto);
        boolean isGradeAdmin = Objects.requireNonNull(BaseSecurityUtil.getUser()).isGradeadmin();
        List<Object> list = new ArrayList();
        if (isGradeAdmin) {
            List treeNode = this.iSysFunctionModulesService.getFunModuleTreeForOrg("true");
            ArrayList arrayList = new ArrayList();
            treeNode.forEach(o -> ids.add(o.getId()));
            funcModuleTreeQueryDto.setFunctionModuleList(arrayList);
            list = this.sysFunctionsMapper.getGradeFunctionAndModuleList(funcModuleTreeQueryDto, page);
            list.forEach(o -> o.setGradeDisabled(true));
        } else {
            list = this.sysFunctionsMapper.getFunctionAndModuleList(funcModuleTreeQueryDto, page);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (SysModuleFunctionsVo sysModuleFunctionsVo : list) {
                sysModuleFunctionsVo.setUp(true);
                sysModuleFunctionsVo.setDown(true);
                if (sysModuleFunctionsVo.getType().equals("0") && ToolUtil.isNotEmpty((Object)functionSeq)) {
                    if (sysModuleFunctionsVo.getSeq().equals(functionSeq.getMinSeq())) {
                        sysModuleFunctionsVo.setUp(false);
                    }
                    if (!sysModuleFunctionsVo.getSeq().equals(functionSeq.getMaxSeq())) continue;
                    sysModuleFunctionsVo.setDown(false);
                    continue;
                }
                if (!sysModuleFunctionsVo.getType().equals("1") || !ToolUtil.isNotEmpty((Object)moduleSeq)) continue;
                if (sysModuleFunctionsVo.getSeq().equals(moduleSeq.getMinSeq())) {
                    sysModuleFunctionsVo.setUp(false);
                }
                if (!sysModuleFunctionsVo.getSeq().equals(moduleSeq.getMaxSeq())) continue;
                sysModuleFunctionsVo.setDown(false);
            }
        }
        page.setRecords(list);
        return page;
    }

    public SysModuleFunctionsVo getFunctionModuleDetail(Long functionModuleId) {
        return this.sysFunctionModulesMapper.getFunctionModuleDetail(functionModuleId);
    }

    public boolean saveOrUpdateFunctionModule(FuncModuleInfoDto funcModuleInfoDto) {
        Long functionModuleId = funcModuleInfoDto.getFunctionModuleId();
        String functionModuleName = funcModuleInfoDto.getFunctionModuleName();
        Long parentModuleId = funcModuleInfoDto.getParentModuleId();
        if (ToolUtil.isEmpty((Object)functionModuleName)) {
            throw new BaseException("\u529f\u80fd\u6a21\u5757\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (functionModuleName.length() > 32) {
            throw new BaseException("\u529f\u80fd\u6a21\u5757\u540d\u79f0\u6700\u591a\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u5b57\u7b26");
        }
        if (ToolUtil.isNotEmpty((Object)functionModuleId)) {
            SysFunctionModules functionModules = (SysFunctionModules)this.sysFunctionModulesMapper.selectById(functionModuleId);
            if (ToolUtil.isNotEmpty((Object)functionModules)) {
                functionModules.setFunctionModuleName(functionModuleName);
                return this.sysFunctionModulesMapper.updateById(functionModules) > 0;
            }
            return false;
        }
        SysFunctionModules functionModules = new SysFunctionModules();
        functionModules.setFunctionModuleName(functionModuleName);
        functionModules.setParentModuleId(parentModuleId);
        Long max = this.sysFunctionModulesMapper.getMaxOrderByParentId(parentModuleId);
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            BigDecimal order = BigDecimal.valueOf(max);
            functionModules.setSeq(order.add(num));
        } else {
            functionModules.setSeq(new BigDecimal(1));
        }
        return this.sysFunctionModulesMapper.insert(functionModules) > 0;
    }

    @DSTransactional
    public boolean deleteFunctionModules(Long functionModuleId) {
        if (ToolUtil.isEmpty((Object)functionModuleId)) {
            throw new BaseException("\u529f\u80fd\u6a21\u5757ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Long> functionIdList = new ArrayList<Long>();
        ArrayList<Long> functionModuleIdList = new ArrayList<Long>();
        ArrayList<Long> parentModuleIds = new ArrayList<Long>();
        functionModuleIdList.add(functionModuleId);
        parentModuleIds.add(functionModuleId);
        this.getFuncAndFuncModuleIds(functionIdList, functionModuleIdList, parentModuleIds);
        if (functionModuleIdList.size() > 0) {
            this.sysFunctionModulesMapper.delete((Wrapper)new LambdaUpdateWrapper().in(SysFunctionModules::getId, functionModuleIdList));
        }
        if (functionIdList.size() > 0) {
            return this.sysFunctionsMapper.delete((Wrapper)new LambdaUpdateWrapper().in(SysFunctions::getId, functionIdList)) > 0 && this.sysFunctionResourcesMapper.delete((Wrapper)new LambdaUpdateWrapper().in(SysFunctionResources::getFunctionId, functionIdList)) > 0;
        }
        return true;
    }

    private void getFuncAndFuncModuleIds(List<Long> functionIdList, List<Long> functionModuleIdList, List<Long> parentModuleIds) {
        List childModuleList;
        List functionsList = this.sysFunctionsMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFunctions::getFunctionModuleId, parentModuleIds));
        if (ToolUtil.isNotEmpty((Object)functionsList)) {
            functionsList.forEach(function -> functionIdList.add(function.getId()));
        }
        if (ToolUtil.isNotEmpty((Object)(childModuleList = this.sysFunctionModulesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysFunctionModules::getParentModuleId, parentModuleIds))))) {
            parentModuleIds.clear();
            childModuleList.forEach(functionModule -> {
                functionModuleIdList.add(functionModule.getId());
                parentModuleIds.add(functionModule.getId());
            });
            this.getFuncAndFuncModuleIds(functionIdList, functionModuleIdList, parentModuleIds);
        }
    }

    public void saveFunctionModuleTreeOrder(List<Long> idList) {
        ArrayList<SysFunctionModules> sysFunctionModulesList = new ArrayList<SysFunctionModules>();
        for (int i = 0; i < idList.size(); ++i) {
            Long id = idList.get(i);
            SysFunctionModules sysFunctionModules = new SysFunctionModules();
            sysFunctionModules.setId(id);
            sysFunctionModules.setSeq(new BigDecimal(i + 1));
            sysFunctionModulesList.add(sysFunctionModules);
        }
        if (ToolUtil.isNotEmpty(sysFunctionModulesList)) {
            this.updateBatchById(sysFunctionModulesList, sysFunctionModulesList.size());
        }
    }

    public List<JSTreeModel> functionModuleTreeByModuleId(Long moduleId) {
        return this.sysFunctionModulesMapper.functionModuleTreeByModuleId(moduleId);
    }

    public ApiResponse<Tip> updateMoveNode(FuncModuleOrderDto funcModuleOrderDto) {
        SysFunctionModules thatFunctionModule;
        Long functionModuleId = funcModuleOrderDto.getFunctionModuleId();
        Boolean isUp = funcModuleOrderDto.getIsUp();
        if (ToolUtil.isEmpty((Object)functionModuleId)) {
            throw new BaseException("\u529f\u80fd\u6a21\u5757id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysFunctionModules thisFunctionModule = (SysFunctionModules)this.sysFunctionModulesMapper.selectById(functionModuleId);
        List<SysFunctionModules> thatFunctionModules = isUp != false ? this.sysFunctionModulesMapper.seletListLt(thisFunctionModule.getParentModuleId(), thisFunctionModule.getSeq()) : this.sysFunctionModulesMapper.seletListGt(thisFunctionModule.getParentModuleId(), thisFunctionModule.getSeq());
        if (thatFunctionModules.size() > 0 && (thatFunctionModule = thatFunctionModules.get(0)) != null) {
            BigDecimal temp = thisFunctionModule.getSeq();
            thisFunctionModule.setSeq(thatFunctionModule.getSeq());
            thatFunctionModule.setSeq(temp);
            this.sysFunctionModulesMapper.updateById(thisFunctionModule);
            this.sysFunctionModulesMapper.updateById(thatFunctionModule);
        }
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }
}

