/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.SysConfRolesetDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesetService;
import com.jxdinfo.hussar.authorization.permit.vo.SysConfRolesVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysConfRolesetVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SysConfRolesetServiceImpl
extends HussarServiceImpl<SysConfRolesetMapper, SysConfRoleset>
implements ISysConfRolesetService {
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysRolesMapper sysRolesMapper;

    public ApiResponse<Long> saveRoleSet(SysConfRoleset sysConfRoleset) {
        if (ToolUtil.isEmpty((Object)sysConfRoleset)) {
            throw new BaseException("\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysConfRoleset, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        String comefrom = "add";
        this.sameRoleName(sysConfRoleset.getSetName(), comefrom);
        boolean flag = this.saveOrUpdate((BaseEntity)sysConfRoleset);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((Object)sysConfRoleset.getId(), (String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse<Tip> updateRoleSet(SysConfRoleset sysConfRoleset) {
        if (ToolUtil.isEmpty((Object)sysConfRoleset)) {
            throw new BaseException("\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysConfRoleset, "edit");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        String comefrom = "edit";
        this.sameRoleName(sysConfRoleset.getSetName(), comefrom);
        boolean flag = this.updateById(sysConfRoleset);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    private void validateParam(Object o, String mdType) {
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysConfRoleset) {
            SysConfRoleset reqBO = (SysConfRoleset)o;
            if ("edit".equals(mdType) && null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getSetName())) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u96c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)reqBO.getSetName()) && 16 < reqBO.getSetName().length()) {
                sBuffer.append(",");
                sBuffer.append("\u89d2\u8272\u96c6\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516516\u4e2a\u5b57\u7b26");
            }
            if (null == reqBO.getCardinality()) {
                sBuffer.append(",");
                sBuffer.append("\u57fa\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (0 < sBuffer.length()) {
                String rspStr = sBuffer.substring(1);
                throw new BaseException(rspStr);
            }
        }
    }

    @DSTransactional
    public ApiResponse<Tip> deleteRoleSet(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids = id.split(",");
        List<String> idList = Arrays.asList(ids);
        boolean flag = this.removeByIds(idList);
        this.sysConfRolesMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysConfRoles::getSetId, idList));
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public List<Long> getRoleView(String id) {
        if (ToolUtil.isEmpty((Object)id)) {
            throw new BaseException("\u4e0d\u76f8\u5bb9\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<Long> result = new ArrayList<Long>();
        List<SysConfRolesVo> roleList = this.getSelectInRoles(id);
        if (ToolUtil.isNotEmpty(roleList)) {
            for (SysConfRolesVo sysConfRolesVo : roleList) {
                result.add(sysConfRolesVo.getId());
            }
        }
        return result;
    }

    public IPage<SysConfRolesetVo> getRolesList(Page<SysConfRolesetVo> page, SysConfRolesetDto sysConfRolesetDto) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (sysConfRolesetDto == null) {
            sysConfRolesetDto = new SysConfRolesetDto();
        }
        String name = sysConfRolesetDto.getSetName() == null ? "" : sysConfRolesetDto.getSetName();
        String org = sysConfRolesetDto.getOrgId() == null ? "" : sysConfRolesetDto.getOrgId();
        return page.setRecords(this.sysConfRolesetMapper.getRolesList(page, name, org));
    }

    public List<SysConfRolesetVo> getTransferData() {
        List roleList = this.sysRolesMapper.selectList((Wrapper)new LambdaQueryWrapper());
        ArrayList<SysConfRolesetVo> result = new ArrayList<SysConfRolesetVo>();
        for (SysRoles role : roleList) {
            SysConfRolesetVo sysConfRolesetVo = new SysConfRolesetVo();
            sysConfRolesetVo.setKey(role.getId());
            sysConfRolesetVo.setLabel(role.getRoleName());
            sysConfRolesetVo.setDisabled(false);
            result.add(sysConfRolesetVo);
        }
        return result;
    }

    public List<SysConfRolesVo> getSelectInRoles(String id) {
        return this.sysConfRolesMapper.getSelectInRoles(id);
    }

    private void sameRoleName(String name, String comefrom) {
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(SysConfRoleset::getSetName, (Object)name));
        if (ToolUtil.isNotEmpty((Object)list)) {
            if ("add".equals(comefrom)) {
                throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u8be5\u89d2\u8272\u96c6\u540d\u79f0\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
            if ("edit".equals(comefrom)) {
                throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\uff08\u8be5\u89d2\u8272\u96c6\u540d\u79f0\u5df2\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01\uff09");
            }
        }
    }
}

