/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dto.SysConfRolesetDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SysConfRolesServiceImpl
extends HussarServiceImpl<SysConfRolesMapper, SysConfRoles>
implements ISysConfRolesService {
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesMapper sysConfRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;

    public List<SysRoles> getSelectInRoles(String selectId) {
        List<SysRoles> list;
        if (selectId != null && !"".equals(selectId)) {
            String[] ids = selectId.substring(1).split(",");
            list = this.sysRolesMapper.getNoSelect(ids);
        } else {
            list = this.sysRolesMapper.selectList(null);
        }
        return list;
    }

    public boolean isIncludeConfRole(Long[] roleIds) {
        boolean flag = false;
        if (roleIds == null || roleIds.length == 0) {
            return true;
        }
        List list = this.sysConfRolesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysConfRoles::getId, Arrays.asList(roleIds)));
        if (ToolUtil.isNotEmpty((Object)list)) {
            ArrayList<String> idList = new ArrayList<String>();
            for (SysConfRoles sysConfRoles : list) {
                idList.add(String.valueOf(sysConfRoles.getSetId()));
            }
            List sysConfRolesetList = this.sysConfRolesetMapper.selectBatchIds(idList);
            for (SysConfRoleset roleset : sysConfRolesetList) {
                BigDecimal cardinality = roleset.getCardinality();
                int count = 0;
                for (SysConfRoles roles : list) {
                    if (!roleset.getId().equals(roles.getSetId())) continue;
                    ++count;
                }
                if (count <= cardinality.intValue() - 1) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    @DSTransactional
    public ApiResponse<Tip> saveBatchSysConfRoles(SysConfRolesetDto sysConfRolesetDto) {
        if (ToolUtil.isEmpty((Object)sysConfRolesetDto)) {
            throw new BaseException("\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6dto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        try {
            this.validateParam(sysConfRolesetDto, "add");
        }
        catch (BaseException e) {
            throw new BaseException(e.getMessage());
        }
        String roIds = sysConfRolesetDto.getRoleIds() == null ? "" : sysConfRolesetDto.getRoleIds();
        Long setId = sysConfRolesetDto.getId() == null ? 0L : sysConfRolesetDto.getId();
        String[] ids = roIds.split(",");
        this.remove((Wrapper)new LambdaQueryWrapper().eq(SysConfRoles::getSetId, (Object)setId));
        ArrayList<SysConfRoles> list = new ArrayList<SysConfRoles>();
        for (String id : ids) {
            SysConfRoles sysConfRoles = new SysConfRoles();
            sysConfRoles.setSetId(setId);
            sysConfRoles.setId(Long.valueOf(id));
            list.add(sysConfRoles);
        }
        if (ToolUtil.isNotEmpty(list)) {
            this.saveBatch(list, list.size());
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private void validateParam(Object o, String mdType) {
        StringBuffer sBuffer = new StringBuffer();
        if (("add".equals(mdType) || "edit".equals(mdType)) && o instanceof SysConfRolesetDto) {
            SysConfRolesetDto reqBO = (SysConfRolesetDto)o;
            if (null == reqBO.getId()) {
                sBuffer.append(",");
                sBuffer.append("\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getRoleIds())) {
                sBuffer.append(",");
                sBuffer.append("\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (0 < sBuffer.length()) {
                String rspStr = sBuffer.substring(1);
                throw new BaseException(rspStr);
            }
        }
    }

    public List<JSTreeModel> getSelfRoleTree(String[] roleIds) {
        ArrayList<JSTreeModel> tree = new ArrayList();
        List result = this.sysOrgManageService.selfRoleTree(roleIds);
        tree = this.doRecursive(result);
        return tree;
    }

    public List<JSTreeModel> doRecursive(List<JSTreeModel> list) {
        JSTreeModel model = new JSTreeModel();
        model.setId(Constants.RES_NODE_ID);
        model.setCode("GROUP");
        model.setParent(Constants.ROOT_NODE_PARENT);
        model.setText("\u89d2\u8272\u6811");
        model.setType("isRoot");
        list.add(model);
        return list;
    }
}

