/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAssistOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.vo.SysStruAuditVo;
import com.jxdinfo.hussar.authorization.permit.dto.StruAuditDto;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4eba\u5458\u5ba1\u6838"})
@RestController
@RequestMapping(value={"/sysStaffAuditFront"})
public class SysStaffAuditFrontController
extends HussarBaseController<SysStaffAudit, ISysStaffAuditService> {
    @Resource
    private ISysStruAuditService sysStruAuditService;
    @Resource
    private ISysStaffAuditService sysStaffAuditService;

    @ApiOperation(value="\u4eba\u5458\u5ba1\u6838\u5217\u8868", notes="\u4eba\u5458\u5ba1\u6838\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="struAuditDto", value="\u7ec4\u7ec7\u673a\u6784\u5ba1\u6838dto", paramType="query")})
    @GetMapping(value={"/getList"})
    @CheckPermission(value={"sysStaffAudit:list"})
    @AuditLog(moduleName="\u4eba\u5458\u5ba1\u6838", eventDesc="\u83b7\u53d6\u4eba\u5458\u5ba1\u6838\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysStruAuditVo>> list(Page<SysStruAuditVo> page, StruAuditDto struAuditDto) {
        struAuditDto.setOrganName(struAuditDto.getOrganName().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.sysStaffAuditService.queryStaffAudit(page, struAuditDto));
    }

    @ApiOperation(value="\u4eba\u5458\u5ba1\u6838\u901a\u8fc7/\u9a73\u56de", notes="\u4eba\u5458\u5ba1\u6838\u901a\u8fc7/\u9a73\u56de")
    @ApiImplicitParam(name="sysStruAudit", value="\u7ec4\u7ec7\u673a\u6784\u5ba1\u6838\u5b9e\u4f53", required=true, paramType="body")
    @PostMapping(value={"/verify"})
    @CheckPermission(value={"sysStruAudit:verify"})
    @AuditLog(moduleName="\u4eba\u5458\u5ba1\u6838", eventDesc="\u4eba\u5458\u5ba1\u6838\u901a\u8fc7/\u9a73\u56de", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> verify(@RequestBody SysStruAudit sysStruAudit) {
        return ApiResponse.success((String)this.sysStruAuditService.verifyVue(sysStruAudit));
    }

    @ApiOperation(value="\u67e5\u770b\u5ba1\u6838\u4eba\u5458\u8be6\u60c5", notes="\u67e5\u770b\u5ba1\u6838\u4eba\u5458\u8be6\u60c5")
    @ApiImplicitParam(name="sysStruAudit", value="\u7ec4\u7ec7\u673a\u6784\u5ba1\u6838\u5b9e\u4f53", required=true, paramType="query")
    @GetMapping(value={"/detail"})
    @CheckPermission(value={"sysStaffAudit:view"})
    @AuditLog(moduleName="\u4eba\u5458\u5ba1\u6838", eventDesc="\u67e5\u8be2\u5ba1\u6838\u4eba\u5458\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<JSONObject> detail(SysStruAudit sysStruAudit) {
        return ApiResponse.success((Object)this.sysStruAuditService.getStaffAuditDetail(sysStruAudit));
    }

    @ApiOperation(value="\u83b7\u53d6\u5ba1\u6838\u4e2d\u4eba\u5458\u7684\u517c\u4efb\u5c97\u4f4d", notes="\u83b7\u53d6\u5ba1\u6838\u4e2d\u4eba\u5458\u7684\u517c\u4efb\u5c97\u4f4d")
    @ApiImplicitParam(name="struId", value="\u4eba\u5458\u7ec4\u7ec7id", required=true, paramType="query")
    @GetMapping(value={"/getAssistDetail"})
    @AuditLog(moduleName="\u4eba\u5458\u5ba1\u6838", eventDesc="\u67e5\u8be2\u5ba1\u6838\u4e2d\u4eba\u5458\u7684\u517c\u4efb\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruAssistOrganAudit>> assistOrgan(String struId) {
        return ApiResponse.success((Object)this.sysStruAuditService.getAssistDetail(struId));
    }
}

