/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dto.FunResourceEntity;
import com.jxdinfo.hussar.authorization.permit.dto.FuncInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleInfoDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncModuleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncOrderDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncPermitDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncResDelDto;
import com.jxdinfo.hussar.authorization.permit.dto.FuncTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResListDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResModuleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResPermitDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResRoleDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourcePathDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeByIdDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceTreeChangeDto;
import com.jxdinfo.hussar.authorization.permit.dto.ResourceUniqueDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.authorization.permit.vo.CheckResourceVo;
import com.jxdinfo.hussar.authorization.permit.vo.FuncResVo;
import com.jxdinfo.hussar.authorization.permit.vo.ImportVueResVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysFunctionVO;
import com.jxdinfo.hussar.authorization.permit.vo.SysModuleFunctionsVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.annotation.Inner;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u8d44\u6e90\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/resourceFront"})
public class SysResManageFrontController
extends HussarBaseController<SysResources, ISysResManageService> {
    @Resource
    ISysResManageService sysResManageService;
    @Resource
    ISysStruResourcesService iSysStruResourcesService;
    @Resource
    ISysStruFunctionsService iSysStruFunctionsService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    ISysRoleResourceService sysRoleResourceService;
    @Resource
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private ISysFunctionResourcesService iSysFunctionResourcesService;

    @ApiOperation(value="\u529f\u80fd\u8d44\u6e90\u6811", notes="\u529f\u80fd\u8d44\u6e90\u6811")
    @ApiImplicitParam(name="resTreeDto", value="\u8d44\u6e90\u6811dto", required=true, paramType="query")
    @GetMapping(value={"/resTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resTree(ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getFunResource(resTreeDto)));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u8d44\u6e90\u6811", notes="\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u8d44\u6e90\u6811")
    @ApiImplicitParam(name="resTreeDto", value="\u8d44\u6e90\u6811dto", required=true, paramType="query")
    @GetMapping(value={"/resTreeForOrgRes"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resTreeForOrgRes(ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getFunResourceForOrg(resTreeDto)));
    }

    @ApiOperation(value="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u6811\u5f62\u6570\u636e", notes="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u6811\u5f62\u6570\u636e")
    @ApiImplicitParam(name="resTreeDto", value="\u8d44\u6e90\u6811dto", required=true, paramType="query")
    @GetMapping(value={"/resFuncTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u6811\u5f62\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resFuncModuleTree(ResTreeDto resTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getResFunTree(resTreeDto)));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u6811\u8282\u70b9\u83b7\u53d6\u4e0b\u7ea7\u5217\u8868", notes="\u6839\u636e\u8d44\u6e90\u6811\u8282\u70b9\u83b7\u53d6\u4e0b\u7ea7\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="resTreeQueryDto", value="\u8d44\u6e90\u6811\u67e5\u8be2dto", required=true, paramType="query")})
    @GetMapping(value={"/resInfoList"})
    @CheckPermission(value={"userFront:userInfo"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90\u6811\u8282\u70b9\u83b7\u53d6\u4e0b\u7ea7\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage> resInfoList(Page page, ResTreeQueryDto resTreeQueryDto) {
        return ApiResponse.success((Object)this.sysResManageService.getResNodeSubList(page, resTreeQueryDto));
    }

    @ApiOperation(value="\u6839\u636e\u8d44\u6e90\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u6811", notes="\u6839\u636e\u8d44\u6e90\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="query"), @ApiImplicitParam(name="isRoot", value="\u662f\u5426\u4e3a\u6839\u8282\u70b9", required=true, paramType="query")})
    @GetMapping(value={"/moduleTreeById"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6839\u636e\u8d44\u6e90\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> moduleTreeById(String moduleId, boolean isRoot) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.moduleTreeById(moduleId, isRoot)));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u6a21\u5757\u65f6\u83b7\u53d6\u6a21\u5757\u7f16\u7801", notes="\u65b0\u589e\u8d44\u6e90\u6a21\u5757\u65f6\u83b7\u53d6\u6a21\u5757\u7f16\u7801")
    @CheckPermission(value={"resourceFront:moduleAdd"})
    @GetMapping(value={"moduleAdd"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u6a21\u5757\u65f6\u83b7\u53d6\u6a21\u5757\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> moduleAdd() {
        return ApiResponse.success((String)this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_RESOURCE_MODULES"));
    }

    @ApiOperation(value="\u67e5\u770b\u8d44\u6e90\u6a21\u5757\u4fe1\u606f", notes="\u67e5\u770b\u8d44\u6e90\u6a21\u5757\u4fe1\u606f")
    @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="query")
    @GetMapping(value={"moduleView"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u770b\u8d44\u6e90\u6a21\u5757\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysResourceModules> moduleView(String moduleId) {
        return ApiResponse.success((Object)this.sysResManageService.getModuleInfoById(moduleId));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u6a21\u5757", notes="\u65b0\u589e\u8d44\u6e90\u6a21\u5757")
    @ApiImplicitParam(name="sysModules", value="\u6a21\u5757\u4fe1\u606f", required=true, paramType="body")
    @CheckPermission(value={"resourceFront:moduleSave"})
    @PostMapping(value={"moduleSave"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> moduleSave(@RequestBody SysResourceModules sysResourceModules) {
        return this.sysResManageService.saveModules(sysResourceModules);
    }

    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u6a21\u5757", notes="\u4fee\u6539\u8d44\u6e90\u6a21\u5757")
    @ApiImplicitParam(name="sysModules", value="\u6a21\u5757\u4fe1\u606f", required=true, paramType="body")
    @CheckPermission(value={"resourceFront:moduleEditSave"})
    @PostMapping(value={"moduleEditSave"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> moduleEditSave(@RequestBody SysResourceModules sysResourceModules) {
        return this.sysResManageService.saveModules(sysResourceModules);
    }

    @ApiOperation(value="\u5220\u9664\u8d44\u6e90\u6a21\u5757", notes="\u5220\u9664\u8d44\u6e90\u6a21\u5757")
    @ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="form")
    @CheckPermission(value={"resourceFront:delModule"})
    @PostMapping(value={"delModule"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5220\u9664\u8d44\u6e90\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delModule(@RequestBody Long moduleId) {
        return this.sysResManageService.delModuleResCascade(moduleId, null);
    }

    @ApiOperation(value="\u65b0\u589e\u529f\u80fd\u65f6\u83b7\u53d6\u529f\u80fd\u7f16\u7801", notes="\u65b0\u589e\u529f\u80fd\u65f6\u83b7\u53d6\u529f\u80fd\u7f16\u7801")
    @ApiImplicitParam(name="moduleCode", value="\u4e0a\u7ea7\u6a21\u5757\u7f16\u7801", required=true, paramType="query")
    @CheckPermission(value={"resourceFront:functionAdd"})
    @GetMapping(value={"functionAdd"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u65b0\u589e\u529f\u80fd\u65f6\u83b7\u53d6\u529f\u80fd\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> functionAdd(String moduleCode) {
        return ApiResponse.success((String)this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS", moduleCode));
    }

    @ApiOperation(value="\u529f\u80fd\u4fe1\u606f\u67e5\u770b", notes="\u529f\u80fd\u4fe1\u606f\u67e5\u770b")
    @ApiImplicitParam(name="functionId", value="\u529f\u80fdid", required=true, paramType="query")
    @GetMapping(value={"functionView"})
    @CheckPermission(value={"resourceFront:functionView"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4fe1\u606f\u67e5\u770b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysFunctionVO> functionView(String functionId) {
        return ApiResponse.success((Object)this.sysResManageService.getFunctionInfoById(functionId));
    }

    @ApiOperation(value="\u529f\u80fd\u65b0\u589e", notes="\u529f\u80fd\u65b0\u589e")
    @ApiImplicitParam(name="sysFunctions", value="\u529f\u80fd\u4fe1\u606f", required=true, paramType="body")
    @CheckPermission(value={"resourceFront:functionSave"})
    @PostMapping(value={"functionSave"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> functionSave(@RequestBody SysFunctions sysFunctions) {
        return this.sysResManageService.saveFunction(sysFunctions);
    }

    @ApiOperation(value="\u529f\u80fd\u4fee\u6539", notes="\u529f\u80fd\u4fee\u6539")
    @ApiImplicitParam(name="sysFunctions", value="\u529f\u80fd\u4fe1\u606f", required=true, paramType="body")
    @PostMapping(value={"functionEditSave"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> functionEditSave(@RequestBody SysFunctions sysFunctions) {
        return this.sysResManageService.updateFunction(sysFunctions);
    }

    @ApiOperation(value="\u5220\u9664\u529f\u80fd", notes="\u5220\u9664\u529f\u80fd")
    @ApiImplicitParam(name="functionId", value="\u529f\u80fdid", required=true, paramType="form")
    @CheckPermission(value={"resourceFront:delFunction"})
    @PostMapping(value={"delFunction"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5220\u9664\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> delFunction(@RequestBody String functionId) {
        return ApiResponse.success((Object)this.iSysFunctionsService.deleteFunction(functionId));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u65f6\u83b7\u53d6\u8d44\u6e90\u7f16\u7801", notes="\u65b0\u589e\u8d44\u6e90\u65f6\u83b7\u53d6\u8d44\u6e90\u7f16\u7801")
    @ApiImplicitParam(name="moduleCode", value="\u4e0a\u7ea7\u529f\u80fd\u7f16\u7801", required=true, paramType="query")
    @CheckPermission(value={"resourceFront:resourceAdd"})
    @GetMapping(value={"resourceAdd"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u65f6\u83b7\u53d6\u8d44\u6e90\u7f16\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> resourceAdd(String moduleCode) {
        return ApiResponse.success((String)this.sysResManageService.getResourceCurrentCode(moduleCode));
    }

    @ApiOperation(value="\u8d44\u6e90\u65b0\u589e", notes="\u8d44\u6e90\u65b0\u589e")
    @ApiImplicitParam(name="sysResources", value="\u8d44\u6e90\u4fe1\u606f", required=true, paramType="body")
    @CheckPermission(value={"resourceFront:resourceSave"})
    @PostMapping(value={"resourceSave"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> resourceSave(@RequestBody SysResources sysResources) {
        return ApiResponse.success((Object)this.sysResManageService.saveResource(sysResources));
    }

    @ApiOperation(value="\u8d44\u6e90\u4fee\u6539", notes="\u8d44\u6e90\u4fee\u6539")
    @ApiImplicitParam(name="sysResources", value="\u8d44\u6e90\u4fe1\u606f", required=true, paramType="body")
    @CheckPermission(value={"resourceFront:resourceEditSave"})
    @PostMapping(value={"resourceEditSave"})
    @CacheEvict(value={"authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u4fee\u6539", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Long> resourceEditSave(@RequestBody SysResources sysResources) {
        return ApiResponse.success((Object)this.sysResManageService.saveResource(sysResources));
    }

    @ApiOperation(value="\u8d44\u6e90\u67e5\u770b", notes="\u8d44\u6e90\u67e5\u770b")
    @ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="query")
    @GetMapping(value={"resourceView"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u67e5\u770b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysResources> resourceView(String resourceId) {
        return ApiResponse.success((Object)this.sysResManageService.getResourceInfoById(resourceId));
    }

    @ApiOperation(value="\u5220\u9664\u8d44\u6e90", notes="\u5220\u9664\u8d44\u6e90")
    @ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="form")
    @CheckPermission(value={"resourceFront:delResource"})
    @PostMapping(value={"delResource"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5220\u9664\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delResource(@RequestBody Long resourceId) {
        return this.sysResManageService.delModuleResCascade(null, resourceId);
    }

    @ApiOperation(value="\u6a21\u5757\u6392\u5e8f\u4fdd\u5b58", notes="\u6a21\u5757\u6392\u5e8f\u4fdd\u5b58")
    @ApiImplicitParam(name="idList", value="\u6392\u5e8f\u6a21\u5757id\u96c6\u5408", required=true, paramType="body")
    @PostMapping(value={"moduleTreeOrder"})
    @CheckPermission(value={"resourceFront:moduleTreeOrder"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6a21\u5757\u6392\u5e8f\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> moduleTreeOrder(@RequestBody List<Long> idList) {
        this.sysResManageService.updateModuleTreeOrder(idList);
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fd\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6811", notes="\u6839\u636e\u529f\u80fd\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="query"), @ApiImplicitParam(name="moduleName", value="\u6a21\u5757\u540d\u79f0", required=true, paramType="query")})
    @CheckPermission(value={"resourceFront:functionTreeById"})
    @GetMapping(value={"/functionTreeById"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fd\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> functionTreeById(Long moduleId, String moduleName) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getFunctionTreeByModuleId(moduleId, moduleName)));
    }

    @ApiOperation(value="\u529f\u80fd\u6811\u6392\u5e8f\u4fdd\u5b58", notes="\u529f\u80fd\u6811\u6392\u5e8f\u4fdd\u5b58")
    @ApiImplicitParam(name="idList", value="\u6392\u5e8f\u529f\u80fdid\u96c6\u5408", required=true, paramType="body")
    @PostMapping(value={"functionTreeOrder"})
    @CheckPermission(value={"resourceFront:functionTreeOrder"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6811\u6392\u5e8f\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> functionTreeOrder(@RequestBody List<Long> idList) {
        if (CollectionUtils.isNotEmpty(idList)) {
            this.sysResManageService.updateFunctionTreeOrder(idList);
        }
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636e\u529f\u80fdID\u83b7\u53d6\u8d44\u6e90\u6811", notes="\u6839\u636e\u529f\u80fdID\u83b7\u53d6\u8d44\u6e90\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u529f\u80fdid", required=true, paramType="query"), @ApiImplicitParam(name="functionName", value="\u529f\u80fd\u540d\u79f0", required=true, paramType="query")})
    @CheckPermission(value={"resourceFront:resourceTreeById"})
    @PostMapping(value={"resourceTreeById"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u529f\u80fdID\u83b7\u53d6\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resourceTreeById(@RequestBody ResourceTreeByIdDto resourceTreeByIdDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getResourceTreeByModuleId(resourceTreeByIdDto)));
    }

    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90\u6811\u6392\u5e8f", notes="\u4fdd\u5b58\u8d44\u6e90\u6811\u6392\u5e8f")
    @ApiImplicitParam(name="idList", value="\u6392\u5e8f\u8d44\u6e90id\u96c6\u5408", required=true, paramType="body")
    @PostMapping(value={"/resourceTreeOrder"})
    @CheckPermission(value={"resourceFront:resourceTreeOrder"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u8d44\u6e90\u6811\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> resourceTreeOrder(@RequestBody List<String> idList) {
        ArrayList<Long> longList = new ArrayList<Long>(idList.size());
        for (int i = 0; i < idList.size(); ++i) {
            longList.add(Long.parseLong(idList.get(i)));
        }
        this.sysResManageService.updateResourceTreeOrder(longList);
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6a21\u5757\u8f6c\u79fb", notes="\u6a21\u5757\u8f6c\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="query"), @ApiImplicitParam(name="isLeaf", value="\u662f\u5426\u4e3a\u672b\u7ea7\u8282\u70b9", required=true, paramType="query")})
    @CheckPermission(value={"resourceFront:moduleChangeById"})
    @GetMapping(value={"moduleChangeById"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u6a21\u5757\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> moduleChangeById(String moduleId, String isLeaf) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getModuleChangeById(moduleId, isLeaf)));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6a21\u5757\u8f6c\u79fb", notes="\u4fdd\u5b58\u6a21\u5757\u8f6c\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="form"), @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u6a21\u5757id", required=true, paramType="form")})
    @PostMapping(value={"moduleTreeChange"})
    @CheckPermission(value={"resourceFront:moduleTreeChange"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u6a21\u5757\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> moduleTreeChange(String moduleId, String parentId) {
        this.sysResManageService.updateModuleTreeChange(moduleId, parentId);
        return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fdd\u5b58\u529f\u80fd\u8f6c\u79fb", notes="\u4fdd\u5b58\u529f\u80fd\u8f6c\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u529f\u80fdid", required=true, paramType="form"), @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u6a21\u5757id", required=true, paramType="form")})
    @PostMapping(value={"functionTreeChange"})
    @CheckPermission(value={"resourceFront:functionTreeChange"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u529f\u80fd\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> functionTreeChange(@RequestBody FuncTreeChangeDto funcTreeChangeDto) {
        this.sysResManageService.updateFunctionTreeChange(funcTreeChangeDto.getFunctionId(), funcTreeChangeDto.getParentId());
        return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u8f6c\u79fb", notes="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u8f6c\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionModuleId", value="\u529f\u80fd\u6a21\u5757id", required=true, paramType="form"), @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u6a21\u5757id", required=true, paramType="form")})
    @PostMapping(value={"functionModulesTreeChange"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u529f\u80fd\u6a21\u5757\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> functionModulesTreeChange(@RequestBody FuncModuleTreeChangeDto funcModuleTreeChangeDto) {
        this.sysResManageService.updateFunctionModulesTreeChange(funcModuleTreeChangeDto.getFunctionModuleId(), funcModuleTreeChangeDto.getParentId());
        return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u8f6c\u79fb\u6811", notes="\u83b7\u53d6\u8d44\u6e90\u8f6c\u79fb\u6811")
    @ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="query")
    @CheckPermission(value={"resourceFront:resourceChangeById"})
    @GetMapping(value={"resourceChangeById"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u8d44\u6e90\u8f6c\u79fb\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resourceChangeById(String resourceId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getResourceChangeById(resourceId)));
    }

    @ApiOperation(value="\u4fdd\u5b58\u8d44\u6e90\u8f6c\u79fb", notes="\u4fdd\u5b58\u8d44\u6e90\u8f6c\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="form"), @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u529f\u80fdid", required=true, paramType="form")})
    @PostMapping(value={"resourceTreeChange"})
    @CheckPermission(value={"resourceFront:resourceTreeChange"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u8d44\u6e90\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> resourceTreeChange(@RequestBody ResourceTreeChangeDto resourceTreeChangeDto) {
        this.sysResManageService.updateResourceTreeChange(resourceTreeChangeDto);
        return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", notes="\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811")
    @ApiImplicitParam(name="resourceIds", value="\u8d44\u6e90ids", required=true, paramType="form")
    @CheckPermission(value={"resourceFront:selfResourceTree"})
    @PostMapping(value={"/selfResourceTree"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfResourceTree(String resourceIds) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getSelfResourceTree(resourceIds)));
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709url", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709url")
    @ApiImplicitParam(name="url", value="\u8d44\u6e90url", required=true, paramType="form")
    @GetMapping(value={"/sameUrl"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u662f\u5426\u5df2\u6709url", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> sameUrl(ResourceUniqueDto resourceUniqueDto) {
        return ApiResponse.success((Object)this.sysResManageService.getSameUrl(resourceUniqueDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811", notes="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811")
    @ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="query")
    @CheckPermission(value={"resourceFront:roleTreeView"})
    @GetMapping(value={"/roleTreeView"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u67d0\u4e2a\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleTreeView(String resourceId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getRoleTreeByResourceId(resourceId)));
    }

    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", notes="\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="form"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272ids", required=true, paramType="form")})
    @CheckPermission(value={"resourceFront:resourceAddSaveRole"})
    @PostMapping(value={"/resourceAddSaveRole"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u65b0\u589e\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> resourceAddSaveRole(Long resourceId, String roleIds) {
        return this.sysResManageService.saveResourceRelationRole(resourceId, roleIds);
    }

    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", notes="\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="form"), @ApiImplicitParam(name="roleIds", value="\u89d2\u8272ids", required=true, paramType="form")})
    @CheckPermission(value={"resourceFront:resourceEditSaveRole"})
    @PostMapping(value={"/resourceEditSaveRole"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u4fee\u6539\u8d44\u6e90\u5173\u8054\u89d2\u8272\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> resourceEditSaveRole(@RequestBody ResRoleDto resRoleDto) {
        return this.sysResManageService.updateResourceRelationRole(resRoleDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272", notes="\u83b7\u53d6\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272")
    @ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="query")
    @GetMapping(value={"/getResourceRoles"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u8d44\u6e90\u5173\u8054\u7684\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> getResourceRoles(String resourceId) {
        return ApiResponse.success((Object)this.sysRoleResourceService.getResourceRoles(resourceId));
    }

    @ApiOperation(value="\u8d44\u6e90\u6570\u636e\u5bfc\u51fa", notes="\u8d44\u6e90\u6570\u636e\u5bfc\u51fa")
    @ApiImplicitParam(name="ids", value="\u5bfc\u51fa\u7684\u8d44\u6e90ids", required=true, paramType="form")
    @PostMapping(value={"/exportRes"})
    @CheckPermission(value={"resourceFront:exportRes"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@RequestBody String ids, HttpServletResponse response) {
        this.sysResManageService.exportRes(ids, response);
    }

    @ApiOperation(value="\u8d44\u6e90\u6570\u636e\u5bfc\u5165", notes="\u8d44\u6e90\u6570\u636e\u5bfc\u5165")
    @ApiImplicitParam(name="file", value="\u5bfc\u5165\u6587\u4ef6", required=true, paramType="form")
    @PostMapping(path={"/importData"})
    @CheckPermission(value={"resourceFront:importData"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u6570\u636e\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<ImportVueResVo> importData(@RequestParam(value="file") MultipartFile hussarFile) throws IOException {
        if (ToolUtil.isEmpty((Object)hussarFile)) {
            throw new BaseException("\u8d44\u6e90\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        byte[] content = hussarFile.getBytes();
        return ApiResponse.success((Object)this.sysResManageService.importVueRes(content));
    }

    @ApiOperation(value="\u5f53\u524d\u6a21\u5757\u3001\u529f\u80fd\u662f\u5426\u6709\u53ef\u4e0b\u653e\u7684\u8d44\u6e90", notes="\u5f53\u524d\u6a21\u5757\u3001\u529f\u80fd\u662f\u5426\u6709\u53ef\u4e0b\u653e\u7684\u8d44\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="query"), @ApiImplicitParam(name="type", value="\u8d44\u6e90\u7c7b\u578b", required=true, paramType="query")})
    @GetMapping(value={"/checkHasResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u5f53\u524d\u6a21\u5757\u3001\u529f\u80fd\u662f\u5426\u6709\u53ef\u4e0b\u653e\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CheckResourceVo> checkHasResources(Long resourceId, String type) {
        return ApiResponse.success((Object)this.sysResManageService.checkHasResources(resourceId, type));
    }

    @ApiOperation(value="\u8d44\u6e90\u4e0b\u653e", notes="\u8d44\u6e90\u4e0b\u653e")
    @ApiImplicitParam(name="resPermitDto", value="\u8d44\u6e90\u4e0b\u653e\u56de\u6536dto", required=true, paramType="body")
    @CheckPermission(value={"resourceFront:delegateResource"})
    @PostMapping(value={"/delegateResource"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u4e0b\u653e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> delegateResource(@RequestBody ResPermitDto resPermitDto) {
        return this.iSysStruResourcesService.saveDelegateResource(resPermitDto);
    }

    @ApiOperation(value="\u529f\u80fd\u4e0b\u653e", notes="\u529f\u80fd\u4e0b\u653e")
    @ApiImplicitParam(name="funcPermitDto", value="\u8d44\u6e90\u4e0b\u653e\u56de\u6536dto", required=true, paramType="body")
    @PostMapping(value={"/delegateFunction"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4e0b\u653e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> delegateFunction(@RequestBody FuncPermitDto funcPermitDto) {
        return this.iSysStruFunctionsService.saveDelegateFunction(funcPermitDto);
    }

    @ApiOperation(value="\u8d44\u6e90\u56de\u6536", notes="\u8d44\u6e90\u56de\u6536")
    @ApiImplicitParam(name="resPermitDto", value="\u8d44\u6e90\u4e0b\u653e\u56de\u6536dto", required=true, paramType="body")
    @CheckPermission(value={"resourceFront:retrieveResource"})
    @RequestMapping(value={"/retrieveResource"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u8d44\u6e90\u56de\u6536", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> retrieveResource(@RequestBody ResPermitDto resPermitDto) {
        return this.iSysStruResourcesService.saveRetrieveResource(resPermitDto);
    }

    @ApiOperation(value="\u529f\u80fd\u56de\u6536", notes="\u529f\u80fd\u56de\u6536")
    @ApiImplicitParam(name="funcPermitDto", value="\u529f\u80fd\u4e0b\u653e\u56de\u6536dto", required=true, paramType="body")
    @RequestMapping(value={"/retrieveFuntion"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u56de\u6536", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> retrieveFuntion(@RequestBody FuncPermitDto funcPermitDto) {
        return this.iSysStruFunctionsService.saveRetrieveFunction(funcPermitDto);
    }

    @ApiOperation(value="\u89d2\u8272\u4fee\u6539\u5c55\u793a\u529f\u80fd\u8d44\u6e90\u6811", notes="\u89d2\u8272\u4fee\u6539\u5c55\u793a\u529f\u80fd\u8d44\u6e90\u6811")
    @GetMapping(value={"/editResTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ba1\u7406", eventDesc="\u89d2\u8272\u4fee\u6539\u5c55\u793a\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> editResTree() {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getEditResTree()));
    }

    @ApiOperation(value="\u9a8c\u8bc1\u8d44\u6e90\u662f\u5426\u4e8c\u6b21\u9a8c\u8bc1", notes="\u9a8c\u8bc1\u8d44\u6e90\u662f\u5426\u4e8c\u6b21\u9a8c\u8bc1")
    @ApiImplicitParam(name="resourceUrl", value="\u8d44\u6e90\u8def\u5f84", required=true, paramType="form")
    @PostMapping(value={"/checkResource"})
    @Inner
    public ApiResponse<JSONObject> checkResource(String resourceUrl) {
        return ApiResponse.success((Object)this.sysResManageService.queryIsCheckResource(resourceUrl));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", notes="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811")
    @ApiImplicitParam(name="functionFlag", value="\u662f\u5426\u52a0\u8f7d\u529f\u80fd", paramType="query")
    @GetMapping(value={"/funcModuleTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> funcModuleTree(String functionFlag) {
        List result = this.iSysFunctionModulesService.getFunModuleTreeForOrg(functionFlag);
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)result));
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u6a21\u5757\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u6a21\u5757\u6811")
    @ApiImplicitParam(name="functionFlag", value="\u662f\u5426\u52a0\u8f7d\u529f\u80fd", paramType="query")
    @GetMapping(value={"/funTreeForOrgFun"})
    @AuditLog(moduleName="\u89d2\u8272\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u89d2\u8272\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> funTreeForOrgFun(String functionFlag) {
        List result = this.iSysFunctionModulesService.getFunModuleTreeForOrg(functionFlag);
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)result));
    }

    @ApiOperation(value="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u5217\u8868\u6570\u636e", notes="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u5217\u8868\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="funcModuleTreeQueryDto", value="\u529f\u80fd\u6a21\u5757\u6811\u67e5\u8be2dto", required=true, paramType="query")})
    @GetMapping(value={"/functionAndModuleList"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u67e5\u8be2\u529f\u80fd\u6a21\u5757\u53ca\u529f\u80fd\u7684\u5217\u8868\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage> functionAndModuleList(Page page, FuncModuleTreeQueryDto funcModuleTreeQueryDto) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.getFunctionAndModuleList(page, funcModuleTreeQueryDto));
    }

    @ApiOperation(value="\u529f\u80fd\u6216\u529f\u80fd\u6a21\u5757\u8be6\u60c5", notes="\u529f\u80fd\u6216\u529f\u80fd\u6a21\u5757\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u529f\u80fdID", required=true, paramType="query"), @ApiImplicitParam(name="functionModuleId", value="\u529f\u80fd\u6a21\u5757ID", required=true, paramType="query")})
    @GetMapping(value={"/functionsDetail"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6216\u529f\u80fd\u6a21\u5757\u8be6\u60c5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysModuleFunctionsVo> functionsDetail(Long functionId, Long functionModuleId) {
        return ApiResponse.success((Object)this.sysResManageService.functionsDetail(functionId, functionModuleId));
    }

    @ApiOperation(value="\u5220\u9664\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", notes="\u5220\u9664\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb")
    @ApiImplicitParam(name="funcResDelDto", value="\u529f\u80fd\u8d44\u6e90\u5220\u9664\u6761\u4ef6dto", required=true, paramType="body")
    @PostMapping(value={"/delFunRes"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5220\u9664\u529f\u80fd\u8d44\u6e90\u5173\u8054\u5173\u7cfb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Integer> delFunRes(@RequestBody FuncResDelDto funcResDelDto) {
        if (ToolUtil.isEmpty((Object)funcResDelDto.getResourceIds())) {
            throw new BaseException("\u8d44\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.iSysFunctionResourcesService.deleteFunRes(funcResDelDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u548c\u529f\u80fd\u8d44\u6e90\u5173\u8054", notes="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u548c\u529f\u80fd\u8d44\u6e90\u5173\u8054")
    @ApiImplicitParam(name="funcInfoDto", value="\u529f\u80fd\u4fdd\u5b58\u4fe1\u606fdto", required=true, paramType="body")
    @PostMapping(value={"/saveFunRes"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u548c\u529f\u80fd\u8d44\u6e90\u5173\u8054", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<?> devolutionAuthority(@RequestBody JSONObject funcInfoJson) {
        FuncInfoDto funcInfoDto = (FuncInfoDto)JSON.parseObject((String)funcInfoJson.toJSONString(), FuncInfoDto.class);
        return ApiResponse.success((Object)this.iSysFunctionsService.saveOrUpdateFunction(funcInfoDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u6a21\u5757", notes="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u6a21\u5757")
    @ApiImplicitParam(name="funcModuleInfoDto", value="\u529f\u80fd\u6a21\u5757\u4fdd\u5b58\u4fe1\u606fdto", required=true, paramType="body")
    @PostMapping(value={"/saveFunModule"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u6216\u4fee\u6539\u529f\u80fd\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<?> saveFunModule(@RequestBody FuncModuleInfoDto funcModuleInfoDto) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.saveOrUpdateFunctionModule(funcModuleInfoDto));
    }

    @ApiOperation(value="\u5220\u9664\u529f\u80fd\u6a21\u5757", notes="\u5220\u9664\u529f\u80fd\u6a21\u5757")
    @ApiImplicitParam(name="functionModuleId", value="\u529f\u80fd\u6a21\u5757id", required=true, paramType="form")
    @PostMapping(value={"/delFunctionModules"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u5220\u9664\u529f\u80fd\u6a21\u5757", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<?> delFunctionModules(@RequestBody Long functionModuleId) {
        return ApiResponse.success((Object)this.iSysFunctionModulesService.deleteFunctionModules(functionModuleId));
    }

    @ApiOperation(value="\u529f\u80fd\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f", notes="\u529f\u80fd\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f")
    @ApiImplicitParam(name="idList", value="\u6392\u5e8f\u529f\u80fdid\u96c6\u5408", required=true, paramType="body")
    @PostMapping(value={"/functionModuleTreeOrder"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6a21\u5757\u4e0b\u7ea7\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> functionModuleTreeOrder(@RequestBody List<Long> idList) {
        if (CollectionUtils.isNotEmpty(idList)) {
            this.iSysFunctionModulesService.saveFunctionModuleTreeOrder(idList);
        }
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6a21\u5757\u6811", notes="\u6839\u636e\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6a21\u5757\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="moduleId", value="\u6a21\u5757id", required=true, paramType="query"), @ApiImplicitParam(name="moduleName", value="\u6a21\u5757\u540d\u79f0", required=true, paramType="query")})
    @GetMapping(value={"/functionModuleTreeById"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u6839\u636e\u6a21\u5757ID\u83b7\u53d6\u4e0b\u7ea7\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> functionModuleTreeById(Long moduleId, String moduleName) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysResManageService.getFunctionModuleTreeByModuleId(moduleId, moduleName)));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90", notes="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90")
    @ApiImplicitParam(name="type", value="\u524d\u53f0\u9875\u9762\u7c7b\u578b", required=true, paramType="query")
    @GetMapping(value={"/getResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7528\u6237\u5173\u8054\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> getResources(String type) {
        return ApiResponse.success((Object)this.sysResManageService.getResources(type));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e3b\u5e93\u4e0b\u5e94\u7528\u7684\u8d44\u6e90", notes="\u83b7\u53d6\u4e3b\u5e93\u4e0b\u5e94\u7528\u7684\u8d44\u6e90")
    @ApiImplicitParam(name="type", value="\u524d\u53f0\u9875\u9762\u7c7b\u578b", required=true, paramType="query")
    @GetMapping(value={"/getMasterResources"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4e3b\u5e93\u4e0b\u5e94\u7528\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> getMasterResources(String type) {
        return ApiResponse.success((Object)this.sysResManageService.getResourcesListByApp(type));
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u5757\u4e0b\u7684\u8d44\u6e90\u5217\u8868", notes="\u83b7\u53d6\u6a21\u5757\u4e0b\u7684\u8d44\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="resListDto", value="\u8d44\u6e90\u5217\u8868dto", required=true, paramType="query")})
    @GetMapping(value={"/resourceList"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6a21\u5757\u4e0b\u7684\u8d44\u6e90\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage> resourceList(Page page, ResListDto resListDto) {
        return ApiResponse.success((Object)this.sysResManageService.getResourceList(resListDto, page));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", notes="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811")
    @ApiImplicitParam(name="resModuleTreeDto", value="\u8d44\u6e90\u6a21\u5757\u6811\u67e5\u8be2\u6761\u4ef6dto", required=true, paramType="query")
    @GetMapping(value={"/resModuleTree"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u6a21\u5757\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resModuleTree(ResModuleTreeDto resModuleTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysFunctionModulesService.getResModuleTree(resModuleTreeDto)));
    }

    @ApiOperation(value="\u83b7\u53d6\u529f\u80fd\u8d44\u6e90\u6811", notes="\u83b7\u53d6\u529f\u80fd\u8d44\u6e90\u6811")
    @ApiImplicitParam(name="functionId", value="\u529f\u80fdID", required=true, paramType="query")
    @GetMapping(value={"/getFunResChooseAuthority"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FuncResVo>> getFunResChooseAuthority(Long functionId) {
        return ApiResponse.success((Object)this.iSysFunctionResourcesService.getFunctionResourceList(functionId));
    }

    @ApiOperation(value="\u529f\u80fd\u6a21\u5757\u4e0a\u79fb\u4e0b\u79fb", notes="\u529f\u80fd\u6a21\u5757\u4e0a\u79fb\u4e0b\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionModuleId", value="\u529f\u80fd\u6a21\u5757ID", required=true, paramType="form"), @ApiImplicitParam(name="isUp", value="\u662f\u5426\u4e0a\u79fb", required=true, paramType="form")})
    @PostMapping(value={"/singleMoveFuncModules"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u6a21\u5757\u4e0a\u79fb\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse updateMoveNodeFuncModules(@RequestBody FuncModuleOrderDto funcModuleOrderDto) {
        return this.iSysFunctionModulesService.updateMoveNode(funcModuleOrderDto);
    }

    @ApiOperation(value="\u529f\u80fd\u4e0a\u79fb\u4e0b\u79fb", notes="\u529f\u80fd\u4e0a\u79fb\u4e0b\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u529f\u80fdID", required=true, paramType="form"), @ApiImplicitParam(name="isUp", value="\u662f\u5426\u4e0a\u79fb", required=true, paramType="form")})
    @PostMapping(value={"/singleMoveFuncs"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u529f\u80fd\u4e0a\u79fb\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse updateMoveNodeFuncs(@RequestBody FuncOrderDto funcOrderDto) {
        return this.iSysFunctionsService.updateMoveNode(funcOrderDto);
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u8def\u7531", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u8def\u7531")
    @ApiImplicitParam(name="resourcePathDto", value="\u8def\u7531\u6821\u9a8cdto", required=true, paramType="query")
    @GetMapping(value={"/samePath"})
    @AuditLog(moduleName="\u8d44\u6e90\u7ba1\u7406", eventDesc="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u8def\u7531", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysResources>> samePath(ResourcePathDto resourcePathDto) {
        return ApiResponse.success((Object)this.sysResManageService.getSamePath(resourcePathDto));
    }

    @GetMapping(value={"/getFunResource"})
    @AuditLog(moduleName="\u529f\u80fd\u7ba1\u7406", eventDesc="\u83b7\u53d6\u529f\u80fd\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<FunResourceEntity>> getFunResource() {
        return this.sysResManageService.getFunResource();
    }
}

