/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.permit.dto.RoleFuncDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleResDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleTreeQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserQueryDto;
import com.jxdinfo.hussar.authorization.permit.dto.SysRolesDto;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.service.ISysResTypeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleDataScopeService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.DataScopeVo;
import com.jxdinfo.hussar.authorization.permit.vo.RoleInfoVO;
import com.jxdinfo.hussar.authorization.permit.vo.SysRoleResourceVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u89d2\u8272\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/roleManagerFront"})
public class RoleManagerFrontController
extends HussarBaseController<SysRoles, ISysRolesService> {
    @Resource
    private SysOrgManageService sysOrgManageService;
    @Resource
    private ISysResTypeService iSysResTypeService;
    @Resource
    private ISysRolesService iSysRolesService;
    @Resource
    private ISysRoleResourceService iSysRoleResourceService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysRoleGroupService sysRoleGroupService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysRoleDataScopeService sysRoleDataScopeService;
    @Resource
    private ISysRoleFunctionsService iSysRoleFunctionsService;
    @Resource
    private SysOrgManageService orgMaintenanceService;

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u6811")
    @ApiImplicitParam(name="roleTreeDto", value="\u89d2\u8272\u6811dto", required=true, paramType="query")
    @CheckPermission(value={"roleManagerFront:roleTree"})
    @GetMapping(value={"/roleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> roleTree(RoleTreeDto roleTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getRoleTree(roleTreeDto)));
    }

    @ApiOperation(value="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u7ec4\u7ec7\u89d2\u8272", notes="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u7ec4\u7ec7\u89d2\u8272")
    @ApiImplicitParam(name="roleTreeDto", value="\u89d2\u8272\u6811dto", required=true, paramType="query")
    @CheckPermission(value={"roleManagerFront:roleTree"})
    @GetMapping(value={"/isContainOrganRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u5224\u65ad\u7528\u6237\u662f\u5426\u6709\u7ec4\u7ec7\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> isContainOrganRole(RoleTreeDto roleTreeDto) {
        return ApiResponse.success((Object)this.iSysRolesService.isContainsOrganRole(roleTreeDto));
    }

    @ApiOperation(value="\u89d2\u8272\u6811\u61d2\u52a0\u8f7d", notes="\u89d2\u8272\u6811\u61d2\u52a0\u8f7d")
    @ApiImplicitParam(name="roleTreeDto", value="\u89d2\u8272\u6811dto", required=true, paramType="query")
    @GetMapping(value={"/lazyRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u6811\u61d2\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> lazyRoleTree(RoleTreeDto roleTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getRoleTreeByLazy(roleTreeDto)));
    }

    @ApiOperation(value="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d", notes="\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u6570\u636e\u52a0\u8f7d")
    @GetMapping(value={"/roleGroupTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5206\u7ec4\u7684\u6811\u72b6\u7ed3\u6784", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> loadRoleGruopTree() {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getRoleGroupTree()));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5217\u8868", notes="\u83b7\u53d6\u89d2\u8272\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="roleTreeQueryDto", value="\u89d2\u8272\u6811\u67e5\u8be2dto", required=true, paramType="query")})
    @GetMapping(value={"/roleInfoList"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage> roleInfoList(Page page, RoleTreeQueryDto roleTreeQueryDto) {
        roleTreeQueryDto.setGroupName(roleTreeQueryDto.getGroupName().replace("%", "\\%").replace("_", "\\_"));
        roleTreeQueryDto.setRoleName(roleTreeQueryDto.getRoleName().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.iSysRolesService.getRoleInfoList(page, roleTreeQueryDto));
    }

    @GetMapping(value={"/roleInfoListForGradeadmin"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5206\u7ea7\u7ba1\u7406\u5458\u767b\u5f55\u65f6\u7684\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage> roleInfoListForGradeadmin(Page page) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleInfoListForGradeadmin(page));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u89d2\u8272", notes="\u83b7\u53d6\u7528\u6237\u89d2\u8272")
    @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query")
    @CheckPermission(value={"roleManager:getUserRole"})
    @GetMapping(value={"/getUserRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u7528\u6237\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> getUserRole(Long userId) {
        return ApiResponse.success((Object)this.iSysRolesService.getUserRoleList(userId));
    }

    @ApiOperation(value="\u52a0\u8f7d\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6811")
    @ApiImplicitParam(name="roleIds", value="\u89d2\u8272ids", required=true, paramType="form")
    @PostMapping(value={"/selfRoleTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5f53\u524d\u7528\u6237\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfRoleTree(@RequestBody String roleIds) {
        String[] ids = roleIds == null ? "".split(",") : roleIds.split(",");
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getSelfRoleTree(ids)));
    }

    @ApiOperation(value="\u52a0\u8f7d\u8d44\u6e90\u6811", notes="\u52a0\u8f7d\u8d44\u6e90\u6811")
    @GetMapping(value={"/resourceTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> resourceTree() {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysResTypeService.getResourceTree()));
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", notes="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f")
    @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query")
    @GetMapping(value={"/getOrganAlias"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Object> getOrganAlias(String nodeId) {
        SysStru stru = (SysStru)this.sysOrgManageService.getById((Serializable)((Object)nodeId));
        return ApiResponse.success((String)(ToolUtil.isEmpty((Object)stru) ? "" : stru.getOrganAlias()));
    }

    @GetMapping(value={"/getOrganAliasByRoleId"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u89d2\u8272ID\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u7ec4\u7ec7\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Object> getOrganAliasByRoleId(String roleId) {
        this.orgMaintenanceService.checkOrganInfo((Object)roleId, "checkRoleId");
        SysRoles sysRoles = (SysRoles)this.iSysRolesService.getById((Serializable)((Object)roleId));
        Long corporationId = sysRoles.getCorporationId();
        if (HussarUtils.isEmpty((Object)corporationId)) {
            return ApiResponse.success((String)"");
        }
        String depId = String.valueOf(corporationId);
        SysStru stru = (SysStru)this.sysOrgManageService.getById((Serializable)((Object)depId));
        return ApiResponse.success((String)(ToolUtil.isEmpty((Object)stru) ? "" : stru.getOrganAlias()));
    }

    @ApiOperation(value="\u65b0\u589e\u89d2\u8272", notes="\u65b0\u589e\u89d2\u8272")
    @ApiImplicitParam(name="sysRolesDto", value="\u89d2\u8272dto", required=true, paramType="body")
    @PostMapping(value={"/addRole"})
    @CheckPermission(value={"roleManagerFront:addRole"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addRole(@RequestBody SysRolesDto sysRolesDto) {
        if (ToolUtil.isEmpty((Object)sysRolesDto.getId())) {
            return ApiResponse.success((Object)this.iSysRolesService.saveRole(sysRolesDto), (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
        }
        SysRoles sysRole = new SysRoles();
        BeanUtils.copyProperties((Object)sysRolesDto, (Object)sysRole);
        this.iSysRolesService.updateRole(sysRole);
        return ApiResponse.success((Object)sysRolesDto.getId(), (String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272", notes="\u4fee\u6539\u89d2\u8272")
    @ApiImplicitParam(name="sysRoles", value="\u89d2\u8272\u4fe1\u606f", required=true, paramType="body")
    @PostMapping(value={"/editRole"})
    @CheckPermission(value={"roleManagerFront:editRole"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fee\u6539\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> editRole(@RequestBody SysRoles sysRoles) {
        this.iSysRolesService.updateRole(sysRoles);
        return ApiResponse.success((String)"\u89d2\u8272\u57fa\u672c\u4fe1\u606f\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u4fe1\u606f", notes="\u67e5\u770b\u89d2\u8272\u4fe1\u606f")
    @ApiImplicitParam(name="id", value="\u89d2\u8272id", required=true, paramType="query")
    @GetMapping(value={"/roleView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<RoleInfoVO> roleView(String id) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleViewMap(id));
    }

    @ApiOperation(value="\u67e5\u770b\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", notes="\u67e5\u770b\u89d2\u8272\u8d44\u6e90\u4fe1\u606f")
    @ApiImplicitParam(name="id", value="\u89d2\u8272id", required=true, paramType="query")
    @GetMapping(value={"/roleResourceView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> getRoleResourceView(String id) {
        return ApiResponse.success((Object)this.iSysRolesService.getRoleResource(id));
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272", notes="\u5220\u9664\u89d2\u8272")
    @ApiImplicitParam(name="id", value="\u89d2\u8272id", required=true, paramType="form")
    @PostMapping(value={"/delRole"})
    @CheckPermission(value={"roleManagerFront:delRole"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u5220\u9664\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delRole(@RequestBody Long id) {
        return this.iSysRolesService.deleteRole(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90", notes="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceIds", value="\u8d44\u6e90ids", required=true, paramType="form"), @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="form")})
    @CheckPermission(value={"roleManager:saveResource"})
    @PostMapping(value={"/saveResource"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u8d44\u6e90\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveResource(@RequestBody String resourceIds, Long roleId) {
        this.iSysRoleResourceService.saveRoleResource(resourceIds, roleId);
        return ApiResponse.success((String)"\u89d2\u8272\u5173\u8054\u8d44\u6e90\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u56de\u6536\u6743\u9650", notes="\u89d2\u8272\u56de\u6536\u6743\u9650")
    @ApiImplicitParam(name="id", value="\u89d2\u8272id", required=true, paramType="form")
    @PostMapping(value={"/reclaimPerm"})
    @CheckPermission(value={"roleManagerFront:reclaimPerm"})
    @CacheEvict(value={"authorization_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u56de\u6536\u89d2\u8272\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> reclaimPerm(@RequestBody Long id) {
        this.iSysRoleResourceService.reclaimPerm(id);
        HashMap<String, Long> columnMap = new HashMap<String, Long>();
        columnMap.put("ROLE_ID", id);
        this.iSysRoleFunctionsService.removeByMap(columnMap);
        return ApiResponse.success((String)"\u56de\u6536\u6743\u9650\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u662f\u5426\u6709\u6743\u9650", notes="\u89d2\u8272\u662f\u5426\u6709\u6743\u9650")
    @ApiImplicitParam(name="id", value="\u89d2\u8272id", required=true, paramType="query")
    @GetMapping(value={"/queryPerm"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u662f\u5426\u6709\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> queryPerm(String id) {
        return ApiResponse.success((Object)this.iSysRoleResourceService.queryPerm(id));
    }

    @ApiOperation(value="\u6dfb\u52a0\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", notes="\u6dfb\u52a0\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @ApiImplicitParam(name="sysRoleGroup", value="\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", required=true, paramType="body")
    @PostMapping(value={"/saveGroup"})
    @CheckPermission(value={"roleManagerFront:saveGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveGroup(@RequestBody SysRoleGroup sysRoleGroup) {
        return this.iSysRolesService.saveGroup(sysRoleGroup);
    }

    @ApiOperation(value="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", notes="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u4fe1\u606f")
    @ApiImplicitParam(name="sysRoleGroup", value="\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", required=true, paramType="body")
    @PostMapping(value={"/editGroup"})
    @CheckPermission(value={"roleManagerFront:editGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> editGroup(@RequestBody SysRoleGroup sysRoleGroup) {
        return this.iSysRolesService.updateGroup(sysRoleGroup);
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272")
    @ApiImplicitParam(name="sameRoleName", value="\u89d2\u8272\u540d\u79f0", required=true, paramType="query")
    @CheckPermission(value={"roleManagerFront:sameRoleName"})
    @GetMapping(value={"/sameRoleName"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> sameRoleName(String sameRoleName) {
        return ApiResponse.success((Object)this.iSysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getRoleName, (Object)sameRoleName)));
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272")
    @ApiImplicitParam(name="sameRoleNameById", value="\u89d2\u8272\u540d\u79f0", required=true, paramType="query")
    @GetMapping(value={"/sameRoleNameById"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u89d2\u8272ID\u67e5\u8be2\u662f\u5426\u5df2\u6709\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> sameRoleNameById(String sameRoleName, String roleId) {
        return ApiResponse.success((Object)this.iSysRolesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysRoles::getRoleName, (Object)sameRoleName)).ne(SysRoles::getId, (Object)roleId)));
    }

    @ApiOperation(value="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u5206\u7ec4", notes="\u67e5\u8be2\u662f\u5426\u5df2\u6709\u5206\u7ec4")
    @ApiImplicitParam(name="sameGroupName", value="\u89d2\u8272\u5206\u7ec4\u540d\u79f0", required=true, paramType="query")
    @CheckPermission(value={"roleManagerFront:sameGroupName"})
    @GetMapping(value={"/sameGroupName"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u540d\u79f0\u67e5\u8be2\u662f\u5426\u6709\u91cd\u590d\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleGroup>> sameGroupName(String sameGroupName) {
        return ApiResponse.success((Object)this.sysRoleGroupService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getGroupName, (Object)sameGroupName)));
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272", notes="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4e0b\u7684\u89d2\u8272")
    @ApiImplicitParam(name="id", value="\u89d2\u8272\u5206\u7ec4id", required=true, paramType="query")
    @CheckPermission(value={"roleManagerFront:searchRoleToGroup"})
    @GetMapping(value={"/searchRoleToGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u6839\u636e\u5206\u7ec4ID\u67e5\u8be2\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoles>> searchRoleToGroup(String id) {
        return ApiResponse.success((Object)this.iSysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getGroupId, (Object)id)));
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272\u5206\u7ec4", notes="\u5220\u9664\u89d2\u8272\u5206\u7ec4")
    @ApiImplicitParam(name="id", value="\u89d2\u8272\u5206\u7ec4id", required=true, paramType="form")
    @PostMapping(value={"/delGroup"})
    @CheckPermission(value={"roleManagerFront:delGroup"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u5220\u9664\u89d2\u8272\u5206\u7ec4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delGroup(@RequestBody Long id) {
        return this.iSysRolesService.deleteGroup(id);
    }

    @ApiOperation(value="\u89d2\u8272\u5206\u7ec4\u67e5\u770b\u9875\u9762", notes="\u89d2\u8272\u5206\u7ec4\u67e5\u770b\u9875\u9762")
    @ApiImplicitParam(name="id", value="\u89d2\u8272\u5206\u7ec4id", required=true, paramType="query")
    @GetMapping(value={"/roleGroupViewPage"})
    @CheckPermission(value={"roleManagerFront:roleGroupViewPage"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5206\u7ec4\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysRoleGroup> roleGroupViewPage(String id) {
        return ApiResponse.success((Object)this.sysRoleGroupService.getById((Serializable)((Object)id)));
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u67e5\u770b\u6811", notes="\u89d2\u8272\u5173\u8054\u7528\u6237\u67e5\u770b\u6811")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="query")
    @CheckPermission(value={"roleManagerFront:roleUserTreeView"})
    @GetMapping(value={"/roleUserTreeView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7528\u6237\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeView(String roleId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getRoleUserTreeView(roleId)));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u83b7\u53d6\u89d2\u8272\u7528\u6237\u6811", notes="\u61d2\u52a0\u8f7d\u83b7\u53d6\u89d2\u8272\u7528\u6237\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="query"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query")})
    @CheckPermission(value={"roleManager:lazyRoleUserTreeView"})
    @GetMapping(value={"/lazyRoleUserTreeView"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u61d2\u52a0\u8f7d\u67e5\u8be2\u89d2\u8272\u7528\u6237\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getLazyRoleUserTreeView(Long roleId, Long nodeId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysUsersService.getLazyUserByRole(roleId, nodeId)));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="roleUserQueryDto", value="\u89d2\u8272\u5173\u8054\u7528\u6237\u67e5\u8be2dto", required=true, paramType="query")})
    @CheckPermission(value={"roleManagerFront:getRoleOrgUser"})
    @GetMapping(value={"/getRoleOrgUser"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u5f53\u524d\u90e8\u95e8\u4e0b\u7684\u7528\u6237\u5173\u8054\u89d2\u8272\u7684\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<RoleOrgUserVo>> getRoleOrgUsers(Page<RoleOrgUserVo> page, RoleUserQueryDto roleUserQueryDto) {
        return ApiResponse.success((Object)this.sysOrgManageService.getRoleOrgUser(page, roleUserQueryDto));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237\u65e0\u5206\u9875", notes="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237\u65e0\u5206\u9875")
    @CheckPermission(value={"roleManagerFront:getRoleOrgUser"})
    @GetMapping(value={"/getAllUsers"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5173\u8054\u7528\u6237\u65e0\u5206\u9875", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<RoleOrgUserVo>> getAllUsers(RoleUserQueryDto roleUserQueryDto) {
        return ApiResponse.success((Object)this.sysOrgManageService.getAllUserByRole(roleUserQueryDto));
    }

    @ApiOperation(value="\u6dfb\u52a0\u5220\u9664\u7528\u6237\u89d2\u8272", notes="\u6dfb\u52a0\u5220\u9664\u7528\u6237\u89d2\u8272")
    @ApiImplicitParam(name="roleUserDto", value="\u89d2\u8272\u5173\u8054\u7528\u6237dto", required=true, paramType="body")
    @CheckPermission(value={"roleManagerFront:addOrDelUserRole"})
    @PostMapping(value={"/addOrDelUserRole"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u6216\u5220\u9664\u7528\u6237\u89d2\u8272\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> getRoleOrgUser(@RequestBody RoleUserDto roleUserDto) {
        return this.iSysUserRoleService.saveOrDelUserRole(roleUserDto);
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u4fee\u6539\u6811", notes="\u89d2\u8272\u5173\u8054\u7528\u6237\u4fee\u6539\u6811")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="query")
    @CheckPermission(value={"roleManager:roleUserTreeEdit"})
    @GetMapping(value={"/roleUserTreeEdit"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7528\u6237\u4fee\u6539\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeEdit(String roleId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getRoleUserTreeEdit(roleId)));
    }

    @ApiOperation(value="\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811", notes="\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811")
    @CheckPermission(value={"roleManager:roleUserTreeAdd"})
    @GetMapping(value={"/roleUserTreeAdd"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u89d2\u8272\u5173\u8054\u7528\u6237\u65b0\u589e\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getRoleUserTreeAdd() {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getRoleUserTreeAdd()));
    }

    @ApiOperation(value="\u89d2\u8272\u65b0\u589e\u5173\u8054\u7528\u6237\u4fdd\u5b58", notes="\u89d2\u8272\u65b0\u589e\u5173\u8054\u7528\u6237\u4fdd\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="form"), @ApiImplicitParam(name="userIds", value="\u7528\u6237ids", paramType="form")})
    @CheckPermission(value={"roleManager:saveRoleUserAdd"})
    @PostMapping(value={"/saveRoleUserAdd"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u5173\u8054\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveRoleUsersAdd(Long roleId, String userIds) {
        this.iSysRoleResourceService.saveRoleUserAdd(userIds, roleId);
        return ApiResponse.success((String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u4fee\u6539\u5173\u8054\u7528\u6237\u4fdd\u5b58", notes="\u89d2\u8272\u4fee\u6539\u5173\u8054\u7528\u6237\u4fdd\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="form"), @ApiImplicitParam(name="userIds", value="\u7528\u6237ids", paramType="form")})
    @CheckPermission(value={"roleManager:saveRoleUserEdit"})
    @PostMapping(value={"/saveRoleUserEdit"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u65b0\u589e\u89d2\u8272\u5173\u8054\u7528\u6237", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveRoleUsersEdit(Long roleId, String userIds) {
        this.iSysRoleResourceService.updateRoleUserEdit(userIds, roleId);
        return ApiResponse.success((String)"\u89d2\u8272\u5173\u8054\u7528\u6237\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811")
    @CheckPermission(value={"roleManager:groupOrderTree"})
    @GetMapping(value={"/groupOrderTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u52a0\u8f7d\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> groupOrderTree() {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getGroupOrderTree()));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5206\u7ec4\u6392\u5e8f", notes="\u4fdd\u5b58\u89d2\u8272\u5206\u7ec4\u6392\u5e8f")
    @ApiImplicitParam(name="idList", value="\u89d2\u8272\u5206\u7ec4id\u96c6\u5408", required=true, paramType="body")
    @PostMapping(value={"/saveGroupOrder"})
    @CheckPermission(value={"roleManagerFront:saveGroupOrder"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fee\u6539\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> saveGroupOrder(@RequestBody List<Long> idList) {
        this.iSysRolesService.updateGroupOrder(idList);
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u52a0\u8f7d\u89d2\u8272\u6392\u5e8f\u6811", notes="\u52a0\u8f7d\u89d2\u8272\u6392\u5e8f\u6811")
    @ApiImplicitParam(name="parentId", value="\u4e0a\u7ea7\u8282\u70b9id", required=true, paramType="query")
    @CheckPermission(value={"roleManagerFront:roleOrderTree"})
    @GetMapping(value={"/roleOrderTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5206\u7ec4\u6392\u5e8f\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> roleOrderTree(Long parentId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysRolesService.getRoleOrderTree(parentId)));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u6392\u5e8f", notes="\u4fdd\u5b58\u89d2\u8272\u6392\u5e8f")
    @ApiImplicitParam(name="idList", value="\u89d2\u8272id\u96c6\u5408", required=true, paramType="body")
    @PostMapping(value={"/saveRoleOrder"})
    @CheckPermission(value={"roleManagerFront:saveRoleOrder"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u6392\u5e8f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> saveRoleOrder(@RequestBody List<Long> idList) {
        this.iSysRolesService.updateRoleOrder(idList);
        return ApiResponse.success((String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa", notes="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    @ApiImplicitParam(name="ids", value="\u8981\u5bfc\u51fa\u7684\u89d2\u8272ids", required=true, paramType="form")
    @PostMapping(value={"/exportData"})
    @CheckPermission(value={"roleManagerFront:exportData"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@RequestBody String ids, HttpServletResponse response) {
        List<String> idList = Arrays.asList(ids == null ? "".split(",") : ids.split(","));
        this.iSysRolesService.exportData(idList, response);
    }

    @ApiOperation(value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa", notes="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    @ApiImplicitParam(name="file", value="\u5bfc\u5165\u6587\u4ef6", required=true, paramType="form")
    @PostMapping(path={"/importData"})
    @CheckPermission(value={"roleManagerFront:importData"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u89d2\u8272\u6570\u636e\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<Map<String, String>> importData(@RequestParam(value="file") MultipartFile hussarFile) throws IOException {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.success((Object)this.iSysRolesService.importVueData(content));
    }

    @ApiOperation(value="\u89d2\u8272\u6570\u636e\u5bfc\u51fa", notes="\u89d2\u8272\u6570\u636e\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="form"), @ApiImplicitParam(name="resourceIds", value="\u8d44\u6e90ids", required=true, paramType="form")})
    @PostMapping(path={"/checkResource"})
    @CheckPermission(value={"roleManagerFront:checkResource"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u68c0\u67e5\u8d44\u6e90\u6709\u6ca1\u6709\u8d4b\u4e88\u522b\u7684\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResourceVo>> checkResource(@RequestBody RoleResDto roleResDto) {
        Long roleId = roleResDto.getRoleId();
        String resourceIds = roleResDto.getResourceId();
        return ApiResponse.success((Object)this.iSysRoleResourceService.selectResource(roleId, resourceIds));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6743\u9650", notes="\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6743\u9650")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272id", required=true, paramType="query")
    @GetMapping(value={"/dataScope"})
    @CheckPermission(value={"roleManager:dataScope"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u6570\u636e\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<DataScopeVo> getRoleDataScope(Long roleId) {
        return ApiResponse.success((Object)this.sysRoleDataScopeService.getRoleDateScope(roleId));
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u6743\u9650", notes="\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u6743\u9650")
    @ApiImplicitParam(name="dataScopeVo", value="\u6570\u636e\u6743\u9650vo", required=true, paramType="body")
    @PostMapping(value={"/saveDataScope"})
    @CheckPermission(value={"roleManager:saveDataScope"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u6570\u636e\u6743\u9650", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> saveDataScope(@RequestBody DataScopeVo dataScopeVo) {
        return this.sysRoleDataScopeService.saveDateScope(dataScopeVo);
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u529f\u80fd", notes="\u4fdd\u5b58\u89d2\u8272\u529f\u80fd")
    @ApiImplicitParam(name="roleFuncDto", value="\u89d2\u8272\u529f\u80fd\u4fdd\u5b58dto", required=true, paramType="body")
    @PostMapping(value={"/saveFunction"})
    @CacheEvict(value={"data_scope_list", "data_scope_type", "authorization_info", "menu_info"}, allEntries=true)
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveFunction(@RequestBody RoleFuncDto roleFuncDto) {
        this.iSysRolesService.saveFunctions(roleFuncDto);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90", notes="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90")
    @ApiImplicitParam(name="RoleResDto", value="\u89d2\u8272\u8d44\u6e90\u4fdd\u5b58dto", required=true, paramType="body")
    @PostMapping(value={"/saveRealResource"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u4fdd\u5b58\u89d2\u8272\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveResource(@RequestBody RoleResDto roleResDto) {
        this.iSysRolesService.saveResources(roleResDto);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u529f\u80fd", notes="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u529f\u80fd")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, paramType="query")
    @GetMapping(value={"/getRelaFunction"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u5df2\u5173\u8054\u7684\u529f\u80fd", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleFunctions>> getChooseAuthority(String roleId) {
        return ApiResponse.success((Object)this.iSysRoleFunctionsService.getRoleFunctions(roleId));
    }

    @ApiOperation(value="\u83b7\u53d6\u89d2\u8272\u7531\u5173\u8054\u8d44\u6e90\u9875\u9762\u5df2\u5173\u8054\u7684\u8d44\u6e90", notes="\u83b7\u53d6\u89d2\u8272\u7531\u5173\u8054\u8d44\u6e90\u9875\u9762\u5df2\u5173\u8054\u7684\u8d44\u6e90")
    @ApiImplicitParam(name="roleId", value="\u89d2\u8272ID", required=true, paramType="query")
    @GetMapping(value={"/getRealResource"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u89d2\u8272\u7531\u5173\u8054\u8d44\u6e90\u9875\u9762\u5df2\u5173\u8054\u7684\u8d44\u6e90", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysRoleResource>> getRelaResource(String roleId) {
        return ApiResponse.success((Object)this.iSysRoleResourceService.getRealResource(roleId));
    }

    @ApiOperation(value="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u529f\u80fd\u6811", notes="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u529f\u80fd\u6811")
    @ApiImplicitParam(name="functionIds", value="\u529f\u80fdID", required=true, paramType="query")
    @PostMapping(value={"/selfFunctionTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5f53\u524d\u89d2\u8272\u7684\u529f\u80fd\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfResourceTree(@RequestBody JSONObject jsonObject) {
        String functionIds = jsonObject.getString("functionIds");
        List result = this.iSysRoleFunctionsService.selfFunctionTree(functionIds);
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)result));
    }

    @ApiOperation(value="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", notes="\u53ea\u52a0\u8f7d\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811")
    @ApiImplicitParam(name="resourceIds", value="\u8d44\u6e90ID", required=true, paramType="query")
    @PostMapping(value={"/selfResourceTree"})
    @AuditLog(moduleName="\u89d2\u8272\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5f53\u524d\u89d2\u8272\u7684\u8d44\u6e90\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfRealResourceTree(@RequestBody JSONObject jsonObject) {
        String resourceIds = jsonObject.getString("resourceIds");
        List result = this.iSysRoleResourceService.selfResourceTree(resourceIds);
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)result));
    }
}

